/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.neeve.query.Query;
import com.neeve.query.QueryRepository;
import com.neeve.query.impl.QueryAbstractField;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.predicates.FieldPredicate;
import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.index.IdxField;
import com.neeve.query.predicates.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryImpl<REC>
implements Query<REC> {
    private List<IdxField<REC, ?>> columns = Lists.newArrayList();
    private List<String> columnNames = Lists.newArrayList();
    private List<IdxField<REC, ?>> groupByColumns = Lists.newArrayList();
    private List<OrderByField<REC, ?>> orderByColumns = Lists.newArrayList();
    private Set<String> repositoryNames = Sets.newLinkedHashSet();
    private Predicate<REC> where = null;
    private Predicate<REC> having = null;
    private boolean implicitTypePredicatesDirty = false;
    private Predicate<REC> implicitTypePredicates;
    private Range<Integer> limitRange;
    private boolean distinct = false;

    @Override
    public <T> Query<REC> select(IdxField<REC, T> field) {
        this.columns.add(field);
        this.columnNames.add(field.getName());
        this.implicitTypePredicatesDirty = true;
        return this;
    }

    @Override
    public Query<REC> as(String name) {
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("A column must be selected prior to aliasing it.");
        }
        if (name != null) {
            this.columnNames.set(this.columnNames.size() - 1, name);
        } else {
            name = this.columnNames.set(this.columnNames.size() - 1, this.columns.get(this.columnNames.size() - 1).getName());
        }
        return this;
    }

    @Override
    public Query<REC> distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public Query<REC> from(String repositoryName) {
        this.repositoryNames.add(repositoryName);
        return this;
    }

    @Override
    public Query<REC> from(QueryRepository<?, REC> repository) {
        this.repositoryNames.add(repository.getName());
        return this;
    }

    @Override
    public Query<REC> where(Predicate<REC> predicate) {
        this.where = predicate;
        return this;
    }

    @Override
    public Query<REC> having(Predicate<REC> predicate) {
        this.having = predicate;
        return this;
    }

    public List<IdxField<REC, ?>> getSelect() {
        return this.columns;
    }

    public List<String> getSelectNames() {
        return this.columnNames;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Iterable<String> getFromList() {
        return this.repositoryNames;
    }

    public Predicate<REC> getWhere() {
        if (this.implicitTypePredicatesDirty) {
            this.implicitTypePredicates = this.getImplicitTypePredicates();
            this.implicitTypePredicatesDirty = false;
        }
        if (this.implicitTypePredicates != null) {
            if (this.where == null) {
                return this.implicitTypePredicates;
            }
            return PredicatesImpl.get().and(this.where, this.implicitTypePredicates);
        }
        return this.where;
    }

    @Override
    public <T> Query<REC> orderBy(IdxField<REC, T> field, Query.SortOrder sortOrder) {
        this.orderByColumns.add(new OrderByField(field, sortOrder));
        this.implicitTypePredicatesDirty = true;
        return this;
    }

    @Override
    public <T> Query<REC> orderBy(IdxField<REC, T> field) {
        return this.orderBy(field, Query.SortOrder.ASCENDING);
    }

    public List<OrderByField<REC, ?>> getOrderBy() {
        return this.orderByColumns;
    }

    @Override
    public <T> Query<REC> groupBy(IdxField<REC, T> field) {
        this.groupByColumns.add(field);
        this.implicitTypePredicatesDirty = true;
        return this;
    }

    public List<IdxField<REC, ?>> getGroupBy() {
        return this.groupByColumns;
    }

    public Set<IdxField<REC, ?>> getAllFields() {
        HashSet allFields = Sets.newHashSet(this.columns);
        allFields.addAll(this.getAllFields(this.where));
        allFields.addAll(this.groupByColumns);
        allFields.addAll(this.getAllFields(this.having));
        for (OrderByField<REC, ?> field : this.orderByColumns) {
            allFields.add(field.getField());
        }
        return allFields;
    }

    public Set<IdxField<REC, ?>> getWhereFields() {
        return this.getAllFields(this.where);
    }

    protected Set<IdxField<REC, ?>> getAllFields(Predicate<REC> predicate) {
        HashSet allFields = Sets.newHashSet();
        if (predicate != null) {
            if (predicate instanceof PredicatesImpl.CompositePredicate) {
                PredicatesImpl.CompositePredicate composite = (PredicatesImpl.CompositePredicate)predicate;
                List childPredicates = composite.getChildPredicates();
                for (Predicate child : childPredicates) {
                    Set childFields = this.getAllFields(child);
                    allFields.addAll(childFields);
                }
            } else if (predicate instanceof FieldPredicate) {
                FieldPredicate fieldPredicate = (FieldPredicate)predicate;
                IdxField field = fieldPredicate.getField();
                allFields.add(field);
            }
        }
        return allFields;
    }

    private final Predicate<REC> getImplicitTypePredicates() {
        HashSet typePredicates = Sets.newHashSet();
        for (IdxField<REC, ?> field : this.getAllFields()) {
            List fieldPreds = ((QueryAbstractField)field).getPathTypePredicates();
            if (fieldPreds == null || fieldPreds.isEmpty()) continue;
            if (fieldPreds.size() == 1) {
                typePredicates.add(fieldPreds.get(0));
                continue;
            }
            typePredicates.add(PredicatesImpl.get().and(fieldPreds));
        }
        if (typePredicates.isEmpty()) {
            return null;
        }
        if (typePredicates.size() == 1) {
            return (Predicate)typePredicates.iterator().next();
        }
        return PredicatesImpl.get().or(typePredicates);
    }

    public Predicate<REC> getHaving() {
        return this.having;
    }

    public boolean isAggregated() {
        if (!this.groupByColumns.isEmpty()) {
            return true;
        }
        for (IdxField<REC, ?> column : this.columns) {
            if (!(column instanceof QueryAggregateField)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Query<REC> limit(int offset, int fetchSize) {
        this.limitRange = Range.openClosed((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(offset + fetchSize));
        return this;
    }

    @Override
    public Query<REC> limit(int fetchSize) {
        this.limitRange = Range.upTo((Comparable)Integer.valueOf(fetchSize), (BoundType)BoundType.CLOSED);
        return this;
    }

    public Range<Integer> getLimitRange() {
        return this.limitRange;
    }

    public void setLimitRange(Range<Integer> limitRange) {
        this.limitRange = limitRange;
    }

    public static final class OrderByField<REC, T> {
        private final IdxField<REC, T> field;
        private final Query.SortOrder sortOrder;

        private OrderByField(IdxField<REC, T> field, Query.SortOrder sortOrder) {
            this.field = field;
            this.sortOrder = sortOrder;
        }

        public IdxField<REC, T> getField() {
            return this.field;
        }

        public boolean isAscending() {
            return this.sortOrder == Query.SortOrder.ASCENDING;
        }
    }
}

