/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.test.unit;

import com.eaio.uuid.UUID;
import com.google.protobuf.Message;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.EventMultiplexerSingleThreaded;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreMemberControlEvent;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectAddedEvent;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStoreObjectReceivedEvent;
import com.neeve.ods.IStoreReplicatorNotificationHandler;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsExpectationNotMetException;
import com.neeve.ods.StoreBindingFactory;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreInterClusterReplicatorDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.ods.StoreReplicatorOperation;
import com.neeve.ods.impl.StoreBindingFailedEvent;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyStoContainer;
import com.neeve.rog.impl.RogNode;
import com.neeve.sto.StoBufferField;
import com.neeve.sto.StoField;
import com.neeve.sto.StoFieldContainer;
import com.neeve.sto.StoIntField;
import com.neeve.sto.StoLongField;
import com.neeve.sto.StoStringField;
import com.neeve.test.UnitTest;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class StoreBindingTest
extends UnitTest {
    @BeforeClass
    public static void initialize() throws Exception {
        StoreReplicatorDescriptor.create("store").save();
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(new TestObjectFactory());
        PktFactory.getInstance().registerPacketType(PktFactory.PktType.create((int)773, (String)"ods_test_object1", (String)TestObject1.Packet.class.getName(), (int)0, (int)0, (boolean)false, null));
        PktFactory.getInstance().registerPacketType(PktFactory.PktType.create((int)774, (String)"ods_test_object2", (String)TestObject2.Packet.class.getName(), (int)0, (int)0, (boolean)false, null));
    }

    private final void validateReplicationOperations(Member m, StoreReplicatorOperation ... expectedOperations) {
        List<StoreReplicatorOperation> actualOperations = m.replicatorNotificationHandler.operations;
        Assert.assertEquals((String)"Unexpected Operations", Arrays.asList(expectedOperations), actualOperations);
    }

    private final void validateReplicationOperationObjectIds(Member m, UUID ... expectedOperationObjectIds) {
        List<UUID> actualOperationObjectIds = m.replicatorNotificationHandler.objectIds;
        Assert.assertTrue((boolean)Arrays.equals(expectedOperationObjectIds, actualOperationObjectIds.toArray(new UUID[actualOperationObjectIds.size()])));
    }

    private void testGetMemberReturnsNonNull(boolean replicated) throws Exception {
        try (Member m = new Member(null, replicated, false);){
            Assert.assertNotNull((Object)m.binding.getMember());
        }
    }

    @Test
    public void testGetMemberReturnsNonNull_Standalone() throws Exception {
        this.testGetMemberReturnsNonNull(false);
    }

    @Test
    public void testGetMemberReturnsNonNull_Clustered() throws Exception {
        this.testGetMemberReturnsNonNull(true);
    }

    private void testGetMemberNameForNullSpecifiedNameReturnsGeneratedName(boolean replicated) throws Exception {
        try (Member m = new Member(null, replicated, false);){
            Assert.assertNotNull((Object)m.binding.getMember().getName());
        }
    }

    @Test
    public void testGetMemberNameForNullSpecifiedNameReturnsGeneratedName_Standalone() throws Exception {
        this.testGetMemberNameForNullSpecifiedNameReturnsGeneratedName(false);
    }

    @Test
    public void testGetMemberNameForNullSpecifiedNameReturnsGeneratedName_Clustered() throws Exception {
        this.testGetMemberNameForNullSpecifiedNameReturnsGeneratedName(true);
    }

    private void testGetMemberNameForNonNullSpecifiedNameReturnsSpecifiedName(boolean replicated) throws Exception {
        try (Member m = new Member("m1", replicated, false);){
            Assert.assertEquals((Object)(replicated ? "255,m1" : "000,m1"), (Object)m.binding.getMember().getName());
        }
    }

    @Test
    public void testGetMemberNameForNonNullSpecifiedNameReturnsSpecifiedName_Standalone() throws Exception {
        this.testGetMemberNameForNonNullSpecifiedNameReturnsSpecifiedName(false);
    }

    @Test
    public void testGetMemberNameForNonNullSpecifiedNameReturnsSpecifiedName_Replicated() throws Exception {
        this.testGetMemberNameForNonNullSpecifiedNameReturnsSpecifiedName(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetMemberNameForNullSpecifiedNameIsUnique(boolean replicated) throws Exception {
        Member m1 = new Member(null, replicated, false);
        Member m2 = new Member(null, replicated, false);
        try {
            Assert.assertFalse((boolean)m1.binding.getMember().getName().equals(m2.binding.getMember().getName()));
        }
        finally {
            m2.close();
            m1.close();
        }
    }

    @Test
    public void testGetMemberNameForNullSpecifiedNameIsUnique_Standalone() throws Exception {
        this.testGetMemberNameForNullSpecifiedNameIsUnique(false);
    }

    @Test
    public void testGetMemberNameForNullSpecifiedNameIsUnique_Clustered() throws Exception {
        this.testGetMemberNameForNullSpecifiedNameIsUnique(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMemberNameOnStandaloneReceiverBindingReturnsSpecifiedName() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            Assert.assertEquals((Object)"000,m1", (Object)m1.binding.getMember().getName());
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test
    public void testGetDescriptor() throws Exception {
        try (Member m = new Member("m");){
            Assert.assertSame((Object)((Object)m.descriptor), (Object)((Object)m.binding.getDescriptor()));
        }
    }

    @Test
    public void testGetDescriptorOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        Assert.assertSame((Object)((Object)m.descriptor), (Object)((Object)m.binding.getDescriptor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDescriptorOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            Assert.assertSame((Object)((Object)m2.descriptor), (Object)((Object)m2.binding.getDescriptor()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDescriptorOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            Assert.assertSame((Object)((Object)m1.descriptor), (Object)((Object)m1.binding.getDescriptor()));
        }
        finally {
            icrDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEventHandler() throws Exception {
        StoreDescriptor descriptor = StoreDescriptor.create("store");
        EventHandler eventHandler = new EventHandler();
        IStoreBinding store = StoreBindingFactory.getInstance().createBinding(null, descriptor, null, 2);
        try {
            Assert.assertNull((Object)store.getEventHandler());
        }
        finally {
            store.close(0);
        }
        store = StoreBindingFactory.getInstance().createBinding(null, descriptor, (IStoreEventHandler)eventHandler, 2);
        try {
            Assert.assertSame((Object)eventHandler, (Object)store.getEventHandler());
        }
        finally {
            store.close(0);
        }
    }

    @Test
    public void testGetEventHandlerOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        Assert.assertSame((Object)m.eventHandler, (Object)m.binding.getEventHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEventHandlerOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            Assert.assertSame((Object)m2.eventHandler, (Object)m2.binding.getEventHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEventHandlerOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            Assert.assertSame((Object)m1.eventHandler, (Object)m1.binding.getEventHandler());
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test
    public void testNewBindingIsInOpenState() throws Exception {
        try (Member m = new Member("m");){
            Assert.assertEquals((Object)((Object)IStoreBinding.State.Open), (Object)((Object)m.binding.getState()));
        }
    }

    @Test
    public void testGetStateOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        Assert.assertSame((Object)((Object)IStoreBinding.State.Closed), (Object)((Object)m.binding.getState()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStateOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            Assert.assertSame((Object)((Object)IStoreBinding.State.Open), (Object)((Object)m2.binding.getState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStateOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            Assert.assertSame((Object)((Object)IStoreBinding.State.Open), (Object)((Object)m1.binding.getState()));
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test
    public void testFirstBindingHasPrimaryRole() throws Exception {
        try (Member m = new Member("m", true, false);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m.binding.getRole()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondAndOnwardBindingsHaveBackupRoles() throws Exception {
        Member m1 = new Member("m1", true, true);
        Member m2 = new Member("m2", true, true);
        Member m3 = new Member("m3", true, true);
        Member m4 = new Member("m4", true, true);
        Member m5 = new Member("m5", true, true);
        try {
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m3.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m4.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m5.binding.getRole()));
        }
        finally {
            m2.close();
            m3.close();
            m4.close();
            m5.close();
            m1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemberElectionPrioritySequentialStart() throws Exception {
        String replicator1Name = new UUID().toString();
        StoreReplicatorDescriptor replicator1Descriptor = StoreReplicatorDescriptor.create(replicator1Name);
        replicator1Descriptor.setProperty("memberElectionPriority", "15");
        replicator1Descriptor.setProperty("storeName", "store");
        replicator1Descriptor.save();
        String replicator2Name = new UUID().toString();
        StoreReplicatorDescriptor replicator2Descriptor = StoreReplicatorDescriptor.create(replicator2Name);
        replicator2Descriptor.setProperty("memberElectionPriority", "14");
        replicator2Descriptor.setProperty("storeName", "store");
        replicator2Descriptor.save();
        try (Member m1 = new Member("m1", replicator1Name, true);
             Member m2 = new Member("m2", replicator2Name, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemberElectionPriorityConcurrentStart() throws Exception {
        String replicator1Name = new UUID().toString();
        StoreReplicatorDescriptor replicator1Descriptor = StoreReplicatorDescriptor.create(replicator1Name);
        replicator1Descriptor.setProperty("memberElectionPriority", "15");
        replicator1Descriptor.setProperty("storeName", "store");
        replicator1Descriptor.save();
        String replicator2Name = new UUID().toString();
        StoreReplicatorDescriptor replicator2Descriptor = StoreReplicatorDescriptor.create(replicator2Name);
        replicator2Descriptor.setProperty("memberElectionPriority", "14");
        replicator2Descriptor.setProperty("storeName", "store");
        replicator2Descriptor.save();
        Member m1 = new Member("m1", replicator1Name, false);
        Member m2 = new Member("m2", replicator2Name, false);
        Thread m1t = this.createMemberThread("M1t", m1, 0);
        Thread m2t = this.createMemberThread("M2t", m2, 0);
        m1t.start();
        m2t.start();
        boolean success = true;
        do {
            m2t.join(10000L);
            if (!m2t.isAlive()) continue;
            m2.binding.fail(new Exception("force failing because thread is stuck"));
            success = false;
        } while (m2t.isAlive());
        do {
            m1t.join(10000L);
            if (!m1t.isAlive()) continue;
            m1.binding.fail(new Exception("force failing because thread is stuck"));
            success = false;
        } while (m1t.isAlive());
        try {
            try {
                if (success) {
                    Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m2.binding.getRole()));
                    Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m1.binding.getRole()));
                }
            }
            finally {
                m2.close();
            }
        }
        finally {
            m1.close();
        }
    }

    @Test
    public void testGetRoleOnClosedBinding() throws Exception {
        Member m = new Member("m", true, false);
        m.close();
        try {
            m.binding.getRole();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRoleOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRoleOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m1.binding.getRole()));
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPutWithNullObject() throws Exception {
        try (Member m = new Member("m");){
            m.binding.put(null);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testPutOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        m.binding.put(new TestObject1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testPutOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            m2.binding.put(new TestObject1());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testPutOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            m1.binding.put(new TestObject1());
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetWithNullId() throws Exception {
        try (Member m = new Member("m");){
            m.binding.get(null);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testGetOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        m.binding.get(new UUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            m2.binding.get(new UUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            m1.binding.get(new UUID());
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test
    public void testGetMissingObject() throws Exception {
        try (Member m1 = new Member("m1");){
            Assert.assertNull((Object)m1.binding.get(new UUID()));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveWithNullObject() throws Exception {
        try (Member m = new Member("m");){
            m.binding.remove(null);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testRemoveOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        m.binding.remove(new TestObject1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testRemoveOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            m2.binding.remove(new TestObject1());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testRemoveOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            m1.binding.remove(new TestObject1());
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSendWithNullObject() throws Exception {
        try (Member m = new Member("m");){
            m.binding.send(null);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testSendOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        m.binding.send(new TestObject1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testSendOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            m2.binding.send(new TestObject1());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testSendOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            m1.binding.send(new TestObject1());
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test
    public void testSizeOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        m.binding.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSizeOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            m2.binding.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSizeOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            m1.binding.size();
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testCommitOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        m.binding.commit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testCommitOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            m2.binding.commit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testCommitOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            m1.binding.commit(null);
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testRollbackOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        m.binding.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testRollbackOnBackupBinding() throws Exception {
        try (Member m1 = new Member("m1", true, true);
             Member m2 = new Member("m2", true, true);){
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            m2.binding.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testRollbackOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try (Member m1 = new Member("m1", icrDescriptor, false);){
            m1.binding.rollback();
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test
    public void testCloseOnClosedBinding() throws Exception {
        Member m = new Member("m");
        m.close();
        m.close();
    }

    @Test
    public void testCloseOnBackupBinding() throws Exception {
        Member m1 = new Member("m1", true, true);
        Member m2 = new Member("m2", true, true);
        Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
        Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
        try {
            m2.close();
        }
        finally {
            m1.close();
        }
    }

    @Test
    public void testCloseOnStandaloneReceiverBinding() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try {
            new Member("m1", icrDescriptor, false).close();
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test
    public void testPut() throws Exception {
        Member m = new Member("m", true, false);
        TestObject1 object = new TestObject1();
        object.setF1("Hi");
        try {
            m.binding.put(object);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "Hi", 0);
        }
        finally {
            m.close();
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPutPut() throws Exception {
        try (Member m = new Member("m", false, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object).put(object);
        }
    }

    @Test
    public void testPutCommit() throws Exception {
        Member m = new Member("m", true, false);
        TestObject1 object = new TestObject1();
        object.setF1("Hi");
        try {
            m.binding.put(object).commit(null);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "Hi", 0);
        }
        finally {
            m.close();
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
    }

    @Test
    public void testPutRollback() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            object.setF1("Hi");
            m.binding.put(object);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "Hi", 0);
            m.binding.rollback();
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, "Hi", 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPutCommitPut() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            m.binding.put(object);
        }
    }

    @Test
    public void testPutRollbackPut() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            object.setF1("Hi");
            m.binding.put(object).rollback().put(object);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "Hi", 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
    }

    @Test
    public void testPutRollbackPutCommit() throws Exception {
        Member m = new Member("m", true, false);
        TestObject1 object = new TestObject1();
        object.setF1("Hi");
        try {
            m.binding.put(object).rollback().put(object).commit(null);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "Hi", 0);
        }
        finally {
            m.close();
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemove() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            m.binding.remove(object);
        }
    }

    @Test
    public void testPutRemove() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            object.setF1("Hi");
            m.binding.put(object).remove(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, "Hi", 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
    }

    @Test
    public void testPutCommitRemove() throws Exception {
        Member m = new Member("m", true, false);
        TestObject1 object = new TestObject1();
        object.setF1("Hi");
        try {
            m.binding.put(object);
            m.commit();
            m.binding.remove(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, "Hi", 0);
        }
        finally {
            m.close();
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPutRollbackRemove() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            m.binding.put(object).rollback().remove(object);
        }
    }

    @Test
    public void testPutRemoveCommit() throws Exception {
        Member m = new Member("m", true, false);
        TestObject1 object = new TestObject1();
        object.setF1("Hi");
        try {
            m.binding.put(object).remove(object).commit(null);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, "Hi", 0);
        }
        finally {
            m.close();
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
    }

    @Test
    public void testPutRemoveRollback() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object).remove(object).rollback();
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
    }

    @Test
    public void testPutCommitRemoveCommit() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
            object.acquire();
            m.binding.remove(object).commit(null);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryRemove, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
    }

    @Test
    public void testPutCommitRemoveRollback() throws Exception {
        TestObject1 object = new TestObject1();
        try (Member m = new Member("m", true, false);){
            m.binding.put(object).commit(null);
            m.binding.remove(object).rollback();
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
        Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
        Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
    }

    @Test
    public void testPutUpdate() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object);
            object.setF1("newf1").setF2(99);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "newf1", 99);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
    }

    @Test
    public void testPutUpdateCommit() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object);
            object.setF1("newf1").setF2(99).getBinding().commit(null);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "newf1", 99);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testPutUpdateRollback() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object);
            object.setF1("newf1").setF2(99).getBinding().rollback();
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
            Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutCommitUpdate() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 emptyObject = new TestObject1();
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            object.setF1("newf1").setF2(99);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "newf1", 99);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)emptyObject.getDataSize(), (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testPutCommitUpdateCommit() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            object.setF1("newf1").setF2(99).getBinding().commit(null);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "newf1", 99);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryUpdate, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutCommitUpdateRollback() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 emptyObject = new TestObject1();
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            object.setF1("newf1").setF2(99).getBinding().rollback();
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)emptyObject.getDataSize(), (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testPutUpdateRemove() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object);
            object.setF1("newf1").setF2(99).getBinding().remove(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, "newf1", 99);
            Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
    }

    @Test
    public void testPutUpdateRemoveCommit() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object);
            object.setF1("newf1").setF2(99).getBinding().remove(object).commit(null);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, "newf1", 99);
            Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
    }

    @Test
    public void testPutUpdateRemoveRollback() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object);
            object.setF1("newf1").setF2(99).getBinding().remove(object).rollback();
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
            Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutCommitUpdateRemove() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 emptyObject = new TestObject1();
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            object.setF1("newf1").setF2(99).getBinding().remove(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, "newf1", 99);
            Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)emptyObject.getDataSize(), (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testPutCommitUpdateRemoveCommit() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            object.acquire();
            m.binding.put(object).commit(null);
            object.setF1("newf1").setF2(99).getBinding().remove(object).commit(null);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, "newf1", 99);
            Assert.assertEquals((String)"Wrong store size", (long)0L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)0L, (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryRemove, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutCommitUpdateRemoveRollback() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 emptyObject = new TestObject1();
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            object.setF1("newf1").setF2(99).getBinding().remove(object).rollback();
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)emptyObject.getDataSize(), (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testLongSequenceCommit() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            object.validate((short)1, object.getId(), m.binding, null, 0);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
            object.setF1("newf1").setF2(99).setF1("anotherf1").setF2(100).setF1("yetanotherf1").getBinding().commit(null);
            object.validate((short)1, object.getId(), m.binding, "yetanotherf1", 100);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
            object.getBinding().remove(object).put(object);
            object.setF2(200).setF1("andyetanotherf1").getBinding().commit(null);
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, "andyetanotherf1", 200);
            Assert.assertEquals((String)"Wrong store size", (long)1L, (long)m.binding.size());
            Assert.assertEquals((String)"Wrong data size", (long)object.getDataSize(), (long)m.binding.getStats().getDataSize());
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryUpdate, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryUpdate, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testLongSequenceRollback() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.put(object).commit(null);
            object.setF1("newf1").setF2(99).setF1("anotherf1").setF2(100).setF1("yetanotherf1").getBinding().remove(object).put(object);
            object.setF2(200).getBinding().rollback();
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testSend() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.send(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSendSend() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            m.binding.send(object).send(object);
        }
    }

    @Test
    public void testSendCommit() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.send(object).commit(null);
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testCommitWithSend() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.commit(0L, 0L, new IStoreObject[]{object}, 1, null, 0);
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testSendRollback() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.send(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
            m.binding.rollback();
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
    }

    @Test
    public void testSendCommitSend() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.send(object).commit(null);
            m.binding.send(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testCommitWithSendSend() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.commit(0L, 0L, new IStoreObject[]{object}, 1, null, 0);
            m.binding.send(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testSendRollbackSend() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.send(object).rollback().send(object);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), m.binding, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.Close);
    }

    @Test
    public void testSendRollbackSendCommit() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.send(object).rollback().send(object).commit(null);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testSendRollbackCommitWithSend() throws Exception {
        try (Member m = new Member("m", true, false);){
            TestObject1 object = new TestObject1();
            m.binding.send(object).rollback().commit(0L, 0L, new IStoreObject[]{object}, 1, null, 0);
            Assert.assertNull((Object)m.binding.get(object.getId()));
            Assert.assertFalse((boolean)m.binding.getTransactionLog().hasUncommitted());
            object.validate((short)1, object.getId(), null, null, 0);
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonCommittedPutIsNotIsolated() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            Putter putter = new Putter(m, object, false);
            putter.start();
            putter.join();
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommittedPutIsNotIsolated() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            Putter putter = new Putter(m, object, true);
            putter.start();
            putter.join();
            Assert.assertSame((Object)object, (Object)m.binding.get(object.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonCommittedRemoveIsNotIsolated() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            m.binding.put(object);
            Remover remover = new Remover(m, object, false);
            remover.start();
            remover.join();
            Assert.assertNull((Object)m.binding.get(object.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommittedRemoveIsNotIsolated() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            m.binding.put(object);
            Remover remover = new Remover(m, object, true);
            remover.start();
            remover.join();
            Assert.assertNull((Object)m.binding.get(object.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDifferentThreadHaveSameTransactionLogs() throws Exception {
        try (Member m = new Member("m");){
            TestObject1 object = new TestObject1();
            Putter putter = new Putter(m, object, false);
            putter.start();
            putter.join();
            Assert.assertTrue((boolean)m.binding.getTransactionLog().hasUncommitted());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleObjectsInSameCommit() throws Exception {
        Member m = new Member("m", true, false);
        TestObject1 object1 = new TestObject1();
        TestObject1 object2 = new TestObject1();
        object2.acquire();
        TestObject1 object3 = new TestObject1();
        object3.acquire();
        TestObject1 object4 = new TestObject1();
        object4.acquire();
        TestObject1 object5 = new TestObject1();
        try {
            m.binding.put(object1).commit(null);
            m.binding.put(object2).commit(null);
            object1.setF1("newf1").setF2(99);
            object2.setF1("newf2").setF2(400).getBinding().remove(object2);
            m.binding.send(object3).send(object4);
            m.binding.commit(0L, 0L, new IStoreObject[]{object5, null}, 1, null, 0);
            Assert.assertEquals((long)1L, (long)m.binding.size());
            Assert.assertSame((Object)object1, (Object)m.binding.get(object1.getId()));
            Assert.assertNull((Object)m.binding.get(object2.getId()));
            Assert.assertNull((Object)m.binding.get(object3.getId()));
            Assert.assertNull((Object)m.binding.get(object4.getId()));
            object1.validate((short)1, object1.getId(), m.binding, "newf1", 99);
            Assert.assertNull((Object)m.binding.get(object2.getId()));
            object2.validate((short)1, object2.getId(), null, "newf2", 400);
        }
        finally {
            m.close();
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryUpdate, StoreReplicatorOperation.CommitEntryRemove, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEntrySend, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
        this.validateReplicationOperationObjectIds(m, object1.getId(), object2.getId(), object1.getId(), object2.getId(), object3.getId(), object4.getId(), object5.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleObjectsInSameCommitWithObject2UpdatedBracketedByObject1UpdateAndThenRemove() throws Exception {
        Member m = new Member("m", true, false);
        TestObject1 object1 = new TestObject1();
        TestObject1 object2 = new TestObject1();
        object2.acquire();
        try {
            m.binding.put(object1).commit(null);
            m.binding.put(object2).commit(null);
            object2.setF1("newf2").setF2(400);
            object1.setF1("newf1").setF2(99);
            m.binding.remove(object2).commit(null);
            Assert.assertEquals((long)1L, (long)m.binding.size());
            Assert.assertSame((Object)object1, (Object)m.binding.get(object1.getId()));
            object1.validate((short)1, object1.getId(), m.binding, "newf1", 99);
            Assert.assertNull((Object)m.binding.get(object2.getId()));
            object2.validate((short)1, object2.getId(), null, "newf2", 400);
        }
        finally {
            m.close();
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryUpdate, StoreReplicatorOperation.CommitEntryRemove, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
        this.validateReplicationOperationObjectIds(m, object1.getId(), object2.getId(), object1.getId(), object2.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleObjectsInSameRollback() throws Exception {
        Member m = new Member("m", true, false);
        TestObject1 object1 = new TestObject1();
        TestObject1 object2 = new TestObject1();
        try {
            m.binding.put(object1).commit(null);
            m.binding.put(object2).commit(null);
            object1.setF1("newf1").setF2(99).getBinding().commit(null);
            object2.setF1("newf2").setF2(400).getBinding().commit(null);
            object1.setF1("anotherf1");
            m.binding.remove(object2);
            m.binding.rollback();
            Assert.assertEquals((long)2L, (long)m.binding.size());
            Assert.assertSame((Object)object1, (Object)m.binding.get(object1.getId()));
            object1.validate((short)1, object1.getId(), m.binding, "newf1", 99);
            Assert.assertSame((Object)object2, (Object)m.binding.get(object2.getId()));
            object2.validate((short)1, object2.getId(), m.binding, "newf2", 400);
        }
        finally {
            m.close();
        }
        this.validateReplicationOperations(m, StoreReplicatorOperation.Open, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryPut, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryUpdate, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.CommitStart, StoreReplicatorOperation.CommitEntryUpdate, StoreReplicatorOperation.CommitEnd, StoreReplicatorOperation.Close);
    }

    @Test
    public void testPrimaryRoleExpectationOnPrimaryMember() throws Exception {
        HashMap startupExpectations = new HashMap();
        startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Primary);
        Member m = new Member("m", startupExpectations, true);
        m.close();
    }

    @Test(expected=OdsExpectationNotMetException.class)
    public void testBackupRoleExpectationOnPrimaryMember() throws Exception {
        HashMap startupExpectations = new HashMap();
        startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Backup);
        Member m = new Member("m", startupExpectations, true);
        m.close();
    }

    @Test(expected=OdsExpectationNotMetException.class)
    public void testPrimaryRoleExpectationOnBackupMember() throws Exception {
        Member m1 = null;
        try {
            m1 = new Member("m1", true, true);
        }
        catch (OdsExpectationNotMetException e) {
            Assert.fail((String)"received expectation not met expectation when no expectation was specified!");
        }
        try {
            HashMap startupExpectations = new HashMap();
            startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Primary);
            new Member("m2", startupExpectations, true);
        }
        finally {
            m1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackupRoleExpectationOnBackupMember() throws Exception {
        Member m1 = null;
        try {
            m1 = new Member("m1", true, true);
        }
        catch (OdsExpectationNotMetException e) {
            Assert.fail((String)"received expectation not met expectation when no expectation was specified!");
        }
        try {
            HashMap startupExpectations = new HashMap();
            startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Backup);
            Member m2 = new Member("m2", startupExpectations, true);
            m2.close();
        }
        finally {
            m1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrimaryRoleExpectationOnPrimaryMemberWithICRSenderInStandaloneStore() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
        icrDescriptor.save();
        try {
            HashMap startupExpectations = new HashMap();
            startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Primary);
            Member m = new Member("m", icrDescriptor, startupExpectations, false);
            m.close();
        }
        finally {
            icrDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrimaryRoleExpectationOnPrimaryMemberWithICRSenderInReplicatedStore() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
        icrDescriptor.save();
        try {
            HashMap startupExpectations = new HashMap();
            startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Primary);
            Member m = new Member("m", icrDescriptor, startupExpectations, true);
            m.close();
        }
        finally {
            icrDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OdsExpectationNotMetException.class)
    public void testBackupRoleExpectationOnPrimaryMemberWithICRSenderInStandaloneStore() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
        icrDescriptor.save();
        try {
            HashMap startupExpectations = new HashMap();
            startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Backup);
            Member m = new Member("m", icrDescriptor, startupExpectations, false);
            m.close();
        }
        finally {
            icrDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OdsExpectationNotMetException.class)
    public void testBackupRoleExpectationOnPrimaryMemberWithICRSenderInReplicatedStore() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
        icrDescriptor.save();
        try {
            HashMap startupExpectations = new HashMap();
            startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Backup);
            Member m = new Member("m", icrDescriptor, startupExpectations, true);
            m.close();
        }
        finally {
            icrDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OdsExpectationNotMetException.class)
    public void testPrimaryRoleExpectationOnBackupMemberWithICRSender() throws Exception {
        Member m1 = null;
        try {
            m1 = new Member("m1", true, true);
        }
        catch (OdsExpectationNotMetException e) {
            Assert.fail((String)"received expectation not met expectation when no expectation was specified!");
        }
        try {
            StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
            icrDescriptor.save();
            try {
                HashMap startupExpectations = new HashMap();
                startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Primary);
                new Member("m2", icrDescriptor, startupExpectations, true);
            }
            finally {
                icrDescriptor.delete();
            }
        }
        finally {
            m1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackupRoleExpectationOnBackupMemberWithICRSender() throws Exception {
        Member m1 = null;
        try {
            m1 = new Member("m1", true, true);
        }
        catch (OdsExpectationNotMetException e) {
            Assert.fail((String)"received expectation not met expectation when no expectation was specified!");
        }
        try {
            StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
            icrDescriptor.save();
            try {
                HashMap startupExpectations = new HashMap();
                startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Backup);
                Member m2 = new Member("m2", icrDescriptor, startupExpectations, true);
                m2.close();
            }
            finally {
                icrDescriptor.delete();
            }
        }
        finally {
            m1.close();
        }
    }

    @Test(expected=OdsException.class)
    public void testStandaloneReceiverMemberInReplicatedStore() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try {
            new Member("m1", icrDescriptor, true);
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test(expected=OdsExpectationNotMetException.class)
    public void testPrimaryRoleExpectationOnStandaloneReceiverMember() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try {
            HashMap startupExpectations = new HashMap();
            startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Primary);
            new Member("m1", icrDescriptor, startupExpectations, false);
        }
        finally {
            icrDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackupRoleExpectationOnStandaloneReceiverMember() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrDescriptor.save();
        try {
            HashMap startupExpectations = new HashMap();
            startupExpectations.put(IStoreBinding.StartupExpectation.Role, IStoreBinding.Role.Backup);
            Member m1 = new Member("m1", icrDescriptor, startupExpectations, false);
            m1.close();
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test(expected=OdsException.class)
    public void testICRSenderOpenFail() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.Sender, "invalid://store");
        icrDescriptor.save();
        try {
            new Member("m", icrDescriptor, false);
        }
        finally {
            icrDescriptor.delete();
        }
    }

    @Test(expected=OdsException.class)
    public void testICRStandaloneReceiverOpenFail() throws Exception {
        StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create("m1", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "invalid://store");
        icrDescriptor.save();
        try {
            new Member("m", icrDescriptor, false);
        }
        finally {
            icrDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testICRWithPrimaryNoBackupStandaloneReceiverSinglePut() throws Exception {
        StoreInterClusterReplicatorDescriptor icrSenderDescriptor = StoreInterClusterReplicatorDescriptor.create("icrSender", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
        icrSenderDescriptor.setProperty("detachedWrite", "false");
        icrSenderDescriptor.save();
        StoreInterClusterReplicatorDescriptor icrReceiverDescriptor = StoreInterClusterReplicatorDescriptor.create("icrReceiver", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrReceiverDescriptor.setProperty("detachedWrite", "false");
        icrReceiverDescriptor.save();
        try {
            Member m1 = new Member("m1", icrSenderDescriptor, true);
            try (Member m2 = new Member("m2", icrReceiverDescriptor, false);){
                m1.binding.put(new TestObject1()).commit(null);
                Assert.assertTrue((boolean)m2.eventHandler.wait(1));
                Assert.assertEquals((long)307L, (long)m2.eventHandler.events[0].getType());
            }
            finally {
                m1.close();
                icrSenderDescriptor.delete();
            }
        }
        finally {
            icrSenderDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testICRWithPrimaryNoBackupStandaloneReceiverMultiplePut() throws Exception {
        StoreInterClusterReplicatorDescriptor icrSenderDescriptor = StoreInterClusterReplicatorDescriptor.create("icrSender", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
        icrSenderDescriptor.setProperty("detachedWrite", "false");
        icrSenderDescriptor.save();
        StoreInterClusterReplicatorDescriptor icrReceiverDescriptor = StoreInterClusterReplicatorDescriptor.create("icrReceiver", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrReceiverDescriptor.setProperty("detachedWrite", "false");
        icrReceiverDescriptor.save();
        try {
            Member m1 = new Member("m1", icrSenderDescriptor, true);
            try (Member m2 = new Member("m2", icrReceiverDescriptor, false);){
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject2()).commit(null);
                Assert.assertTrue((boolean)m2.eventHandler.wait(2));
                Assert.assertEquals((long)307L, (long)m2.eventHandler.events[0].getType());
                Assert.assertEquals((long)307L, (long)m2.eventHandler.events[1].getType());
            }
            finally {
                m1.close();
                icrSenderDescriptor.delete();
            }
        }
        finally {
            icrSenderDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testICRWithPrimaryBackupStandaloneReceiverPutSendUpdateRemove() throws Exception {
        StoreInterClusterReplicatorDescriptor icrSenderDescriptor = StoreInterClusterReplicatorDescriptor.create("icrSender", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
        icrSenderDescriptor.setProperty("detachedWrite", "false");
        icrSenderDescriptor.save();
        StoreInterClusterReplicatorDescriptor icrReceiverDescriptor = StoreInterClusterReplicatorDescriptor.create("icrReceiver", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrReceiverDescriptor.setProperty("detachedWrite", "false");
        icrReceiverDescriptor.save();
        TestObject1 testObject1 = new TestObject1();
        TestObject2 testObject2 = new TestObject2();
        TestObject2 testObject3 = new TestObject2();
        try (Member m1 = new Member("m2", icrSenderDescriptor, true);
             Member m2 = new Member("m1", icrSenderDescriptor, true);
             Member m3 = new Member("m3", icrReceiverDescriptor, false);){
            m1.binding.put(testObject1);
            m1.binding.put(testObject2);
            m1.binding.send(testObject3);
            m1.binding.commit(null);
            Assert.assertTrue((boolean)m2.eventHandler.wait(3));
            Assert.assertEquals((long)307L, (long)m2.eventHandler.events[0].getType());
            Assert.assertEquals((long)307L, (long)m2.eventHandler.events[1].getType());
            Assert.assertEquals((long)309L, (long)m2.eventHandler.events[2].getType());
            Assert.assertTrue((boolean)m3.eventHandler.wait(3));
            Assert.assertEquals((long)307L, (long)m3.eventHandler.events[0].getType());
            Assert.assertEquals((long)307L, (long)m3.eventHandler.events[1].getType());
            Assert.assertEquals((long)309L, (long)m3.eventHandler.events[2].getType());
            testObject1.setF2(100);
            m1.binding.commit(null);
            Assert.assertTrue((boolean)m2.eventHandler.wait(4));
            Assert.assertEquals((long)310L, (long)m2.eventHandler.events[3].getType());
            Assert.assertTrue((boolean)m3.eventHandler.wait(4));
            Assert.assertEquals((long)310L, (long)m3.eventHandler.events[3].getType());
            m1.binding.remove(testObject2);
            m1.binding.commit(null);
            Assert.assertTrue((boolean)m2.eventHandler.wait(5));
            Assert.assertEquals((long)308L, (long)m2.eventHandler.events[4].getType());
            Assert.assertTrue((boolean)m3.eventHandler.wait(5));
            Assert.assertEquals((long)308L, (long)m3.eventHandler.events[4].getType());
            for (int i = 0; i < 10; ++i) {
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject1());
                m1.binding.commit(null);
                Thread.sleep(100L);
            }
            Assert.assertEquals((long)1L, (long)((PktPacket)testObject1.getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)testObject2.getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)testObject3.getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject1)m2.binding.get(testObject1.getId())).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject2)((IStoreObjectAddedEvent)m2.eventHandler.events[1]).getObject()).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject2)((IStoreObjectReceivedEvent)m2.eventHandler.events[2]).getObject()).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject1)m3.binding.get(testObject1.getId())).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject2)((IStoreObjectAddedEvent)m3.eventHandler.events[1]).getObject()).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject2)((IStoreObjectReceivedEvent)m3.eventHandler.events[2]).getObject()).getMessage()).getOwnerCount());
        }
        finally {
            icrSenderDescriptor.delete();
            icrReceiverDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testICRWithPrimaryBackupStandaloneReceiverPutSendUpdateRemoveWithPersist() throws Exception {
        long ts = System.currentTimeMillis();
        String appName = "app-" + ts;
        StorePersisterDescriptor persisterSender1Descriptor = StorePersisterDescriptor.create(appName + "-s1", "com.neeve.rog.log.RogLog");
        persisterSender1Descriptor.setProperty("storeRoot", XRuntime.getDataDirectory((boolean)false) + File.separator + "s1");
        persisterSender1Descriptor.setProperty("flushOnCommit", "true");
        persisterSender1Descriptor.setProperty("detachedWrite", "false");
        persisterSender1Descriptor.save();
        StorePersisterDescriptor persisterSender2Descriptor = StorePersisterDescriptor.create(appName + "-s2", "com.neeve.rog.log.RogLog");
        persisterSender2Descriptor.setProperty("storeRoot", XRuntime.getDataDirectory((boolean)false) + File.separator + "s2");
        persisterSender2Descriptor.setProperty("flushOnCommit", "true");
        persisterSender2Descriptor.setProperty("detachedWrite", "false");
        persisterSender2Descriptor.save();
        StorePersisterDescriptor persisterReceiverDescriptor = StorePersisterDescriptor.create(appName + "-r", "com.neeve.rog.log.RogLog");
        persisterReceiverDescriptor.setProperty("storeRoot", XRuntime.getDataDirectory((boolean)false) + File.separator + "r");
        persisterReceiverDescriptor.setProperty("flushOnCommit", "true");
        persisterReceiverDescriptor.setProperty("detachedWrite", "false");
        persisterReceiverDescriptor.save();
        StoreInterClusterReplicatorDescriptor icrSenderDescriptor = StoreInterClusterReplicatorDescriptor.create(appName + "-icr-sender", IStoreBinding.InterClusterReplicationRole.Sender, "loopback://store");
        icrSenderDescriptor.setProperty("detachedWrite", "false");
        icrSenderDescriptor.save();
        StoreInterClusterReplicatorDescriptor icrReceiverDescriptor = StoreInterClusterReplicatorDescriptor.create(appName + "-icr-receiver", IStoreBinding.InterClusterReplicationRole.StandaloneReceiver, "loopback://store");
        icrReceiverDescriptor.setProperty("detachedWrite", "false");
        icrReceiverDescriptor.save();
        TestObject1 testObject1 = new TestObject1();
        TestObject2 testObject2 = new TestObject2();
        TestObject2 testObject3 = new TestObject2();
        try (Member m1 = new Member("m1", persisterSender1Descriptor, icrSenderDescriptor, null, true, true);
             Member m2 = new Member("m2", persisterSender2Descriptor, icrSenderDescriptor, null, true, true);
             Member m3 = new Member("m3", persisterReceiverDescriptor, icrReceiverDescriptor, null, false, false);){
            m1.binding.put(testObject1);
            m1.binding.put(testObject2);
            m1.binding.send(testObject3);
            m1.binding.commit(null);
            Assert.assertTrue((boolean)m2.eventHandler.wait(3));
            Assert.assertEquals((long)307L, (long)m2.eventHandler.events[0].getType());
            Assert.assertEquals((long)307L, (long)m2.eventHandler.events[1].getType());
            Assert.assertEquals((long)309L, (long)m2.eventHandler.events[2].getType());
            Assert.assertTrue((boolean)m3.eventHandler.wait(3));
            Assert.assertEquals((long)307L, (long)m3.eventHandler.events[0].getType());
            Assert.assertEquals((long)307L, (long)m3.eventHandler.events[1].getType());
            Assert.assertEquals((long)309L, (long)m3.eventHandler.events[2].getType());
            testObject1.setF2(100);
            m1.binding.commit(null);
            Assert.assertTrue((boolean)m2.eventHandler.wait(4));
            Assert.assertEquals((long)310L, (long)m2.eventHandler.events[3].getType());
            Assert.assertTrue((boolean)m3.eventHandler.wait(4));
            Assert.assertEquals((long)310L, (long)m3.eventHandler.events[3].getType());
            m1.binding.remove(testObject2);
            m1.binding.commit(null);
            Assert.assertTrue((boolean)m2.eventHandler.wait(5));
            Assert.assertEquals((long)308L, (long)m2.eventHandler.events[4].getType());
            Assert.assertTrue((boolean)m3.eventHandler.wait(5));
            Assert.assertEquals((long)308L, (long)m3.eventHandler.events[4].getType());
            for (int i = 0; i < 10; ++i) {
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject1());
                m1.binding.put(new TestObject1());
                m1.binding.commit(null);
                Thread.sleep(100L);
            }
            Assert.assertEquals((long)1L, (long)((PktPacket)testObject1.getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)testObject2.getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)testObject3.getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject1)m2.binding.get(testObject1.getId())).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject2)((IStoreObjectAddedEvent)m2.eventHandler.events[1]).getObject()).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject2)((IStoreObjectReceivedEvent)m2.eventHandler.events[2]).getObject()).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject1)m3.binding.get(testObject1.getId())).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject2)((IStoreObjectAddedEvent)m3.eventHandler.events[1]).getObject()).getMessage()).getOwnerCount());
            Assert.assertEquals((long)1L, (long)((PktPacket)((TestObject2)((IStoreObjectReceivedEvent)m3.eventHandler.events[2]).getObject()).getMessage()).getOwnerCount());
        }
        finally {
            icrSenderDescriptor.delete();
            icrReceiverDescriptor.delete();
            persisterSender1Descriptor.delete();
            persisterSender2Descriptor.delete();
            persisterReceiverDescriptor.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProgrammaticDiscoveryAddress() throws Exception {
        StoreDescriptor m1Desc = StoreDescriptor.create("m1");
        StoreReplicatorDescriptor m1ReplicatorDescriptor = StoreReplicatorDescriptor.create("store1");
        m1ReplicatorDescriptor.setProperty("discoveryDescriptor", "mcast://224.0.0.1:4070");
        m1ReplicatorDescriptor.setProperty("storeName", "store1");
        m1ReplicatorDescriptor.save();
        m1Desc.setReplicator(m1ReplicatorDescriptor.getName());
        StoreDescriptor m2Desc = StoreDescriptor.create("m2");
        StoreReplicatorDescriptor m2ReplicatorDescriptor = StoreReplicatorDescriptor.create("store2");
        m2ReplicatorDescriptor.setProperty("discoveryDescriptor", "mcast://224.0.0.1:4060");
        m2ReplicatorDescriptor.setProperty("storeName", "store2");
        m2ReplicatorDescriptor.save();
        m2Desc.setReplicator(m2ReplicatorDescriptor.getName());
        Member m1 = new Member(m1Desc, null);
        Member m2 = new Member(m2Desc, null);
        try {
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
            Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m2.binding.getRole()));
        }
        finally {
            m2.close();
            m1.close();
            m1ReplicatorDescriptor.delete();
            m2ReplicatorDescriptor.delete();
        }
    }

    private final Thread createMemberThread(String threadName, final Member m1, final int startDelay) {
        Thread thread = new Thread(){

            @Override
            public final void run() {
                try {
                    if (startDelay > 0) {
                        Thread.sleep(startDelay);
                    }
                    m1.binding.open();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        thread.setName(threadName);
        System.out.println(threadName + " thread:" + thread.getId());
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testPrimaryBusyOnConcurrentClusterFormation(int primaryStartDelay, int backupStartDelay) throws Exception {
        Member m1 = new Member("m1", null, null, null, true, false, true);
        Member m2 = new Member("m2", null, null, null, true, false, true);
        m1.eventHandler.setToBlockOn(315);
        Thread primary = this.createMemberThread("Primary", m1, primaryStartDelay);
        Thread backup = this.createMemberThread("Backup", m2, backupStartDelay);
        System.out.println("Starting primary and backup");
        try {
            primary.start();
            backup.start();
            if (!m1.eventHandler.waitForBlockedInEventHandler(10000L)) {
                throw new RuntimeException("backup connect event did not arrive at primary");
            }
            Thread.sleep(6000L);
        }
        finally {
            EventHandler eventHandler = m1.eventHandler;
            synchronized (eventHandler) {
                m1.eventHandler.setToBlockOn(0);
                m1.eventHandler.notifyAll();
            }
        }
        Thread.sleep(5000L);
        boolean success = true;
        do {
            primary.join(5000L);
            if (!primary.isAlive()) continue;
            m1.binding.fail(new Exception("force failing because thread is stuck"));
            success = false;
        } while (primary.isAlive());
        do {
            backup.join(5000L);
            if (!backup.isAlive()) continue;
            m1.binding.fail(new Exception("force failing because thread is stuck"));
            success = false;
        } while (backup.isAlive());
        try {
            if (success) {
                Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
                Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            } else {
                Assert.fail((String)"primary or backup main thread did not exit correctly");
            }
        }
        finally {
            m2.close();
            m1.close();
        }
    }

    @Test
    public void testPrimaryBusyOnConcurrentClusterFormation_SimultaneousLaunch() throws Exception {
        this.testPrimaryBusyOnConcurrentClusterFormation(0, 0);
    }

    @Test
    public void testPrimaryBusyOnConcurrentClusterFormation_PrimaryFirstAndThenBackup() throws Exception {
        this.testPrimaryBusyOnConcurrentClusterFormation(0, 1000);
    }

    @Test
    public void testPrimaryBusyOnConcurrentClusterFormation_BackupFirstAndThenPrimary() throws Exception {
        this.testPrimaryBusyOnConcurrentClusterFormation(1000, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testPrimaryBusyOnSequentialClusterFormation(String m1Name, String m2Name, int eventToBlockOnToSimulateBusy) throws Exception {
        Member m1 = new Member(m1Name, null, null, null, true, false, true);
        Member m2 = new Member(m2Name, null, null, null, true, false, true);
        m1.eventHandler.setToBlockOn(eventToBlockOnToSimulateBusy);
        Thread backup = this.createMemberThread("Backup", m2, 0);
        System.out.println("Starting primary and backup");
        try {
            m1.binding.open();
            backup.start();
            if (!m1.eventHandler.waitForBlockedInEventHandler(10000L)) {
                throw new RuntimeException("event to block on did not occur on the primary");
            }
            Thread.sleep(6000L);
        }
        finally {
            EventHandler eventHandler = m1.eventHandler;
            synchronized (eventHandler) {
                m1.eventHandler.setToBlockOn(0);
                m1.eventHandler.notifyAll();
            }
        }
        Thread.sleep(5000L);
        boolean success = true;
        do {
            backup.join(5000L);
            if (!backup.isAlive()) continue;
            m2.binding.fail(new Exception("force failing because thread is stuck"));
            success = false;
        } while (backup.isAlive());
        try {
            if (success) {
                Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
                Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            } else {
                Assert.fail((String)"primary or backup main thread did not exit correctly");
            }
        }
        finally {
            m2.close();
            m1.close();
        }
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_BackupConnectsToPrimary_PrimaryBlocksInMemberFound() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m1", "m2", 312);
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_BackupConnectsToPrimary_PrimaryBlocksInMemberConnect() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m1", "m2", 315);
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_BackupConnectsToPrimary_PrimaryBlocksInHandshakeStartReady() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m1", "m2", 316);
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_BackupConnectsToPrimary_PrimaryBlocksInBackupHello() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m1", "m2", 317);
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_BackupConnectsToPrimary_PrimaryBlocksInInitReady() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m1", "m2", 314);
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_PrimaryConnectsToBackup_PrimaryBlocksInMemberFound() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m2", "m1", 312);
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_PrimaryConnectsToBackup_PrimaryBlocksInMemberConnectReply() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m2", "m1", 318);
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_PrimaryConnectsToBackup_PrimaryBlocksInHandshakeStartReady() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m2", "m1", 316);
    }

    @Test
    public void testPrimaryBusyOnSequentialClusterFormation_PrimaryConnectsToBackup_PrimaryBlocksInInitReady() throws Exception {
        this.testPrimaryBusyOnSequentialClusterFormation("m2", "m1", 314);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemberDiscoveryIsDelayedBehindAccept() throws Exception {
        StoreDescriptor m1Desc = StoreDescriptor.create("m1");
        StoreReplicatorDescriptor m1ReplicatorDescriptor = StoreReplicatorDescriptor.create("store1");
        m1ReplicatorDescriptor.setProperty("discoveryDescriptor", "mcast://224.0.0.1:4070");
        m1ReplicatorDescriptor.setProperty("storeName", "store");
        m1ReplicatorDescriptor.save();
        m1Desc.setReplicator(m1ReplicatorDescriptor.getName());
        StoreDescriptor m2Desc = StoreDescriptor.create("m2");
        StoreReplicatorDescriptor m2ReplicatorDescriptor = StoreReplicatorDescriptor.create("store2");
        m2ReplicatorDescriptor.setProperty("discoveryDescriptor", "mcast://224.0.0.1:4070");
        m2ReplicatorDescriptor.setProperty("storeName", "store");
        m2ReplicatorDescriptor.save();
        m2Desc.setReplicator(m2ReplicatorDescriptor.getName());
        Member m1 = new Member(m1Desc, null, false);
        Member m2 = new Member(m2Desc, null, false);
        m1.replicatorNotificationHandler.setToBlockOn(StoreReplicatorOperation.HandleEntityAdd, 2);
        Thread backup = this.createMemberThread("Backup", m2, 0);
        System.out.println("Starting primary and backup");
        try {
            m1.binding.open();
            backup.start();
            if (!m1.replicatorNotificationHandler.waitForBlockedInNotificationHandler(10000L)) {
                throw new RuntimeException("event to block on did not occur on the primary");
            }
            Thread.sleep(6000L);
        }
        finally {
            ReplicatorNotificationHandler replicatorNotificationHandler = m1.replicatorNotificationHandler;
            synchronized (replicatorNotificationHandler) {
                m1.replicatorNotificationHandler.setToBlockOn(null, 0);
                m1.replicatorNotificationHandler.notifyAll();
            }
        }
        Thread.sleep(5000L);
        boolean success = true;
        do {
            backup.join(5000L);
            if (!backup.isAlive()) continue;
            m1.binding.fail(new Exception("force failing because thread is stuck"));
            success = false;
        } while (backup.isAlive());
        try {
            if (success) {
                Assert.assertEquals((Object)((Object)IStoreBinding.Role.Primary), (Object)((Object)m1.binding.getRole()));
                Assert.assertEquals((Object)((Object)IStoreBinding.Role.Backup), (Object)((Object)m2.binding.getRole()));
            } else {
                Assert.fail((String)"primary or backup main thread did not exit correctly");
            }
        }
        finally {
            m2.close();
            m1.close();
        }
    }

    @AfterClass
    public static void cleanup() throws Exception {
        StoreReplicatorDescriptor.load("store").delete();
    }

    private static final class Remover
    extends Thread {
        private final Member m;
        private final IStoreObject object;
        private final boolean commit;

        Remover(Member m, IStoreObject object, boolean commit) {
            this.m = m;
            this.object = object;
            this.commit = commit;
        }

        @Override
        public final void run() {
            this.m.binding.remove(this.object);
            if (this.commit) {
                try {
                    this.m.binding.commit(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static final class Putter
    extends Thread {
        private final Member m;
        private final IStoreObject object;
        private final boolean commit;

        Putter(Member m, IStoreObject object, boolean commit) {
            this.m = m;
            this.object = object;
            this.commit = commit;
        }

        @Override
        public final void run() {
            this.m.binding.put(this.object);
            if (this.commit) {
                try {
                    this.m.binding.commit(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private final class Member {
        final StoreDescriptor descriptor;
        final IStoreBinding binding;
        final EventHandler eventHandler;
        final ReplicatorNotificationHandler replicatorNotificationHandler;
        long lastTransactionId = 0L;

        Member(StoreDescriptor descriptor, Map<IStoreBinding.StartupExpectation, Enum<?>> startupExpectations, boolean open) throws OdsException {
            this.descriptor = descriptor;
            this.eventHandler = new EventHandler(this);
            this.replicatorNotificationHandler = new ReplicatorNotificationHandler();
            this.binding = StoreBindingFactory.getInstance().createBinding(descriptor.getName(), descriptor, (IStoreEventHandler)this.eventHandler, (IStoreReplicatorNotificationHandler)this.replicatorNotificationHandler, 2);
            if (open) {
                this.binding.open(startupExpectations);
            }
        }

        Member(StoreDescriptor descriptor, Map<IStoreBinding.StartupExpectation, Enum<?>> startupExpectations) throws OdsException {
            this(descriptor, startupExpectations, true);
        }

        Member(String name, StorePersisterDescriptor persisterDescriptor, StoreInterClusterReplicatorDescriptor icrDescriptor, Map<IStoreBinding.StartupExpectation, Enum<?>> startupExpectations, boolean replicated, boolean clustered, String replicatorName, boolean open) throws Exception {
            this.descriptor = StoreDescriptor.create("store");
            if (replicated) {
                this.descriptor.setReplicator(replicatorName != null ? replicatorName : "store");
                if (!clustered) {
                    StoreReplicatorDescriptor.load(this.descriptor.getReplicator()).setProperty("discoveryDescriptor", "local://.&initWaitTime=0").setProperty("initWaitTime", "0").save();
                } else {
                    StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.load(this.descriptor.getReplicator());
                    replicatorDescriptor.getProperties().remove("discoveryDescriptor");
                    replicatorDescriptor.getProperties().remove("initWaitTime");
                    replicatorDescriptor.save();
                }
            } else {
                this.descriptor.setReplicator(null);
            }
            this.descriptor.setPersister(persisterDescriptor != null ? persisterDescriptor.getName() : null);
            this.descriptor.setInterClusterReplicator(icrDescriptor != null ? icrDescriptor.getName() : null);
            this.eventHandler = new EventHandler(this);
            try {
                this.replicatorNotificationHandler = new ReplicatorNotificationHandler();
                this.binding = StoreBindingFactory.getInstance().createBinding(name, this.descriptor, (IStoreEventHandler)this.eventHandler, (IStoreReplicatorNotificationHandler)this.replicatorNotificationHandler, 2);
                if (open) {
                    this.binding.open(startupExpectations);
                }
            }
            catch (Exception e) {
                this.eventHandler.close();
                throw e;
            }
            catch (Error e) {
                this.eventHandler.close();
                throw e;
            }
        }

        Member(String name, StorePersisterDescriptor persisterDescriptor, StoreInterClusterReplicatorDescriptor icrDescriptor, Map<IStoreBinding.StartupExpectation, Enum<?>> startupExpectations, boolean replicated, boolean open, boolean clustered) throws Exception {
            this(name, persisterDescriptor, icrDescriptor, startupExpectations, replicated, clustered, null, open);
        }

        Member(String name, StorePersisterDescriptor persisterDescriptor, StoreInterClusterReplicatorDescriptor icrDescriptor, Map<IStoreBinding.StartupExpectation, Enum<?>> startupExpectations, boolean replicated, boolean clustered) throws Exception {
            this(name, persisterDescriptor, icrDescriptor, startupExpectations, replicated, true, clustered);
        }

        Member(String name, StoreInterClusterReplicatorDescriptor icrDescriptor, Map<IStoreBinding.StartupExpectation, Enum<?>> startupExpectations, boolean hasReplicator) throws Exception {
            this(name, null, icrDescriptor, startupExpectations, hasReplicator, true);
        }

        Member(String name, StoreInterClusterReplicatorDescriptor icrDescriptor, boolean hasReplicator) throws Exception {
            this(name, null, icrDescriptor, null, hasReplicator, true);
        }

        Member(String name, Map<IStoreBinding.StartupExpectation, Enum<?>> startupExpectations, boolean hasReplicator) throws Exception {
            this(name, null, null, startupExpectations, hasReplicator, true);
        }

        Member(String name, boolean hasReplicator, boolean clustered) throws Exception {
            this(name, null, null, null, hasReplicator, clustered);
        }

        Member(String name, String replicatorName, boolean open) throws Exception {
            this(name, null, null, null, true, true, replicatorName, open);
        }

        Member(String name) throws Exception {
            this(name, null, null, null, false, false);
        }

        public void commit() throws OdsException, InterruptedException {
            IStoreCommitCompletionEvent event = this.binding.createCommitCompletionEvent();
            event.setNotify(true);
            event.setEndOfBatch(true);
            ++this.lastTransactionId;
            this.binding.commit(this.lastTransactionId, this.lastTransactionId, event, 0);
            event.waitForCompletion();
        }

        void close() throws Exception {
            this.eventHandler.close();
            this.binding.close(0);
        }
    }

    private final class ReplicatorNotificationHandler
    implements IStoreReplicatorNotificationHandler {
        final List<StoreReplicatorOperation> operations = new ArrayList<StoreReplicatorOperation>();
        final List<UUID> objectIds = new ArrayList<UUID>();
        private final Object blockedInNotificationHandlerNotifier = new Object();
        StoreReplicatorOperation blockOnOp;
        int blockOnCount;
        private boolean blockedInNotificationHandler;

        private ReplicatorNotificationHandler() {
        }

        final void setToBlockOn(StoreReplicatorOperation op, int count) {
            this.blockOnOp = op;
            this.blockOnCount = count;
        }

        private final long elapsedTime(long ts) {
            return System.currentTimeMillis() - ts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean waitForBlockedInNotificationHandler(long maxTimeInMillis) {
            Object object = this.blockedInNotificationHandlerNotifier;
            synchronized (object) {
                long ts = System.currentTimeMillis();
                while (!this.blockedInNotificationHandler && this.elapsedTime(ts) <= maxTimeInMillis) {
                    try {
                        this.blockedInNotificationHandlerNotifier.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.blockedInNotificationHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onOperation(StoreReplicatorOperation op, Object data) {
            ReplicatorNotificationHandler replicatorNotificationHandler = this;
            synchronized (replicatorNotificationHandler) {
                block16: {
                    try {
                        if (this.blockOnCount <= 0 || this.blockOnOp != op || --this.blockOnCount != 0) break block16;
                        while (this.blockOnOp == op) {
                            Object object = this.blockedInNotificationHandlerNotifier;
                            synchronized (object) {
                                this.blockedInNotificationHandler = true;
                                this.blockedInNotificationHandlerNotifier.notifyAll();
                            }
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    finally {
                        this.blockedInNotificationHandler = false;
                    }
                }
            }
            switch (op) {
                case CommitEntryPut: 
                case CommitEntryUpdate: 
                case CommitEntryRemove: 
                case CommitEntrySend: {
                    this.objectIds.add(((StoreCommitEntry)data).id);
                    this.operations.add(op);
                    break;
                }
                case Open: 
                case StartMemberInit: 
                case SendMemberInitEntry: 
                case CompleteMemberInit: 
                case CommitStart: 
                case CommitEnd: 
                case Close: {
                    this.operations.add(op);
                    break;
                }
            }
        }
    }

    private final class EventHandler
    implements IStoreEventHandler {
        private final IEventMultiplexer multiplexer;
        private final Object blockedInEventHandlerNotifier = new Object();
        private int blockOnEventType;
        private boolean blockedInEventHandler;
        final IStoreEvent[] events = new IStoreEvent[256];
        int count = 0;
        Member member;

        EventHandler() {
            this.multiplexer = null;
        }

        EventHandler(Member member) {
            this.multiplexer = EventMultiplexerSingleThreaded.create((String)(StoreBindingTest.this.testcaseName.getMethodName() + "-" + member.descriptor.getName()), (boolean)true, (IEventHandler)new EventMultiplexerEventHandler(), null);
            this.multiplexer.open();
            this.member = member;
        }

        private final long elapsedTime(long ts) {
            return System.currentTimeMillis() - ts;
        }

        private final boolean isContinuationEvent(IStoreEvent event) {
            switch (event.getType()) {
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: {
                    return true;
                }
            }
            return false;
        }

        private final boolean isTransactionEvent(IStoreEvent event) {
            switch (event.getType()) {
                case 307: 
                case 308: 
                case 309: 
                case 310: {
                    return true;
                }
            }
            return false;
        }

        final void setToBlockOn(int eventType) {
            this.blockOnEventType = eventType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean waitForBlockedInEventHandler(long maxTimeInMillis) {
            Object object = this.blockedInEventHandlerNotifier;
            synchronized (object) {
                long ts = System.currentTimeMillis();
                while (!this.blockedInEventHandler && this.elapsedTime(ts) <= maxTimeInMillis) {
                    try {
                        this.blockedInEventHandlerNotifier.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.blockedInEventHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean wait(int expectedCount) {
            EventHandler eventHandler = this;
            synchronized (eventHandler) {
                long ts = System.currentTimeMillis();
                while (this.count < expectedCount && this.elapsedTime(ts) <= 10000L) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.count == expectedCount;
            }
        }

        final void close() {
            if (this.multiplexer != null) {
                this.multiplexer.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onEvent(IStoreEvent event) {
            EventHandler eventHandler = this;
            synchronized (eventHandler) {
                try {
                    while (this.blockOnEventType == event.getType()) {
                        Object object = this.blockedInEventHandlerNotifier;
                        synchronized (object) {
                            this.blockedInEventHandler = true;
                            this.blockedInEventHandlerNotifier.notifyAll();
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    this.blockedInEventHandler = false;
                }
                if (this.isContinuationEvent(event)) {
                    this.multiplexer.multiplexEvent((Event)event, 1);
                }
                if (this.isTransactionEvent(event)) {
                    try {
                        event.acquire();
                        this.events[this.count++] = event;
                        this.notifyAll();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (event instanceof StoreBindingFailedEvent) {
                    StoreBindingFailedEvent failureEvent = (StoreBindingFailedEvent)event;
                    failureEvent.getCause().printStackTrace();
                }
            }
        }

        public String toString() {
            return this.member != null ? this.member.descriptor.getName() : "EventHandler";
        }

        private final class EventMultiplexerEventHandler
        implements IEventHandler {
            private EventMultiplexerEventHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onEvent(Event event) {
                EventMultiplexerEventHandler eventMultiplexerEventHandler = this;
                synchronized (eventMultiplexerEventHandler) {
                    EventHandler.this.member.binding.processMemberControlEvent((IStoreMemberControlEvent)event);
                }
            }
        }
    }

    private static final class TestObject2
    extends RogNode {
        private final int offset_start = 0;
        private final int offset_type = 0;
        private final int offset_end = 2;
        private final int fid_f1 = super.getLastFid() + 1;
        private final int fid_f2 = super.getLastFid() + 2;
        private StoFieldContainer container;
        private StoBufferField fld_buffer;
        private StoStringField fld_f1;
        private StoLongField fld_f2;
        private ByteBuffer fixlenFieldBuffer;

        TestObject2() throws Exception {
            this(new UUID(), PktFactory.getInstance().createPacket(774));
        }

        TestObject2(UUID id, PktPacket packet) throws Exception {
            super((short)1, (short)0, (short)2, id, true);
            this.setContentContainer(packet);
            if (this.container.count() == 0) {
                this.createFields();
            } else {
                this.initFields();
            }
        }

        private final void setContentContainer(PktPacket packet) {
            this.container = ((PktBodyStoContainer)packet.getBody()).getContainer();
            this.setMessage(1, packet);
        }

        private final void createFields() {
            this.fld_buffer = StoBufferField.create((String)null, (int)2);
            this.container.append((StoField)this.fld_buffer);
            this.fixlenFieldBuffer = this.fld_buffer.getValue((StoBufferField.ChangeNotifier)new FixlenFieldBufferChangeReceiver());
            this.fld_f2 = StoLongField.create(null);
            this.container.append((StoField)this.fld_f2);
            this.fld_f1 = StoStringField.create(null);
            this.container.append((StoField)this.fld_f1);
        }

        private final void initFields() {
            this.fld_buffer = (StoBufferField)this.container.first();
            this.fixlenFieldBuffer = this.fld_buffer.getValue((StoBufferField.ChangeNotifier)new FixlenFieldBufferChangeReceiver());
            this.fld_f2 = (StoLongField)this.container.next();
            this.fld_f1 = (StoStringField)this.container.next();
        }

        public final byte[] serializeToByteArray() {
            throw new UnsupportedOperationException();
        }

        public final ByteBuffer serializeToByteBuffer() {
            throw new UnsupportedOperationException();
        }

        public final PktPacket serializeToPacket() {
            this.sync();
            ((PktPacket)this.getMessage()).acquire();
            return (PktPacket)this.getMessage();
        }

        @Override
        public final Message serializeToProtobuf() {
            throw new UnsupportedOperationException();
        }

        public final String serializeToJson() {
            throw new UnsupportedOperationException();
        }

        public final TestObject2 deserializeFromByteArray(byte[] array) {
            throw new UnsupportedOperationException();
        }

        public final TestObject2 deserializeFromByteBuffer(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        public final TestObject2 deserializeFromPacket(PktPacket packet) {
            this.setContentContainer(packet);
            this.initFields();
            return this;
        }

        @Override
        public final TestObject2 deserializeFromProtobuf(Message message) {
            throw new UnsupportedOperationException();
        }

        public final TestObject2 deserializeFromJson(String json) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int getLastFid() {
            return this.fid_f2;
        }

        public final void sync() {
            this.fixlenFieldBuffer.putShort(0, this.getType());
        }

        @Override
        public final IStoreObject.EncodingType getContentEncodingType() {
            return IStoreObject.EncodingType.Custom;
        }

        @Override
        public final PktPacket serialize() {
            return this.serializeToPacket();
        }

        @Override
        public final IStoreObject deserialize(PktPacket packet) {
            return this.deserializeFromPacket(packet);
        }

        @Override
        public final IStoreObject setFieldValue(long fid, Object val) {
            if (fid == (long)this.fid_f1) {
                this.fld_f1.setValue((Object)((String)val));
            } else if (fid == (long)this.fid_f2) {
                this.fld_f2.setValue(((Long)val).longValue());
            } else {
                super.setFieldValue(fid, val);
            }
            return this;
        }

        public static final class Packet
        extends PktBodyStoContainer {
            private Packet(Properties props, boolean direct) {
                super(774, props, direct);
            }

            public static PktBody create(Properties props) {
                return new Packet(props, false);
            }

            public static PktBody create() {
                return Packet.create(null);
            }
        }

        private final class FixlenFieldBufferChangeReceiver
        implements StoBufferField.ChangeNotifier {
            private FixlenFieldBufferChangeReceiver() {
            }

            public final void onChange(ByteBuffer newBuffer) {
                TestObject2.this.fixlenFieldBuffer = newBuffer;
            }
        }
    }

    private static final class TestObject1
    extends RogNode {
        private final int offset_start = 0;
        private final int offset_type = 0;
        private final int offset_end = 2;
        private final int fid_f1 = super.getLastFid() + 1;
        private final int fid_f2 = super.getLastFid() + 2;
        private StoFieldContainer container;
        private StoBufferField fld_buffer;
        private StoStringField fld_f1;
        private StoIntField fld_f2;
        private ByteBuffer fixlenFieldBuffer;

        TestObject1() throws Exception {
            this(new UUID(), PktFactory.getInstance().createPacket(773));
        }

        TestObject1(UUID id, PktPacket packet) throws Exception {
            super((short)1, (short)0, (short)1, id, true);
            this.setContentContainer(packet);
            if (this.container.count() == 0) {
                this.createFields();
            } else {
                this.initFields();
            }
        }

        private final void setContentContainer(PktPacket packet) {
            this.container = ((PktBodyStoContainer)packet.getBody()).getContainer();
            this.setMessage(1, packet);
        }

        private final void createFields() {
            this.fld_buffer = StoBufferField.create((String)null, (int)2);
            this.container.append((StoField)this.fld_buffer);
            this.fixlenFieldBuffer = this.fld_buffer.getValue((StoBufferField.ChangeNotifier)new FixlenFieldBufferChangeReceiver());
            this.fld_f2 = StoIntField.create(null);
            this.container.append((StoField)this.fld_f2);
            this.fld_f1 = StoStringField.create(null);
            this.container.append((StoField)this.fld_f1);
        }

        private final void initFields() {
            this.fld_buffer = (StoBufferField)this.container.first();
            this.fixlenFieldBuffer = this.fld_buffer.getValue((StoBufferField.ChangeNotifier)new FixlenFieldBufferChangeReceiver());
            this.fld_f2 = (StoIntField)this.container.next();
            this.fld_f1 = (StoStringField)this.container.next();
        }

        final void validate(short type, UUID id, IStoreBinding binding, String f1, int f2) {
            Assert.assertEquals((long)type, (long)this.getType());
            Assert.assertEquals((Object)id, (Object)this.getId());
            Assert.assertSame((Object)binding, (Object)this.getBinding());
            Assert.assertEquals((Object)f1, (Object)this.getF1());
            Assert.assertEquals((long)f2, (long)this.getF2());
        }

        public final byte[] serializeToByteArray() {
            throw new UnsupportedOperationException();
        }

        public final ByteBuffer serializeToByteBuffer() {
            throw new UnsupportedOperationException();
        }

        public final PktPacket serializeToPacket() {
            this.sync();
            ((PktPacket)this.getMessage()).acquire();
            return (PktPacket)this.getMessage();
        }

        @Override
        public final Message serializeToProtobuf() {
            throw new UnsupportedOperationException();
        }

        public final String serializeToJson() {
            throw new UnsupportedOperationException();
        }

        public final TestObject1 deserializeFromByteArray(byte[] array) {
            throw new UnsupportedOperationException();
        }

        public final TestObject1 deserializeFromByteBuffer(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        public final TestObject1 deserializeFromPacket(PktPacket packet) {
            this.setContentContainer(packet);
            this.initFields();
            return this;
        }

        @Override
        public final TestObject2 deserializeFromProtobuf(Message message) {
            throw new UnsupportedOperationException();
        }

        public final TestObject1 deserializeFromJson(String json) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int getLastFid() {
            return this.fid_f2;
        }

        final TestObject1 setF1(String val) {
            this.recordFieldUpdate(this.fid_f1, this.getF1());
            this.fld_f1.setValue((Object)val);
            return this;
        }

        final String getF1() {
            return (String)this.fld_f1.getValue();
        }

        final TestObject1 setF2(int val) {
            this.recordFieldUpdate(this.fid_f2, this.getF2());
            this.fld_f2.setValue(val);
            return this;
        }

        final int getF2() {
            return this.fld_f2.getValue();
        }

        public final void sync() {
            this.fixlenFieldBuffer.putShort(0, this.getType());
        }

        @Override
        public final IStoreObject.EncodingType getContentEncodingType() {
            return IStoreObject.EncodingType.Custom;
        }

        @Override
        public final PktPacket serialize() {
            return this.serializeToPacket();
        }

        @Override
        public final IStoreObject deserialize(PktPacket packet) {
            return this.deserializeFromPacket(packet);
        }

        @Override
        public final IStoreObject setFieldValue(long fid, Object val) {
            if (fid == (long)this.fid_f1) {
                this.fld_f1.setValue((Object)((String)val));
            } else if (fid == (long)this.fid_f2) {
                this.fld_f2.setValue(((Integer)val).intValue());
            } else {
                super.setFieldValue(fid, val);
            }
            return this;
        }

        public int getDataSize() {
            if (this.getMessage() == null) {
                this.sync();
            }
            return ((PktPacket)this.getMessage()).getBody().getSerializedLength();
        }

        public static final class Packet
        extends PktBodyStoContainer {
            private Packet(Properties props, boolean direct) {
                super(773, props, direct);
            }

            public static PktBody create(Properties props) {
                return new Packet(props, false);
            }

            public static PktBody create() {
                return Packet.create(null);
            }
        }

        private final class FixlenFieldBufferChangeReceiver
        implements StoBufferField.ChangeNotifier {
            private FixlenFieldBufferChangeReceiver() {
            }

            public final void onChange(ByteBuffer newBuffer) {
                TestObject1.this.fixlenFieldBuffer = newBuffer;
            }
        }
    }

    private static final class TestObjectFactory
    implements IStoreObjectFactory {
        static final short OFID = 1;
        public static final short ID_TestObject1 = 1;
        public static final short ID_TestObject2 = 2;
        public static final short PKTID_TestObject1 = 773;
        public static final short PKTID_TestObject2 = 774;

        private TestObjectFactory() {
        }

        @Override
        public final short getOfid() {
            return 1;
        }

        @Override
        public final IStoreObject create(short type, UUID id, IStoreObject.EncodingType encodingType, PktPacket packet) throws Exception {
            switch (type) {
                case 1: {
                    return new TestObject1(id, packet);
                }
                case 2: {
                    return new TestObject2(id, packet);
                }
            }
            throw new RuntimeException("unknown object type: " + type);
        }
    }
}

