/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreField;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreQuery;
import com.neeve.ods.IStoreQueryEngine;
import com.neeve.ods.IStoreQueryResultSet;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.impl.StoreQueryFieldResolverImpl;
import com.neeve.ods.impl.StoreQueryImpl;
import com.neeve.ods.impl.StoreQueryResultSetImpl;
import com.neeve.query.QueryException;
import com.neeve.query.QueryParseException;
import com.neeve.query.QueryRepository;
import com.neeve.query.impl.QueryEngineImpl;
import com.neeve.query.impl.QueryFieldResolver;
import com.neeve.query.impl.QueryResultSetImpl;
import com.neeve.trace.Tracer;
import java.util.HashSet;

public class StoreQueryEngineImpl
extends QueryEngineImpl<UUID, IStoreObject>
implements IStoreQueryEngine {
    private StoreQueryFieldResolverImpl fieldResolver;

    public StoreQueryEngineImpl() {
        super(IStoreObject.class);
    }

    @Override
    public final QueryFieldResolver<IStoreObject> getQueryFieldResolver(Class<IStoreObject> concreteBaseType) {
        if (this.fieldResolver == null) {
            this.fieldResolver = new StoreQueryFieldResolverImpl(concreteBaseType);
        }
        return this.fieldResolver;
    }

    @Override
    public void addRepository(QueryRepository<UUID, IStoreObject> store, String alias) {
        if (store == null) {
            throw new QueryException("Cannot add a null repository: " + alias);
        }
        HashSet<String> factories = new HashSet<String>();
        StoreObjectFactoryRegistry.getInstance().getStoreObjectFactoryNames(factories);
        for (String factoryClassName : factories) {
            try {
                Class<?> clazz = Class.forName(factoryClassName);
                this.fieldResolver.addFactory(clazz);
            }
            catch (Exception e) {
                this.tracer.log("Error registering factory with field resolver for " + store.getName() + ": " + e.getMessage(), Tracer.Level.SEVERE);
            }
        }
        super.addRepository(store, alias);
    }

    @Override
    public IStoreQuery createQuery() {
        return new StoreQueryImpl();
    }

    @Override
    public IStoreQuery createQuery(String xsql) {
        return (IStoreQuery)super.createQuery(xsql);
    }

    @Override
    public IStoreQueryResultSet execute(String xsql) {
        return this.execute(this.createQuery(xsql));
    }

    @Override
    public IStoreQueryResultSet execute(IStoreQuery query) {
        return (IStoreQueryResultSet)super.execute(query);
    }

    @Override
    public QueryResultSetImpl<UUID, IStoreObject> createResultSet() {
        return new StoreQueryResultSetImpl(this);
    }

    @Override
    public final <T> IStoreField<T> getField(String objectTypeName, String fieldPath) {
        return this.fieldResolver.getField(objectTypeName, fieldPath);
    }

    @Override
    public <T> IStoreField<T> getField(String columnDefinition) throws QueryException, QueryParseException {
        return (IStoreField)super.getField(columnDefinition);
    }

    @Override
    public final <T> IStoreField<T> getField(Class<?> objectType, String fieldPath) {
        return this.fieldResolver.getField((Class)objectType, fieldPath);
    }

    @Override
    public final <T> IStoreField<T> getField(Class<?> objectType, String fieldPath, Class<T> fieldType, Class<?> ... pathTypes) {
        return this.fieldResolver.getField((Class)objectType, fieldPath, (Class)fieldType, (Class[])pathTypes);
    }

    @Override
    protected boolean isAllRepositoriesToken(String token) {
        if (token.equalsIgnoreCase("store")) {
            return true;
        }
        return super.isAllRepositoriesToken(token);
    }
}

