/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jcsmp;

import com.neeve.sma.SmaException;
import com.neeve.solxf.ESolException;
import com.neeve.solxf.ISolFlowReceiver;
import com.neeve.solxf.ISolQueue;
import com.neeve.solxf.impl.jcsmp.SolJcsmpMessageListener;
import com.neeve.solxf.impl.jcsmp.SolJcsmpQueue;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.XMLMessageListener;
import java.util.Properties;

public final class SolJcsmpFlowReceiver
implements ISolFlowReceiver {
    private final FlowReceiver _flowReceiver;
    private final SolJcsmpMessageListener _listener;

    SolJcsmpFlowReceiver(JCSMPSession session, ISolQueue queue, SolJcsmpMessageListener listener, Properties props) throws SmaException {
        ConsumerFlowProperties fp = new ConsumerFlowProperties();
        fp.setEndpoint((Endpoint)((SolJcsmpQueue)queue).getQueue());
        try {
            this._listener = listener;
            this._flowReceiver = session.createFlow((XMLMessageListener)listener, fp);
        }
        catch (JCSMPErrorResponseException ex) {
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final void start() throws SmaException {
        try {
            this._flowReceiver.start();
        }
        catch (JCSMPErrorResponseException ex) {
            throw new ESolException(ex.getSubcodeEx(), ex.getMessage());
        }
        catch (JCSMPException e) {
            throw new SmaException((Throwable)e);
        }
    }

    @Override
    public final void stop() {
        this._flowReceiver.stop();
    }

    @Override
    public final void close() {
        this._flowReceiver.close();
    }

    @Override
    public final void ack(long messageId) {
        this._listener.ackMessage(messageId);
    }
}

