/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf;

import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.solxf.ISolDynamicTopic;
import com.neeve.solxf.ISolQueue;
import com.neeve.solxf.ISolSession;
import com.neeve.solxf.ISolStaticTopic;
import com.neeve.solxf.impl.jcsmp.SolJcsmpFactory;
import com.neeve.solxf.impl.jcsmp.SolJcsmpSession;
import com.neeve.solxf.impl.jni.SolJniFactory;
import java.util.Properties;

public final class SolFactory {
    private static final SolFactory _instance = new SolFactory();
    private final boolean isJNIAvailable;
    final Throwable jniLoadError;
    private static boolean isJNI = false;

    private SolFactory() {
        boolean jniAvailable = false;
        Throwable error = null;
        try {
            SolJniFactory.onlyInstance();
            jniAvailable = true;
        }
        catch (Throwable thrown) {
            error = thrown;
        }
        this.jniLoadError = error;
        this.isJNIAvailable = jniAvailable;
    }

    public static final SolFactory onlyInstance() {
        return _instance;
    }

    public final ISolSession createSession(String host, String user, Properties props, Properties solxfProperties) throws SmaException {
        return isJNI ? SolJniFactory.onlyInstance().createSession(host, user, props, solxfProperties) : SolJcsmpFactory.onlyInstance().createSession(host, user, props, solxfProperties);
    }

    public final ISolQueue createQueue(ISolSession session, String name) {
        return isJNI ? SolJniFactory.onlyInstance().createQueue(name) : SolJcsmpFactory.onlyInstance().createQueue((SolJcsmpSession)session, name);
    }

    public final ISolStaticTopic createStaticTopic(String name) {
        return isJNI ? SolJniFactory.onlyInstance().createStaticTopic(name) : SolJcsmpFactory.onlyInstance().createStaticTopic(name);
    }

    public final ISolDynamicTopic createDynamicTopic() {
        return isJNI ? SolJniFactory.onlyInstance().createDynamicTopic() : SolJcsmpFactory.onlyInstance().createDynamicTopic();
    }

    public final void setIsJNI(boolean value) {
        isJNI = value;
    }

    public final boolean isJNI() {
        return isJNI;
    }

    public final boolean isJNIAvailable() {
        return this.isJNIAvailable;
    }

    public final void assertJNIAvailable() throws Throwable {
        if (this.isJNIAvailable) {
            return;
        }
        if (this.jniLoadError != null) {
            throw this.jniLoadError;
        }
        throw new SmaPermanentException("JNI implementation not available");
    }
}

