/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializer;
import com.neeve.sma.CopyableMessageView;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelKeyResolver;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewImpl;
import com.neeve.sma.SmaException;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlPool;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class RawMessageViewImpl
extends MessageViewImpl
implements UtlPool.Item<RawMessageViewImpl>,
CopyableMessageView<RawMessageViewImpl> {
    private static final UtlPool<RawMessageViewImpl> POOL = UtlPool.create((String)"sma_rawmessageview", (String)"default", (UtlPool.Factory)new Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
    private final PktSerializer packetSerializer = PktSerializer.create();
    private String messageBus;
    private String messageChannel;
    private XString messageKeyBuffer;
    private int messageSender;
    private int messageFlow;
    private long messageSno;
    private boolean isPossibleDuplicate;
    private long originTs;
    private long createTs;
    private long appSendBeginTs = 0L;
    private long appSendDoneTs = 0L;
    private long sendTs;
    private long sendStartTs;
    private long outTs;
    private long preSerializeTs;
    private long postSerializeTs;
    private long preWireTs;
    private long postWireSendTs;
    private long postWireTs;
    private long preDeserializeTs;
    private long postDeserializeTs;
    private long enqueueTs;
    private long receiveTs;
    private long preProcessingTs;
    private long postProcessingTs;
    private UtlPool<RawMessageViewImpl> pool;
    private MessageTransportHeaders transportHeaders;

    @Override
    public MessageTransportHeaders getMessageTransportHeaders() {
        return this.transportHeaders;
    }

    @Override
    public MessageView setMessageTransportHeaders(MessageTransportHeaders val) {
        if (val != this.transportHeaders) {
            if (this.transportHeaders != null) {
                this.transportHeaders.dispose();
            }
            this.transportHeaders = val.copy();
        }
        return this;
    }

    private RawMessageViewImpl() {
        super((short)1, (short)0);
    }

    static final RawMessageViewImpl create() {
        RawMessageViewImpl view = (RawMessageViewImpl)POOL.get(null);
        view.undispose();
        return view;
    }

    public final RawMessageViewImpl init() {
        this.setMessage(1, null);
        this.messageBus = null;
        this.messageChannel = null;
        if (this.messageKeyBuffer != null) {
            this.messageKeyBuffer.clear();
        }
        this.messageSender = 0;
        this.messageFlow = 0;
        this.messageSno = 0L;
        this.isPossibleDuplicate = false;
        this.originTs = 0L;
        this.createTs = 0L;
        this.appSendBeginTs = 0L;
        this.appSendDoneTs = 0L;
        this.sendTs = 0L;
        this.sendStartTs = 0L;
        this.outTs = 0L;
        this.preSerializeTs = 0L;
        this.postSerializeTs = 0L;
        this.preWireTs = 0L;
        this.postWireTs = 0L;
        this.preDeserializeTs = 0L;
        this.postDeserializeTs = 0L;
        this.receiveTs = 0L;
        this.preProcessingTs = 0L;
        this.enqueueTs = 0L;
        this.postProcessingTs = 0L;
        if (this.transportHeaders != null) {
            this.transportHeaders.dispose();
            this.transportHeaders = null;
        }
        return this;
    }

    public final RawMessageViewImpl setPool(UtlPool<RawMessageViewImpl> pool) {
        this.pool = pool;
        return this;
    }

    public final UtlPool<RawMessageViewImpl> getPool() {
        return this.pool;
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            PktPacket packet = (PktPacket)this.getMessage();
            if (packet != null) {
                packet.dispose();
            }
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }
        return count;
    }

    @Override
    public final MessageView setMessageBus(String name) {
        this.messageBus = name;
        return this;
    }

    @Override
    public final String getMessageBus() {
        return this.messageBus;
    }

    @Override
    public final MessageView setMessageBusAsRaw(XString bus) {
        this.messageBus = bus != null ? bus.getValue() : null;
        return this;
    }

    @Override
    public final XString getMessageBusAsRaw() {
        if (this.messageBus == null) {
            return null;
        }
        return XString.create((String)this.messageBus);
    }

    @Override
    public final MessageView setMessageChannel(String name) {
        this.messageChannel = name;
        return this;
    }

    @Override
    public final String getMessageChannel() {
        return this.messageChannel;
    }

    @Override
    public final MessageView setMessageChannelAsRaw(XString channel) {
        this.messageChannel = channel != null ? channel.getValue() : null;
        return this;
    }

    @Override
    public final XString getMessageChannelAsRaw() {
        if (this.messageChannel == null) {
            return null;
        }
        return XString.create((String)this.messageChannel);
    }

    @Override
    public final MessageView setMessageKey(String key) {
        this.messageKeyBuffer(key.length() + 1).setValue(key);
        this.messageKeyBuffer.padForNullTerminator();
        return this;
    }

    @Override
    public final String getMessageKey() {
        return this.messageKeyBuffer != null && this.messageKeyBuffer.isInitialized() ? this.messageKeyBuffer.getValue() : null;
    }

    @Override
    public final MessageView setMessageKeyAsRaw(XString key) {
        if (key == null || key.isNull()) {
            if (this.messageKeyBuffer != null) {
                this.messageKeyBuffer.reset();
            }
        } else if (key == this.messageKeyBuffer) {
            key.padForNullTerminator();
        } else {
            this.messageKeyBuffer(key.length() + 1).setValue(key);
        }
        return this;
    }

    @Override
    public final XString getMessageKeyAsRaw() {
        return this.messageKeyBuffer;
    }

    @Override
    public final void resolveMessageKeyWith(MessageChannelKeyResolver channelKeyResolver, MessageChannel.RawKeyResolutionTable rawKeyResolutionTable) throws SmaException {
        XString keyBuffer = this.messageKeyBuffer(64);
        if (rawKeyResolutionTable != null || channelKeyResolver.getKeyResolutionTable() == null) {
            keyBuffer.clear();
            channelKeyResolver.resolveMessageKey(keyBuffer, this, rawKeyResolutionTable);
        } else {
            String strKey = channelKeyResolver.resolveMessageKey(this, null);
            if (strKey != null) {
                keyBuffer.setValue(strKey);
            }
        }
        this.setMessageKeyAsRaw(keyBuffer);
    }

    @Override
    public final void resolveMessageKeyWith(MessageChannelKeyResolver channelKeyResolver, Properties keyResolutionTable) throws SmaException {
        XString keyBuffer = this.messageKeyBuffer(64);
        if (keyResolutionTable == null && channelKeyResolver.getKeyResolutionTable() == null) {
            channelKeyResolver.resolveMessageKey(keyBuffer, this, null);
        } else {
            String strKey = channelKeyResolver.resolveMessageKey(this, keyResolutionTable);
            if (strKey != null) {
                keyBuffer.setValue(strKey);
            }
        }
        this.setMessageKeyAsRaw(keyBuffer);
    }

    final XString messageKeyBuffer(int initialLength) {
        if (this.messageKeyBuffer == null) {
            this.messageKeyBuffer = XString.create((int)initialLength, (boolean)true, (boolean)true);
        } else if (this.messageKeyBuffer.getBackingBuffer().getLength() < initialLength) {
            this.messageKeyBuffer.getBackingBuffer().setLength(initialLength);
        }
        return this.messageKeyBuffer;
    }

    @Override
    public final MessageView setMessageSender(int sender) {
        this.messageSender = sender;
        return this;
    }

    @Override
    public final int getMessageSender() {
        return this.messageSender;
    }

    @Override
    public final MessageView setMessageFlow(int flow) {
        this.messageFlow = flow;
        return this;
    }

    @Override
    public final int getMessageFlow() {
        return this.messageFlow;
    }

    @Override
    public final MessageView setMessageSequenceNumber(long sno) {
        this.messageSno = sno;
        return this;
    }

    @Override
    public final long getMessageSequenceNumber() {
        return this.messageSno;
    }

    @Override
    public final MessageView setPossibleDuplicate() {
        this.isPossibleDuplicate = true;
        return this;
    }

    @Override
    public final boolean isPossibleDuplicate() {
        return this.isPossibleDuplicate;
    }

    @Override
    public final MessageView setOriginTs(long ts) {
        this.originTs = ts;
        return this;
    }

    @Override
    public final long getOriginTs() {
        return this.originTs;
    }

    @Override
    public final MessageView setCreateTs(long ts) {
        this.createTs = ts;
        return this;
    }

    @Override
    public final long getCreateTs() {
        return this.createTs;
    }

    @Override
    public MessageView setAppSendBeginTs(long ts) {
        this.appSendBeginTs = ts;
        return this;
    }

    @Override
    public long getAppSendBeginTs() {
        return this.appSendBeginTs;
    }

    @Override
    public MessageView setAppSendDoneTs(long ts) {
        this.appSendDoneTs = ts;
        return this;
    }

    @Override
    public long getAppSendDoneTs() {
        return this.appSendDoneTs;
    }

    @Override
    public final MessageView setSendTs(long ts) {
        this.sendTs = ts;
        return this;
    }

    @Override
    public final long getSendTs() {
        return this.sendTs;
    }

    @Override
    public final MessageView setSendStartTs(long ts) {
        this.sendStartTs = ts;
        return this;
    }

    @Override
    public final long getSendStartTs() {
        return this.sendStartTs;
    }

    @Override
    @Deprecated
    public final MessageView setOutTs(long ts) {
        this.outTs = ts * 1000L;
        return this;
    }

    @Override
    public final long getOutTs() {
        return this.outTs / 1000L;
    }

    @Override
    public final MessageView setOutTsMicros(long ts) {
        this.outTs = ts;
        return this;
    }

    @Override
    public final long getOutTsMicros() {
        return this.outTs;
    }

    @Override
    public final MessageView setPreSerializeTs(long ts) {
        this.preSerializeTs = ts;
        return this;
    }

    @Override
    public final long getPreSerializeTs() {
        return this.preSerializeTs;
    }

    @Override
    public final MessageView setPostSerializeTs(long ts) {
        this.postSerializeTs = ts;
        return this;
    }

    @Override
    public final long getPostSerializeTs() {
        return this.postSerializeTs;
    }

    @Override
    public final MessageView setPreWireTs(long ts) {
        this.preWireTs = ts;
        return this;
    }

    @Override
    public final long getPreWireTs() {
        return this.preWireTs;
    }

    @Override
    public final RawMessageViewImpl setPostWireSendTs(long ts) {
        this.postWireSendTs = ts;
        return this;
    }

    @Override
    public final long getPostWireSendTs() {
        return this.postWireSendTs;
    }

    @Override
    public final MessageView setPostWireTs(long ts) {
        this.postWireTs = ts;
        return this;
    }

    @Override
    public final long getPostWireTs() {
        return this.postWireTs;
    }

    @Override
    public final MessageView setPreDeserializeTs(long ts) {
        this.preDeserializeTs = ts;
        return this;
    }

    @Override
    public final long getPreDeserializeTs() {
        return this.preDeserializeTs;
    }

    @Override
    public final MessageView setPostDeserializeTs(long ts) {
        this.postDeserializeTs = ts;
        return this;
    }

    @Override
    public final long getPostDeserializeTs() {
        return this.postDeserializeTs;
    }

    @Override
    public long getEnqueueTs() {
        return this.enqueueTs / 1000L;
    }

    @Override
    public MessageView setEnqueueTsMicros(long ts) {
        this.enqueueTs = ts;
        return this;
    }

    @Override
    public long getEnqueueTsMicros() {
        return this.enqueueTs;
    }

    @Override
    public final MessageView setReceiveTs(long ts) {
        this.receiveTs = ts;
        return this;
    }

    @Override
    public final long getReceiveTs() {
        return this.receiveTs;
    }

    @Override
    @Deprecated
    public final MessageView setPreProcessingTs(long ts) {
        this.preProcessingTs = ts * 1000L;
        return this;
    }

    @Override
    public final long getPreProcessingTs() {
        return this.preProcessingTs / 1000L;
    }

    @Override
    public final MessageView setPreProcessingTsMicros(long ts) {
        this.preProcessingTs = ts;
        return this;
    }

    @Override
    public final long getPreProcessingTsMicros() {
        return this.preProcessingTs;
    }

    @Override
    @Deprecated
    public final MessageView setPostProcessingTs(long ts) {
        this.postProcessingTs = ts * 1000L;
        return this;
    }

    @Override
    @Deprecated
    public final long getPostProcessingTs() {
        return this.postProcessingTs / 1000L;
    }

    @Override
    public final MessageView setPostProcessingTsMicros(long ts) {
        this.postProcessingTs = ts;
        return this;
    }

    @Override
    public final long getPostProcessingTsMicros() {
        return this.postProcessingTs;
    }

    @Override
    public final void sync() {
        if (this.getMessage() == null) {
            this.setMessage(1, PktFactory.getInstance().createPacket(256));
        }
    }

    @Override
    public final byte[] serializeToByteArray() {
        ByteBuffer serializedPacketAsByteBuffer = this.serializeToByteBuffer();
        byte[] serializedPacketAsByteArray = new byte[serializedPacketAsByteBuffer.remaining()];
        UtlBuffer.copy((ByteBuffer)serializedPacketAsByteBuffer, (int)0, (byte[])serializedPacketAsByteArray, (int)0, (int)serializedPacketAsByteArray.length);
        return serializedPacketAsByteArray;
    }

    @Override
    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        ByteBuffer buffer = ByteBuffer.allocate(packet.getSerializedLength());
        packet.serialize(buffer);
        return buffer;
    }

    @Override
    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        IOBuffer ioBuffer = IOBuffer.create((int)packet.getSerializedLength(), (boolean)useNative);
        packet.serialize(ioBuffer, 0);
        return ioBuffer;
    }

    @Override
    public final RawMessageViewImpl copy() {
        IOBuffer buffer = this.serializeToIOBuffer(true);
        RawMessageViewImpl copy = RawMessageViewImpl.create();
        copy.deserializeFromByteBuffer(buffer.takeBuffer());
        buffer.releaseBuffer().dispose();
        this.copyCopyableFieldsToCopy(copy);
        return copy;
    }

    @Override
    public final PktPacket serializeToPacket() {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        packet.acquire();
        return packet;
    }

    @Override
    public final String serializeToJson() {
        return "{}";
    }

    @Override
    public final RawMessageViewImpl deserializeFromByteArray(byte[] array) {
        try {
            this.setMessage(1, this.packetSerializer.deserialize(ByteBuffer.wrap(array), null));
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final RawMessageViewImpl deserializeFromByteBuffer(ByteBuffer buffer) {
        buffer.mark();
        try {
            this.setMessage(1, this.packetSerializer.deserialize(buffer, false, null));
            RawMessageViewImpl rawMessageViewImpl = this;
            return rawMessageViewImpl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            buffer.reset();
        }
    }

    @Override
    public final RawMessageViewImpl deserializeFromPacket(PktPacket packet) {
        if (this.getMessage() == packet) {
            return this;
        }
        packet.acquire();
        this.setMessage(1, packet);
        return this;
    }

    @Override
    public final RawMessageViewImpl deserializeFromJson(String json) {
        throw new UnsupportedOperationException();
    }

    private static final class Factory
    implements UtlPool.Factory<RawMessageViewImpl> {
        private Factory() {
        }

        public RawMessageViewImpl createItem(Object object) {
            RawMessageViewImpl view = new RawMessageViewImpl();
            view.ownershipCount.set(0);
            return view;
        }

        public RawMessageViewImpl[] createItemArray(int size) {
            return new RawMessageViewImpl[size];
        }
    }
}

