/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigComplexEntity;
import com.neeve.config.IConfigComplexEntityContainer;
import com.neeve.config.IConfigRepository;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.trace.Tracer;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public final class MessageChannelDescriptor
extends SmaObject {
    private final String name;
    private final MessageBusDescriptor parent;
    private Properties providerConfig;
    private short channelId;
    private String channelKey;
    private String channelFilter;
    private MessageChannel.Qos channelQos;
    private MessageChannel.PreserveJoinPolicy preserveJoinsOnClose = MessageChannel.PreserveJoinPolicy.Default;

    private MessageChannelDescriptor(String name, MessageBusDescriptor parent) {
        super(null);
        this.name = name;
        this.channelId = (short)-1;
        this.parent = parent;
        this.channelQos = MessageChannel.Qos.BestEffort;
        this.providerConfig = new Properties();
    }

    private static final String toEntityName(String name) {
        return name.replace("$", "$$").replace("/", "$");
    }

    private static final String fromEntityName(String entityName) {
        return entityName.replace("$", "/").replace("//", "$");
    }

    static final String normalizeChannelName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("channel name cannot be null");
        }
        if (name.contains("\\\\")) {
            throw new IllegalArgumentException("channel name cannot contain '\\\\'");
        }
        if ((name = name.replace("\\", "/")).contains("//")) {
            throw new IllegalArgumentException("channel name cannot contain '//'");
        }
        if (name.startsWith("/")) {
            throw new IllegalArgumentException("channel name cannot start with '/'");
        }
        if (name.endsWith("/")) {
            throw new IllegalArgumentException("channel name cannot end with '/'");
        }
        return name;
    }

    public final String getName() {
        return this.name;
    }

    public final MessageBusDescriptor getParent() {
        return this.parent;
    }

    public final MessageChannelDescriptor setProviderConfig(Properties props) {
        this.providerConfig = props;
        return this;
    }

    public final Properties getProviderConfig() {
        return this.providerConfig;
    }

    public final void setChannelId(short id) {
        this.channelId = id;
    }

    public final short getChannelId() {
        return this.channelId;
    }

    public final MessageChannelDescriptor setChannelKey(String key) {
        this.channelKey = key;
        return this;
    }

    public final String getChannelKey() {
        return this.channelKey;
    }

    public final MessageChannelDescriptor setChannelFilter(String filter) {
        this.channelFilter = filter;
        return this;
    }

    public final String getChannelFilter() {
        return this.channelFilter;
    }

    public final MessageChannelDescriptor setChannelQos(MessageChannel.Qos qos) {
        this.channelQos = qos;
        return this;
    }

    public final MessageChannel.Qos getChannelQos() {
        return this.channelQos;
    }

    public MessageChannel.PreserveJoinPolicy getPreserveJoinsOnClose() {
        return this.preserveJoinsOnClose;
    }

    public MessageChannelDescriptor setPreserveJoinsOnClose(MessageChannel.PreserveJoinPolicy preserveJoinsOnClose) {
        this.preserveJoinsOnClose = preserveJoinsOnClose;
        return this;
    }

    public final void save(IConfigRepository repo, String userName) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigComplexEntity entity;
            String addr = "/sma/buses/" + this.parent.getName() + "/channels";
            IConfigComplexEntityContainer container = repo.getComplexEntityContainer(addr);
            if (container == null) {
                container = repo.createComplexEntityContainer(addr);
            }
            if ((entity = (IConfigComplexEntity)container.getEntity(MessageChannelDescriptor.toEntityName(this.name))) == null) {
                entity = (IConfigComplexEntity)container.createEntity(MessageChannelDescriptor.toEntityName(this.name));
            }
            entity.setProperties("channel.properties", null);
            entity.setProperty("channel.properties", "ChannelId", String.valueOf(this.channelId));
            entity.setProperty("channel.properties", "ChannelQos", this.channelQos.toString());
            if (this.channelKey != null) {
                entity.setProperty("channel.properties", "ChannelKey", this.channelKey);
            }
            if (userName != null) {
                String userPropset = "channel." + userName + ".properties";
                entity.setProperties(userPropset, null);
                if (this.channelFilter != null) {
                    entity.setProperty(userPropset, "ChannelFilter", this.channelFilter);
                }
                if (this.preserveJoinsOnClose != null) {
                    entity.setProperty(userPropset, "PreserveJoinsOnClose", this.preserveJoinsOnClose.name());
                }
            }
            if (this.providerConfig != null) {
                entity.setProperties("provider.config", null).setProperties("provider.config", this.getProviderConfig());
            }
        }
        catch (EConfigException e) {
            throw new SmaException(e);
        }
    }

    public final void delete(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        String addr = "/sma/buses/" + this.parent.getName() + "/channels";
        IConfigComplexEntityContainer container = repo.getComplexEntityContainer(addr);
        if (container != null) {
            container.removeEntity(MessageChannelDescriptor.toEntityName(this.name));
        }
    }

    public final String toString() {
        return "(name=" + this.name + ", id=" + this.channelId + ", qos=" + (Object)((Object)this.channelQos) + ", key=" + this.channelKey + ", filter=" + this.channelFilter + ", preserveJoinsOnClose=" + this.preserveJoinsOnClose.name() + ", providerconfig=" + this.providerConfig + ")";
    }

    public static boolean exists(IConfigRepository repo, String busName, String channelName) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (busName == null) {
            throw new IllegalArgumentException("bus name cannot be null");
        }
        return repo.getComplexEntity("/sma/buses/" + busName + "/channels/" + MessageChannelDescriptor.toEntityName(MessageChannelDescriptor.normalizeChannelName(channelName))) != null;
    }

    public static boolean exists(String busName, String channelName) {
        return MessageChannelDescriptor.exists(ConfigRepositoryFactory.getInstance().getDefaultRepository(), busName, channelName);
    }

    public static MessageChannelDescriptor create(String name, MessageBusDescriptor parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        return new MessageChannelDescriptor(MessageChannelDescriptor.normalizeChannelName(name), parent);
    }

    public static MessageChannelDescriptor load(IConfigRepository repo, MessageBusDescriptor busDescriptor, String channelName, String userName) throws SmaException {
        String addr;
        IConfigComplexEntity entity;
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (busDescriptor == null) {
            throw new IllegalArgumentException("bus descriptor cannot be null");
        }
        if (channelName == null) {
            throw new IllegalArgumentException("channel name cannot be null");
        }
        MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create(channelName, busDescriptor);
        Tracer tracer = channelDescriptor.getTracer();
        if (tracer.debug) {
            tracer.log("[ChannelDescriptor," + channelName + "] Loading channel descriptor for channel '" + channelName + "@" + busDescriptor.getName() + "' from repository...", Tracer.Level.DEBUG);
        }
        if ((entity = repo.getComplexEntity(addr = "/sma/buses/" + busDescriptor.getName() + "/channels/" + MessageChannelDescriptor.toEntityName(MessageChannelDescriptor.normalizeChannelName(channelName)))) != null) {
            String channelFilter;
            String channelKey;
            MessageChannel.Qos channelQos;
            String channelQosStr;
            String channelIdStr;
            Properties providerConfigProps;
            Properties channelUserProps;
            Properties channelProps = entity.getProperties("channel.properties");
            if (channelProps == null) {
                channelProps = new Properties();
            }
            if (tracer.debug) {
                tracer.log("[ChannelDescriptor," + channelName + "] Channel properties=" + channelProps, Tracer.Level.DEBUG);
            }
            Properties properties = channelUserProps = userName == null ? null : entity.getProperties("channel." + userName + ".properties");
            if (tracer.debug) {
                tracer.log("[ChannelDescriptor," + channelName + "] Channel user properties=" + channelUserProps, Tracer.Level.DEBUG);
            }
            if ((providerConfigProps = entity.getProperties("provider.config")) == null) {
                providerConfigProps = new Properties();
            }
            if (tracer.debug) {
                tracer.log("[ChannelDescriptor," + channelName + "] Channel provider config=" + providerConfigProps, Tracer.Level.DEBUG);
            }
            short channelId = (channelIdStr = channelProps.getProperty("ChannelId", null)) != null ? (short)Short.valueOf(channelIdStr.trim()) : (short)-1;
            if (tracer.debug) {
                tracer.log("[ChannelDescriptor," + channelName + "] Channel Id=" + channelId, Tracer.Level.DEBUG);
            }
            if ((channelQosStr = channelProps.getProperty("ChannelQos", "BestEffort")) != null) {
                channelQosStr = channelQosStr.trim();
            }
            try {
                channelQos = MessageChannel.Qos.valueOf(channelQosStr);
            }
            catch (Exception e) {
                channelQos = MessageChannel.Qos.BestEffort;
            }
            if (tracer.debug) {
                tracer.log("[ChannelDescriptor," + channelName + "] Channel QOS=" + (Object)((Object)channelQos), Tracer.Level.DEBUG);
            }
            if ((channelKey = channelProps.getProperty("ChannelKey", null)) != null) {
                channelKey = channelKey.trim();
            }
            if (tracer.debug) {
                tracer.log("[ChannelDescriptor," + channelName + "] Channel Key=" + channelKey, Tracer.Level.DEBUG);
            }
            String string = channelFilter = channelUserProps == null ? null : channelUserProps.getProperty("ChannelFilter", null);
            if (channelFilter != null) {
                channelFilter = channelFilter.trim();
            }
            if (tracer.debug) {
                tracer.log("[ChannelDescriptor," + channelName + "] Channel Filter=" + channelFilter, Tracer.Level.DEBUG);
            }
            String preserveJoinsOnCloseStr = channelUserProps == null ? null : channelUserProps.getProperty("PreserveJoinsOnClose", null);
            MessageChannel.PreserveJoinPolicy preserveJoinsOnClose = MessageChannel.PreserveJoinPolicy.Default;
            if (preserveJoinsOnCloseStr != null) {
                preserveJoinsOnClose = MessageChannel.PreserveJoinPolicy.valueOf(preserveJoinsOnCloseStr);
            }
            if (tracer.debug) {
                tracer.log("[ChannelDescriptor," + channelName + "] PreserveJoinsOnClose=" + (Object)((Object)preserveJoinsOnClose), Tracer.Level.DEBUG);
            }
            channelDescriptor.setProviderConfig((Properties)providerConfigProps.clone());
            channelDescriptor.setChannelId(channelId);
            channelDescriptor.setChannelKey(channelKey);
            channelDescriptor.setChannelQos(channelQos);
            channelDescriptor.setChannelFilter(channelFilter);
            channelDescriptor.setPreserveJoinsOnClose(preserveJoinsOnClose);
            return channelDescriptor;
        }
        throw new SmaException("Message channel '" + channelName + "@" + busDescriptor.getName() + "' not found in repository");
    }

    public static Set<MessageChannelDescriptor> loadAll(IConfigRepository repo, MessageBusDescriptor busDescriptor, String userName) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<MessageChannelDescriptor> channels = new LinkedHashSet<MessageChannelDescriptor>();
        String addr = "/sma/buses/" + busDescriptor.getName() + "/channels";
        IConfigComplexEntityContainer container = repo.getComplexEntityContainer(addr);
        if (container != null) {
            for (IConfigComplexEntity entity : container) {
                try {
                    channels.add(MessageChannelDescriptor.load(repo, busDescriptor, MessageChannelDescriptor.fromEntityName(entity.getName()), userName));
                }
                catch (SmaException e) {
                    throw new SmaException("Failure in loading descriptor for channel '" + entity.getName() + "' in bus '" + busDescriptor.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return channels;
    }
}

