/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.kafka;

import com.neeve.kafka.KafkaMessageBusBinding;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlTime;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class KafkaMessageChannel
extends MessageChannelBase {
    private final KafkaMessageBusBinding binding;
    private final XString sendTopicBuilder = XString.create((int)32, (boolean)true);
    private String[] filters;

    protected KafkaMessageChannel(MessageChannelDescriptor descriptor, KafkaMessageBusBinding binding) throws SmaException {
        super(null, descriptor, (MessageBusBindingBase)binding);
        this.binding = binding;
    }

    private final void subscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String topic = this.normalizeTopic(filter == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + filter : filter));
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Subscribing to topic '" + topic + "' (" + (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed ? "guaranteed" : "best effort") + ")...", Tracer.Level.DEBUG);
        }
        this.binding.subscribe(this, topic);
    }

    private final void unsubscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String topic = this.normalizeTopic(filter == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + filter : filter));
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Unsubscribing from topic '" + topic + "' (" + (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed ? "guaranteed" : "best effort") + ")...", Tracer.Level.DEBUG);
        }
        this.binding.unsubscribe(this, topic);
    }

    private final XString resolveSendTopic(XString keyOrFilter, boolean topicStartsWithChannel) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Constructing topic using [keyOrFilter=" + keyOrFilter + ", topicStartsWithChannel=" + topicStartsWithChannel + "]...", Tracer.Level.DEBUG);
        }
        if (keyOrFilter == null || keyOrFilter.length() == 0) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is null. using static topic", Tracer.Level.DEBUG);
            }
            return this.getNameAsRaw();
        }
        if (topicStartsWithChannel) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic starts with channel. preparing topic...", Tracer.Level.DEBUG);
            }
            this.sendTopicBuilder.clear();
            this.sendTopicBuilder.append((CharSequence)this.descriptor.getName()).append((CharSequence)"/").append(keyOrFilter);
            return this.sendTopicBuilder;
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic does not starts with channel. using keyOrFilter as topic...", Tracer.Level.DEBUG);
        }
        return keyOrFilter;
    }

    final void onMessage(byte[] message, MessageMetadata metadata, MessageTransportHeaders transportHeaders, String topic, KafkaMessageBusBinding.KafkaAcknowledger acknowledger, long postWireTs) {
        long preDeserializeTs;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received from binding. Payload is " + (message != null ? Integer.valueOf(message.length) : "0") + " bytes. Metadata is " + metadata, Tracer.Level.DEBUG);
        }
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.d1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)message);
        long l = preDeserializeTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Dispatching...", Tracer.Level.DEBUG);
        }
        if (transportHeaders != null && this.getId() == Short.MAX_VALUE) {
            XString receivedMessageChannel = metadata.getMessageChannelNameAsRaw();
            if (receivedMessageChannel == null || receivedMessageChannel.isNull() || receivedMessageChannel.length() == 0) {
                transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, metadata.getMessageChannelId());
            } else {
                transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, receivedMessageChannel);
            }
        }
        this.onMessage(message, transportHeaders, metadata.getMessageViewFactory(), metadata.getMessageViewType(), metadata.getMessageEncodingType(), metadata.getMessageSender(), metadata.getMessageFlow(), metadata.getMessageSno(), XString.create((String)topic), acknowledger, 0L, 0L, postWireTs, preDeserializeTs);
    }

    final void onAckNack(MessageView view, Exception status) {
        this.onMessageStability(view, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doSend(MessageView view, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received request to send message...", Tracer.Level.DEBUG);
        }
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
        if (MessageLatencyManager.captureMsgLatencyStats) {
            view.setPreSerializeTs(UtlTime.now());
        }
        byte[] serializedMessage = null;
        MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
        try {
            metadata.serializeV2((byte)view.getMessageEncodingType(), view.getVfid(), view.getType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
            switch (view.getMessageEncodingType()) {
                case 1: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is CUSTOM.", Tracer.Level.DEBUG);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                    }
                    serializedMessage = view.serializeToByteArray();
                    break;
                }
                case 6: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is QUARK.", Tracer.Level.DEBUG);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                    }
                    serializedMessage = view.serializeToByteArray();
                    break;
                }
                case 3: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is XBUF.", Tracer.Level.DEBUG);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                    }
                    serializedMessage = view.serializeToByteArray();
                    break;
                }
                case 7: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is XBUF2.", Tracer.Level.DEBUG);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                    }
                    serializedMessage = view.serializeToByteArray();
                    break;
                }
                case 4: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is PROTOBUF.", Tracer.Level.DEBUG);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...serializing...", Tracer.Level.DEBUG);
                    }
                    serializedMessage = view.serializeToByteArray();
                    break;
                }
                case 5: {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Encoding type is JSON.", Tracer.Level.DEBUG);
                    }
                    String message = (String)view.getMessage();
                    try {
                        serializedMessage = message.getBytes("UTF-8");
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SmaException((Throwable)e);
                    }
                }
                default: {
                    throw new SmaException("unsupported encoding type '" + view.getMessageEncodingType() + "'");
                }
            }
            XString key = view.getMessageKeyAsRaw();
            boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
            if (key == null && !topicStartsWithChannel) {
                throw new SmaException("send performed with null key but binding configured to not prepend topic with channel");
            }
            String topic = this.normalizeTopic(this.resolveSendTopic(key, topicStartsWithChannel).getValue());
            if (MessageLatencyManager.captureMsgLatencyStats) {
                view.setPostSerializeTs(UtlTime.now());
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s2, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Publishing message. Message is " + serializedMessage.length + " bytes, metadata is " + metadata + ", topic is '" + topic + "'", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... ...preSerialize=" + view.getPreSerializeTs(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... ...postSerialize=" + view.getPostSerializeTs(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(serializedMessage)).toString(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
            }
            boolean bl = this.binding.send(this, view, metadata, serializedMessage, this.normalizeTopic(topic), this.descriptor.getChannelQos(), flushContext, flags);
            return bl;
        }
        finally {
            metadata.dispose();
        }
    }

    private final String normalizeTopic(String destination) {
        return destination.replace('/', '.');
    }

    protected final void doJoin(String[] filters, int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(filters != null && filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("join performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (filters == null || filters.length == 0) {
            this.subscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : filters) {
                this.subscribe(filter, topicStartsWithChannel);
            }
        }
        this.filters = filters;
    }

    protected final void doLeave(int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(this.filters != null && this.filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("leave performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (this.filters == null || this.filters.length == 0) {
            this.unsubscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : this.filters) {
                this.unsubscribe(filter, topicStartsWithChannel);
            }
        }
    }

    protected final void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing channel...", Tracer.Level.DEBUG);
        }
        this.binding.onChannelClose(this);
    }

    public final String getType() {
        return "kafka";
    }
}

