/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import cern.colt.function.ObjectProcedure;
import cern.colt.list.ObjectArrayList;
import com.neeve.stats.IStats;
import com.neeve.stats.StatsRegistry;
import com.neeve.tools.interactive.commands.Command;

public final class Stats
extends Command {
    private void processStats() {
        System.out.printf("\n%-35s%-20s%-30s%-50s\n", "Name", "Type", "Logger", "RegistryKey");
        System.out.printf("----------------------------------------------------------------------------------------------------------------------------\n", new Object[0]);
        ObjectArrayList list = StatsRegistry.getInstance().getValues();
        if (list.size() > 0) {
            list.forEach(new ObjectProcedure(){

                public final boolean apply(Object element) {
                    IStats stats = (IStats)element;
                    System.out.printf("%-35s%-20s%-30s%-50s\n", stats.getName(), stats.getType(), stats.getLogger(), StatsRegistry.getFullyQualifiedName((IStats)stats));
                    return true;
                }
            });
        } else {
            System.out.printf("<No entries>\n", new Object[0]);
        }
        System.out.printf("\n", new Object[0]);
    }

    public final void run(String[] args) {
        if (args.length != 0) {
            System.out.println("Syntax error: stats");
        } else {
            this.processStats();
        }
    }

    public final void help() {
        System.out.println("stats");
        System.out.println("  List the contents of the statistics registry");
    }

    public final String[] keywords() {
        return new String[]{"stats"};
    }
}

