/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoField;
import com.neeve.sto.StoStringArrayField;
import com.neeve.sto.StoStringField;
import com.neeve.sto.test.unit.StoStringFieldTest;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class StoStringArrayFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final String[] createArray(int len) {
        String[] array = new String[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = StoStringFieldTest.createString();
        }
        return array;
    }

    public static final String[] cloneArray(String[] original) {
        String[] clone = new String[original.length];
        System.arraycopy(original, 0, clone, 0, original.length);
        return clone;
    }

    public static final void compare(String[] array1, String[] array2, boolean same) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (same) {
            Assert.assertSame((Object)array1, (Object)array2);
        } else if (array2 == null) {
            Assert.fail();
        } else if (array1.length != array2.length) {
            Assert.fail();
        } else {
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i].equals(array2[i])) continue;
                Assert.fail();
            }
        }
    }

    private final void validate(StoStringArrayField field, String name, ByteBuffer buffer, String[] val, boolean same) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.STRING_ARRAY), (Object)((Object)field.getType()));
        StoStringArrayFieldTest.compare(val, (String[])field.getValue(), same);
    }

    private final void cloneAndValidate(StoStringArrayField field, String name, String[] val) {
        StoStringArrayField clone = (StoStringArrayField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val, false);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    private final int expectedSerializedLength(String[] array) {
        int len = 2;
        for (int i = 0; i < array.length; ++i) {
            len += StoStringField.getSerializedLength(array[i]);
        }
        return len;
    }

    @Test
    public void testStaticMethods() throws Exception {
        String[] array = StoStringArrayFieldTest.createArray(5);
        Assert.assertEquals((long)StoStringArrayField.getSerializedLength(array), (long)this.expectedSerializedLength(array));
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        StoStringArrayField.put(buffer, 5, null);
        Assert.assertEquals((long)StoStringArrayField.getSerializedLength(buffer, 5), (long)2L);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayFieldTest.compare(StoStringArrayField.get(buffer, 5), null, false);
        this.validate(buffer, 0, 1000, 1000);
        String[] array1 = StoStringArrayFieldTest.createArray(0);
        StoStringArrayField.put(buffer, 5, array1);
        Assert.assertEquals((long)StoStringArrayField.getSerializedLength(buffer, 5), (long)2L);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayFieldTest.compare(StoStringArrayField.get(buffer, 5), array1, false);
        this.validate(buffer, 0, 1000, 1000);
        array1 = StoStringArrayFieldTest.createArray(5);
        String[] array2 = StoStringArrayFieldTest.createArray(5);
        Assert.assertEquals((long)StoStringArrayField.put(buffer, 5, array1), (long)this.expectedSerializedLength(array1));
        this.validate(buffer, 0, 1000, 1000);
        Assert.assertEquals((long)StoStringArrayField.getSerializedLength(buffer, 5), (long)this.expectedSerializedLength(array1));
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayFieldTest.compare(StoStringArrayField.get(buffer, 5), array1, false);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayField.put(buffer, 5, array2);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayFieldTest.compare(StoStringArrayField.get(buffer, 5), array2, false);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoStringArrayField field = StoStringArrayField.create(null);
        this.validate(field, null, null, null, true);
        this.cloneAndValidate(field, null, null);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoStringArrayField field = StoStringArrayField.create("name");
        this.validate(field, "name", null, null, true);
        this.cloneAndValidate(field, "name", null);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertTrue((boolean)StoStringArrayField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoStringArrayField field = StoStringArrayField.create(null);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(field, null, null, array, true);
        this.cloneAndValidate(field, null, array);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoStringArrayField field = StoStringArrayField.create("name");
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(field, "name", null, array, true);
        this.cloneAndValidate(field, "name", array);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoStringArrayField field = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, null, buffer, null, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, null, null);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoStringArrayField field = StoStringArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, "name", buffer, null, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, "name", null);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoStringArrayField field = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, null, buffer, array, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoStringArrayField field = StoStringArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, "name", buffer, array, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoStringArrayField field = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 1000, 1000);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoStringArrayField field = StoStringArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 1000, 1000);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoStringArrayField field = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 1000, 1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, null, buffer, array, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoStringArrayField field = StoStringArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 1000, 1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, "name", buffer, array, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoStringArrayField field = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 1000, 1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 1000, 1000);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoStringArrayField field = StoStringArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 1000, 1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 1000, 1000);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoStringArrayField field = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayFieldTest.compare(StoStringArrayField.get(buffer, field.shiftForHeader(45)), array, false);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoStringArrayField field = StoStringArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field.setValue(array);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 1000, 1000);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayFieldTest.compare(StoStringArrayField.get(buffer, field.shiftForHeader(52)), array, false);
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 1000, 1000);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 1000, 1000);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field2, "name", array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 1000, 1000);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 1000, 1000);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 1000, 1000);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 1000, 1000);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 1000, 1000);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 1000, 1000);
        this.cloneAndValidate(field2, "name", array);
        this.validate(buffer, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 1000, 1000);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 1000, 1000);
        ByteBuffer buffer2 = ByteBuffer.allocate(1000);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 1000, 1000);
        StoStringArrayField field3 = (StoStringArrayField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 1000, 1000);
        this.validate(field3, null, buffer2, array, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 1000, 1000);
        this.cloneAndValidate(field3, null, array);
        this.validate(buffer2, 0, 1000, 1000);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(1000);
        String[] array = StoStringArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer1, 32);
        this.validate(buffer1, 0, 1000, 1000);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer1, 32);
        this.validate(buffer1, 0, 1000, 1000);
        ByteBuffer buffer2 = ByteBuffer.allocate(1000);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 1000, 1000);
        StoStringArrayField field3 = (StoStringArrayField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 1000, 1000);
        this.validate(field3, "name", buffer2, array, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 1000, 1000);
        this.cloneAndValidate(field3, "name", array);
        this.validate(buffer2, 0, 1000, 1000);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetNullValueDeserialize() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(null);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetEmptyValueDeserialize() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        String[] array = StoStringArrayFieldTest.createArray(0);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoStringArrayField field2 = (StoStringArrayField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 65);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoStringArrayField.create("name").contentsEquals(StoStringArrayField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoStringArrayField.create(null).contentsEquals(StoStringArrayField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoStringArrayField.create("name1").contentsEquals(StoStringArrayField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        StoStringArrayField field2 = StoStringArrayField.create(null);
        field1.setValue(StoStringArrayFieldTest.createArray(5));
        field2.setValue(null);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        StoStringArrayField field2 = StoStringArrayField.create(null);
        field1.setValue(null);
        field2.setValue(StoStringArrayFieldTest.createArray(5));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffLengths() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        StoStringArrayField field2 = StoStringArrayField.create(null);
        field1.setValue(StoStringArrayFieldTest.createArray(5));
        field2.setValue(StoStringArrayFieldTest.createArray(4));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        StoStringArrayField field2 = StoStringArrayField.create(null);
        field1.setValue(StoStringArrayFieldTest.createArray(5));
        field2.setValue(StoStringArrayFieldTest.createArray(5));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        StoStringArrayField field2 = StoStringArrayField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create("name");
        StoStringArrayField field2 = StoStringArrayField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create(null);
        StoStringArrayField field2 = StoStringArrayField.create(null);
        field1.setValue(StoStringArrayFieldTest.createArray(5));
        field2.setValue(StoStringArrayFieldTest.cloneArray((String[])field1.getValue()));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoStringArrayField field1 = StoStringArrayField.create("name");
        StoStringArrayField field2 = StoStringArrayField.create("name");
        field1.setValue(StoStringArrayFieldTest.createArray(5));
        field2.setValue(StoStringArrayFieldTest.cloneArray((String[])field1.getValue()));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

