/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoBooleanField;
import com.neeve.sto.StoField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class StoBooleanFieldTest
extends UnitTest {
    private final void validate(StoBooleanField field, String name, ByteBuffer buffer, boolean val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.BOOLEAN), (Object)((Object)field.getType()));
        Assert.assertEquals((Object)field.getValue(), (Object)val);
    }

    private final void cloneAndValidate(StoBooleanField field, String name, boolean val) {
        StoBooleanField clone = (StoBooleanField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoBooleanField.getSerializedLength(null, 0), (long)1L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoBooleanField.put(buffer, 5, true);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)StoBooleanField.get(buffer, 5));
        this.validate(buffer, 0, 100, 100);
        StoBooleanField.put(buffer, 5, false);
        this.validate(buffer, 0, 100, 100);
        Assert.assertFalse((boolean)StoBooleanField.get(buffer, 5));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoBooleanField field = StoBooleanField.create(null);
        this.validate(field, null, null, false);
        this.cloneAndValidate(field, null, false);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoBooleanField field = StoBooleanField.create("name");
        this.validate(field, "name", null, false);
        this.cloneAndValidate(field, "name", false);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoBooleanField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoBooleanField field = StoBooleanField.create(null);
        field.setValue(true);
        this.validate(field, null, null, true);
        this.cloneAndValidate(field, null, true);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoBooleanField field = StoBooleanField.create("name");
        field.setValue(true);
        this.validate(field, "name", null, true);
        this.cloneAndValidate(field, "name", true);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoBooleanField field = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, false);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, false);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoBooleanField field = StoBooleanField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, false);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", false);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoBooleanField field = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(true);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoBooleanField field = StoBooleanField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(true);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoBooleanField field = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(true);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoBooleanField field = StoBooleanField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(true);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoBooleanField field = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(true);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoBooleanField field = StoBooleanField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(true);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoBooleanField field = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(true);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoBooleanField field = StoBooleanField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(true);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, true);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoBooleanField field = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(true);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, true);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)StoBooleanField.get(buffer, field.shiftForHeader(45)));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoBooleanField field = StoBooleanField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(true);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, true);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)StoBooleanField.get(buffer, field.shiftForHeader(52)));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(true);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoBooleanField field2 = (StoBooleanField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoBooleanField field1 = StoBooleanField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(true);
        field1.setBackingBuffer(buffer, 89);
        this.validate(buffer, 0, 100, 100);
        StoBooleanField field2 = (StoBooleanField)StoField.create(buffer, 89);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(true);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoBooleanField field2 = (StoBooleanField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoBooleanField field1 = StoBooleanField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(true);
        field1.setBackingBuffer(buffer, 89);
        this.validate(buffer, 0, 100, 100);
        StoBooleanField field2 = (StoBooleanField)StoField.create(buffer, 89);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", true);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(true);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoBooleanField field2 = (StoBooleanField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoBooleanField field3 = (StoBooleanField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, true);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, true);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoBooleanField field1 = StoBooleanField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(true);
        field1.setBackingBuffer(buffer1, 89);
        this.validate(buffer1, 0, 100, 100);
        StoBooleanField field2 = (StoBooleanField)StoField.create(buffer1, 89);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoBooleanField field3 = (StoBooleanField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, true);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", true);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoBooleanField field2 = (StoBooleanField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, false);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoBooleanField field2 = (StoBooleanField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 65);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoBooleanField.create("name").contentsEquals(StoBooleanField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoBooleanField.create(null).contentsEquals(StoBooleanField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoBooleanField.create("name1").contentsEquals(StoBooleanField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        StoBooleanField field2 = StoBooleanField.create(null);
        field1.setValue(true);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        StoBooleanField field2 = StoBooleanField.create(null);
        field2.setValue(true);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        StoBooleanField field2 = StoBooleanField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoBooleanField field1 = StoBooleanField.create("name");
        StoBooleanField field2 = StoBooleanField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoBooleanField field1 = StoBooleanField.create(null);
        StoBooleanField field2 = StoBooleanField.create(null);
        field1.setValue(true);
        field2.setValue(true);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoBooleanField field1 = StoBooleanField.create("name");
        StoBooleanField field2 = StoBooleanField.create("name");
        field1.setValue(true);
        field2.setValue(true);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

