/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import java.nio.ByteBuffer;

public final class StoShortField
extends StoField {
    private short val;

    private StoShortField(String name) {
        super(StoField.Type.SHORT, name);
    }

    private StoShortField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        StoShortField.put(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoShortField.put(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferDetach() {
        if (this.val == 0) {
            this.val = StoShortField.get(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = 0;
    }

    @Override
    protected final int getSerializedLength() {
        return 2;
    }

    @Override
    protected final String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        return this.getValue() == ((StoShortField)other).getValue();
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        ((StoShortField)clonee).setValue(this.getValue());
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    public static StoShortField create(String name) {
        return new StoShortField(name);
    }

    public static StoShortField create(ByteBuffer buffer, int bufferOffset) {
        return new StoShortField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 2;
    }

    public static void put(ByteBuffer buffer, int offset, short val) {
        buffer.putShort(offset, val);
    }

    public static short get(ByteBuffer buffer, int offset) {
        return buffer.getShort(offset);
    }

    @Override
    public final void reset() {
        this.setValue((short)0);
    }

    public final void setValue(short val) {
        this.val = val;
        if (this.buffer != null) {
            StoShortField.put(this.buffer, this.bodyOffset, val);
        }
    }

    public final short getValue() {
        if (this.val == 0 && this.buffer != null) {
            this.val = StoShortField.get(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

