/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.types;

import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBodyVariable;
import java.util.Properties;

public class PktBodyText
extends PktBodyVariable {
    protected int TEXTLEN_POS;
    protected int TEXT_POS;
    private boolean hasValue;
    private boolean readOnly;

    private PktBodyText(Properties props, boolean direct) {
        super(258, direct);
    }

    protected PktBodyText(int type, Properties props, boolean direct) {
        super(type, direct);
    }

    public static PktBody create(Properties props) {
        return new PktBodyText(props, false);
    }

    public static PktBody create() {
        return PktBodyText.create(null);
    }

    private final void updateFieldOffsets() {
        this.TEXTLEN_POS = 0;
        this.TEXT_POS = this.TEXTLEN_POS + 4;
    }

    private final void init() {
        this.updateFieldOffsets();
        this.readOnly = false;
        this.hasValue = false;
    }

    protected int toBackingBuffer(byte[] text) {
        this.buffer.putFrom(this.TEXT_POS, text, 0, text.length);
        return text.length;
    }

    protected byte[] fromBackingBuffer(int textLen) {
        byte[] text = new byte[textLen];
        this.buffer.getTo(this.TEXT_POS, text, 0, textLen);
        return text;
    }

    @Override
    protected final void initialize() {
        this.init();
    }

    @Override
    protected final boolean isResettable() {
        return true;
    }

    @Override
    protected final void doReset() {
        super.doReset();
        this.init();
    }

    @Override
    public final int doGetSerializedLength() {
        return 4 + Math.max(0, this.hasValue ? this.buffer.getInt(this.TEXTLEN_POS) : 0);
    }

    @Override
    public final void postDeserialize(int len) {
        this.readOnly = true;
        this.hasValue = true;
    }

    public final void setText(String val) {
        int textLen;
        byte[] text;
        if (this.readOnly) {
            throw new IllegalStateException("body is ready only");
        }
        if (val == null) {
            text = null;
            textLen = 0;
        } else {
            try {
                text = val.getBytes("UTF-8");
                textLen = text.length == 0 ? -1 : text.length;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.updateFieldOffsets();
        if (text != null && text.length > 0) {
            this.buffer.putInt(this.TEXTLEN_POS, this.toBackingBuffer(text));
        } else {
            this.buffer.putInt(this.TEXTLEN_POS, textLen);
        }
        this.hasValue = true;
    }

    public final String getText() {
        if (this.hasValue) {
            int textLen = this.buffer.getInt(this.TEXTLEN_POS);
            if (textLen == 0) {
                return null;
            }
            if (textLen < 0) {
                return "";
            }
            try {
                return new String(this.fromBackingBuffer(textLen), "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String toString() {
        return "<text=" + this.getText() + ">";
    }
}

