/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import cern.colt.list.ObjectArrayList;
import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktConstants;
import com.neeve.pkt.PktSerializable;
import com.neeve.root.RootConfig;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class PktSerializableTest
extends UnitTest {
    static final Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)"nv.packet"));

    static void checkPoliciesInEntity(String name, PktSerializable entity, int serializationPolicy, int deserializationPolicy) {
        if (entity.getSerializationPolicy() != serializationPolicy) {
            PktSerializableTest.testFailure((String)("Incorrect serialization policy in " + name + " [" + PktConstants.serializationPolicyToStr(entity.getSerializationPolicy()) + "]"));
        }
        if (entity.getDeserializationPolicy() != deserializationPolicy) {
            PktSerializableTest.testFailure((String)("Incorrect deserialization policy in " + name + " [" + PktConstants.deserializationPolicyToStr(entity.getDeserializationPolicy()) + "]"));
        }
    }

    static ByteBuffer testCopySerialization(PktSerializable entity, int policy, boolean direct, boolean enoughSpace) {
        ByteBuffer lastBuffer;
        int expectedBufferCount;
        int entitySerializedLength = entity.getSerializedLength();
        int bufferLength = enoughSpace ? entitySerializedLength : IOBuffer.create((int)(entitySerializedLength - 1), (boolean)direct).getBufferUnsafe().capacity() / 2;
        PktSerializable.SerializeContext serializeContext1 = PktSerializable.SerializeContext.create().setPolicy(policy).addBuffer(IOBuffer.create((int)bufferLength, (boolean)direct));
        ByteBuffer buffer1 = serializeContext1.getByteBuffer(0);
        entity.serialize(serializeContext1);
        serializeContext1.flipBuffers();
        ByteBuffer list1buffer1 = serializeContext1.getByteBuffer(0);
        ByteBuffer list1buffer2 = serializeContext1.getBufferCount() > 1 ? serializeContext1.getByteBuffer(1) : null;
        if (list1buffer1 != buffer1) {
            PktSerializableTest.testFailure((String)("First buffer in list is incorrect [exp= " + buffer1 + " actual=" + list1buffer1 + "]"));
        }
        int n = expectedBufferCount = enoughSpace ? 1 : 2;
        if (serializeContext1.getBufferCount() != expectedBufferCount) {
            PktSerializableTest.testFailure((String)("Incorrect buffer count after serialization [exp=" + expectedBufferCount + " actual=" + serializeContext1.getBufferCount() + "]"));
        }
        if ((lastBuffer = serializeContext1.getByteBuffer(serializeContext1.getBufferCount() - 1)).remaining() != entitySerializedLength) {
            PktSerializableTest.testFailure((String)("Serialized data length is invalid [exp=" + entitySerializedLength + " actual=" + lastBuffer + "]"));
        }
        if (expectedBufferCount == 2) {
            if (list1buffer1.remaining() > 0) {
                PktSerializableTest.testFailure((String)"Data serialized into buffer with insufficient space.");
            }
            if (list1buffer1.isDirect() != list1buffer2.isDirect()) {
                PktSerializableTest.testFailure((String)"Appended buffer has different 'direct' attribute from original!");
            }
            int slabCapacity = IOBuffer.create((int)entitySerializedLength, (boolean)direct).getBufferUnsafe().capacity();
            if (list1buffer2.capacity() != slabCapacity) {
                PktSerializableTest.testFailure((String)("Buffer allocated for growth is not the right slab for the entity serialized length [cap=" + lastBuffer.capacity() + " slabcap=" + slabCapacity + "]!"));
            }
        }
        PktSerializable.SerializeContext serializeContext2 = PktSerializable.SerializeContext.create().addBuffer(IOBuffer.create((int)bufferLength, (boolean)direct)).setPolicy(1);
        entity.serialize(serializeContext2);
        ByteBuffer buffer2 = serializeContext2.getByteBuffer(0);
        serializeContext2.flipBuffers();
        if (serializeContext1.getBufferCount() != serializeContext2.getBufferCount()) {
            PktSerializableTest.testFailure((String)("Successive serialization yields different buffer count [buffers1=" + serializeContext1.getBufferCount() + " buffers2=" + serializeContext2.getBufferCount() + "]"));
        }
        for (int i = 0; i < serializeContext1.getBufferCount(); ++i) {
            ByteBuffer list2buffer;
            ByteBuffer list1buffer = serializeContext1.getByteBuffer(i);
            if (list1buffer == (list2buffer = serializeContext2.getByteBuffer(i))) {
                PktSerializableTest.testFailure((String)("Successive serialization created the same buffers. buffer1=" + list1buffer + " buffer2=" + list2buffer));
            }
            if (list1buffer.rewind().equals(list2buffer.rewind())) continue;
            PktSerializableTest.testFailure((String)("Successive serialization does not yield the same result. buffer1=" + UtlBuffer.dump((ByteBuffer)list1buffer) + " buffer2=" + UtlBuffer.dump((ByteBuffer)list2buffer)));
        }
        return serializeContext1.getByteBuffer(serializeContext1.getBufferCount() - 1);
    }

    static ObjectArrayList testAttachSerialization(PktSerializable entity, int policy) {
        int entitySerializedLength = entity.getSerializedLength();
        int bufferLength = entitySerializedLength * 2;
        PktSerializable.SerializeContext serializeContext1 = PktSerializable.SerializeContext.create().setPolicy(policy).addBuffer(IOBuffer.create((int)bufferLength, (boolean)false));
        ByteBuffer buffer1 = serializeContext1.getByteBuffer(0);
        entity.serialize(serializeContext1);
        serializeContext1.flipBuffers();
        if (serializeContext1.getByteBuffer(0) != buffer1) {
            PktSerializableTest.testFailure((String)("First buffer in list is incorrect [exp= " + buffer1 + " actual=" + serializeContext1.getByteBuffer(0) + "]"));
        }
        if (serializeContext1.getBufferCount() < 2) {
            PktSerializableTest.testFailure((String)("Incorrect buffer count after serialization [exp=(>=2) actual=" + serializeContext1.getBufferCount() + "]"));
        }
        if (serializeContext1.getByteBuffer(0).remaining() != 0) {
            PktSerializableTest.testFailure((String)("First buffer in list is not empty [exp=0 actual=" + serializeContext1.getByteBuffer(0).remaining() + "]"));
        }
        int remaining = 0;
        for (int i = 1; i < serializeContext1.getBufferCount(); ++i) {
            remaining += serializeContext1.getByteBuffer(i).remaining();
        }
        if (remaining != entitySerializedLength) {
            PktSerializableTest.testFailure((String)("Total remaining in serialized buffers does not total entity serialized length [exp=" + entitySerializedLength + " actual=" + remaining + "]"));
        }
        PktSerializable.SerializeContext serializeContext2 = PktSerializable.SerializeContext.create().addBuffer(IOBuffer.create((int)bufferLength, (boolean)false)).setPolicy(3);
        entity.serialize(serializeContext2);
        ByteBuffer buffer2 = serializeContext2.getByteBuffer(0);
        serializeContext2.flipBuffers();
        if (serializeContext1.getBufferCount() != serializeContext2.getBufferCount()) {
            PktSerializableTest.testFailure((String)("Successive serialization yields different buffer count [buffers1=" + serializeContext1.getBufferCount() + " buffers2=" + serializeContext2.getBufferCount() + "]"));
        }
        for (int i = 1; i < serializeContext1.getBufferCount(); ++i) {
            ByteBuffer list2buffer;
            ByteBuffer list1buffer = serializeContext1.getByteBuffer(i);
            if (list1buffer == (list2buffer = serializeContext2.getByteBuffer(i))) continue;
            PktSerializableTest.testFailure((String)("Successive serialization created different buffers. buffer1=" + list1buffer + " buffer2=" + list2buffer));
        }
        ObjectArrayList ret = new ObjectArrayList();
        for (int i = 1; i < serializeContext1.getBufferCount(); ++i) {
            ret.add((Object)serializeContext1.getByteBuffer(i));
        }
        return ret;
    }

    static ObjectArrayList testMixedSerialization(PktSerializable entity, int policy) {
        int entitySerializedLength = entity.getSerializedLength();
        PktSerializable.SerializeContext serializeContext1 = PktSerializable.SerializeContext.create().setPolicy(policy).addBuffer(IOBuffer.create((int)entitySerializedLength, (boolean)false));
        ByteBuffer buffer1 = serializeContext1.getByteBuffer(0);
        entity.serialize(serializeContext1);
        serializeContext1.flipBuffers();
        if (serializeContext1.getByteBuffer(0) != buffer1) {
            PktSerializableTest.testFailure((String)("First buffer in list is incorrect [exp= " + buffer1 + " actual=" + serializeContext1.getByteBuffer(0) + "]"));
        }
        int remaining = 0;
        for (int i = 1; i < serializeContext1.getBufferCount(); ++i) {
            remaining += serializeContext1.getByteBuffer(i).remaining();
        }
        if (remaining != entitySerializedLength) {
            PktSerializableTest.testFailure((String)("Total remaining in serialized buffers does not total entity serialized length [exp=" + entitySerializedLength + " actual=" + remaining + "]"));
        }
        PktSerializable.SerializeContext serializeContext2 = PktSerializable.SerializeContext.create().addBuffer(IOBuffer.create((int)entitySerializedLength, (boolean)false)).setPolicy(policy);
        entity.serialize(serializeContext2);
        ByteBuffer buffer2 = serializeContext2.getByteBuffer(0);
        serializeContext2.flipBuffers();
        if (serializeContext1.getBufferCount() != serializeContext2.getBufferCount()) {
            PktSerializableTest.testFailure((String)("Successive serialization yields different buffer count [buffers1=" + serializeContext1.getBufferCount() + " buffers2=" + serializeContext2.getBufferCount() + "]"));
        }
        for (int i = 1; i < serializeContext1.getBufferCount(); ++i) {
            ByteBuffer list2buffer;
            ByteBuffer list1buffer = serializeContext1.getByteBuffer(i);
            if (list1buffer == (list2buffer = serializeContext2.getByteBuffer(i))) {
                PktSerializableTest.testFailure((String)("Successive serialization created the same buffers. buffer1=" + list1buffer + " buffer2=" + list2buffer));
            }
            if (list1buffer.rewind().equals(list2buffer.rewind())) continue;
            PktSerializableTest.testFailure((String)("Successive serialization does not yield the same result. buffer1=" + UtlBuffer.dump((ByteBuffer)list1buffer) + " buffer2=" + UtlBuffer.dump((ByteBuffer)list2buffer)));
        }
        ObjectArrayList ret = new ObjectArrayList();
        for (int i = 0; i < serializeContext1.getBufferCount(); ++i) {
            ret.add((Object)serializeContext1.getByteBuffer(i));
        }
        return ret;
    }

    static ByteBuffer testDeserializationSerialize(PktSerializable entity, int serializePolicy, int serializeMode) {
        ByteBuffer buffer;
        if (serializeMode == 1) {
            buffer = PktSerializableTest.testCopySerialization(entity, serializePolicy, false, true);
        } else {
            ObjectArrayList buffers = serializeMode == 2 ? PktSerializableTest.testAttachSerialization(entity, serializePolicy) : PktSerializableTest.testMixedSerialization(entity, serializePolicy);
            if (buffers.size() > 1) {
                int i;
                int size = 0;
                for (i = 0; i < buffers.size(); ++i) {
                    size += ((ByteBuffer)buffers.get(i)).remaining();
                }
                buffer = ByteBuffer.allocate(size);
                for (i = 0; i < buffers.size(); ++i) {
                    buffer.put((ByteBuffer)buffers.get(i));
                }
                buffer.flip();
            } else {
                buffer = (ByteBuffer)buffers.get(0);
            }
        }
        return buffer;
    }

    static PktSerializable testDeserializationDeserialize(PktSerializable entity, PktSerializable.DeserializeContext context, int serializedLength) {
        ByteBuffer buffer = context.getBuffer();
        entity.deserialize(context, serializedLength, tracer);
        if (buffer != context.getBuffer()) {
            PktSerializableTest.testFailure((String)"The entity replaced the context buffer post deserialization");
        }
        return entity;
    }

    @Test(expected=IllegalStateException.class)
    public final void testGetByteBufferForCopyWithoutAdd() {
        PktSerializable.SerializeContext.create().getByteBufferForCopy(100);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testSetBufferCountLessThanZero() {
        PktSerializable.SerializeContext.create().setBufferCount(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testSetBufferCountMoreThanCurrent() {
        PktSerializable.SerializeContext.create().setBufferCount(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetBufferNegativeIndex() {
        PktSerializable.SerializeContext.create().getBuffer(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetBufferEqualToCurrentCountIndex() {
        PktSerializable.SerializeContext.create().getBuffer(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetBufferMoreThanCurrentCountIndex() {
        PktSerializable.SerializeContext.create().getBuffer(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetByteBufferNegativeIndex() {
        PktSerializable.SerializeContext.create().getByteBuffer(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetByteBufferEqualToCurrentCountIndex() {
        PktSerializable.SerializeContext.create().getByteBuffer(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testGetByteBufferMoreThanCurrentCountIndex() {
        PktSerializable.SerializeContext.create().getByteBuffer(1);
    }

    @Test
    public final void testFreshCreate() {
        PktSerializable.SerializeContext context = PktSerializable.SerializeContext.create();
        Assert.assertEquals((long)0L, (long)context.getBufferCount());
        ByteBuffer[] byteBuffers = context.getByteBuffers();
        Assert.assertNotNull((Object)byteBuffers);
        for (int i = 0; i < byteBuffers.length; ++i) {
            Assert.assertNull((Object)byteBuffers[i]);
        }
        IOBuffer[] ioBuffers = context.getBuffers();
        Assert.assertNotNull((Object)ioBuffers);
        for (int i = 0; i < ioBuffers.length; ++i) {
            Assert.assertNull((Object)ioBuffers[i]);
        }
        Assert.assertEquals((long)0L, (long)context.getRemaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testAddBuffer() {
        PktSerializable.SerializeContext context = PktSerializable.SerializeContext.create();
        IOBuffer ioBuffer1 = IOBuffer.create((int)5000, (boolean)false);
        context.addBuffer(ioBuffer1);
        Assert.assertSame((Object)ioBuffer1, (Object)context.getBuffer(0));
        ioBuffer1.releaseBuffer();
        try {
            Assert.assertSame((Object)ioBuffer1.getBufferUnsafe(), (Object)context.getByteBuffer(0));
        }
        finally {
            ioBuffer1.takeBuffer();
        }
        Assert.assertEquals((long)5000L, (long)context.getRemaining());
        Assert.assertEquals((long)1L, (long)ioBuffer1.getOwnerCount());
        IOBuffer ioBuffer2 = IOBuffer.create((int)4000, (boolean)false);
        context.addBuffer(ioBuffer2);
        Assert.assertSame((Object)ioBuffer2, (Object)context.getBuffer(1));
        ioBuffer2.releaseBuffer();
        try {
            Assert.assertSame((Object)ioBuffer2.getBufferUnsafe(), (Object)context.getByteBuffer(1));
        }
        finally {
            ioBuffer2.takeBuffer();
        }
        Assert.assertEquals((long)9000L, (long)context.getRemaining());
        Assert.assertEquals((long)1L, (long)ioBuffer2.getOwnerCount());
        IOBuffer ioBuffer3 = IOBuffer.create((int)3000, (boolean)false);
        context.addBuffer(ioBuffer3);
        Assert.assertSame((Object)ioBuffer3, (Object)context.getBuffer(2));
        ioBuffer3.releaseBuffer();
        try {
            Assert.assertSame((Object)ioBuffer3.getBufferUnsafe(), (Object)context.getByteBuffer(2));
        }
        finally {
            ioBuffer3.takeBuffer();
        }
        Assert.assertEquals((long)12000L, (long)context.getRemaining());
        Assert.assertEquals((long)1L, (long)ioBuffer3.getOwnerCount());
        context.setBufferCount(1);
        Assert.assertEquals((long)1L, (long)ioBuffer1.getOwnerCount());
        Assert.assertEquals((long)1L, (long)ioBuffer2.getOwnerCount());
        Assert.assertEquals((long)1L, (long)ioBuffer3.getOwnerCount());
        Assert.assertEquals((long)5000L, (long)context.getRemaining());
        IOBuffer ioBuffer4 = IOBuffer.create((int)2000, (boolean)false);
        context.addBuffer(ioBuffer4);
        Assert.assertSame((Object)ioBuffer4, (Object)context.getBuffer(1));
        ioBuffer4.releaseBuffer();
        try {
            Assert.assertSame((Object)ioBuffer4.getBufferUnsafe(), (Object)context.getByteBuffer(1));
        }
        finally {
            ioBuffer4.takeBuffer();
        }
        Assert.assertEquals((long)7000L, (long)context.getRemaining());
        Assert.assertEquals((long)1L, (long)ioBuffer1.getOwnerCount());
        Assert.assertEquals((long)0L, (long)ioBuffer2.getOwnerCount());
        Assert.assertEquals((long)1L, (long)ioBuffer3.getOwnerCount());
        Assert.assertEquals((long)1L, (long)ioBuffer4.getOwnerCount());
        IOBuffer ioBuffer5 = IOBuffer.create((int)1000, (boolean)false);
        context.addBuffer(ioBuffer5);
        Assert.assertSame((Object)ioBuffer5, (Object)context.getBuffer(2));
        ioBuffer5.releaseBuffer();
        try {
            Assert.assertSame((Object)ioBuffer5.getBufferUnsafe(), (Object)context.getByteBuffer(2));
        }
        finally {
            ioBuffer5.takeBuffer();
        }
        Assert.assertEquals((long)8000L, (long)context.getRemaining());
        Assert.assertEquals((long)1L, (long)ioBuffer1.getOwnerCount());
        Assert.assertEquals((long)0L, (long)ioBuffer2.getOwnerCount());
        Assert.assertEquals((long)0L, (long)ioBuffer3.getOwnerCount());
        Assert.assertEquals((long)1L, (long)ioBuffer4.getOwnerCount());
        Assert.assertEquals((long)1L, (long)ioBuffer5.getOwnerCount());
    }

    @Test
    public final void testSetBufferCount() {
        PktSerializable.SerializeContext context = PktSerializable.SerializeContext.create();
        IOBuffer ioBuffer1 = IOBuffer.create((int)5000, (boolean)false);
        context.addBuffer(ioBuffer1);
        IOBuffer ioBuffer2 = IOBuffer.create((int)4000, (boolean)false);
        context.addBuffer(ioBuffer2);
        IOBuffer ioBuffer3 = IOBuffer.create((int)3000, (boolean)false);
        context.addBuffer(ioBuffer3);
        Assert.assertEquals((long)12000L, (long)context.getRemaining());
        context.setBufferCount(1);
        Assert.assertEquals((long)1L, (long)ioBuffer1.getOwnerCount());
        Assert.assertEquals((long)1L, (long)ioBuffer2.getOwnerCount());
        Assert.assertEquals((long)1L, (long)ioBuffer3.getOwnerCount());
        Assert.assertEquals((long)5000L, (long)context.getRemaining());
        Assert.assertEquals((long)1L, (long)context.getBufferCount());
        Assert.assertSame((Object)ioBuffer1, (Object)context.getBuffer(0));
    }
}

