/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import cern.colt.list.ObjectArrayList;
import com.neeve.pkt.EPktCorruptException;
import com.neeve.pkt.EPktVersionInvalidException;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.PktSubheaderFMC;
import com.neeve.pkt.PktSubheaderFUC;
import com.neeve.pkt.PktSubheaderRR;
import com.neeve.pkt.test.unit.PktSerializableTest;
import com.neeve.pkt.test.unit.PktTestHelper;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public final class PktHeaderTest
extends UnitTest {
    private static Random random;

    @BeforeClass
    public static void createPacketTypeConfigFiles() {
        PktTestHelper.loadPacketTypes();
        random = new Random((int)System.currentTimeMillis());
        PktFactory.getInstance().getTracer().setLevel(Tracer.Level.OFF);
    }

    static void checkHeaderValues(PktHeader header, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, short numSubheaders, boolean failOnWrite, boolean copyOnWrite, PktBody rrSubheader, boolean rrEquals, PktBody fmcSubheader, boolean fmcEquals, PktBody fucSubheader, boolean fucEquals) {
        if (header.getBuffer().isFailOnWrite() != failOnWrite) {
            PktHeaderTest.testFailure((String)("Incorrect header FAILONWRITE [exp=" + failOnWrite + " actual=" + header.getBuffer().isFailOnWrite() + "]"));
        }
        if (header.getBuffer().isCopyOnWrite() != copyOnWrite) {
            PktHeaderTest.testFailure((String)("Incorrect header COPYONWRITE [exp=" + copyOnWrite + " actual=" + header.getBuffer().isCopyOnWrite() + "]"));
        }
        if (header.getBuffer().isFailOnWrite()) {
            PktHeaderTest.testFailure((String)"Header FAILONWRITE is true after first read!");
        }
        if (header.getVersion() != ver) {
            PktHeaderTest.testFailure((String)("Incorrect header VER [exp=" + ver + " actual=" + header.getVersion() + "]"));
        }
        if (header.getSrc() != src) {
            PktHeaderTest.testFailure((String)("Incorrect header SRC [exp=" + src + " actual=" + header.getSrc() + "]"));
        }
        if (header.getDest() != dest) {
            PktHeaderTest.testFailure((String)("Incorrect header DEST [exp=" + dest + " actual=" + header.getDest() + "]"));
        }
        if (header.getFlow() != flow) {
            PktHeaderTest.testFailure((String)("Incorrect header FLOW [exp=" + flow + " actual=" + header.getFlow() + "]"));
        }
        if (header.getNoBuffering() != nobuffer) {
            PktHeaderTest.testFailure((String)("Incorrect header NO_BUFFERING flag [exp=" + nobuffer + " actual=" + header.getNoBuffering() + "]"));
        }
        if (header.getReplyExpected() != replyexpected) {
            PktHeaderTest.testFailure((String)("Incorrect header REPLY_EXPECTED flag [exp=" + replyexpected + " actual=" + header.getReplyExpected() + "]"));
        }
        if (header.getHtl() != htl) {
            PktHeaderTest.testFailure((String)("Incorrect header HTL [exp=" + htl + " actual=" + header.getHtl() + "]"));
        }
        if (header.getClazz() != clazz) {
            PktHeaderTest.testFailure((String)("Incorrect header CLAZZ [exp=" + clazz + " actual=" + header.getClazz() + "]"));
        }
        if (header.getBody() != null && header.getBody().getType() != type) {
            PktHeaderTest.testFailure((String)("Incorrect header TYPE [exp=" + type + " actual=" + header.getBody().getType() + "]"));
        }
        if (header.getBody() == null && type != 0) {
            PktHeaderTest.testFailure((String)("Incorrect header TYPE [exp=" + type + " actual=<null body>]"));
        }
        if (header.getLength() != len) {
            PktHeaderTest.testFailure((String)("Incorrect header LEN [exp=" + len + " actual=" + header.getLength() + "]"));
        }
        if (header.getNumSubheaders() != numSubheaders) {
            PktHeaderTest.testFailure((String)("Incorrect header NUMSH [exp=" + numSubheaders + " actual=" + header.getNumSubheaders() + "]"));
        }
        int nsh = numSubheaders;
        if (header.getRRSubheader() != null) {
            --nsh;
        }
        if (header.getFMCSubheader() != null) {
            --nsh;
        }
        if (header.getFUCSubheader() != null) {
            --nsh;
        }
        if (nsh != 0) {
            PktHeaderTest.testFailure((String)("Number of subheaders header element [" + header.getNumSubheaders() + " ] does not match the actual subheader count [" + (header.getNumSubheaders() - nsh) + "]"));
        }
        if (!rrEquals && header.getRRSubheader() != rrSubheader) {
            PktHeaderTest.testFailure((String)("Incorrect RR subheader [exp=" + (Object)((Object)rrSubheader) + " actual=" + (Object)((Object)header.getRRSubheader()) + "]"));
        }
        if (rrEquals && header.getRRSubheader() != null && rrSubheader != null && !header.getRRSubheader().equals((Object)rrSubheader)) {
            PktHeaderTest.testFailure((String)("Incorrect RR subheader (via equals()) [exp=" + ((Object)((Object)rrSubheader)).toString() + " actual=" + header.getRRSubheader().toString() + "]"));
        }
        if (!fmcEquals && header.getFMCSubheader() != fmcSubheader) {
            PktHeaderTest.testFailure((String)("Incorrect FMC subheader [exp=" + (Object)((Object)fmcSubheader) + " actual=" + (Object)((Object)header.getFMCSubheader()) + "]"));
        }
        if (fmcEquals && header.getFMCSubheader() != null && fmcSubheader != null && !header.getFMCSubheader().equals((Object)fmcSubheader)) {
            PktHeaderTest.testFailure((String)("Incorrect FMC subheader (via equals()) [exp=" + ((Object)((Object)fmcSubheader)).toString() + " actual=" + header.getFMCSubheader().toString() + "]"));
        }
        if (!fucEquals && header.getFUCSubheader() != fucSubheader) {
            PktHeaderTest.testFailure((String)("Incorrect FUC subheader [exp=" + (Object)((Object)fucSubheader) + " actual=" + (Object)((Object)header.getFUCSubheader()) + "]"));
        }
        if (fucEquals && header.getFUCSubheader() != null && fucSubheader != null && !header.getFUCSubheader().equals((Object)fucSubheader)) {
            PktHeaderTest.testFailure((String)("Incorrect FUC subheader (via equals()) [exp=" + ((Object)((Object)fucSubheader)).toString() + " actual=" + ((Object)((Object)header.getFUCSubheader())).toString() + "]"));
        }
        if (header.getBuffer().isCopyOnWrite() != copyOnWrite) {
            PktHeaderTest.testFailure((String)"Header COPYONWRITE has changed even though no write was performed on header.");
        }
        if (copyOnWrite) {
            header.setSrc(src);
            PktHeaderTest.checkHeaderValues(header, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, (short)numSubheaders, false, false, rrSubheader, rrEquals, fmcSubheader, fmcEquals, fucSubheader, fucEquals);
        }
    }

    static void checkHeaderValues(PktHeader header, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, short numSubheaders, boolean failOnWrite, boolean copyOnWrite, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader) {
        PktHeaderTest.checkHeaderValues(header, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, numSubheaders, failOnWrite, copyOnWrite, rrSubheader, false, fmcSubheader, false, fucSubheader, false);
    }

    private void testHeaderElementsSet(PktHeader header, short ver, int type) throws Exception {
        PktHeaderTest.checkHeaderValues(header, ver, 0, 0, 0, false, false, (short)255, (short)0, type, 0, (short)0, false, false, null, null, null);
        int newSrc = random.nextInt();
        header.setSrc(newSrc);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, 0, 0, false, false, (short)255, (short)0, type, 0, (short)0, false, false, null, null, null);
        int newDest = random.nextInt();
        header.setDest(newDest);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, 0, false, false, (short)255, (short)0, type, 0, (short)0, false, false, null, null, null);
        int newFlow = random.nextInt();
        header.setFlow(newFlow);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, false, false, (short)255, (short)0, type, 0, (short)0, false, false, null, null, null);
        boolean newNoBuffering = !header.getNoBuffering();
        header.setNoBuffering(newNoBuffering);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, false, (short)255, (short)0, type, 0, (short)0, false, false, null, null, null);
        boolean newReplyExpected = !header.getReplyExpected();
        header.setReplyExpected(newReplyExpected);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, (short)255, (short)0, type, 0, (short)0, false, false, null, null, null);
        short newHtl = (short)random.nextInt(255);
        header.setHtl(newHtl);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, (short)0, type, 0, (short)0, false, false, null, null, null);
        short newClazz = (short)random.nextInt(255);
        header.setClazz(newClazz);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, 0, (short)0, false, false, null, null, null);
        int len = this.getHeaderLenPostSerialization(header);
        this.testCopySerialization(header, 1, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)0, null, null, null);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)0, false, false, null, null, null);
        PktSubheaderRR newRRSubheader = header.activateRRSubheader(false);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)1, false, false, newRRSubheader, null, null);
        PktSubheaderFMC newFMCSubheader = header.activateFMCSubheader(false);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)2, false, false, newRRSubheader, newFMCSubheader, null);
        PktSubheaderFUC newFUCSubheader = header.activateFUCSubheader(false);
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)3, false, false, newRRSubheader, newFMCSubheader, newFUCSubheader);
        header.deactivateRRSubheader();
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)2, false, false, null, newFMCSubheader, newFUCSubheader);
        header.deactivateFMCSubheader();
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)1, false, false, null, null, newFUCSubheader);
        header.deactivateFUCSubheader();
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)0, false, false, null, null, null);
        header.deactivateFUCSubheader();
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)0, false, false, null, null, null);
        header.deactivateFMCSubheader();
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)0, false, false, null, null, null);
        header.deactivateRRSubheader();
        PktHeaderTest.checkHeaderValues(header, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, (short)0, false, false, null, null, null);
    }

    private void testSerializationPolicyValidSet(PktHeader header) {
        PktTestHelper.checkPoliciesInPacketHeader(header, 1, 1);
        header.setSerializationPolicy(2);
        PktTestHelper.checkPoliciesInPacketHeader(header, 2, 1);
        header.setSerializationPolicy(3);
        PktTestHelper.checkPoliciesInPacketHeader(header, 3, 1);
        header.activateRRSubheader(false);
        header.activateFMCSubheader(false);
        header.activateFUCSubheader(false);
        PktTestHelper.checkPoliciesInPacketHeader(header, 3, 1);
        header.setSerializationPolicy(2);
        PktTestHelper.checkPoliciesInPacketHeader(header, 2, 1);
        header.setSerializationPolicy(1);
        PktTestHelper.checkPoliciesInPacketHeader(header, 1, 1);
    }

    private void testSerializationPolicyInvalidSet(PktHeader header) {
        try {
            header.setSerializationPolicy(0);
            PktHeaderTest.testFailure((String)"Allowed serialization policy to be set to SERIALIZE_POLICY_DEFAULT");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            header.setSerializationPolicy(4);
            PktHeaderTest.testFailure((String)"Allowed serialization policy to be set to SERIALIZE_POLICY_HEADER_ATTACH_BODY_ATTACH + 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testDeserializationPolicyValidSet(PktHeader header) {
        PktTestHelper.checkPoliciesInPacketHeader(header, 1, 1);
        header.setDeserializationPolicy(2);
        PktTestHelper.checkPoliciesInPacketHeader(header, 1, 2);
        header.setDeserializationPolicy(3);
        PktTestHelper.checkPoliciesInPacketHeader(header, 1, 3);
        header.activateRRSubheader(false);
        header.activateFMCSubheader(false);
        header.activateFUCSubheader(false);
        PktTestHelper.checkPoliciesInPacketHeader(header, 1, 3);
        header.setDeserializationPolicy(2);
        PktTestHelper.checkPoliciesInPacketHeader(header, 1, 2);
        header.setDeserializationPolicy(1);
        PktTestHelper.checkPoliciesInPacketHeader(header, 1, 1);
    }

    private void testDeserializationPolicyInvalidSet(PktHeader header) {
        try {
            header.setDeserializationPolicy(0);
            PktHeaderTest.testFailure((String)"Allowed deserialization policy to be set to DESERIALIZE_POLICY_DEFAULT");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            header.setDeserializationPolicy(4);
            PktHeaderTest.testFailure((String)"Allowed deserialization policy to be set to DESERIALIZE_POLICY_HEADER_SLICE_BODY_SLICE + 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testCopySerialization(PktHeader header, int policy, boolean direct, boolean enoughSpace, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader) {
        ByteBuffer buffer = PktSerializableTest.testCopySerialization(header, policy, direct, enoughSpace);
        if (PktHeader.getBodyType(buffer, 0) != type) {
            PktHeaderTest.testFailure((String)("The type field was not serialized correctly during copy serialization [exp= " + type + " actual=" + PktHeader.getBodyType(buffer, 0) + "]"));
        }
        PktHeaderTest.checkHeaderValues(header, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, numSubheaders, false, false, rrSubheader, fmcSubheader, fucSubheader);
        ByteBuffer clone = UtlBuffer.clone((ByteBuffer)buffer);
        header.setSrc(random.nextInt());
        header.setDest(random.nextInt());
        header.setFlow(random.nextInt());
        header.setNoBuffering(!header.getNoBuffering());
        header.setReplyExpected(!header.getReplyExpected());
        header.setHtl((short)random.nextInt(255));
        header.setClazz((short)random.nextInt(255));
        String topic = null;
        if (rrSubheader != null) {
            // empty if block
        }
        if (fmcSubheader != null) {
            topic = ((PktSubheaderFMC)fmcSubheader).getTopic();
            ((PktSubheaderFMC)fmcSubheader).setTopic(topic + "ch");
        }
        if (fucSubheader != null) {
            // empty if block
        }
        if (!buffer.equals(clone)) {
            PktHeaderTest.testFailure((String)"Writing to a header post serialization changed the copy serialization buffer");
        }
        header.setSrc(src);
        header.setDest(dest);
        header.setFlow(flow);
        header.setNoBuffering(nobuffer);
        header.setReplyExpected(replyexpected);
        header.setHtl(htl);
        header.setClazz(clazz);
        if (rrSubheader != null) {
            // empty if block
        }
        if (fmcSubheader != null) {
            ((PktSubheaderFMC)fmcSubheader).setTopic(topic);
        }
        if (fucSubheader != null) {
            // empty if block
        }
    }

    private void testAttachSerialization(PktHeader header, int policy, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader) {
        ObjectArrayList buffers = PktSerializableTest.testAttachSerialization(header, policy);
        if (PktHeader.getBodyType((ByteBuffer)buffers.get(0), 0) != type) {
            PktHeaderTest.testFailure((String)("The type field was not serialized correctly during attach serialization [exp= " + type + " actual=" + PktHeader.getBodyType((ByteBuffer)buffers.get(0), 0) + "]"));
        }
        PktHeaderTest.checkHeaderValues(header, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, numSubheaders, false, false, rrSubheader, fmcSubheader, fucSubheader);
        ObjectArrayList clones = new ObjectArrayList();
        for (int i = 0; i < buffers.size(); ++i) {
            clones.add((Object)UtlBuffer.clone((ByteBuffer)((ByteBuffer)buffers.get(i))));
        }
        header.setSrc(random.nextInt());
        header.setDest(random.nextInt());
        header.setFlow(random.nextInt());
        header.setNoBuffering(!header.getNoBuffering());
        header.setReplyExpected(!header.getReplyExpected());
        header.setHtl((short)random.nextInt(255));
        header.setClazz((short)random.nextInt(255));
        String topic = null;
        if (rrSubheader != null) {
            ((PktSubheaderRR)rrSubheader).setCorrelationId(((PktSubheaderRR)rrSubheader).getCorrelationId() + 1L);
        }
        if (fmcSubheader != null) {
            topic = ((PktSubheaderFMC)fmcSubheader).getTopic();
            ((PktSubheaderFMC)fmcSubheader).setTopic(topic + "ch");
        }
        if (fucSubheader != null) {
            // empty if block
        }
        for (int i = 0; i < buffers.size(); ++i) {
            ByteBuffer buffer = (ByteBuffer)buffers.get(i);
            ByteBuffer clone = (ByteBuffer)clones.get(i);
            if (i != 0 || !buffer.equals(clone)) continue;
            PktHeaderTest.testFailure((String)"Writing to a header post serialization did not change the attach serialization buffers");
        }
        header.setSrc(src);
        header.setDest(dest);
        header.setFlow(flow);
        header.setNoBuffering(nobuffer);
        header.setReplyExpected(replyexpected);
        header.setHtl(htl);
        header.setClazz(clazz);
        if (rrSubheader != null) {
            // empty if block
        }
        if (fmcSubheader != null) {
            ((PktSubheaderFMC)fmcSubheader).setTopic(topic);
        }
        if (fucSubheader != null) {
            // empty if block
        }
    }

    private int getHeaderLenPostSerialization(PktHeader header) {
        return header.getSerializedLength() + (header.getBody() != null ? header.getBody().getSerializedLength() : 0);
    }

    private void testCopySerializationWithEnoughSpace(PktHeader header, int policy, short ver, int type) {
        this.testCopySerialization(header, policy, false, true, ver, 0, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, 0, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newSrc = random.nextInt();
        header.setSrc(newSrc);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newDest = random.nextInt();
        header.setDest(newDest);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newFlow = random.nextInt();
        header.setFlow(newFlow);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        boolean newNoBuffering = !header.getNoBuffering();
        header.setNoBuffering(newNoBuffering);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        boolean newReplyExpected = !header.getReplyExpected();
        header.setReplyExpected(newReplyExpected);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        short newHtl = (short)random.nextInt(255);
        header.setHtl(newHtl);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        short newClazz = (short)random.nextInt(255);
        header.setClazz(newClazz);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        PktSubheaderRR newRRSubheader = header.activateRRSubheader(false);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, newRRSubheader, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, newRRSubheader, null, null);
        PktSubheaderFMC newFMCSubheader = header.activateFMCSubheader(false);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, newRRSubheader, newFMCSubheader, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, newRRSubheader, newFMCSubheader, null);
        PktSubheaderFUC newFUCSubheader = header.activateFUCSubheader(false);
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)3, newRRSubheader, newFMCSubheader, newFUCSubheader);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)3, newRRSubheader, newFMCSubheader, newFUCSubheader);
        header.deactivateRRSubheader();
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, null, newFMCSubheader, newFUCSubheader);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, null, newFMCSubheader, newFUCSubheader);
        header.deactivateFMCSubheader();
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, null, null, newFUCSubheader);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, null, null, newFUCSubheader);
        header.deactivateFUCSubheader();
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateFUCSubheader();
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateFMCSubheader();
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateRRSubheader();
        this.testCopySerialization(header, policy, false, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, true, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
    }

    private void testCopySerializationWithoutEnoughSpace(PktHeader header, int policy, short ver, int type) {
        this.testCopySerialization(header, policy, false, false, ver, 0, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, 0, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newSrc = random.nextInt();
        header.setSrc(newSrc);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newDest = random.nextInt();
        header.setDest(newDest);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newFlow = random.nextInt();
        header.setFlow(newFlow);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        boolean newNoBuffering = !header.getNoBuffering();
        header.setNoBuffering(newNoBuffering);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        boolean newReplyExpected = !header.getReplyExpected();
        header.setReplyExpected(newReplyExpected);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        short newHtl = (short)random.nextInt(255);
        header.setHtl(newHtl);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        short newClazz = (short)random.nextInt(255);
        header.setClazz(newClazz);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        PktSubheaderRR newRRSubheader = header.activateRRSubheader(false);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, newRRSubheader, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, newRRSubheader, null, null);
        PktSubheaderFMC newFMCSubheader = header.activateFMCSubheader(false);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, newRRSubheader, newFMCSubheader, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, newRRSubheader, newFMCSubheader, null);
        PktSubheaderFUC newFUCSubheader = header.activateFUCSubheader(false);
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)3, newRRSubheader, newFMCSubheader, newFUCSubheader);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)3, newRRSubheader, newFMCSubheader, newFUCSubheader);
        header.deactivateRRSubheader();
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, null, newFMCSubheader, newFUCSubheader);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, null, newFMCSubheader, newFUCSubheader);
        header.deactivateFMCSubheader();
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, null, null, newFUCSubheader);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, null, null, newFUCSubheader);
        header.deactivateFUCSubheader();
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateFUCSubheader();
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateFMCSubheader();
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateRRSubheader();
        this.testCopySerialization(header, policy, false, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testCopySerialization(header, policy, true, false, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
    }

    private void testAttachSerialization(PktHeader header, int policy, short ver, int type) {
        this.testAttachSerialization(header, policy, ver, 0, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        this.testAttachSerialization(header, policy, ver, 0, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newSrc = random.nextInt();
        header.setSrc(newSrc);
        this.testAttachSerialization(header, policy, ver, newSrc, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newDest = random.nextInt();
        header.setDest(newDest);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        int newFlow = random.nextInt();
        header.setFlow(newFlow);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        boolean newNoBuffering = !header.getNoBuffering();
        header.setNoBuffering(newNoBuffering);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        boolean newReplyExpected = !header.getReplyExpected();
        header.setReplyExpected(newReplyExpected);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        short newHtl = (short)random.nextInt(255);
        header.setHtl(newHtl);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, (short)0, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        short newClazz = (short)random.nextInt(255);
        header.setClazz(newClazz);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        PktSubheaderRR newRRSubheader = header.activateRRSubheader(false);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, newRRSubheader, null, null);
        PktSubheaderFMC newFMCSubheader = header.activateFMCSubheader(false);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, newRRSubheader, newFMCSubheader, null);
        PktSubheaderFUC newFUCSubheader = header.activateFUCSubheader(false);
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)3, newRRSubheader, newFMCSubheader, newFUCSubheader);
        header.deactivateRRSubheader();
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)2, null, newFMCSubheader, newFUCSubheader);
        header.deactivateFMCSubheader();
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)1, null, null, newFUCSubheader);
        header.deactivateFUCSubheader();
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateFUCSubheader();
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateFMCSubheader();
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        header.deactivateRRSubheader();
        this.testAttachSerialization(header, policy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), (short)0, null, null, null);
        PktHeaderTest.testSuccess((String)"Packet header serialization using attach is working fine.");
    }

    private void testPreDeserializationInvalidMagic(PktHeader header) throws Exception {
        int val;
        ByteBuffer buffer = PktSerializableTest.testCopySerialization(header, 1, false, true);
        int magic = 12246189;
        while (magic == ((val = buffer.getInt(0) & 0xFF | random.nextInt() & 0xFFFFFF00) & 0xFFFFFF00) >> 8) {
        }
        buffer.putInt(0, val);
        try {
            PktHeader.preDeserialize(PktSerializable.DeserializeContext.create().setBuffer(buffer));
            PktHeaderTest.testFailure((String)"predeserialize did not catch an invalid magic number in a serialized header");
        }
        catch (EPktCorruptException e) {
            PktHeaderTest.testSuccess((String)("Received corrupt packet exception [" + e.getMessage() + "] when predeserializing a buffer with an invalid magic"));
        }
    }

    private void testPreDeserializationInvalidVersion(PktHeader header) throws Exception {
        int val;
        ByteBuffer buffer = PktSerializableTest.testCopySerialization(header, 1, false, true);
        short version = header.getVersion();
        while (version == (short)((val = buffer.getInt(0) & 0xFFFFFF00 | random.nextInt() & 0xFF) & 0xFF)) {
        }
        buffer.putInt(0, val);
        try {
            PktHeader.preDeserialize(PktSerializable.DeserializeContext.create().setBuffer(buffer));
            PktHeaderTest.testFailure((String)("predeserialize did not catch an invalid version [" + (val & 0xFF) + " in a serialized header"));
        }
        catch (EPktVersionInvalidException e) {
            PktHeaderTest.testSuccess((String)("Received invalid version exception [" + e.getMessage() + "] when predeserializing a buffer with a valid magic and invalid header format version"));
        }
    }

    private void testPreDeserializationLessMinLenBuffer(PktHeader header) throws Exception {
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(ByteBuffer.allocate(0));
        PktHeader.preDeserialize(context);
        int minLen = context.getNumBytes();
        ByteBuffer buffer = PktSerializableTest.testCopySerialization(header, 1, false, true);
        context.setBuffer(buffer);
        for (int i = 0; i < minLen; ++i) {
            buffer.position(0).limit(i);
            if (PktHeader.preDeserialize(context.reset())) {
                PktHeaderTest.testFailure((String)("Predeserialise of a " + i + " byte buffer returned true!"));
            }
            if (context.getNumBytes() != minLen - i) {
                PktHeaderTest.testFailure((String)("Invalid numBytes in context [exp=" + (minLen - i) + " actual=" + context.getNumBytes() + "] from predeserialise of a " + i + " byte buffer"));
            }
            if (buffer.position() != 0) {
                PktHeaderTest.testFailure((String)("Predeserialization of buffer of length=" + i + " changed the buffer position marker [before=0 after=" + buffer.position() + "]"));
            }
            if (buffer.limit() != i) {
                PktHeaderTest.testFailure((String)("Predeserialization of buffer of length=" + i + " changed the buffer limit marker [before=" + i + " after=" + buffer.limit() + "]"));
            }
            PktHeaderTest.testSuccess((String)("Predeserialization of a buffer of length=" + i + " bytes returned false and requested " + context.getNumBytes() + " additional bytes"));
        }
    }

    private void testPreDeserializationLessOrEqualLenBuffer(PktHeader header, PktBody body) throws Exception {
        if (header.getBody() != body) {
            PktHeaderTest.testFailure((String)"Incorrect test setup. Body must be associated with header");
        }
        ByteBuffer hdrBuffer = PktSerializableTest.testCopySerialization(header, 1, false, true);
        ByteBuffer bodyBuffer = PktSerializableTest.testCopySerialization(body, 1, false, true);
        if (bodyBuffer.remaining() <= 0) {
            PktHeaderTest.testFailure((String)"Incorrect test setup. Provided body serialized length = 0");
        }
        ByteBuffer buffer = ByteBuffer.allocate(hdrBuffer.remaining() + bodyBuffer.remaining());
        buffer.put(hdrBuffer);
        buffer.put(bodyBuffer);
        int len = header.getLength();
        if (len != buffer.capacity()) {
            PktHeaderTest.testFailure((String)("Incorrect test setup. Consolidated buffer capacity (header buffer length + body buffer length) is not the same as the length in header [hdrLen=" + header.getLength() + " bufferCapacity=" + buffer.capacity() + "]"));
        }
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(ByteBuffer.allocate(0));
        PktHeader.preDeserialize(context);
        int minLen = context.getNumBytes();
        context.setBuffer(buffer);
        for (int i = minLen; i < len; ++i) {
            buffer.position(0).limit(i);
            if (PktHeader.preDeserialize(context.reset())) {
                PktHeaderTest.testFailure((String)("Predeserialise of a " + i + " byte buffer returned true!"));
            }
            if (context.getNumBytes() != len - i) {
                PktHeaderTest.testFailure((String)("Invalid numBytes in context [exp=" + (len - i) + " actual=" + context.getNumBytes() + "] from predeserialise of a " + i + " byte buffer"));
            }
            if (buffer.position() != 0) {
                PktHeaderTest.testFailure((String)("Predeserialization of buffer of length=" + i + " changed the buffer position marker [before=0 after=" + buffer.position() + "]"));
            }
            if (buffer.limit() != i) {
                PktHeaderTest.testFailure((String)("Predeserialization of buffer of length=" + i + " changed the buffer limit marker [before=" + i + " after=" + buffer.limit() + "]"));
            }
            PktHeaderTest.testSuccess((String)("Predeserialization of a buffer of length=" + i + " bytes returned false and requested " + context.getNumBytes() + " additional bytes"));
        }
        buffer.position(0).limit(buffer.capacity());
        if (!PktHeader.preDeserialize(context.reset())) {
            PktHeaderTest.testFailure((String)"Predeserialize from fully serialized packet returned false!");
        }
        if (context.getNumBytes() != 0) {
            PktHeaderTest.testFailure((String)("Predeserialize from fully serialized packet changed the context.numBytes field [exp=0 actual=" + context.getNumBytes() + "]"));
        }
    }

    private void testDeserializationPostDeserialize(PktHeader header, PktHeader newHeader, PktSerializable.DeserializeContext context, int pos, ByteBuffer buffer, int serializePolicy, int deserializePolicy, boolean serializeCopy, boolean deserializeCopy, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int slen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader) {
        if (buffer.position() - pos != slen) {
            PktHeaderTest.testFailure((String)("Deserialization caused buffer pointer to advance by an incorrect amount [exp=" + slen + " actual=" + (buffer.position() - pos) + "]"));
        }
        if (context.getNumBytes() != slen) {
            PktHeaderTest.testFailure((String)("Deserialization did not update context with accurate byte count [exp=" + slen + " actual=" + context.getNumBytes() + "]"));
        }
        PktHeaderTest.checkHeaderValues(header, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, numSubheaders, false, false, rrSubheader, fmcSubheader, fucSubheader);
        PktHeaderTest.checkHeaderValues(newHeader, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, numSubheaders, false, false, rrSubheader, true, fmcSubheader, true, fucSubheader, true);
        if (PktHeader.getBodyType(newHeader.getBuffer(), 0) != type) {
            PktHeaderTest.testFailure((String)("Incorrect TYPE in deserialized header buffer [exp=" + type + " actual=" + PktHeader.getBodyType(newHeader.getBuffer(), 0) + "]"));
        }
        header.setSrc(random.nextInt());
        header.setDest(random.nextInt());
        header.setFlow(random.nextInt());
        header.setNoBuffering(!header.getNoBuffering());
        header.setReplyExpected(!header.getReplyExpected());
        header.setHtl((short)random.nextInt(255));
        header.setClazz((short)random.nextInt(255));
        String topic = null;
        if (rrSubheader != null) {
            // empty if block
        }
        if (fmcSubheader != null) {
            topic = ((PktSubheaderFMC)fmcSubheader).getTopic();
            ((PktSubheaderFMC)fmcSubheader).setTopic(topic + "ch");
        }
        if (fucSubheader != null) {
            // empty if block
        }
        PktSubheaderFMC newFmcSubheader = (PktSubheaderFMC)PktSubheaderFMC.create();
        newFmcSubheader.setTopic(topic);
        PktHeaderTest.checkHeaderValues(newHeader, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, numSubheaders, false, false, rrSubheader, true, newFmcSubheader, true, fucSubheader, true);
        header.setSrc(src);
        header.setDest(dest);
        header.setFlow(flow);
        header.setNoBuffering(nobuffer);
        header.setReplyExpected(replyexpected);
        header.setHtl(htl);
        header.setClazz(clazz);
        if (rrSubheader != null) {
            // empty if block
        }
        if (fmcSubheader != null) {
            ((PktSubheaderFMC)fmcSubheader).setTopic(topic);
        }
        if (fucSubheader != null) {
            // empty if block
        }
    }

    private void testDeserializationSimple(PktHeader header, int serializePolicy, int deserializePolicy, boolean serializeCopy, boolean deserializeCopy, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int slen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader) throws Exception {
        ByteBuffer buffer = PktSerializableTest.testDeserializationSerialize(header, serializePolicy, serializeCopy ? 1 : 2);
        if (!serializeCopy && !deserializeCopy) {
            buffer = UtlBuffer.clone((ByteBuffer)buffer);
        }
        int pos = buffer.position();
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(buffer).setPolicy(deserializePolicy);
        PktHeader newHeader = (PktHeader)PktSerializableTest.testDeserializationDeserialize(PktFactory.getInstance().createPacket(header.getBody().getType()).getHeader(), context, -1);
        this.testDeserializationPostDeserialize(header, newHeader, context, pos, buffer, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
    }

    private void testDeserializationRepeat(PktHeader header, int serializePolicy, int deserializePolicy, boolean serializeCopy, boolean deserializeCopy, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int slen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader) throws Exception {
        this.testDeserializationSimple(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
        this.testDeserializationSimple(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
    }

    private void testDeserializationFromLarger(PktHeader header, int serializePolicy, int deserializePolicy, boolean serializeCopy, boolean deserializeCopy, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int slen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader) throws Exception {
        ByteBuffer buffer = PktSerializableTest.testDeserializationSerialize(header, serializePolicy, serializeCopy ? 1 : 2);
        ByteBuffer buffer1 = ByteBuffer.allocate(buffer.capacity() * 3 / 2);
        buffer1.put(buffer);
        buffer1.flip();
        int pos = buffer1.position();
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(buffer1).setPolicy(deserializePolicy);
        PktHeader newHeader = (PktHeader)PktSerializableTest.testDeserializationDeserialize(PktFactory.getInstance().createPacket(header.getBody().getType()).getHeader(), context, -1);
        this.testDeserializationPostDeserialize(header, newHeader, context, pos, buffer1, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
    }

    private void testDeserializationTwice(PktHeader header, int serializePolicy, int deserializePolicy, boolean serializeCopy, boolean deserializeCopy, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int slen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader) throws Exception {
        ByteBuffer buffer = PktSerializableTest.testDeserializationSerialize(header, serializePolicy, serializeCopy ? 1 : 2).duplicate();
        ByteBuffer buffer1 = PktSerializableTest.testDeserializationSerialize(header, serializePolicy, serializeCopy ? 1 : 2);
        ByteBuffer buffer2 = ByteBuffer.allocate(buffer.capacity() + buffer1.capacity());
        buffer2.put(buffer).put(buffer1);
        buffer2.flip();
        int pos = buffer2.position();
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(buffer2).setPolicy(deserializePolicy);
        PktHeader newHeader = (PktHeader)PktSerializableTest.testDeserializationDeserialize(PktFactory.getInstance().createPacket(header.getBody().getType()).getHeader(), context, -1);
        this.testDeserializationPostDeserialize(header, newHeader, context, pos, buffer2, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
        buffer2 = context.getBuffer();
        pos = buffer2.position();
        newHeader = (PktHeader)PktSerializableTest.testDeserializationDeserialize(PktFactory.getInstance().createPacket(header.getBody().getType()).getHeader(), context.reset(), -1);
        ByteBuffer buffer3 = PktSerializableTest.testDeserializationSerialize(header, serializePolicy, serializeCopy ? 1 : 2);
        this.testDeserializationPostDeserialize(header, newHeader, context, pos, buffer2, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
    }

    private void testDeserialization(PktHeader header, int serializePolicy, int deserializePolicy, boolean serializeCopy, boolean deserializeCopy, short ver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int slen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader, boolean repeat) throws Exception {
        this.testDeserializationSimple(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
        if (repeat) {
            this.testDeserializationRepeat(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
        }
        this.testDeserializationFromLarger(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
        this.testDeserializationTwice(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, slen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader);
    }

    private void testDeserialization(PktHeader header, int serializePolicy, int deserializePolicy, boolean serializeCopy, boolean deserializeCopy, short ver, int type, int len) throws Exception {
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, 0, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        int newSrc = random.nextInt();
        header.setSrc(newSrc);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, 0, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        int newDest = random.nextInt();
        header.setDest(newDest);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, 0, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        int newFlow = random.nextInt();
        header.setFlow(newFlow);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, false, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        boolean newNoBuffering = !header.getNoBuffering();
        header.setNoBuffering(newNoBuffering);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, false, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        boolean newReplyExpected = !header.getReplyExpected();
        header.setReplyExpected(newReplyExpected);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, (short)255, (short)0, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        short newHtl = (short)random.nextInt(255);
        header.setHtl(newHtl);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, (short)0, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        short newClazz = (short)random.nextInt(255);
        header.setClazz(newClazz);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        PktSubheaderRR newRRSubheader = header.activateRRSubheader(false);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)1, newRRSubheader, null, null, true);
        PktSubheaderFMC newFMCSubheader = header.activateFMCSubheader(false);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)2, newRRSubheader, newFMCSubheader, null, true);
        PktSubheaderFUC newFUCSubheader = header.activateFUCSubheader(false);
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)3, newRRSubheader, newFMCSubheader, newFUCSubheader, true);
        header.deactivateRRSubheader();
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)2, null, newFMCSubheader, newFUCSubheader, true);
        header.deactivateFMCSubheader();
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)1, null, null, newFUCSubheader, true);
        header.deactivateFUCSubheader();
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        header.deactivateFUCSubheader();
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        header.deactivateFMCSubheader();
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
        header.deactivateRRSubheader();
        this.testDeserialization(header, serializePolicy, deserializePolicy, serializeCopy, deserializeCopy, ver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, this.getHeaderLenPostSerialization(header), header.getSerializedLength(), (short)0, null, null, null, true);
    }

    @Test
    public void testGetNumSubheadersDoesNotTriggerBufferCreation() {
        PktHeader header = PktHeader.create(null, null);
        Assert.assertEquals((long)0L, (long)header.getNumSubheaders());
        Assert.assertNull((Object)header.getBuffer().getIOBuffer());
    }

    @Test
    public void testCreate1() {
        PktHeader header = PktHeader.create(null, null);
        PktHeaderTest.checkHeaderValues(header, PktHeader.getLatestVersion(), 0, 0, 0, false, false, (short)255, (short)0, 0, 0, (short)0, false, false, null, null, null);
        int len = header.getSerializedLength();
        Assert.assertEquals((long)len, (long)34L);
        len = header.getSerializedLength();
        Assert.assertEquals((long)len, (long)34L);
        header = PktHeader.create(null, null);
        if (header.getBuffer() == null) {
            PktHeaderTest.testFailure((String)"Header buffer is null immediately after create");
        }
    }

    @Test
    public void testCreate2() {
        PktHeader header = PktFactory.getInstance().createPacket(2001).getHeader();
        PktHeaderTest.checkHeaderValues(header, PktHeader.getLatestVersion(), 0, 0, 0, false, false, (short)255, (short)0, 2001, 0, (short)0, false, false, null, null, null);
        int len = header.getSerializedLength();
        Assert.assertEquals((long)len, (long)34L);
        len = header.getSerializedLength();
        Assert.assertEquals((long)len, (long)34L);
        header = PktFactory.getInstance().createPacket(2001).getHeader();
        Assert.assertNotNull((Object)((Object)header.getBuffer()));
    }

    @Test
    public void testHeaderElementsSet1() throws Exception {
        this.testHeaderElementsSet(PktHeader.create(null, null), PktHeader.getLatestVersion(), 0);
    }

    @Test
    public void testHeaderElementsSet2() throws Exception {
        this.testHeaderElementsSet(PktFactory.getInstance().createPacket(2001).getHeader(), PktHeader.getLatestVersion(), 2001);
    }

    @Test
    public void testSerializationPolicyValidSet1() throws Exception {
        this.testSerializationPolicyValidSet(PktHeader.create(null, null));
    }

    @Test
    public void testSerializationPolicyValidSet2() {
        this.testSerializationPolicyValidSet(PktFactory.getInstance().createPacket(2001).getHeader());
    }

    @Test
    public void testSerializationPolicyInvalidSet1() {
        this.testSerializationPolicyInvalidSet(PktHeader.create(null, null));
    }

    @Test
    public void testSerializationPolicyInvalidSet2() {
        this.testSerializationPolicyInvalidSet(PktFactory.getInstance().createPacket(2001).getHeader());
    }

    @Test
    public void testDeserializationPolicyValidSet1() {
        this.testDeserializationPolicyValidSet(PktHeader.create(null, null));
    }

    @Test
    public void testDeserializationPolicyValidSet2() {
        this.testDeserializationPolicyValidSet(PktFactory.getInstance().createPacket(2001).getHeader());
    }

    @Test
    public void testDeserializationPolicyInvalidSet1() {
        this.testDeserializationPolicyInvalidSet(PktHeader.create(null, null));
    }

    @Test
    public void testDeserializationPolicyInvalidSet2() {
        this.testDeserializationPolicyInvalidSet(PktFactory.getInstance().createPacket(2001).getHeader());
    }

    @Test
    public void testCopySerializationWithEnoughSpace1() {
        this.testCopySerializationWithEnoughSpace(PktHeader.create(null, null), 0, PktHeader.getLatestVersion(), 0);
    }

    @Test
    public void testCopySerializationWithEnoughSpace2() {
        this.testCopySerializationWithEnoughSpace(PktHeader.create(null, null), 1, PktHeader.getLatestVersion(), 0);
    }

    @Test
    public void testCopySerializationWithEnoughSpace3() {
        this.testCopySerializationWithEnoughSpace(PktHeader.create(null, null), 2, PktHeader.getLatestVersion(), 0);
    }

    @Test
    public void testCopySerializationWithEnoughSpace4() {
        this.testCopySerializationWithEnoughSpace(PktFactory.getInstance().createPacket(2001).getHeader(), 0, PktHeader.getLatestVersion(), 2001);
    }

    @Test
    public void testCopySerializationWithEnoughSpace5() {
        this.testCopySerializationWithEnoughSpace(PktFactory.getInstance().createPacket(2001).getHeader(), 1, PktHeader.getLatestVersion(), 2001);
    }

    @Test
    public void testCopySerializationWithEnoughSpace6() {
        this.testCopySerializationWithEnoughSpace(PktFactory.getInstance().createPacket(2001).getHeader(), 2, PktHeader.getLatestVersion(), 2001);
    }

    @Test
    public void testCopySerializationWithEnoughSpace7() {
        this.testCopySerializationWithEnoughSpace(PktFactory.getInstance().createPacket(2002).getHeader(), 0, PktHeader.getLatestVersion(), 2002);
    }

    @Test
    public void testCopySerializationWithEnoughSpace8() {
        this.testCopySerializationWithEnoughSpace(PktFactory.getInstance().createPacket(2002).getHeader(), 1, PktHeader.getLatestVersion(), 2002);
    }

    @Test
    public void testCopySerializationWithEnoughSpace9() {
        this.testCopySerializationWithEnoughSpace(PktFactory.getInstance().createPacket(2002).getHeader(), 2, PktHeader.getLatestVersion(), 2002);
    }

    @Test
    public void testCopySerializationWithEnoughSpace10() {
        this.testCopySerializationWithEnoughSpace(PktFactory.getInstance().createPacket(2003).getHeader(), 0, PktHeader.getLatestVersion(), 2003);
    }

    @Test
    public void testCopySerializationWithEnoughSpace11() {
        this.testCopySerializationWithEnoughSpace(PktFactory.getInstance().createPacket(2003).getHeader(), 1, PktHeader.getLatestVersion(), 2003);
    }

    @Test
    public void testCopySerializationWithEnoughSpace12() {
        PktPacket packet = PktFactory.getInstance().createPacket(2003);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithEnoughSpace(header, 2, PktHeader.getLatestVersion(), 2003);
    }

    @Test
    public void testCopySerializationWithEnoughSpace13() {
        PktPacket packet = PktFactory.getInstance().createPacket(2004);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithEnoughSpace(header, 1, PktHeader.getLatestVersion(), 2004);
    }

    @Test
    public void testCopySerializationWithEnoughSpace14() {
        PktPacket packet = PktFactory.getInstance().createPacket(2004);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithEnoughSpace(header, 2, PktHeader.getLatestVersion(), 2004);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace1() {
        PktHeader header = PktHeader.create(null, null);
        this.testCopySerializationWithoutEnoughSpace(header, 0, PktHeader.getLatestVersion(), 0);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace2() {
        PktHeader header = PktHeader.create(null, null);
        this.testCopySerializationWithoutEnoughSpace(header, 1, PktHeader.getLatestVersion(), 0);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace3() {
        PktHeader header = PktHeader.create(null, null);
        this.testCopySerializationWithoutEnoughSpace(header, 2, PktHeader.getLatestVersion(), 0);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace4() {
        PktPacket packet = PktFactory.getInstance().createPacket(2001);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 0, PktHeader.getLatestVersion(), 2001);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace5() {
        PktPacket packet = PktFactory.getInstance().createPacket(2001);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 1, PktHeader.getLatestVersion(), 2001);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace6() {
        PktPacket packet = PktFactory.getInstance().createPacket(2001);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 2, PktHeader.getLatestVersion(), 2001);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace7() {
        PktPacket packet = PktFactory.getInstance().createPacket(2002);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 0, PktHeader.getLatestVersion(), 2002);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace8() {
        PktPacket packet = PktFactory.getInstance().createPacket(2002);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 1, PktHeader.getLatestVersion(), 2002);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace9() {
        PktPacket packet = PktFactory.getInstance().createPacket(2002);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 2, PktHeader.getLatestVersion(), 2002);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace10() {
        PktPacket packet = PktFactory.getInstance().createPacket(2003);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 0, PktHeader.getLatestVersion(), 2003);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace11() {
        PktPacket packet = PktFactory.getInstance().createPacket(2003);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 1, PktHeader.getLatestVersion(), 2003);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace12() {
        PktPacket packet = PktFactory.getInstance().createPacket(2003);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 2, PktHeader.getLatestVersion(), 2003);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace13() {
        PktPacket packet = PktFactory.getInstance().createPacket(2004);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 1, PktHeader.getLatestVersion(), 2004);
    }

    @Test
    public void testCopySerializationWithoutEnoughSpace14() {
        PktPacket packet = PktFactory.getInstance().createPacket(2004);
        PktHeader header = packet.getHeader();
        this.testCopySerializationWithoutEnoughSpace(header, 2, PktHeader.getLatestVersion(), 2004);
    }

    @Ignore
    @Test
    public void testAttachSerialization1() {
        PktHeader header = PktHeader.create(null, null);
        this.testAttachSerialization(header, 3, PktHeader.getLatestVersion(), 0);
    }

    @Ignore
    @Test
    public void testAttachSerialization2() {
        PktPacket packet = PktFactory.getInstance().createPacket(2001);
        PktHeader header = packet.getHeader();
        this.testAttachSerialization(header, 3, PktHeader.getLatestVersion(), 2001);
    }

    @Ignore
    @Test
    public void testAttachSerialization3() {
        PktPacket packet = PktFactory.getInstance().createPacket(2002);
        PktHeader header = packet.getHeader();
        this.testAttachSerialization(header, 3, PktHeader.getLatestVersion(), 2002);
    }

    @Ignore
    @Test
    public void testAttachSerialization4() {
        PktPacket packet = PktFactory.getInstance().createPacket(2003);
        PktHeader header = packet.getHeader();
        this.testAttachSerialization(header, 3, PktHeader.getLatestVersion(), 2003);
    }

    @Ignore
    @Test
    public void testAttachSerialization5() {
        PktPacket packet = PktFactory.getInstance().createPacket(2004);
        PktHeader header = packet.getHeader();
        this.testAttachSerialization(header, 0, PktHeader.getLatestVersion(), 2004);
    }

    @Ignore
    @Test
    public void testAttachSerialization6() {
        PktPacket packet = PktFactory.getInstance().createPacket(2004);
        PktHeader header = packet.getHeader();
        this.testAttachSerialization(header, 3, PktHeader.getLatestVersion(), 2004);
    }

    @Test
    public void testPreDeserializationZeroLenBuffer() {
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(ByteBuffer.allocate(0));
        if (PktHeader.preDeserialize(context)) {
            PktHeaderTest.testFailure((String)"Predeserialise of a zero len buffer returne true!");
        }
        Assert.assertTrue((String)("Invalid numBytes in context [exp=(>0) actual=" + context.getNumBytes() + "] from predeserialise of a zero len buffer"), (context.getNumBytes() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPreDeserializationInvalidMagic() throws Exception {
        PktHeader header = PktHeader.create(null, null);
        this.testPreDeserializationInvalidMagic(header);
    }

    @Test
    public void testPreDeserializationInvalidVersion() throws Exception {
        PktHeader header = PktHeader.create(null, null);
        this.testPreDeserializationInvalidVersion(header);
    }

    @Test
    public void testPreDeserializationLessMinLenBuffer() throws Exception {
        PktHeader header = PktHeader.create(null, null);
        this.testPreDeserializationLessMinLenBuffer(header);
    }

    @Test
    public void testPreDeserializationLessOrEqualLenBuffer() throws Exception {
        PktPacket packet = PktFactory.getInstance().createPacket(3005);
        this.testPreDeserializationLessOrEqualLenBuffer(packet.getHeader(), packet.getBody());
    }

    @Test
    public void testDeserialization1() throws Exception {
        PktHeader header = PktFactory.getInstance().createPacket(2005).getHeader();
        this.testDeserialization(header, 1, 0, true, true, header.getLatestVersion(), 2005, header.getSerializedLength());
    }

    @Test
    public void testDeserialization2() throws Exception {
        PktHeader header = PktFactory.getInstance().createPacket(2005).getHeader();
        this.testDeserialization(header, 1, 1, true, true, header.getLatestVersion(), 2005, header.getSerializedLength());
    }

    @Ignore
    @Test
    public void testDeserialization3() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2005).getHeader();
            this.testDeserialization(header, 1, 2, true, true, header.getLatestVersion(), 2005, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB5, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization4() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2005).getHeader();
            this.testDeserialization(header, 1, 3, true, false, header.getLatestVersion(), 2005, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB5, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization5() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2005).getHeader();
            this.testDeserialization(header, 3, 0, false, true, header.getLatestVersion(), 2005, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, copy deserialize, body=VPTNB5, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization6() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2005).getHeader();
            this.testDeserialization(header, 3, 1, false, true, header.getLatestVersion(), 2005, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, copy deserialize, body=VPTNB5, 'hdrbodycopy' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization7() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2005).getHeader();
            this.testDeserialization(header, 3, 2, false, true, header.getLatestVersion(), 2005, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB5, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization8() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2005).getHeader();
            this.testDeserialization(header, 3, 3, false, false, header.getLatestVersion(), 2005, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB5, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testDeserialization9() throws Exception {
        PktHeader header = PktFactory.getInstance().createPacket(2006).getHeader();
        this.testDeserialization(header, 1, 0, true, true, header.getLatestVersion(), 2006, header.getSerializedLength());
    }

    @Test
    public void testDeserialization10() throws Exception {
        PktHeader header = PktFactory.getInstance().createPacket(2006).getHeader();
        this.testDeserialization(header, 1, 1, true, true, header.getLatestVersion(), 2006, header.getSerializedLength());
    }

    @Ignore
    @Test
    public void testDeserialization11() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2006).getHeader();
            this.testDeserialization(header, 1, 2, true, true, header.getLatestVersion(), 2006, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB6, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization12() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2006).getHeader();
            this.testDeserialization(header, 1, 3, true, false, header.getLatestVersion(), 2006, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB6, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization13() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2006).getHeader();
            this.testDeserialization(header, 3, 0, false, true, header.getLatestVersion(), 2006, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, copy deserialize, body=VPTNB6, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization14() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2006).getHeader();
            this.testDeserialization(header, 3, 1, false, true, header.getLatestVersion(), 2006, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, copy deserialize, body=VPTNB6, 'hdrbodycopy' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization15() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2006).getHeader();
            this.testDeserialization(header, 3, 2, false, true, header.getLatestVersion(), 2006, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB6, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization16() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2006).getHeader();
            this.testDeserialization(header, 3, 3, false, false, header.getLatestVersion(), 2006, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB6, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization17() throws Exception {
        PktHeader header = PktFactory.getInstance().createPacket(2007).getHeader();
        this.testDeserialization(header, 1, 0, true, true, header.getLatestVersion(), 2007, header.getSerializedLength());
    }

    @Test
    public void testDeserialization18() throws Exception {
        PktHeader header = PktFactory.getInstance().createPacket(2007).getHeader();
        this.testDeserialization(header, 1, 1, true, true, header.getLatestVersion(), 2007, header.getSerializedLength());
    }

    @Ignore
    @Test
    public void testDeserialization19() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2007).getHeader();
            this.testDeserialization(header, 1, 2, true, true, header.getLatestVersion(), 2007, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB7, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization20() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2007).getHeader();
            this.testDeserialization(header, 1, 3, true, false, header.getLatestVersion(), 2007, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB7, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization21() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2007).getHeader();
            this.testDeserialization(header, 3, 0, false, true, header.getLatestVersion(), 2007, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB7, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization22() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2007).getHeader();
            this.testDeserialization(header, 3, 1, false, true, header.getLatestVersion(), 2007, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, copy deserialize, body=VPTNB7, 'hdrbodycopy' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization23() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2007).getHeader();
            this.testDeserialization(header, 3, 2, false, true, header.getLatestVersion(), 2007, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB7, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization24() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2007).getHeader();
            this.testDeserialization(header, 3, 3, false, false, header.getLatestVersion(), 2007, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB7, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization25() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2008).getHeader();
            this.testDeserialization(header, 1, 0, true, false, header.getLatestVersion(), 2008, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB8, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testDeserialization26() throws Exception {
        PktHeader header = PktFactory.getInstance().createPacket(2008).getHeader();
        this.testDeserialization(header, 1, 1, true, true, header.getLatestVersion(), 2008, header.getSerializedLength());
    }

    @Ignore
    @Test
    public void testDeserialization27() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2008).getHeader();
            this.testDeserialization(header, 1, 2, true, true, header.getLatestVersion(), 2008, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB8, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization28() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2008).getHeader();
            this.testDeserialization(header, 1, 3, true, false, header.getLatestVersion(), 2008, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, copy serialize, slice deserialize, body=VPTNB8, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization29() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2008).getHeader();
            this.testDeserialization(header, 3, 0, false, false, header.getLatestVersion(), 2008, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB8, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization30() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2008).getHeader();
            this.testDeserialization(header, 3, 1, false, true, header.getLatestVersion(), 2008, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, copy deserialize, body=VPTNB8, 'hdrbodycopy' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization31() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2008).getHeader();
            this.testDeserialization(header, 3, 2, false, true, header.getLatestVersion(), 2008, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB8, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testDeserialization32() {
        try {
            PktHeader header = PktFactory.getInstance().createPacket(2008).getHeader();
            this.testDeserialization(header, 3, 3, false, false, header.getLatestVersion(), 2008, header.getSerializedLength());
            PktHeaderTest.testSuccess((String)"Packet header deserialization, attach serialize, slice deserialize, body=VPTNB8, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktHeaderTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }
}

