/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.eaio.uuid.UUID;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderVariable;
import com.neeve.quark.QuarkBuffer;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class PktSubheaderODS
extends PktSubheaderVariable {
    public static final byte V1 = 1;
    public static final byte V2 = 2;
    public static final byte VERSION = 2;
    private static int VERSION_POS = 1;
    private int OBJID_HI_POS;
    private int OBJID_LO_POS;
    private int OFID_POS;
    private int OTYPE_POS;
    private int CONTENT_ENC_POS;
    private int ENTTYPE_POS;
    private int TIMESTAMP_POS;
    private int FLAGS_POS;
    private int TXN_ID_POS;
    private int STABLE_TXN_ID_POS;
    private int CHECKPOINT_VERSION_POS;
    private int OBJMETADATALEN_POS;
    private int OBJMETADATA_POS;
    private int PERMETADATALEN_POS;
    private int PERMETADATA_POS;
    private final UUID objectId = new UUID(0L, 0L);
    private boolean objectIdInitialized = false;
    private final PktBuffer objectMetadata = PktBuffer.create(null, 1, true);
    private short objectMetadataLen = 0;
    private boolean objectMetadataInitialized = false;
    private final PktBuffer persisterMetadata = PktBuffer.create(null, 1, true);
    private short persisterMetadataLen = 0;
    private boolean persisterMetadataInitialized = false;
    private boolean inGetSubheaderVersion;
    public static final int FLAG_COMMIT_START = 2;
    public static final int FLAG_COMMIT_END = 1;
    public static final int FLAG_COMMIT_ACK_REQUIRED = 4;
    public static final int FLAG_COMMIT_ENTRY_IS_PUT = 8;
    public static final int FLAG_COMMIT_ENTRY_IS_UPDATE = 16;
    public static final int FLAG_COMMIT_ENTRY_IS_REMOVE = 32;
    public static final int FLAG_COMMIT_ENTRY_IS_SEND = 64;
    public static final int FLAG_COMMIT_ENTRY_IN_INIT = 128;
    public static final short ENTRY_TYPE_PUT = 1;
    public static final short ENTRY_TYPE_UPDATE = 2;
    public static final short ENTRY_TYPE_REMOVE = 3;
    public static final short ENTRY_TYPE_SEND = 4;
    public static final short ENTRY_TYPE_MESSAGE = 5;

    private PktSubheaderODS(Properties props) {
        super(7, true);
    }

    public static PktBody create(Properties props) {
        return new PktSubheaderODS(props);
    }

    public static PktBody create() {
        return PktSubheaderODS.create(null);
    }

    public static PktBody create(short version) {
        PktSubheaderODS subheader = (PktSubheaderODS)PktSubheaderODS.create();
        subheader.setSubheaderVersion(version);
        subheader.setFieldOffsets(version, false);
        return subheader;
    }

    private static final int getSerializedLength(short version, short objectMetadataLen, short persisterMetadataLen) {
        switch (version) {
            case 1: {
                return 57 + (2 + objectMetadataLen);
            }
            case 2: {
                return 57 + (2 + objectMetadataLen) + (2 + persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + version + " subheader is not supported");
    }

    private final short setFieldOffsets(short version, boolean onDeserialize) {
        switch (version) {
            case 1: {
                this.OBJID_HI_POS = VERSION_POS + 1;
                this.OBJID_LO_POS = this.OBJID_HI_POS + 8;
                this.OFID_POS = this.OBJID_LO_POS + 8;
                this.OTYPE_POS = this.OFID_POS + 2;
                this.CONTENT_ENC_POS = this.OTYPE_POS + 2;
                this.ENTTYPE_POS = this.CONTENT_ENC_POS + 1;
                this.TIMESTAMP_POS = this.ENTTYPE_POS + 1;
                this.FLAGS_POS = this.TIMESTAMP_POS + 8;
                this.TXN_ID_POS = this.FLAGS_POS + 1;
                this.STABLE_TXN_ID_POS = this.TXN_ID_POS + 8;
                this.CHECKPOINT_VERSION_POS = this.STABLE_TXN_ID_POS + 8;
                this.OBJMETADATALEN_POS = this.CHECKPOINT_VERSION_POS + 8;
                this.OBJMETADATA_POS = this.OBJMETADATALEN_POS + 2;
                break;
            }
            case 2: {
                this.OBJID_HI_POS = VERSION_POS + 1;
                this.OBJID_LO_POS = this.OBJID_HI_POS + 8;
                this.OFID_POS = this.OBJID_LO_POS + 8;
                this.OTYPE_POS = this.OFID_POS + 2;
                this.CONTENT_ENC_POS = this.OTYPE_POS + 2;
                this.TIMESTAMP_POS = this.CONTENT_ENC_POS + 1 + 1;
                this.FLAGS_POS = this.TIMESTAMP_POS + 8;
                this.TXN_ID_POS = this.FLAGS_POS + 1;
                this.STABLE_TXN_ID_POS = this.TXN_ID_POS + 8;
                this.CHECKPOINT_VERSION_POS = this.STABLE_TXN_ID_POS + 8;
                this.OBJMETADATALEN_POS = this.CHECKPOINT_VERSION_POS + 8;
                this.OBJMETADATA_POS = this.OBJMETADATALEN_POS + 2;
                this.PERMETADATALEN_POS = this.OBJMETADATA_POS + (onDeserialize ? (int)this.buffer.getShort(this.OBJMETADATALEN_POS) : 0);
                this.PERMETADATA_POS = this.PERMETADATALEN_POS + 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("V" + version + " subheader is not supported");
            }
        }
        return version;
    }

    private final void updateFieldOffsetsOnObjectMetadataSet() {
        this.PERMETADATALEN_POS = this.OBJMETADATA_POS + this.objectMetadataLen;
        this.PERMETADATA_POS = this.PERMETADATALEN_POS + 2;
    }

    private final void initObjectMetadataFromBuffer() {
        this.objectMetadataLen = this.buffer.getShort(this.OBJMETADATALEN_POS);
        this.objectMetadata.wrapIOBuffer(this.buffer.getIOBuffer(), this.buffer.getOffset() + this.OBJMETADATA_POS, this.objectMetadataLen);
        this.objectMetadataInitialized = true;
    }

    private final void initPersisterMetadataFromBuffer() {
        this.persisterMetadataLen = this.buffer.getShort(this.PERMETADATALEN_POS);
        this.persisterMetadata.wrapIOBuffer(this.buffer.getIOBuffer(), this.buffer.getOffset() + this.PERMETADATA_POS, this.persisterMetadataLen);
        this.persisterMetadataInitialized = true;
    }

    private final void setSubheaderVersion(PktBuffer buffer, short version) {
        buffer.put(VERSION_POS, (byte)version);
    }

    private final short getSubheaderVersion(PktBuffer buffer) {
        if (this.inGetSubheaderVersion) {
            return 2;
        }
        this.inGetSubheaderVersion = true;
        try {
            short s = (short)(0xFF & buffer.get(VERSION_POS));
            return s;
        }
        finally {
            this.inGetSubheaderVersion = false;
        }
    }

    private final short getSubheaderVersion(ByteBuffer buffer, int offset) {
        return (short)(0xFF & buffer.get(offset + VERSION_POS));
    }

    private static final short getSubheaderVersion(long addr, int offset) {
        return (short)(0xFF & QuarkBuffer.getByte((long)addr, (int)(offset + VERSION_POS)));
    }

    private final void setObjectId(PktBuffer buffer, UUID id) {
        if (id != null) {
            this.objectId.time = id.time;
            this.objectId.clockSeqAndNode = id.clockSeqAndNode;
            buffer.putLong(this.OBJID_HI_POS, id.getTime());
            buffer.putLong(this.OBJID_LO_POS, id.getClockSeqAndNode());
            this.objectIdInitialized = true;
        } else {
            this.objectId.time = 0L;
            this.objectId.clockSeqAndNode = 0L;
            buffer.putLong(this.OBJID_HI_POS, 0L);
            buffer.putLong(this.OBJID_LO_POS, 0L);
            this.objectIdInitialized = false;
        }
    }

    private final void setObjectFactoryId(PktBuffer buffer, short ofid) {
        buffer.putShort(this.OFID_POS, ofid);
    }

    private final void setObjectType(PktBuffer buffer, short otype) {
        buffer.putShort(this.OTYPE_POS, otype);
    }

    private final void setContentEncodingType(PktBuffer buffer, short contentEncodingType) {
        buffer.put(this.CONTENT_ENC_POS, (byte)contentEncodingType);
    }

    private final void setTimestamp(PktBuffer buffer, long timestamp) {
        buffer.putLong(this.TIMESTAMP_POS, timestamp);
    }

    private final void setCommitEntryType(PktBuffer buffer, short entryType) {
        block0 : switch (this.getSubheaderVersion()) {
            case 1: {
                buffer.put(this.ENTTYPE_POS, (byte)entryType);
                break;
            }
            default: {
                switch (entryType) {
                    case 1: {
                        this.setFlagCommitEntryIsPut(true);
                        break block0;
                    }
                    case 2: {
                        this.setFlagCommitEntryIsUpdate(true);
                        break block0;
                    }
                    case 3: {
                        this.setFlagCommitEntryIsRemove(true);
                        break block0;
                    }
                    case 4: {
                        this.setFlagCommitEntryIsSend(true);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("unknown commit entry type '" + entryType + "'");
            }
        }
    }

    private final void setFlags(PktBuffer buffer, byte flags) {
        buffer.put(this.FLAGS_POS, flags);
    }

    public static void prepare(PktPacket packet, UUID objectId, short ofid, short otype, short contentEncodingType, long transactionId, long stableTransactionId, long checkpointVersion, long timestamp, byte flags) {
        PktSubheaderODS subheaderODS = packet.getHeader().activateODSSubheader(false);
        PktBuffer buffer = subheaderODS.getBuffer();
        subheaderODS.setObjectId(buffer, objectId);
        subheaderODS.setObjectFactoryId(buffer, ofid);
        subheaderODS.setObjectType(buffer, otype);
        subheaderODS.setContentEncodingType(buffer, contentEncodingType);
        subheaderODS.setTransactionId(transactionId);
        subheaderODS.setStableTransactionId(stableTransactionId);
        subheaderODS.setCheckpointVersion(checkpointVersion);
        subheaderODS.setTimestamp(timestamp);
        subheaderODS.setFlags(buffer, flags);
    }

    public static final short getLatestSubheaderVersion() {
        return 2;
    }

    @Override
    protected final void initialize() {
        this.setFieldOffsets((short)2, false);
    }

    public static final int getSerializedLength(long addr, int offset) {
        int objmetadatalen_pos;
        short version = PktSubheaderODS.getSubheaderVersion(addr, offset);
        switch (version) {
            case 1: 
            case 2: {
                objmetadatalen_pos = 57;
                break;
            }
            default: {
                throw new UnsupportedOperationException("V" + version + " subheader is not supported");
            }
        }
        short objectMetadataLen = QuarkBuffer.getShort((long)addr, (int)(offset + objmetadatalen_pos));
        switch (version) {
            case 1: {
                return PktSubheaderODS.getSerializedLength((short)1, objectMetadataLen, (short)0);
            }
            case 2: {
                short persisterMetadataLen = QuarkBuffer.getShort((long)addr, (int)(offset + objmetadatalen_pos + 2 + objectMetadataLen));
                return PktSubheaderODS.getSerializedLength((short)2, objectMetadataLen, persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + version + " subheader is not supported");
    }

    @Override
    public final int doGetSerializedLength() {
        return PktSubheaderODS.getSerializedLength(this.getSubheaderVersion(), this.objectMetadataLen, this.persisterMetadataLen);
    }

    @Override
    public final int getSerializedLength(ByteBuffer buffer, int offset) {
        short objectMetadataLen = buffer.getShort(offset + this.OBJMETADATALEN_POS);
        switch (this.getSubheaderVersion(buffer, offset)) {
            case 1: {
                return PktSubheaderODS.getSerializedLength((short)1, objectMetadataLen, (short)0);
            }
            case 2: {
                short persisterMetadataLen = buffer.getShort(offset + this.OBJMETADATALEN_POS + 2 + objectMetadataLen);
                return PktSubheaderODS.getSerializedLength((short)2, objectMetadataLen, persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + this.getSubheaderVersion(buffer, offset) + " subheader is not supported");
    }

    @Override
    protected final void postDeserialize(int len) {
        VERSION_POS = 1;
        short version = this.getSubheaderVersion();
        this.setFieldOffsets(version, true);
        this.initObjectMetadataFromBuffer();
        if (version > 1) {
            this.initPersisterMetadataFromBuffer();
        }
    }

    @Override
    protected final boolean isResettable() {
        return true;
    }

    @Override
    protected final void doReset() {
        this.objectId.clockSeqAndNode = 0L;
        this.objectId.time = 0L;
        this.objectIdInitialized = false;
        this.objectMetadataLen = 0;
        this.objectMetadataInitialized = false;
        this.persisterMetadataLen = 0;
        this.persisterMetadataInitialized = false;
        super.doReset();
    }

    @Override
    public final int doGetInitialBufferLength() {
        return PktSubheaderODS.getSerializedLength((short)2, (short)0, (short)0);
    }

    private final void setSubheaderVersion(short version) {
        this.setSubheaderVersion(this.buffer, version);
    }

    public final short getSubheaderVersion() {
        return this.getSubheaderVersion(this.buffer);
    }

    public final void setObjectId(UUID objectId) {
        this.setObjectId(this.buffer, objectId);
    }

    public final UUID getObjectId() {
        if (!this.objectIdInitialized) {
            long objectIdLo = this.buffer.getLong(this.OBJID_LO_POS);
            if (objectIdLo != 0L) {
                this.objectId.time = this.buffer.getLong(this.OBJID_HI_POS);
                this.objectId.clockSeqAndNode = objectIdLo;
                this.objectIdInitialized = true;
                return this.objectId;
            }
            return null;
        }
        return this.objectId;
    }

    public final void setObjectFactoryId(short ofid) {
        this.buffer.putShort(this.OFID_POS, ofid);
    }

    public final short getObjectFactoryId() {
        return this.buffer.getShort(this.OFID_POS);
    }

    public final void setObjectType(short otype) {
        this.buffer.putShort(this.OTYPE_POS, otype);
    }

    public final short getObjectType() {
        return this.buffer.getShort(this.OTYPE_POS);
    }

    public final void setContentEncodingType(short contentEncodingType) {
        this.setContentEncodingType(this.buffer, contentEncodingType);
    }

    public final short getContentEncodingType() {
        return (short)(0xFF & this.buffer.get(this.CONTENT_ENC_POS));
    }

    public final void setTimestamp(long timestamp) {
        this.setTimestamp(this.buffer, timestamp);
    }

    public final long getTimestamp() {
        return this.buffer.getLong(this.TIMESTAMP_POS);
    }

    public final void setCommitEntryType(short entryType) {
        this.setCommitEntryType(this.buffer, entryType);
    }

    public final short getCommitEntryType() {
        switch (this.getSubheaderVersion()) {
            case 1: {
                return (short)(0xFF & this.buffer.get(this.ENTTYPE_POS));
            }
        }
        this.getFlags();
        if (this.getFlagCommitEntryIsPut()) {
            return 1;
        }
        if (this.getFlagCommitEntryIsUpdate()) {
            return 2;
        }
        if (this.getFlagCommitEntryIsRemove()) {
            return 3;
        }
        if (this.getFlagCommitEntryIsSend()) {
            return 4;
        }
        return 0;
    }

    public final void setTransactionId(long transactionId) {
        this.buffer.putLong(this.TXN_ID_POS, transactionId);
    }

    public final long getTransactionId() {
        return this.buffer.getLong(this.TXN_ID_POS);
    }

    public final void setStableTransactionId(long stableTransactionId) {
        this.buffer.putLong(this.STABLE_TXN_ID_POS, stableTransactionId);
    }

    public final long getStableTransactionId() {
        return this.buffer.getLong(this.STABLE_TXN_ID_POS);
    }

    public final void setCheckpointVersion(long checkpointVersion) {
        this.buffer.putLong(this.CHECKPOINT_VERSION_POS, checkpointVersion);
    }

    public final long getCheckpointVersion() {
        if (this.getSubheaderVersion() == 0) {
            return 0L;
        }
        return this.buffer.getLong(this.CHECKPOINT_VERSION_POS);
    }

    public static final int getFlags(long addr, int offset) {
        int flags_pos;
        short version = PktSubheaderODS.getSubheaderVersion(addr, offset);
        switch (version) {
            case 1: 
            case 2: {
                flags_pos = 32;
                break;
            }
            default: {
                throw new UnsupportedOperationException("V" + version + " subheader is not supported");
            }
        }
        return QuarkBuffer.getByte((long)addr, (int)(offset + flags_pos));
    }

    public final void setFlags(byte flags) {
        this.setFlags(this.buffer, flags);
    }

    public final int getFlags() {
        return this.buffer.get(this.FLAGS_POS);
    }

    public final void setFlagCommitStart(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        flags = val ? (byte)(flags | 2) : (byte)(flags & 0xFFFFFFFD);
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitStart() {
        return (this.buffer.get(this.FLAGS_POS) & 2) == 2;
    }

    public final void setFlagCommitEnd(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        flags = val ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEnd() {
        return (this.buffer.get(this.FLAGS_POS) & 1) == 1;
    }

    public final void setFlagCommitAckRequired(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        flags = val ? (byte)(flags | 4) : (byte)(flags & 0xFFFFFFFB);
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitAckRequired() {
        return (this.buffer.get(this.FLAGS_POS) & 4) == 4;
    }

    public final void setFlagCommitEntryIsPut(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        if (val) {
            flags = (byte)(flags | 8);
            flags = (byte)(flags & 0xFFFFFFEF);
            flags = (byte)(flags & 0xFFFFFFDF);
            flags = (byte)(flags & 0xFFFFFFBF);
        } else {
            flags = (byte)(flags & 0xFFFFFFF7);
        }
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryIsPut() {
        return (this.buffer.get(this.FLAGS_POS) & 8) == 8;
    }

    public final void setFlagCommitEntryIsUpdate(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        if (val) {
            flags = (byte)(flags & 0xFFFFFFF7);
            flags = (byte)(flags | 0x10);
            flags = (byte)(flags & 0xFFFFFFDF);
            flags = (byte)(flags & 0xFFFFFFBF);
        } else {
            flags = (byte)(flags & 0xFFFFFFEF);
        }
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryIsUpdate() {
        return (this.buffer.get(this.FLAGS_POS) & 0x10) == 16;
    }

    public final void setFlagCommitEntryIsRemove(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        if (val) {
            flags = (byte)(flags & 0xFFFFFFF7);
            flags = (byte)(flags & 0xFFFFFFEF);
            flags = (byte)(flags | 0x20);
            flags = (byte)(flags & 0xFFFFFFBF);
        } else {
            flags = (byte)(flags & 0xFFFFFFDF);
        }
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryIsRemove() {
        return (this.buffer.get(this.FLAGS_POS) & 0x20) == 32;
    }

    public final void setFlagCommitEntryIsSend(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        if (val) {
            flags = (byte)(flags & 0xFFFFFFF7);
            flags = (byte)(flags & 0xFFFFFFEF);
            flags = (byte)(flags & 0xFFFFFFDF);
            flags = (byte)(flags | 0x40);
        } else {
            flags = (byte)(flags & 0xFFFFFFBF);
        }
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryIsSend() {
        return (this.buffer.get(this.FLAGS_POS) & 0x40) == 64;
    }

    public final void setFlagCommitEntryInInit(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        flags = val ? (byte)(flags | 0x80) : (byte)(flags & 0xFFFFFF7F);
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryInInit() {
        return (this.buffer.get(this.FLAGS_POS) & 0x80) == 128;
    }

    public final void copyObjectMetadataFrom(IOElasticBuffer metadata) {
        if (metadata != null && metadata.getLength() == 0) {
            throw new IllegalArgumentException("serialized metadata cannot be empty");
        }
        this.objectMetadataLen = (short)(metadata == null ? 0 : metadata.getLength());
        this.buffer.putShort(this.OBJMETADATALEN_POS, this.objectMetadataLen);
        if (this.objectMetadataLen > 0) {
            this.buffer.putFrom(this.OBJMETADATA_POS, metadata, 0, this.objectMetadataLen);
        }
        this.updateFieldOffsetsOnObjectMetadataSet();
        this.initObjectMetadataFromBuffer();
        if (this.persisterMetadata != null) {
            this.persisterMetadata.reset();
        }
        this.persisterMetadataLen = 0;
        this.buffer.putShort(this.PERMETADATALEN_POS, this.persisterMetadataLen);
    }

    public final int prepareForObjectMetadataCopy(int length) {
        if (length == 0) {
            throw new IllegalArgumentException("serialized metadata cannot be empty");
        }
        this.objectMetadataLen = (short)length;
        this.buffer.putShort(this.OBJMETADATALEN_POS, this.objectMetadataLen);
        this.buffer.setLength(PktSubheaderODS.getSerializedLength(this.getSubheaderVersion(), this.objectMetadataLen, (short)0));
        this.updateFieldOffsetsOnObjectMetadataSet();
        this.initObjectMetadataFromBuffer();
        if (this.persisterMetadata != null) {
            this.persisterMetadata.reset();
        }
        this.persisterMetadataLen = 0;
        this.buffer.putShort(this.PERMETADATALEN_POS, this.persisterMetadataLen);
        return 0;
    }

    public final PktBuffer getObjectMetadata() {
        if (!this.objectMetadataInitialized) {
            this.initObjectMetadataFromBuffer();
        }
        if (this.objectMetadataLen == 0) {
            return null;
        }
        return this.objectMetadata;
    }

    public final void copyObjectMetadataTo(PktBuffer buffer, int offset) {
        if (this.objectMetadata != null) {
            buffer.putFrom(offset, this.objectMetadata, 0, this.objectMetadataLen);
        } else {
            buffer.putFrom(offset, buffer, this.OBJMETADATA_POS, this.objectMetadataLen);
        }
    }

    public final void copyPersisterMetadataFrom(IOElasticBuffer metadata) {
        if (metadata != null && metadata.getLength() == 0) {
            throw new IllegalArgumentException("serialized metadata cannot be empty");
        }
        if (this.getSubheaderVersion() == 1) {
            throw new IllegalStateException("persister metadata is not supported in a V1 subheader");
        }
        this.persisterMetadataLen = (short)(metadata == null ? 0 : metadata.getLength());
        this.buffer.putShort(this.PERMETADATALEN_POS, this.persisterMetadataLen);
        if (this.persisterMetadataLen > 0) {
            this.buffer.putFrom(this.PERMETADATA_POS, metadata, 0, this.persisterMetadataLen);
        }
        this.initPersisterMetadataFromBuffer();
    }

    public final PktBuffer getPersisterMetadata() {
        if (this.getSubheaderVersion() == 1) {
            return null;
        }
        if (!this.persisterMetadataInitialized) {
            this.initPersisterMetadataFromBuffer();
        }
        if (this.persisterMetadataLen == 0) {
            return null;
        }
        return this.persisterMetadata;
    }

    public final void copyPersisterMetadataTo(PktBuffer buffer, int offset) {
        if (this.getSubheaderVersion() == 1) {
            return;
        }
        if (this.persisterMetadata != null) {
            buffer.putFrom(offset, this.persisterMetadata, 0, this.persisterMetadataLen);
        } else {
            buffer.putFrom(offset, this.buffer, this.PERMETADATA_POS, this.persisterMetadataLen);
        }
    }

    @Override
    public final void initializeBuffer() {
        this.setSubheaderVersion((short)2);
    }

    public final String toString() {
        switch (this.getSubheaderVersion()) {
            case 1: 
            case 2: {
                return "ODS{" + this.getSubheaderVersion() + " " + (this.getObjectId() == null ? "null" : this.getObjectId().toString()) + " " + this.getObjectFactoryId() + " " + this.getObjectType() + " " + this.getContentEncodingType() + " " + this.getCommitEntryType() + " " + this.getTimestamp() + " " + this.getFlags() + " " + this.getTransactionId() + " " + this.getStableTransactionId() + " " + this.getCheckpointVersion() + " " + (this.objectMetadataInitialized ? this.objectMetadataLen : this.buffer.getShort(this.OBJMETADATALEN_POS)) + " " + (this.persisterMetadataInitialized ? this.persisterMetadataLen : this.buffer.getShort(this.PERMETADATALEN_POS)) + "}";
            }
        }
        return "ODS{Unknown version " + this.getSubheaderVersion() + "}";
    }
}

