/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import cern.colt.bitvector.QuickBitVector;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.EPktCorruptException;
import com.neeve.pkt.EPktDeserializeException;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.EPktSerializeException;
import com.neeve.pkt.EPktVersionInvalidException;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.PktSubheader;
import com.neeve.pkt.PktSubheaderFMC;
import com.neeve.pkt.PktSubheaderFUC;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.PktSubheaderRR;
import com.neeve.pkt.PktSubheaderSMA;
import com.neeve.quark.QuarkBuffer;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFabricAddress;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class PktHeader
extends PktSerializable
implements IOElasticBuffer.Initializer {
    private static final int MAGIC_POS = 0;
    private static final int VERSION_POS = 3;
    private static final int LEN_POS = 4;
    private static final int SRC_POS = 8;
    private static final int DEST_POS = 12;
    private static final int SPORT_POS = 16;
    private static final int DPORT_POS = 18;
    private static final int FLOW_POS = 20;
    private static final int FLAGS_POS = 24;
    private static final int HTL_POS = 27;
    private static final int CLAZZ_POS = 28;
    private static final int NUM_SH_POS = 29;
    private static final int BODY_TYPE_POS = 30;
    private static final int FLAG_NO_BUFFERING = 256;
    private static final int FLAG_REPLY_EXPECTED = 512;
    private static final byte V1 = 1;
    private static final byte VERSION = 1;
    private static final int STATIC_HEADER_LENGTH_V1 = 34;
    public static final int STATIC_HEADER_LENGTH = 34;
    private static final int SUBHDR_ARRAY_LENGTH = 8;
    private final PktBuffer buffer;
    private final PktSubheader[] subheaders;
    private final PktBody body;
    private final long[] activeSubheaders;
    private boolean inDeserialize;
    public static final int MAGIC_SIZE = 3;
    public static final int MAGIC = 12246189;
    public static final short MAX_HTL = 255;

    private PktHeader(PktBody body, Properties props) {
        this.buffer = PktBuffer.create(this, 34, body != null ? body.isNative() : false);
        this.buffer.setInitializer(this);
        this.subheaders = new PktSubheader[8];
        this.activeSubheaders = new long[1];
        this.body = body;
    }

    public static PktHeader create(PktBody body, Properties props) {
        return new PktHeader(body, props);
    }

    private static final int getMagic(ByteBuffer buffer, int offset) {
        return buffer.getInt(offset + 0) >>> 8;
    }

    private static final short getVersion(ByteBuffer buffer, int offset) {
        return (short)(0xFF & buffer.get(offset + 3));
    }

    private static final short getVersion(long addr, int offset) {
        return (short)(0xFF & QuarkBuffer.getByte((long)addr, (int)(offset + 3)));
    }

    private static final int getLength(ByteBuffer buffer, int offset) {
        return buffer.getInt(offset + 4);
    }

    public static final EPktException convertPreDeserializeErrorCodeToException(ByteBuffer buf, int bufOffset, int code) {
        switch (code) {
            case -1: {
                return new EPktCorruptException("invalid header magic number: " + PktHeader.getMagic(buf, bufOffset));
            }
            case -2: {
                return new EPktCorruptException("Invalid header version [" + PktHeader.getVersion(buf, bufOffset) + "]");
            }
            case -3: {
                return new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + PktHeader.getVersion(buf, bufOffset));
            }
        }
        throw new IllegalArgumentException(code + " does not represent a valid error returned by preDeserializeNoException");
    }

    public static final int preDeserialize(ByteBuffer buf, int bufOffset, int length) {
        if (length < 8) {
            return 0;
        }
        int magic = PktHeader.getMagic(buf, bufOffset);
        if (magic != 12246189) {
            throw new EPktCorruptException("invalid header magic number: " + magic);
        }
        short version = PktHeader.getVersion(buf, bufOffset);
        if (version <= 0) {
            throw new EPktCorruptException("Invalid header version [" + version + "]");
        }
        if (version > 1) {
            throw new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + version);
        }
        return PktHeader.getLength(buf, bufOffset);
    }

    public static final int preDeserializeNoException(ByteBuffer buf, int bufOffset, int length) {
        if (length < 8) {
            return 0;
        }
        int magic = PktHeader.getMagic(buf, bufOffset);
        if (magic != 12246189) {
            return -1;
        }
        short version = PktHeader.getVersion(buf, bufOffset);
        if (version <= 0) {
            return -2;
        }
        if (version > 1) {
            return -3;
        }
        return PktHeader.getLength(buf, bufOffset);
    }

    public static final EPktException convertPreDeserializeErrorCodeToException(IOBuffer iobuf, int iobufOffset, int code) {
        return PktHeader.convertPreDeserializeErrorCodeToException(iobuf.getBufferUnsafe(), iobufOffset, code);
    }

    public static final int preDeserialize(IOBuffer iobuf, int iobufOffset, int length) {
        return PktHeader.preDeserialize(iobuf.getBufferUnsafe(), iobufOffset, length);
    }

    public static final int preDeserializeNoException(IOBuffer iobuf, int iobufOffset, int length) {
        return PktHeader.preDeserializeNoException(iobuf.getBufferUnsafe(), iobufOffset, length);
    }

    public static final boolean preDeserialize(PktSerializable.DeserializeContext context) throws EPktCorruptException, EPktVersionInvalidException {
        ByteBuffer buffer = context.getBuffer();
        int bufferPos = buffer.position();
        int magicPlusVersionLen = 4;
        if (buffer.remaining() > 4) {
            int magic = PktHeader.getMagic(buffer, bufferPos);
            if (magic != 12246189) {
                throw new EPktCorruptException("invalid header magic number: " + magic);
            }
            short version = PktHeader.getVersion(buffer, bufferPos);
            if (version <= 0) {
                throw new EPktCorruptException("Invalid header version [" + version + "]");
            }
            if (version > 1) {
                throw new EPktVersionInvalidException("Invalid header version [max supported=1 received=" + version);
            }
            if (buffer.remaining() >= 34) {
                int len = PktHeader.getLength(buffer, bufferPos);
                if (buffer.remaining() >= len) {
                    return true;
                }
                context.setNumBytes(len - buffer.remaining());
            } else {
                context.setNumBytes(34 - buffer.remaining());
            }
        } else {
            context.setNumBytes(34 - buffer.remaining());
        }
        return false;
    }

    public static final void clearMagic(ByteBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)0);
    }

    public static final void clearMagic(PktBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)0);
    }

    public static final void restoreClearedMagic(ByteBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)-70);
    }

    public static final void restoreClearedMagic(PktBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)-70);
    }

    public static final boolean hasMagic(ByteBuffer buffer, int offset) {
        return buffer.remaining() >= 4 && PktHeader.getMagic(buffer, offset) == 12246189;
    }

    public static final short getLatestVersion() {
        return 1;
    }

    private final void setLength(int length) {
        this.buffer.putInt(4, length);
    }

    private final void setLength() {
        int headerSerializedLength = this.getSerializedLength();
        int bodySerializedLength = this.body != null ? this.body.getSerializedLength() : 0;
        int packetSerializedLength = headerSerializedLength + bodySerializedLength;
        if (this.getLength() != packetSerializedLength) {
            this.setLength(packetSerializedLength);
        }
    }

    private final void setNumSubheaders(short num) {
        this.buffer.put(29, (byte)num);
    }

    private final PktSubheader activateSubheader(int type, boolean reset) {
        if (!QuickBitVector.get((long[])this.activeSubheaders, (int)type)) {
            QuickBitVector.set((long[])this.activeSubheaders, (int)type);
            this.initializeSubheader(type);
            if (reset) {
                this.subheaders[type].reset();
            }
            this.setNumSubheaders((short)(this.getNumSubheaders() + 1));
        }
        return this.subheaders[type];
    }

    private final void initializeSubheader(int type) {
        if (this.subheaders[type] == null && PktFactory.getInstance().getPacketType(type) != null) {
            this.subheaders[type] = (PktSubheader)PktFactory.getInstance().createPacketBody(type);
            this.subheaders[type].setSerializationPolicy(super.getSerializationPolicy());
            this.subheaders[type].setDeserializationPolicy(super.getDeserializationPolicy());
        }
    }

    private final void deactivateSubheader(int type) {
        if (QuickBitVector.get((long[])this.activeSubheaders, (int)type)) {
            QuickBitVector.clear((long[])this.activeSubheaders, (int)type);
            this.setNumSubheaders((short)(this.getNumSubheaders() - 1));
        }
    }

    private static final int getStaticSerializedLength(short version) {
        switch (version) {
            case 1: {
                return 34;
            }
        }
        return 0;
    }

    final PktSubheader getSubheader(int type, boolean ignoreInactive) {
        if (ignoreInactive || QuickBitVector.get((long[])this.activeSubheaders, (int)type)) {
            this.initializeSubheader(type);
            return this.subheaders[type];
        }
        return null;
    }

    final boolean isSubheaderActive(int type) {
        return QuickBitVector.get((long[])this.activeSubheaders, (int)type);
    }

    final void cloneActiveSubheaderMask(PktHeader header) {
        header.activeSubheaders[0] = this.activeSubheaders[0];
        if (this.activeSubheaders.length > 1) {
            throw new InternalError("active subheader mask clone needs to be updated!");
        }
    }

    final void fork(PktHeader header, boolean storageOnly) {
        if (this.buffer.getIOBuffer() != null) {
            header.buffer.wrapIOBuffer(this.buffer.getIOBuffer(), this.buffer.getOffset(), this.buffer.getLength());
            int numSubheaders = this.getNumSubheaders();
            int numProcessed = 0;
            for (int i = 0; i < this.subheaders.length && numProcessed < numSubheaders; ++i) {
                PktSubheader subheader = this.getSubheader(i, false);
                if (subheader == null) continue;
                QuickBitVector.set((long[])header.activeSubheaders, (int)i);
                subheader.fork(header.getSubheader(i, false), storageOnly);
                ++numProcessed;
            }
            int headerSerializedLength = this.getSerializedLength();
            int bodySerializedLength = this.body != null ? this.body.getSerializedLength() : 0;
            int serializedLength = headerSerializedLength + bodySerializedLength;
            this.setLength(serializedLength);
            this.buffer.setCopyOnWrite();
            header.buffer.setCopyOnWrite();
        }
    }

    final void setOutTs(ByteBuffer buffer, int pos, long ts) {
        buffer.putInt(pos + 8, (int)(ts >> 32 & 0xFFFFFFFFL));
        buffer.putInt(pos + 12, (int)(ts & 0xFFFFFFFFL));
    }

    final long getOutTs() {
        return (long)this.buffer.getInt(12) & 0xFFFFFFFFL | ((long)this.buffer.getInt(8) & 0xFFFFFFFFL) << 32;
    }

    public final short getVersion() {
        return (short)(0xFF & this.buffer.get(3));
    }

    public final int getLength() {
        return this.buffer.getInt(4);
    }

    public final void setSrc(int addr) {
        this.buffer.putInt(8, addr);
    }

    public final int getSrc() {
        return this.buffer.getInt(8);
    }

    public final void setDest(int addr) {
        this.buffer.putInt(12, addr);
    }

    public final int getDest() {
        return this.buffer.getInt(12);
    }

    public final void setSrcPort(short port) {
        this.buffer.putShort(16, port);
    }

    public final short getSrcPort() {
        return this.buffer.getShort(16);
    }

    public final void setDestPort(short port) {
        this.buffer.putShort(18, port);
    }

    public final short getDestPort() {
        return this.buffer.getShort(18);
    }

    public final void setFlow(int flow) {
        this.buffer.putInt(20, flow);
    }

    public final int getFlow() {
        return this.buffer.getInt(20);
    }

    public final void setNoBuffering(boolean val) {
        int flags = this.buffer.getInt(24);
        flags = val ? (flags |= 0x100) : (flags &= 0xFFFFFEFF);
        this.buffer.putInt(24, flags);
    }

    public final boolean getNoBuffering() {
        return (this.buffer.getInt(24) & 0x100) == 256;
    }

    public final void setReplyExpected(boolean val) {
        int flags = this.buffer.getInt(24);
        flags = val ? (flags |= 0x200) : (flags &= 0xFFFFFDFF);
        this.buffer.putInt(24, flags);
    }

    public final boolean getReplyExpected() {
        return (this.buffer.getInt(24) & 0x200) == 512;
    }

    public final void setHtl(short htl) {
        this.buffer.put(27, (byte)htl);
    }

    public final short getHtl() {
        return (short)(0xFF & this.buffer.get(27));
    }

    public final void setClazz(short clazz) {
        this.buffer.put(28, (byte)clazz);
    }

    public final short getClazz() {
        return (short)(0xFF & this.buffer.get(28));
    }

    public final int getBodyType() {
        return this.buffer.getInt(30);
    }

    public static final int getBodyType(PktBuffer buffer, int offset) {
        return buffer.getInt(offset + 30);
    }

    public static final int getBodyType(ByteBuffer buffer, int offset) {
        return buffer.getInt(offset + 30);
    }

    public static final short getNumSubheaders(long addr, int offset) {
        return (short)(0xFF & QuarkBuffer.getByte((long)addr, (int)(offset + 29)));
    }

    public final short getNumSubheaders() {
        return this.buffer.getIOBuffer() == null ? (short)0 : (short)(0xFF & this.buffer.get(29));
    }

    public final PktBuffer getBuffer() {
        return this.buffer;
    }

    public final PktSubheaderRR activateRRSubheader(boolean reset) {
        return (PktSubheaderRR)this.activateSubheader(1, reset);
    }

    public final void deactivateRRSubheader() {
        this.deactivateSubheader(1);
    }

    public final PktSubheaderRR getRRSubheader() {
        return (PktSubheaderRR)this.getSubheader(1, false);
    }

    public final PktSubheaderFMC activateFMCSubheader(boolean reset) {
        return (PktSubheaderFMC)this.activateSubheader(2, reset);
    }

    public final void deactivateFMCSubheader() {
        this.deactivateSubheader(2);
    }

    public final PktSubheaderFMC getFMCSubheader() {
        return (PktSubheaderFMC)this.getSubheader(2, false);
    }

    public final PktSubheaderFUC activateFUCSubheader(boolean reset) {
        return (PktSubheaderFUC)this.activateSubheader(3, reset);
    }

    public final void deactivateFUCSubheader() {
        this.deactivateSubheader(3);
    }

    public final PktSubheaderFUC getFUCSubheader() {
        return (PktSubheaderFUC)this.getSubheader(3, false);
    }

    public final PktSubheaderSMA activateSMASubheader(boolean reset) {
        return (PktSubheaderSMA)this.activateSubheader(5, reset);
    }

    public final void deactivateSMASubheader() {
        this.deactivateSubheader(5);
    }

    public final PktSubheaderSMA getSMASubheader() {
        return (PktSubheaderSMA)this.getSubheader(5, false);
    }

    public static final int getSubheaderOffset(long addr, int offset, int subheaderType) {
        int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(addr, offset));
        int numSubheaders = PktHeader.getNumSubheaders(addr, offset);
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < numSubheaders; ++i) {
            int subheaderSerializedLength;
            int pktTypeId = PktSubheader.getType(addr, offset + headerSerializedLength);
            if (pktTypeId == subheaderType) {
                return offset + headerSerializedLength;
            }
            switch (pktTypeId) {
                case 1: {
                    subheaderSerializedLength = PktSubheaderRR.getSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                case 2: {
                    subheaderSerializedLength = PktSubheaderFMC.getSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                case 3: {
                    subheaderSerializedLength = PktSubheaderFUC.getSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                case 5: {
                    subheaderSerializedLength = PktSubheaderSMA.getSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                case 7: {
                    subheaderSerializedLength = PktSubheaderODS.getSerializedLength(addr, offset + headerSerializedLength);
                    break;
                }
                default: {
                    throw new EPktCorruptException("invalid header type '" + pktTypeId + "' in serialized header");
                }
            }
            headerSerializedLength += subheaderSerializedLength;
        }
        return -1;
    }

    public final PktSubheaderODS activateODSSubheader(boolean reset) {
        return (PktSubheaderODS)this.activateSubheader(7, reset);
    }

    public final void deactivateODSSubheader() {
        this.deactivateSubheader(7);
    }

    public final PktSubheaderODS getODSSubheader() {
        return (PktSubheaderODS)this.getSubheader(7, false);
    }

    public final PktBody getBody() {
        return this.body;
    }

    public final void reset() {
        this.getNumSubheaders();
        this.buffer.wipe(0, 34);
        this.initializeBuffer();
        for (int i = 1; i < this.subheaders.length; ++i) {
            if (this.subheaders[i] != null) {
                this.subheaders[i].reset();
            }
            QuickBitVector.clear((long[])this.activeSubheaders, (int)i);
        }
    }

    @Override
    public final void setSerializationPolicy(int policy) {
        super.setSerializationPolicy(policy);
        for (int i = 1; i < this.subheaders.length; ++i) {
            if (this.subheaders[i] == null) continue;
            this.subheaders[i].setSerializationPolicy(policy);
        }
    }

    @Override
    public final void serialize(PktSerializable.SerializeContext context, Tracer tracer) throws EPktSerializeException {
        ByteBuffer contextBuffer;
        if (tracer != null && tracer.debug) {
            tracer.log("...serializing packet header...", Tracer.Level.DEBUG);
        }
        int policy = context.getPolicy();
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        int headerSerializedLength = this.getSerializedLength();
        int bodySerializedLength = this.body != null ? this.body.getSerializedLength() : 0;
        int resolvedPolicy = this.resolveSerializationPolicy(policy);
        boolean serializeWithoutMagic = context.getSerializeWithoutMagic();
        int numSubheaders = this.getNumSubheaders();
        if (tracer != null && tracer.debug) {
            tracer.log("......pre-serialize state {", Tracer.Level.DEBUG);
            tracer.log(".........serialization context", Tracer.Level.DEBUG);
            context.trace(tracer, "............");
            tracer.log(".........headerStaticSerializedLength=" + headerStaticSerializedLength, Tracer.Level.DEBUG);
            tracer.log(".........headerSerializedLength=" + headerSerializedLength, Tracer.Level.DEBUG);
            tracer.log("............numSubheaders=" + numSubheaders, Tracer.Level.DEBUG);
            tracer.log(".........bodySerializedLength=" + bodySerializedLength, Tracer.Level.DEBUG);
            tracer.log(".........resolvedPolicy=" + resolvedPolicy, Tracer.Level.DEBUG);
            tracer.log(".........hdrBuffer=" + (Object)((Object)this.buffer), Tracer.Level.DEBUG);
            tracer.log("......}", Tracer.Level.DEBUG);
        }
        int packetSerializedLength = headerSerializedLength + bodySerializedLength;
        if (this.getLength() != packetSerializedLength) {
            if (tracer != null && tracer.debug) {
                tracer.log("......setting packet length from " + this.getLength() + " to " + packetSerializedLength + ".", Tracer.Level.DEBUG);
            }
            this.setLength(packetSerializedLength);
        } else if (tracer != null && tracer.debug) {
            tracer.log("......packet length already set to " + this.getLength(), Tracer.Level.DEBUG);
        }
        if (resolvedPolicy == 1 || resolvedPolicy == 2) {
            contextBuffer = context.getByteBufferForCopy(headerSerializedLength);
            if (serializeWithoutMagic) {
                contextBuffer.put(contextBuffer.position(), (byte)0);
                this.buffer.getTo(1, contextBuffer, 1, headerStaticSerializedLength - 1);
            } else {
                this.buffer.getTo(0, contextBuffer, headerStaticSerializedLength);
            }
        } else {
            throw new IllegalStateException("serialize by attach is currently not supported");
        }
        contextBuffer.position(contextBuffer.position() + headerStaticSerializedLength);
        if (tracer != null && tracer.debug) {
            tracer.log("......post-serialize state {", Tracer.Level.DEBUG);
            tracer.log(".........serialization context", Tracer.Level.DEBUG);
            context.trace(tracer, "............");
            tracer.log(".........hdrBuffer=" + (Object)((Object)this.buffer), Tracer.Level.DEBUG);
            tracer.log("......}", Tracer.Level.DEBUG);
        }
        int numProcessed = 0;
        for (int i = 0; i < this.subheaders.length && numProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            subheader.serialize(context, tracer);
            ++numProcessed;
        }
    }

    public final int serialize(ByteBuffer buf) {
        return this.serialize(buf, buf.position());
    }

    public final int serialize(ByteBuffer buf, int bufOffset) {
        this.setLength();
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        this.buffer.getTo(0, buf, bufOffset, headerStaticSerializedLength);
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.serialize(buf, bufOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int serialize(byte[] array, int arrayOffset) {
        this.setLength();
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        this.buffer.getTo(0, array, arrayOffset, headerStaticSerializedLength);
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.serialize(array, arrayOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int serialize(IOBuffer iobuf, int iobufOffset) {
        this.setLength();
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        this.buffer.getTo(0, iobuf.getBufferUnsafe(), iobufOffset, headerStaticSerializedLength);
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.serialize(iobuf, iobufOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int serialize(IOElasticBuffer iobuf, int iobufOffset) {
        this.setLength();
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        iobuf.putFrom(iobufOffset, (IOElasticBuffer)this.buffer, 0, headerStaticSerializedLength);
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.serialize(iobuf, iobufOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    public final int serialize(long address, int addressOffset) {
        this.setLength();
        int headerStaticSerializedLength = this.getStaticSerializedLength();
        this.buffer.getToNative(0, address, addressOffset, headerStaticSerializedLength);
        int numSubheaders = this.getNumSubheaders();
        int numSubheadersProcessed = 0;
        int headerSerializedLength = headerStaticSerializedLength;
        for (int i = 0; i < this.subheaders.length && numSubheadersProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            headerSerializedLength += subheader.serialize(address, addressOffset + headerSerializedLength);
            ++numSubheadersProcessed;
        }
        return headerSerializedLength;
    }

    @Override
    public final void setDeserializationPolicy(int policy) {
        super.setDeserializationPolicy(policy);
        for (int i = 1; i < this.subheaders.length; ++i) {
            if (this.subheaders[i] == null) continue;
            this.subheaders[i].setDeserializationPolicy(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deserialize(PktSerializable.DeserializeContext context, int headerSerializedLength, Tracer tracer) throws EPktDeserializeException {
        block17: {
            if (context == null) {
                throw new IllegalArgumentException("context cannot be null");
            }
            if (headerSerializedLength != -1) {
                throw new IllegalArgumentException("serialized length must be -1 since header lengths are pulled from the serialized form");
            }
            this.inDeserialize = true;
            try {
                ByteBuffer contextBuffer = context.getBuffer();
                int contextBufferPos = contextBuffer.position();
                int contextBufferLim = contextBuffer.limit();
                int policy = context.getPolicy();
                if (contextBuffer.remaining() >= 34) {
                    int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(contextBuffer, contextBufferPos));
                    if (headerStaticSerializedLength > 0) {
                        if (contextBuffer.remaining() >= headerStaticSerializedLength) {
                            int resolvedPolicy = this.resolveDeserializationPolicy(policy);
                            if (tracer != null && tracer.debug) {
                                tracer.log("...deserializing packet header...", Tracer.Level.DEBUG);
                                tracer.log("......pre-deserialize state {", Tracer.Level.DEBUG);
                                tracer.log(".........deserialization context", Tracer.Level.DEBUG);
                                context.trace(tracer, "............");
                                tracer.log(".........resolvedPolicy=" + resolvedPolicy, Tracer.Level.DEBUG);
                                tracer.log("......}", Tracer.Level.DEBUG);
                            }
                            if (resolvedPolicy == 1 || resolvedPolicy == 2) {
                                if (tracer != null && tracer.debug) {
                                    tracer.log("......copying into buffer " + (Object)((Object)this.buffer) + "...", Tracer.Level.DEBUG);
                                }
                            } else {
                                this.buffer.setCopyOnWrite();
                                context.setBufferRetained(true);
                                throw new IllegalStateException("deserialize by slice is currently not supported");
                            }
                            contextBuffer.limit(contextBuffer.position() + headerStaticSerializedLength);
                            this.buffer.putFrom(0, contextBuffer, headerStaticSerializedLength);
                            contextBuffer.limit(contextBufferLim);
                            context.setBufferRetained(false);
                            context.setNumBytes(headerStaticSerializedLength);
                            contextBuffer.position(contextBufferPos + headerStaticSerializedLength);
                            if (tracer != null && tracer.debug) {
                                tracer.log("......post-deserialize state {", Tracer.Level.DEBUG);
                                tracer.log(".........deserialization context", Tracer.Level.DEBUG);
                                context.trace(tracer, "............");
                                tracer.log(".........hdrBuffer=" + (Object)((Object)this.buffer), Tracer.Level.DEBUG);
                                tracer.log("......}", Tracer.Level.DEBUG);
                            }
                            int numSubheaders = this.getNumSubheaders();
                            this.setNumSubheaders((short)0);
                            if (tracer != null && tracer.debug) {
                                tracer.log("......num subheaders=" + numSubheaders + ".", Tracer.Level.DEBUG);
                            }
                            for (int i = 0; i < numSubheaders; ++i) {
                                int pktTypeId = PktSubheader.getType(contextBuffer, contextBuffer.position());
                                if (tracer != null && tracer.debug) {
                                    tracer.log("......subheader '" + pktTypeId + "'...", Tracer.Level.DEBUG);
                                }
                                if (QuickBitVector.get((long[])this.activeSubheaders, (int)pktTypeId)) {
                                    throw new InternalError("Subheader (type=" + pktTypeId + ") is marked as active during deserialize!");
                                }
                                this.initializeSubheader(pktTypeId);
                                PktSubheader subheader = this.subheaders[pktTypeId];
                                int subheaderSerializedLength = subheader.getSerializedLength(contextBuffer, contextBuffer.position());
                                subheader.deserialize(context, subheaderSerializedLength, tracer);
                                this.activateSubheader(pktTypeId, false);
                            }
                            break block17;
                        }
                        throw new InternalError("buffer does not contain a complete serialized packet header {preDeserialize() should be invoked prior to invoking deserialize() for this to be a non-fatal error}.");
                    }
                    throw new InternalError("Unsupported version in serialized header. preDeserialize() should be invoked prior to invoking deserialize() for this to be a non-fatal error");
                }
                throw new InternalError("buffer does not contain a complete serialized packet header {preDeserialize() should be invoked prior to invoking deserialize() for this to be a non-fatal error}.");
            }
            finally {
                this.inDeserialize = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deserialize(ByteBuffer buf, int bufOffset) {
        this.inDeserialize = true;
        try {
            int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(buf, bufOffset));
            this.buffer.putFrom(0, buf, bufOffset, headerStaticSerializedLength);
            int numSubheaders = this.getNumSubheaders();
            this.setNumSubheaders((short)0);
            int headerSerializedLength = headerStaticSerializedLength;
            for (int i = 0; i < numSubheaders; ++i) {
                int pktTypeId = PktSubheader.getType(buf, bufOffset + headerSerializedLength);
                if (QuickBitVector.get((long[])this.activeSubheaders, (int)pktTypeId)) {
                    throw new InternalError("Subheader (type=" + pktTypeId + ") is marked as active during deserialize!");
                }
                this.initializeSubheader(pktTypeId);
                PktSubheader subheader = this.subheaders[pktTypeId];
                int subheaderSerializedLength = subheader.getSerializedLength(buf, bufOffset + headerSerializedLength);
                subheader.deserialize(buf, bufOffset + headerSerializedLength, subheaderSerializedLength);
                headerSerializedLength += subheaderSerializedLength;
                this.activateSubheader(pktTypeId, false);
            }
            int n = headerSerializedLength;
            return n;
        }
        finally {
            this.inDeserialize = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deserialize(IOBuffer iobuf, int iobufOffset, boolean wrap) {
        this.inDeserialize = true;
        try {
            ByteBuffer bytebuf = iobuf.getBufferUnsafe();
            int headerStaticSerializedLength = PktHeader.getStaticSerializedLength(PktHeader.getVersion(bytebuf, iobufOffset));
            if (wrap) {
                this.buffer.wrapIOBuffer(iobuf, iobufOffset, headerStaticSerializedLength);
            } else {
                this.buffer.putFrom(0, iobuf, iobufOffset, headerStaticSerializedLength);
            }
            int numSubheaders = this.getNumSubheaders();
            this.setNumSubheaders((short)0);
            int headerSerializedLength = headerStaticSerializedLength;
            for (int i = 0; i < numSubheaders; ++i) {
                int pktTypeId = PktSubheader.getType(bytebuf, iobufOffset + headerSerializedLength);
                if (QuickBitVector.get((long[])this.activeSubheaders, (int)pktTypeId)) {
                    throw new InternalError("Subheader (type=" + pktTypeId + ") is marked as active during deserialize!");
                }
                this.initializeSubheader(pktTypeId);
                PktSubheader subheader = this.subheaders[pktTypeId];
                int subheaderSerializedLength = subheader.getSerializedLength(bytebuf, iobufOffset + headerSerializedLength);
                subheader.deserialize(iobuf, iobufOffset + headerSerializedLength, subheaderSerializedLength, wrap);
                headerSerializedLength += subheaderSerializedLength;
                this.activateSubheader(pktTypeId, false);
            }
            int n = headerSerializedLength;
            return n;
        }
        finally {
            this.inDeserialize = false;
        }
    }

    public final int getStaticSerializedLength() {
        return PktHeader.getStaticSerializedLength(this.getVersion());
    }

    @Override
    public final int getSerializedLength() {
        int size = this.getStaticSerializedLength();
        int numSubheaders = this.getNumSubheaders();
        int numProcessed = 0;
        for (int i = 0; i < this.subheaders.length && numProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            size += subheader.getSerializedLength();
            ++numProcessed;
        }
        return size;
    }

    public final int getInitialBufferLength() {
        return this.getStaticSerializedLength();
    }

    public final void initializeBuffer() {
        if (!this.inDeserialize) {
            this.buffer.putInt(0, -1159942912);
            this.buffer.put(3, (byte)1);
            this.buffer.put(27, (byte)-1);
            this.buffer.putInt(30, this.body != null ? this.body.getType() : 0);
        }
    }

    public final String toString() {
        String str = "";
        str = str + "[";
        str = str + this.getVersion() + "," + this.getLength() + ",<" + UtlFabricAddress.toString((int)this.getSrc()) + ":" + this.getSrcPort() + ">,<" + UtlFabricAddress.toString((int)this.getDest()) + ":" + this.getDestPort() + ">," + this.getFlow() + ",<nb=" + this.getNoBuffering() + " re=" + this.getReplyExpected() + ">," + this.getHtl() + "," + this.getClazz() + "," + this.getNumSubheaders() + "," + this.getBodyType();
        int numSubheaders = this.getNumSubheaders();
        int numProcessed = 0;
        for (int i = 0; i < this.subheaders.length && numProcessed < numSubheaders; ++i) {
            PktSubheader subheader = this.getSubheader(i, false);
            if (subheader == null) continue;
            str = str + " " + (Object)((Object)subheader);
            ++numProcessed;
        }
        str = str + "]";
        return str;
    }
}

