/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.test.stress;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkFactory;
import com.neeve.link.LnkSynchronousConnector;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import java.util.Random;

public final class LnkTestStressWriter {
    private String descriptor;
    private IEmxDispatcher dispatcher;
    private ILnkClientEndpoint cep;
    private FlushCompleteEventHandler handler;
    private Random random;
    private static boolean init = false;
    private static PktPacket packet;

    private final PktPacket getPacket() throws Exception {
        if (!init) {
            packet = PktFactory.getInstance().createPacket("data_buffer");
            packet.getHeader().activateFMCSubheader(false);
            init = true;
        }
        int len = 8192;
        ((PktBodyData)packet.getBody()).setBufferLength(8192);
        return packet;
    }

    private final ILnkPeerEndpoint.FlushContext getFlushContext() {
        return new ILnkPeerEndpoint.SynchronousBlockingFlushContext();
    }

    private final int getEnqueFlags() {
        return 0;
    }

    private final void postProcess() {
    }

    private final void run(String descriptor) throws Exception {
        this.descriptor = descriptor;
        this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, "LnkTestStressWriterDispatcher", null);
        this.handler = new FlushCompleteEventHandler();
        this.random = new Random((int)System.currentTimeMillis());
        ILnkClientEndpoint cep = null;
        ILnkPeerEndpoint pep = null;
        try {
            cep = LnkFactory.getInstance().createClientEndpoint(descriptor, null);
            pep = new LnkSynchronousConnector().run(cep, 1000);
            System.out.println("Successfully establish link connection [" + pep.getName() + "].");
        }
        catch (Exception e) {
            System.out.println("Failed to establish link connection [" + e.toString() + "]");
        }
        try {
            while (true) {
                PktPacket packet = this.getPacket();
                ILnkPeerEndpoint.FlushContext flushContext = this.getFlushContext();
                int flags = this.getEnqueFlags();
                int bodyLength = ((PktBodyData)packet.getBody()).getBufferLength();
                String flagsStr = "[flushForce=" + ((flags & 0x10) == 16) + " flushSuppress=" + ((flags & 8) == 8) + "]";
                System.out.println("Enqueueing packet [body length = " + bodyLength + "] flush context=" + flushContext + " flags=" + flagsStr);
                boolean flushed = pep.enque((short)-1, packet, flushContext, flags);
                System.out.println("Enqueued packet [flushed=" + flushed + "] flush context=" + flushContext);
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            System.out.println("Error during writing packets [" + e.toString() + "]");
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            try {
                new LnkTestStressWriter().run(args[0]);
            }
            catch (Throwable e) {
                System.out.println("Unhandled fault [" + e.toString() + "]");
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage java com.neeve,link.test.stress.LnkTestStressWriter <link descriptor>");
        }
    }

    private final class FlushCompleteEventHandler
    implements ILnkEventHandler {
        private FlushCompleteEventHandler() {
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int event, Object data) {
        }
    }
}

