/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.test.stress;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ELnkOpWouldAsyncException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkFactory;
import java.util.Random;

public final class LnkAcceptor {
    private IEmxDispatcher dispatcher;
    private ILnkServerEndpoint sep;
    private AcceptCompleteEventHandler handler;
    private Random random;

    private final boolean postAccept(boolean fromBody, PostParams params) {
        System.out.println("\nPosting accept from " + (fromBody ? "body" : "handler") + " using params " + params + "...");
        try {
            this.sep.acceptPost(this.dispatcher, this.handler, params.timeout, params.flags);
            if (this.handler.done()) {
                if (!params.immediateDispatch) {
                    throw new InternalError("Accept post dispatched completion event immediately when immediate dispatch was not specified");
                }
                System.out.println("Accept done synchronously [Event=" + this.handler.event + " data=" + this.handler.eventData + "]");
                return false;
            }
            System.out.println("Accept pending completion.");
            return true;
        }
        catch (ELnkOpFailedException e) {
            if (e instanceof ELnkOpWouldAsyncException && !params.noAsync) {
                throw new InternalError("Accept post threw ELnkOpWouldAsyncException when noAsync was not specified!");
            }
            System.out.println("Accept failed [" + e.toString() + "]");
            return false;
        }
        catch (ELnkInvalidStateException e) {
            e.printStackTrace();
            System.exit(0);
            return false;
        }
    }

    private final void cancelAccept() {
        try {
            System.out.println("Cancelling accept from body...");
            this.sep.acceptCancel(0);
        }
        catch (ELnkInvalidStateException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private final void run(String desc) throws Exception {
        this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, "LnkAcceptorDispatcher", null);
        this.sep = LnkFactory.getInstance().createServerEndpoint(desc, null);
        this.handler = new AcceptCompleteEventHandler();
        this.random = new Random((int)System.currentTimeMillis());
        block0: while (true) {
            PostParams params = new PostParams(this.random);
            this.handler.reset(params);
            if (!this.postAccept(true, params)) continue;
            while (true) {
                int timeout = params.cancel ? params.cancelWait : -1;
                System.out.println("Running dispatcher [timeout=" + timeout + "]");
                if (this.dispatcher.run(timeout) == 0) {
                    if (timeout == -1) {
                        throw new InternalError("Dispatcher returned indicating timeout with supplied timeout=-1");
                    }
                    this.cancelAccept();
                    timeout = -1;
                    continue;
                }
                if (this.handler.done()) {
                    System.out.println("Accept done asynchronously (repost from body) [Event=" + this.handler.event + " data=" + this.handler.eventData + "]");
                    continue block0;
                }
                System.out.println("Accept may have been reposted from handler");
                params = this.handler.params();
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            try {
                new LnkAcceptor().run(args[0]);
            }
            catch (Throwable e) {
                System.out.println("Unhandled fault [" + e.toString() + "]");
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage java com.neeve,link.test.stress.LnkAcceptor <link descriptor>");
        }
    }

    private final class PostParams {
        final int timeout;
        final boolean immediateDispatch;
        final boolean noAsync;
        final boolean cancel;
        final int cancelWait;
        final boolean repostFromHandler;
        int flags;

        PostParams(Random random) {
            this.timeout = random.nextInt(1000);
            this.immediateDispatch = random.nextBoolean();
            this.noAsync = random.nextBoolean();
            this.cancel = random.nextBoolean();
            this.cancelWait = this.cancel ? random.nextInt(this.timeout + 1) : -1;
            this.repostFromHandler = false;
            this.flags = 0;
            if (this.immediateDispatch) {
                this.flags |= 1;
            }
            if (this.noAsync) {
                this.flags |= 2;
            }
        }

        public String toString() {
            return "[timeout=" + this.timeout + " immdDisp=" + this.immediateDispatch + " noAsync=" + this.noAsync + " cancel=" + this.cancel + "(" + this.cancelWait + ") repostFromHandler=" + this.repostFromHandler + "]";
        }
    }

    private final class AcceptCompleteEventHandler
    implements ILnkEventHandler {
        int event = -1;
        LnkEvents.ConnectAcceptCompleteEventData eventData;
        PostParams params;

        AcceptCompleteEventHandler() {
            this.reset(null);
        }

        final AcceptCompleteEventHandler reset(PostParams params) {
            this.event = -1;
            this.eventData = null;
            this.params = params;
            return this;
        }

        final boolean done() {
            return this.event != -1;
        }

        final PostParams params() {
            return this.params;
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int event, Object data) {
            this.event = event;
            this.eventData = (LnkEvents.ConnectAcceptCompleteEventData)data;
            if (this.eventData.status) {
                try {
                    System.out.println("Closing peer endpoint");
                    this.eventData.pep.close((short)-1);
                }
                catch (Exception e) {
                    System.out.println("Failed to close pep [" + e.toString() + "]");
                }
            }
            if (this.params.repostFromHandler) {
                System.out.println("Accept done asynchronously (repost from handler) [Event=" + event + " data=" + this.eventData + "]");
                do {
                    this.params = new PostParams(LnkAcceptor.this.random);
                    this.reset(this.params);
                } while (!LnkAcceptor.this.postAccept(false, this.params));
            }
        }
    }
}

