/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.network;

import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.ILnkMessage;
import com.neeve.link.ILnkMessageFactory;
import com.neeve.link.network.LnkNwPeerEndpointStats;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;

final class LnkNwPeerEndpointInputBuffer
extends UtlListElement {
    private final int id;
    private final Tracer tracer;
    private final String tracePrefix;
    private final PktSerializable.DeserializeContext deserializeContext;
    private final LnkNwPeerEndpointStats stats;
    private final boolean useDirect;
    private final int minBufferSize;
    private final int maxBufferSizeSoft;
    private final int maxBufferSizeHard;
    private final int maxReadSpinTime;
    private int meanReadSize;
    private final double meanReadSizeChangeLambda;
    private int meanPacketSize;
    private final double meanPacketSizeChangeLambda;
    private final boolean shouldShrink;
    private final double retainedOnShrinkage;
    private boolean stampInTs;

    LnkNwPeerEndpointInputBuffer(String name, int id, Tracer tracer, int minBufferSize, int maxBufferSizeSoft, int maxBufferSizeHard, boolean useDirect, int maxReadSpinTime, double meanReadSizeChangeLambda, double meanPacketSizeChangeLambda, boolean shouldShrink, int shrinkagePct, boolean stampInTs, LnkNwPeerEndpointStats stats) {
        this.id = id;
        this.tracer = tracer;
        this.tracePrefix = "[ibuf #" + id + "] ";
        this.deserializeContext = PktSerializable.DeserializeContext.create();
        this.stats = stats;
        this.useDirect = useDirect;
        this.minBufferSize = minBufferSize;
        this.maxBufferSizeSoft = maxBufferSizeSoft == 0 ? Integer.MAX_VALUE : maxBufferSizeSoft;
        this.maxBufferSizeHard = maxBufferSizeHard == 0 ? Integer.MAX_VALUE : maxBufferSizeHard;
        this.maxReadSpinTime = maxReadSpinTime;
        this.meanReadSize = 0;
        this.meanReadSizeChangeLambda = meanReadSizeChangeLambda;
        this.meanPacketSize = 0;
        this.meanPacketSizeChangeLambda = meanPacketSizeChangeLambda;
        this.shouldShrink = shouldShrink;
        this.stampInTs = stampInTs;
        this.retainedOnShrinkage = (double)(100 - shrinkagePct) / 100.0;
        this.deserializeContext.setBuffer(this.allocateBuffer(minBufferSize));
        tracer.log("Network Link Endpoint Configuration (Input Buffer)...", Tracer.Level.CONFIG);
        tracer.log("....link=" + name, Tracer.Level.CONFIG);
        tracer.log("........id=" + this.id, Tracer.Level.CONFIG);
        tracer.log("........minBufferSize=" + this.minBufferSize, Tracer.Level.CONFIG);
        tracer.log("........maxBufferSize {soft=" + this.maxBufferSizeSoft + ", hard=" + this.maxBufferSizeHard + "}", Tracer.Level.CONFIG);
        tracer.log("........useDirect=" + this.useDirect, Tracer.Level.CONFIG);
        tracer.log("........maxReadSpinTime=" + this.maxReadSpinTime, Tracer.Level.CONFIG);
        tracer.log("........meanReadSizeChangeLambda=" + this.meanReadSizeChangeLambda, Tracer.Level.CONFIG);
        tracer.log("........meanPacketSizeChangeLambda=" + this.meanPacketSizeChangeLambda, Tracer.Level.CONFIG);
        tracer.log("........shouldShrink=" + shouldShrink, Tracer.Level.CONFIG);
        tracer.log("........retainedOnShrinkage=" + (int)(this.retainedOnShrinkage * 100.0) + "%", Tracer.Level.CONFIG);
        tracer.log("........stampInTs=" + stampInTs, Tracer.Level.CONFIG);
    }

    final void enableIOTimestamps(boolean enabled) {
        this.stampInTs = enabled;
    }

    private final ByteBuffer allocateBuffer(int size) {
        this.stats.inputBufSize = size;
        ++this.stats.numInputBufAllocs;
        this.stats.numInputBufBytesAllocated += (long)size;
        return this.useDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    private final int read(ByteBuffer buffer, IEmxNwLnkPeerEndpoint pep, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        int startPos = buffer.position();
        int totalBytesRead = 0;
        long startTime = 0L;
        while (buffer.remaining() > 0) {
            long currentTime;
            int bytesRead = pep.read(buffer, waitCond);
            ++this.stats.numNetworkReads;
            totalBytesRead += bytesRead;
            if (bytesRead != 0) continue;
            if (buffer.position() > startPos) break;
            long l = currentTime = this.maxReadSpinTime > 0 ? UtlTime.now() : 0L;
            if (startTime == 0L) {
                startTime = currentTime;
            }
            if (currentTime - startTime < (long)this.maxReadSpinTime) continue;
            break;
        }
        return totalBytesRead;
    }

    final int readDeserializeAndDispatch(IEmxNwLnkPeerEndpoint pep, IEmxDispatcher dispatcher, EmxNwLnkOpWaitCond waitCond, ILnkMessageFactory messageFactory, boolean dispatchList, ILnkEventHandlerCore handler, Tracer packetTracer) throws Exception {
        long preReadTs;
        UtlList list = dispatchList ? UtlList.create() : null;
        ByteBuffer readBuffer = this.deserializeContext.getBuffer();
        int bufferCapacity = readBuffer.capacity();
        long l = preReadTs = this.stampInTs ? UtlTime.now() : 0L;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Reading from network [capacity=" + bufferCapacity + " remaining=" + readBuffer.remaining() + "]...", Tracer.Level.DEBUG);
        }
        int bytesRead = this.read(readBuffer, pep, waitCond);
        boolean fullBufferRead = readBuffer.remaining() == 0;
        ++this.stats.numReads;
        this.stats.numBytesRead += (long)bytesRead;
        if (bytesRead > 0) {
            this.meanReadSize = this.meanReadSize == 0 ? bytesRead : (int)Math.ceil(this.meanReadSizeChangeLambda * (double)bytesRead + (1.0 - this.meanReadSizeChangeLambda) * (double)this.meanReadSize);
            this.stats.meanReadSize = this.meanReadSize;
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Read complete [bytesRead=" + bytesRead + "(" + this.meanReadSize + ") fullBufferRead=" + fullBufferRead + "]", Tracer.Level.DEBUG);
        }
        if (this.stampInTs) {
            this.stats.r.add((double)(UtlTime.now() - preReadTs));
        }
        readBuffer.flip();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Deserializing packets from read data [buffer=" + readBuffer.toString() + "]", Tracer.Level.DEBUG);
        }
        int numDeserialized = 0;
        boolean bufferRetained = false;
        Exception failure = null;
        int packetBufferPos = -1;
        int packetBufferLimit = -1;
        try {
            while (this.deserializeContext.getBuffer().remaining() > 0) {
                long ts = this.stampInTs ? UtlTime.now() : 0L;
                packetBufferPos = this.deserializeContext.getBuffer().position();
                packetBufferLimit = this.deserializeContext.getBuffer().limit();
                PktPacket packet = PktFactory.getInstance().createPacket(this.deserializeContext.reset(), this.tracer);
                packetBufferPos = -1;
                if (packet != null) {
                    ILnkMessage message;
                    if (ts > 0L) {
                        packet.setInTs(ts);
                    }
                    ++this.stats.numPacketsRead;
                    ++numDeserialized;
                    bufferRetained |= this.deserializeContext.getBufferRetained();
                    this.meanPacketSize = this.meanPacketSize == 0 ? this.deserializeContext.getNumBytes() : (int)Math.ceil(this.meanPacketSizeChangeLambda * (double)this.deserializeContext.getNumBytes() + (1.0 - this.meanPacketSizeChangeLambda) * (double)this.meanPacketSize);
                    this.stats.meanPacketSize = this.meanPacketSize;
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Packet deserialized [buffer=" + this.deserializeContext.getBuffer().toString() + " retained=" + bufferRetained + " packetSize=" + this.deserializeContext.getNumBytes() + "(" + this.meanPacketSize + ")]", Tracer.Level.DEBUG);
                    }
                    if (packetTracer.debug) {
                        packetTracer.log("[PTRACE.NWL<-] " + (Object)((Object)packet.getHeader()), Tracer.Level.DEBUG);
                    }
                    ILnkMessage iLnkMessage = message = messageFactory != null ? messageFactory.convert(packet) : null;
                    if (handler == null) continue;
                    if (list != null && messageFactory != null) {
                        if (message != null) {
                            if (this.tracer.debug) {
                                this.tracer.log(this.tracePrefix + "Adding message to dispatch list...", Tracer.Level.DEBUG);
                            }
                            list.append((UtlListElement)message);
                            continue;
                        }
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Received incovertible packet.", Tracer.Level.DEBUG);
                        }
                        if (list.count() > 0) {
                            if (this.tracer.debug) {
                                this.tracer.log(this.tracePrefix + "Dispatching message list completed thus far (count=" + list.count() + ")...", Tracer.Level.DEBUG);
                            }
                            handler.onEvent(dispatcher, 12, list);
                            list = UtlList.create();
                        }
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Dispatching inconvertible packet...", Tracer.Level.DEBUG);
                        }
                        handler.onEvent(dispatcher, 5, (Object)packet);
                        continue;
                    }
                    if (list != null) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Adding packet to dispatch list...", Tracer.Level.DEBUG);
                        }
                        list.append((UtlListElement)packet);
                        continue;
                    }
                    if (message != null) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Dispatching " + (message != null ? "message" : "packet") + "...", Tracer.Level.DEBUG);
                        }
                        handler.onEvent(dispatcher, 11, message);
                        continue;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Dispatching packet...", Tracer.Level.DEBUG);
                    }
                    handler.onEvent(dispatcher, 5, (Object)packet);
                    continue;
                }
                if (!this.tracer.debug) break;
                this.tracer.log(this.tracePrefix + "Insufficient space to deserialize packet [buffer=" + this.deserializeContext.getBuffer().toString() + " additional=" + this.deserializeContext.getNumBytes() + "]", Tracer.Level.DEBUG);
                break;
            }
            if (list != null && list.count() > 0 && handler != null) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Dispatching " + (messageFactory != null ? "message" : "packet") + " list (count=" + list.count() + ")...", Tracer.Level.DEBUG);
                }
                handler.onEvent(dispatcher, messageFactory != null ? 12 : 6, list);
            }
        }
        catch (Exception e) {
            if (packetBufferPos >= 0) {
                PktSerializable.DeserializeContext.dumpCorruptedPacketBuffer(this.tracePrefix + " Error deserializing packet from network link [" + e.getMessage() + "]", this.deserializeContext.getBuffer(), packetBufferPos, packetBufferLimit, e, this.tracer);
            }
            failure = e;
            throw e;
        }
        finally {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Deserialized " + numDeserialized + " packets (failure=" + failure + ")...", Tracer.Level.DEBUG);
            }
        }
        ByteBuffer postDeserializeBuffer = this.deserializeContext.getBuffer();
        int bufferRemaining = postDeserializeBuffer.remaining();
        int additionalBytesForLastPacket = bufferRemaining > 0 ? this.deserializeContext.getNumBytes() : 0;
        int lastPacketSize = additionalBytesForLastPacket > 0 ? bufferRemaining + additionalBytesForLastPacket : 0;
        int bufferRemainingSpace = bufferCapacity - bufferRemaining;
        int newSize = 0;
        if (additionalBytesForLastPacket > bufferRemainingSpace) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Insufficient space in buffer to accomodate packet.", Tracer.Level.DEBUG);
            }
            if (lastPacketSize > this.maxBufferSizeHard) {
                throw new RuntimeException("Inbound packet size is greater than the hard upper limit of the inbound buffer [packetSize=" + lastPacketSize + " maxBufferSize=" + this.maxBufferSizeHard + "]");
            }
            newSize = bufferCapacity + Math.max(additionalBytesForLastPacket - bufferRemainingSpace, fullBufferRead ? bytesRead : 0);
            ++this.stats.numInputBufGrowths;
        } else if (fullBufferRead && bufferCapacity < this.maxBufferSizeSoft) {
            newSize = Math.min(bufferCapacity + bytesRead, this.maxBufferSizeSoft);
            ++this.stats.numInputBufGrowths;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Sufficient space in buffer to accomodate packet but full buffer read.", Tracer.Level.DEBUG);
            }
        } else if ((this.shouldShrink || bufferCapacity > this.maxBufferSizeSoft) && numDeserialized > 0 && bufferCapacity > this.minBufferSize && (this.meanReadSize + bufferRemaining) * 2 < bufferCapacity && this.meanPacketSize * 2 < bufferCapacity && lastPacketSize * 2 < bufferCapacity) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Shrinking buffer.", Tracer.Level.DEBUG);
            }
            if ((newSize = Math.max(this.minBufferSize, (int)Math.ceil((double)bufferCapacity * this.retainedOnShrinkage))) == bufferCapacity) {
                newSize = 0;
            }
            ++this.stats.numInputBufShrinks;
        } else if (bufferRetained) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Buffer was retained. Copying to new buffer.", Tracer.Level.DEBUG);
            }
            newSize = bufferCapacity;
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Buffer was not retained. Continuing with existing buffer.", Tracer.Level.DEBUG);
        }
        this.stats.numInputBufBytesCompacted += (long)postDeserializeBuffer.remaining();
        if (newSize > 0) {
            ByteBuffer newBuffer = this.allocateBuffer(newSize);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Compacting to new buffer [oldBuffer=" + postDeserializeBuffer + " newBuffer=" + newBuffer + "]", Tracer.Level.DEBUG);
            }
            this.deserializeContext.setBuffer(newBuffer.put(postDeserializeBuffer));
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Compacting existing buffer.", Tracer.Level.DEBUG);
            }
            if (postDeserializeBuffer != readBuffer) {
                this.deserializeContext.setBuffer(((ByteBuffer)readBuffer.clear()).put(postDeserializeBuffer));
            } else {
                postDeserializeBuffer.compact();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Buffer after deserialization [" + this.deserializeContext.getBuffer().toString() + "]", Tracer.Level.DEBUG);
        }
        if (this.deserializeContext.getBuffer().remaining() == 0) {
            throw new InternalError("No space remaining in buffer after done with deserialize!");
        }
        return numDeserialized;
    }
}

