/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.network;

import com.neeve.ci.XRuntime;
import com.neeve.command.Command;
import com.neeve.command.ICommandHandler;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxNotOwnerException;
import com.neeve.emx.EEmxNwLnkClosedGracefullyException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.EmxNwLnkProps;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.emx.IEmxNwWriteReadyEvent;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkNotOwnerException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.ILnkMessageFactory;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkPeerEndpointCore;
import com.neeve.link.ILnkRootEndpoint;
import com.neeve.link.ILnkSTRRootEndpoint;
import com.neeve.link.LnkPeerEndpoint;
import com.neeve.link.network.LnkNwConfig;
import com.neeve.link.network.LnkNwObject;
import com.neeve.link.network.LnkNwPeerEndpointInputBuffer;
import com.neeve.link.network.LnkNwPeerEndpointOutputBuffer;
import com.neeve.link.network.LnkNwPeerEndpointStats;
import com.neeve.pkt.PktPacket;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlNet;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

final class LnkNwPeerEndpoint
extends LnkNwObject
implements ILnkPeerEndpointCore,
ILnkSTRRootEndpoint {
    private final IEmxNwLnkPeerEndpoint pep;
    private final UtlAddressDescriptor descriptor;
    private final String name;
    private final ILnkRootEndpoint.ThreadingModel threadingModel;
    private final boolean dispatchLists;
    private final int flushTimeout;
    private final IEmxDispatcher dispatcher;
    private final LnkNwPeerEndpointStats stats;
    private final SyncBlockingFlushWriteReadyEventHandler syncBlockingFlushWriteReadyEventHandler;
    private final AsyncFlushWriteReadyEventHandler asyncFlushWriteReadyEventHandler;
    private final ReadReadyEventHandler readReadyEventHandler;
    private final CloseEventHandler closeEventHandler;
    private final Object closure;
    private final Tracer packetTracer;
    private final LnkNwPeerEndpointOutputBuffer obuf;
    private final UtlList ibufs;
    private int ibufCounter;
    private LnkNwPeerEndpointInputBuffer ibuf;
    private volatile ILnkPeerEndpoint.State state;
    private volatile ILnkPeerEndpoint.AsynchronousFlushContext pendingFlushContext;
    private volatile ILnkEventHandlerCore handler;
    private final EmxNwLnkOpWaitCond readWaitCond;
    private final EmxNwLnkOpWaitCond flushWaitCond;
    private final boolean eagerRead;
    private final int maxEagerReadTime;
    private final int statsInterval;
    private IEmxDispatcher readDispatcher;
    private boolean flgReadReadyEventScheduled;
    private ILnkMessageFactory messageFactory;
    private boolean stampInOutTs;

    private LnkNwPeerEndpoint(IEmxNwLnkPeerEndpoint pep, UtlAddressDescriptor descriptor) throws ELnkException {
        ILnkRootEndpoint.ThreadingModel threadingModel;
        String name;
        this.pep = pep;
        this.descriptor = descriptor;
        String traceLevelStr = UtlProps.getValue((Map)descriptor.props, (String)"trace", null);
        if (traceLevelStr != null) {
            this.tracer.setLevel(Tracer.getLevel((String)traceLevelStr));
        }
        this.readWaitCond = new EmxNwLnkOpWaitCond();
        this.flushWaitCond = new EmxNwLnkOpWaitCond();
        try {
            HashMap props = new HashMap();
            ((ICommandHandler)pep).procCommand(Command.getprops.toString(), props);
            String localifaddr = UtlProps.getValue(props, (String)EmxNwLnkProps.Socket.localifaddr.toString(), null);
            String localifname = localifaddr != null ? UtlNet.inetAddrToName((String)localifaddr) : "<??>";
            int localport = UtlProps.getValue(props, (String)EmxNwLnkProps.Socket.localport.toString(), (int)0);
            String remoteifaddr = UtlProps.getValue(props, (String)EmxNwLnkProps.Socket.remoteifaddr.toString(), null);
            String remoteifname = remoteifaddr != null ? UtlNet.inetAddrToName((String)remoteifaddr) : "<??>";
            int remoteport = UtlProps.getValue(props, (String)EmxNwLnkProps.Socket.remoteport.toString(), (int)0);
            name = "<" + localifname + ":" + localport + "->" + remoteifname + ":" + remoteport + ">";
        }
        catch (Exception e) {
            this.tracer.log("Failed to get socket address information from underlying network link endpoint [" + e.toString() + "]. Unable to set endpoint name.", Tracer.Level.WARNING);
            name = this.toString();
        }
        this.name = name;
        String threadingModelStr = UtlProps.getValue((Map)descriptor.props, (String)"threadingmodel", (String)"strw");
        try {
            threadingModel = ILnkRootEndpoint.ThreadingModel.valueOf(threadingModelStr);
        }
        catch (IllegalArgumentException e) {
            threadingModel = ILnkRootEndpoint.ThreadingModel.strw;
        }
        this.threadingModel = threadingModel;
        this.dispatchLists = XRuntime.optimizeForLatency() ? false : UtlProps.getValue((Map)descriptor.props, (String)"dispatchlists", (boolean)UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.link.network.dispatchlists", (boolean)false));
        this.stampInOutTs = UtlProps.getValue((Map)descriptor.props, (String)"stampiots", (boolean)UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.link.network.stampiots", (boolean)false));
        this.eagerRead = XRuntime.conserveCPU() ? false : UtlProps.getValue((Map)descriptor.props, (String)"eagerread", (boolean)UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.link.network.eagerread", (XRuntime.optimizeForLatency() ? 1 : 0) != 0));
        this.maxEagerReadTime = UtlProps.getValue((Map)descriptor.props, (String)"maxeagerreadtime", (int)UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.link.network.maxeagerreadtime", (int)-1));
        this.flushTimeout = UtlProps.getValue((Map)descriptor.props, (String)"flushtimeout", (int)UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.link.network.flushtimeout", (int)0));
        this.statsInterval = UtlProps.getValue((Map)descriptor.props, (String)"statsinterval", (int)UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.link.network.stats.interval", (int)0));
        this.tracer.log("Network Link Endpoint Configuration...", Tracer.Level.CONFIG);
        this.tracer.log("....link=" + this.name, Tracer.Level.CONFIG);
        this.tracer.log("........threadingModel=" + (Object)((Object)this.threadingModel), Tracer.Level.CONFIG);
        this.tracer.log("........dispatchLists=" + this.dispatchLists, Tracer.Level.CONFIG);
        this.tracer.log("........stampInOutTs=" + this.stampInOutTs, Tracer.Level.CONFIG);
        this.tracer.log("........eagerRead=" + this.eagerRead, Tracer.Level.CONFIG);
        this.tracer.log("........maxEagerReadTime=" + this.maxEagerReadTime, Tracer.Level.CONFIG);
        this.tracer.log("........flushTimeout=" + this.flushTimeout, Tracer.Level.CONFIG);
        this.tracer.log("........statsInterval=" + this.statsInterval, Tracer.Level.CONFIG);
        try {
            this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, this.name, IEmxDispatcher.Params.create(false, false));
        }
        catch (EEmxException e) {
            throw new ELnkException((Throwable)((Object)e));
        }
        String statsIntervalPropName = "nv.link.network." + UUID.randomUUID().toString() + ".stats.interval";
        XRuntime.getProps().setProperty(statsIntervalPropName, String.valueOf(this.statsInterval));
        this.stats = new LnkNwPeerEndpointStats(this.name, statsIntervalPropName);
        this.syncBlockingFlushWriteReadyEventHandler = new SyncBlockingFlushWriteReadyEventHandler();
        this.asyncFlushWriteReadyEventHandler = new AsyncFlushWriteReadyEventHandler();
        this.readReadyEventHandler = new ReadReadyEventHandler();
        this.closeEventHandler = new CloseEventHandler();
        this.closure = new Object();
        this.ibufs = UtlList.create();
        this.ibuf = this.createInputBuffer();
        this.ibufs.append((UtlListElement)this.ibuf);
        this.obuf = this.createOutputBuffer();
        this.packetTracer = Tracer.get((String)"nv.packet");
        this.state = ILnkPeerEndpoint.State.CONNECTED;
    }

    static ILnkPeerEndpoint create(IEmxNwLnkPeerEndpoint emxPep, UtlAddressDescriptor descriptor) throws ELnkException {
        LnkNwPeerEndpoint pep = new LnkNwPeerEndpoint(emxPep, descriptor);
        return LnkPeerEndpoint.create(LnkNwConfig.getConfig(), pep, pep.descriptor.props, pep.descriptor.type);
    }

    private final LnkNwPeerEndpointInputBuffer createInputBuffer() {
        if (this.tracer.debug) {
            this.tracer.log("Creating input buffer #" + this.ibufCounter, Tracer.Level.DEBUG);
        }
        return new LnkNwPeerEndpointInputBuffer(this.name, this.ibufCounter++, this.tracer, XRuntime.optimizeForLatency() ? 34 : Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"mininputbuffersize", (int)8192), 128), XRuntime.optimizeForLatency() ? 34 : Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"maxinputbuffersize", (int)131072), 0), Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"hardmaxinputbuffersize", (int)0), 0), XRuntime.optimizeForLatency() ? true : UtlProps.getValue((Map)this.descriptor.props, (String)"usedirectinputbuffer", (boolean)true), Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"maxreadspintime", (int)0), 0), Math.min(Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"meanreadsizechangeweight", (double)0.1), 0.0), 1.0), Math.min(Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"meanpacketsizechangeweight", (double)0.1), 0.0), 1.0), UtlProps.getValue((Map)this.descriptor.props, (String)"shrinkinputbuffer", (boolean)false), Math.min(Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"inputbuffershrinkage", (int)10), 0), 50), this.stampInOutTs, this.stats);
    }

    private final LnkNwPeerEndpointOutputBuffer createOutputBuffer() {
        return new LnkNwPeerEndpointOutputBuffer(this.name, this.tracer, XRuntime.optimizeForLatency() ? 1 : Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"autoflushsize", (int)8192), 0), Math.max(UtlProps.getValue((Map)this.descriptor.props, (String)"maxoutputbuffersize", (int)0), 0), XRuntime.optimizeForLatency() ? true : UtlProps.getValue((Map)this.descriptor.props, (String)"usedirectoutputbuffer", (boolean)true), this.stampInOutTs, this.stats);
    }

    private final void closeFinal(IEmxDispatcher dispatcher) throws ELnkOpFailedException {
        this.stats.close();
        try {
            this.pep.close();
        }
        catch (EEmxException e) {
            throw new ELnkOpFailedException((Throwable)((Object)e));
        }
        try {
            this.dispatcher.close(false);
        }
        catch (EEmxException e) {
            throw new ELnkOpFailedException((Throwable)((Object)e));
        }
        this.state = ILnkPeerEndpoint.State.CLOSED;
        this.handler.onEvent(dispatcher, 9, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void startReadUnprotected(IEmxDispatcher dispatcher, int flags) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.tracer.debug) {
            this.tracer.log("Starting read on network endpoint...", Tracer.Level.DEBUG);
        }
        if (this.state != ILnkPeerEndpoint.State.CONNECTED) {
            if (!this.tracer.debug) throw new ELnkInvalidStateException("read start", this.state.toString());
            this.tracer.log("Invalid state on read start [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("read start", this.state.toString());
        }
        if (!this.isReadOperational()) {
            if (dispatcher.getOwner() != Thread.currentThread()) throw new ELnkNotOwnerException();
            this.readDispatcher = dispatcher;
            IEmxUserEvent event = (IEmxUserEvent)EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, this.readReadyEventHandler).setPriority(31);
            this.readDispatcher.schedUserEv(event);
            if (!this.tracer.debug) return;
            this.tracer.log("Scheduled event to start read.", Tracer.Level.DEBUG);
            return;
        }
        if (!this.tracer.debug) throw new ELnkInvalidStateException("read start", "read operational");
        this.tracer.log("Read already operational.", Tracer.Level.DEBUG);
        throw new ELnkInvalidStateException("read start", "read operational");
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void scheduleReadUnprotected() throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.tracer.debug) {
            this.tracer.log("Scheduling read on network endpoint...", Tracer.Level.DEBUG);
        }
        if (this.state != ILnkPeerEndpoint.State.CONNECTED) {
            if (!this.tracer.debug) throw new ELnkInvalidStateException("read schedule", this.state.toString());
            this.tracer.log("Invalid state on read schedule [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("read schedule", this.state.toString());
        }
        if (this.isReadOperational()) {
            if (this.readDispatcher.getOwner() != Thread.currentThread()) throw new ELnkNotOwnerException();
            IEmxUserEvent event = (IEmxUserEvent)EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, this.readReadyEventHandler).setPriority(31);
            this.readDispatcher.schedUserEv(event);
            if (!this.tracer.debug) return;
            this.tracer.log("Scheduled event to perform read.", Tracer.Level.DEBUG);
            return;
        }
        if (!this.tracer.debug) throw new ELnkInvalidStateException("read schedule", "read not operational");
        this.tracer.log("Read not operational.", Tracer.Level.DEBUG);
        throw new ELnkInvalidStateException("read schedule", "read not operational");
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void stopReadUnprotected(int flags) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.tracer.debug) {
            this.tracer.log("Stopping read on network endpoint...", Tracer.Level.DEBUG);
        }
        if (this.state == ILnkPeerEndpoint.State.CLOSED) {
            if (!this.tracer.debug) throw new ELnkInvalidStateException("read stop", this.state.toString());
            this.tracer.log("Invalid state on read stop [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("read stop", this.state.toString());
        }
        if (!this.isReadOperational()) {
            if (!this.tracer.debug) throw new ELnkInvalidStateException("read stop", "read not operational");
            this.tracer.log("Read not operational.", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("read stop", "read not operational");
        }
        if (this.readDispatcher.getOwner() != Thread.currentThread()) throw new ELnkNotOwnerException();
        if (this.flgReadReadyEventScheduled) {
            if (this.tracer.debug) {
                this.tracer.log("Unscheduling scheduled read ready event from read dispatcher...", Tracer.Level.DEBUG);
            }
            this.readDispatcher.unschedNwReadReadyEv((IEmxNwReadReadyEvent)this.readWaitCond.list().get(0));
            this.flgReadReadyEventScheduled = false;
        } else if (this.tracer.debug) {
            this.tracer.log("No read ready event scheduled with read dispatcher.", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("Read stopped on network endpoint.", Tracer.Level.DEBUG);
        }
        this.readDispatcher = null;
        this.readWaitCond.list().removeFromTo(0, this.readWaitCond.list().size() - 1);
    }

    private final void closeUnprotected() throws ELnkOpFailedException {
        if (this.pendingFlushContext != null) {
            throw new InternalError("close() invoked when a flush is pending completion");
        }
        if (this.tracer.debug) {
            this.tracer.log("Closing network endpoint...", Tracer.Level.DEBUG);
        }
        if (this.isReadOperational()) {
            if (this.tracer.debug) {
                this.tracer.log("Endpoint read is operational. Scheduling event to stop read and finish the close...", Tracer.Level.DEBUG);
            }
            this.state = ILnkPeerEndpoint.State.CLOSING;
            IEmxUserEvent event = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, this.closeEventHandler);
            this.readDispatcher.schedUserEv(event);
        } else {
            if (this.tracer.debug) {
                this.tracer.log("Endpoint read is not operational. Closing...", Tracer.Level.DEBUG);
            }
            this.closeFinal(null);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final short getLtp() {
        return 0;
    }

    @Override
    public short getPeerLtp() {
        return 0;
    }

    @Override
    public final boolean isGroupEndpoint() {
        return false;
    }

    @Override
    public final boolean isRootEndpoint() {
        return true;
    }

    @Override
    public final ILnkRootEndpoint getRootEndpoint() {
        return this;
    }

    @Override
    public final int getEnqueuedSize() {
        if (this.state != ILnkPeerEndpoint.State.CONNECTED) {
            throw new InternalError("getEnqueuedSize() %invoked while endpoint is closing!");
        }
        return this.obuf.getSize();
    }

    @Override
    public final void setEventHandler(ILnkEventHandlerCore handler) {
        if (this.state != ILnkPeerEndpoint.State.CONNECTED) {
            throw new InternalError("setEventHandler() invoked while endpoint is closing!");
        }
        if (this.tracer.debug) {
            this.tracer.log("Setting event handler in network endpoint...", Tracer.Level.DEBUG);
        }
        this.handler = handler;
    }

    @Override
    public final void join(short ltp) {
        if (this.state != ILnkPeerEndpoint.State.CONNECTED) {
            throw new InternalError("join() invoked while endpoint is closing!");
        }
    }

    @Override
    public final void leave(short ltp) {
        if (this.state != ILnkPeerEndpoint.State.CONNECTED) {
            throw new InternalError("leave() invoked while endpoint is closing!");
        }
    }

    @Override
    public final boolean enque(PktPacket packet, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws ELnkOpFailedException {
        boolean flgFlushSuppress;
        if (this.state != ILnkPeerEndpoint.State.CONNECTED) {
            throw new InternalError("enque() invoked while endpoint is closing!");
        }
        if (this.packetTracer.debug) {
            this.packetTracer.log("[PTRACE.NWL->] " + (Object)((Object)packet.getHeader()), Tracer.Level.DEBUG);
        }
        boolean bl = flgFlushSuppress = (flags & 8) == 8;
        if (this.tracer.debug) {
            this.tracer.log("Enqueuing packet in network endpoint [packet=" + (Object)((Object)packet) + " flushSuppress=" + flgFlushSuppress + "]...", Tracer.Level.DEBUG);
        }
        if (flushContext != null) {
            flushContext.reset();
        }
        boolean toFlush = this.obuf.serialize(packet);
        boolean flushed = false;
        flushed = toFlush && !flgFlushSuppress;
        if (flushed) {
            if (this.tracer.debug) {
                this.tracer.log("Flushing on enque...", Tracer.Level.DEBUG);
            }
            this.flush(flushContext);
        }
        return flushed;
    }

    @Override
    public final void flush(ILnkPeerEndpoint.FlushContext flushContext) throws ELnkOpFailedException {
        boolean drained;
        boolean syncNonBlockingFlush;
        if (this.state != ILnkPeerEndpoint.State.CONNECTED) {
            throw new InternalError("flush() invoked while endpoint is closing!");
        }
        boolean syncBlockingFlush = flushContext == null || flushContext.flushMode == ILnkPeerEndpoint.FlushContext.FlushMode.SYNC_BLOCKING;
        boolean bl = syncNonBlockingFlush = flushContext != null && flushContext.flushMode == ILnkPeerEndpoint.FlushContext.FlushMode.SYNC_NON_BLOCKING;
        if (this.tracer.debug) {
            this.tracer.log("Flushing network endpoint [syncB=" + syncBlockingFlush + " syncNb=" + syncNonBlockingFlush + "]...", Tracer.Level.DEBUG);
        }
        if (flushContext != null) {
            flushContext.reset();
        }
        try {
            drained = this.obuf.flush(this.pep, this.flushWaitCond);
            ++this.stats.numFlushes;
            if (this.tracer.debug) {
                this.tracer.log("Buffer flush complete [drained=" + drained + "].", Tracer.Level.DEBUG);
            }
        }
        catch (Exception e) {
            if (this.tracer.debug) {
                this.tracer.log("Buffer flush threw exception [" + e.toString() + "].", Tracer.Level.DEBUG);
            }
            throw new ELnkOpFailedException(e);
        }
        if (syncBlockingFlush) {
            if (this.tracer.debug) {
                this.tracer.log("Sync blocking flush [drained=" + drained + "].", Tracer.Level.DEBUG);
            }
            if (!drained) {
                long end;
                if (this.tracer.debug) {
                    this.tracer.log("Completing flush synchronously...", Tracer.Level.DEBUG);
                }
                this.dispatcher.setOwner(0);
                this.dispatcher.schedNwWriteReadyEv((IEmxNwWriteReadyEvent)((IEmxEvent)this.flushWaitCond.list().get(0)).setHandler(this.syncBlockingFlushWriteReadyEventHandler.reset()));
                long start = System.currentTimeMillis();
                long l = end = this.flushTimeout > 0 ? start + (long)this.flushTimeout : Long.MAX_VALUE;
                while (!this.syncBlockingFlushWriteReadyEventHandler.done && System.currentTimeMillis() < end) {
                    this.dispatcher.run(100);
                }
                if (!this.syncBlockingFlushWriteReadyEventHandler.done) {
                    this.syncBlockingFlushWriteReadyEventHandler.status = new ELnkOpFailedException("flush timed out [timeout=" + this.flushTimeout + "ms]");
                }
                if (this.tracer.debug) {
                    this.tracer.log("Flush complete [status=" + (Object)((Object)this.syncBlockingFlushWriteReadyEventHandler.status) + "]...", Tracer.Level.DEBUG);
                }
                if (this.syncBlockingFlushWriteReadyEventHandler.status != null) {
                    throw new ELnkOpFailedException((Throwable)((Object)this.syncBlockingFlushWriteReadyEventHandler.status));
                }
            }
            if (flushContext != null) {
                ILnkPeerEndpoint.SynchronousBlockingFlushContext syncBlockingFlushContext = (ILnkPeerEndpoint.SynchronousBlockingFlushContext)flushContext;
                syncBlockingFlushContext.complete = true;
            }
            ++this.stats.numFlushesSync;
        } else if (syncNonBlockingFlush) {
            if (this.tracer.debug) {
                this.tracer.log("Sync non-blocking flush [drained=" + drained + "].", Tracer.Level.DEBUG);
            }
            ILnkPeerEndpoint.SynchronousNonBlockingFlushContext syncNonBlockingFlushContext = (ILnkPeerEndpoint.SynchronousNonBlockingFlushContext)flushContext;
            syncNonBlockingFlushContext.complete = drained;
            if (drained) {
                ++this.stats.numFlushesSync;
            }
        } else {
            ILnkPeerEndpoint.AsynchronousFlushContext asyncFlushContext = (ILnkPeerEndpoint.AsynchronousFlushContext)flushContext;
            asyncFlushContext.syncComplete = drained;
            boolean bl2 = asyncFlushContext.inProgress = !drained;
            if (this.tracer.debug) {
                this.tracer.log("Async flush [drained=" + drained + "].", Tracer.Level.DEBUG);
            }
            if (!drained) {
                if (this.tracer.debug) {
                    this.tracer.log("Kicking off background completion machinery...", Tracer.Level.DEBUG);
                }
                this.pendingFlushContext = asyncFlushContext;
                try {
                    asyncFlushContext.dispatcher.schedEv(((IEmxEvent)this.flushWaitCond.list().get(0)).setHandler(this.asyncFlushWriteReadyEventHandler.reset()));
                }
                catch (EEmxNotOwnerException e) {
                    throw new ELnkNotOwnerException(asyncFlushContext.dispatcher);
                }
            }
            if (drained) {
                ++this.stats.numFlushesSync;
            }
        }
    }

    @Override
    public final ILnkRootEndpoint.ThreadingModel getThreadingModel() {
        return this.threadingModel;
    }

    @Override
    public final boolean isReadOperational() {
        return this.readDispatcher != null;
    }

    @Override
    public final void registerMessageFactory(ILnkMessageFactory messageFactory) {
        if (this.isReadOperational()) {
            throw new IllegalStateException("a message factory cannot be registered once the read has been started");
        }
        this.messageFactory = messageFactory;
    }

    @Override
    public void enableIOTimestamps(boolean enabled) {
        if (this.isReadOperational()) {
            throw new IllegalStateException("a message factory cannot be registered once the read has been started");
        }
        if (enabled != this.stampInOutTs) {
            this.ibuf.enableIOTimestamps(enabled);
            this.obuf.enableIOTimestamps(enabled);
            this.stampInOutTs = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startRead(IEmxDispatcher dispatcher, int flags) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.threaded) {
            Object object = this.closure;
            synchronized (object) {
                this.startReadUnprotected(dispatcher, flags);
            }
        } else {
            this.startReadUnprotected(dispatcher, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void scheduleRead() throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.threaded) {
            Object object = this.closure;
            synchronized (object) {
                this.scheduleReadUnprotected();
            }
        } else {
            this.scheduleReadUnprotected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopRead(int flags) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.threaded) {
            Object object = this.closure;
            synchronized (object) {
                this.stopReadUnprotected(flags);
            }
        } else {
            this.stopReadUnprotected(flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws ELnkOpFailedException {
        if (this.threaded) {
            Object object = this.closure;
            synchronized (object) {
                this.closeUnprotected();
            }
        } else {
            this.closeUnprotected();
        }
    }

    private final class CloseEventHandler
    implements IEmxEventHandler {
        private CloseEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                LnkNwPeerEndpoint.this.tracer.log("Received close event.", Tracer.Level.DEBUG);
            }
            if (LnkNwPeerEndpoint.this.isReadOperational()) {
                try {
                    LnkNwPeerEndpoint.this.stopReadUnprotected(0);
                }
                catch (Exception e) {
                    LnkNwPeerEndpoint.this.tracer.log("Failure to stop read during deferred close [" + e.toString() + "].", Tracer.Level.WARNING);
                }
            }
            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                LnkNwPeerEndpoint.this.tracer.log("Closing endpoint...", Tracer.Level.DEBUG);
            }
            try {
                LnkNwPeerEndpoint.this.closeFinal(dispatcher);
            }
            catch (Exception e) {
                LnkNwPeerEndpoint.this.tracer.log("Failure in closing underlying network endpoint during deferred close [" + e.toString() + "].", Tracer.Level.WARNING);
            }
            return false;
        }
    }

    private final class ReadReadyEventHandler
    implements IEmxEventHandler {
        ReadReadyEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                if (event.getType() == IEmxEvent.EventType.NW_READ_READY) {
                    LnkNwPeerEndpoint.this.tracer.log("Received read ready event.", Tracer.Level.DEBUG);
                } else {
                    LnkNwPeerEndpoint.this.tracer.log("Received read start event.", Tracer.Level.DEBUG);
                }
            }
            if (LnkNwPeerEndpoint.this.isReadOperational()) {
                LnkNwPeerEndpointInputBuffer ibuf;
                if (event.getType() == IEmxEvent.EventType.NW_READ_READY) {
                    LnkNwPeerEndpoint.this.flgReadReadyEventScheduled = false;
                }
                if ((ibuf = LnkNwPeerEndpoint.this.ibuf).next() == null) {
                    LnkNwPeerEndpoint.this.ibufs.append((UtlListElement)LnkNwPeerEndpoint.this.createInputBuffer());
                }
                LnkNwPeerEndpoint.this.ibuf = (LnkNwPeerEndpointInputBuffer)ibuf.next();
                ELnkException failure = null;
                try {
                    long startTime = LnkNwPeerEndpoint.this.eagerRead ? UtlTime.now() : 0L;
                    do {
                        try {
                            int batchSize = ibuf.readDeserializeAndDispatch(LnkNwPeerEndpoint.this.pep, dispatcher, LnkNwPeerEndpoint.this.readWaitCond, LnkNwPeerEndpoint.this.messageFactory, LnkNwPeerEndpoint.this.dispatchLists, LnkNwPeerEndpoint.this.handler, LnkNwPeerEndpoint.this.packetTracer);
                            ++((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).stats.numPacketBatchesRead;
                            if (batchSize > ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).stats.maxBatchSize) {
                                ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).stats.maxBatchSize = batchSize;
                            }
                            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).stats.minBatchSize == 0 || batchSize > 0 && batchSize < ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).stats.minBatchSize) {
                                ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).stats.minBatchSize = batchSize;
                            }
                            if (batchSize != 0) continue;
                            break;
                        }
                        catch (EEmxNwLnkClosedGracefullyException closed) {
                            failure = new ELnkException("Network link was closed");
                            ((Throwable)((Object)failure)).initCause((Throwable)((Object)closed));
                        }
                        catch (EEmxNwLnkOpFailedException readFailure) {
                            LnkNwPeerEndpoint.this.tracer.log("Failure during read/deserialize/dispatch [" + readFailure.toString() + "]. Failing endpoint...", Tracer.Level.WARNING);
                            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                                LnkNwPeerEndpoint.this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)((Object)readFailure)), Tracer.Level.DEBUG);
                            }
                            failure = new ELnkException("Failure during read/deserialize/dispatch [" + readFailure.toString() + "].");
                            ((Throwable)((Object)failure)).initCause((Throwable)((Object)readFailure));
                        }
                        catch (Throwable t) {
                            LnkNwPeerEndpoint.this.tracer.log("Failure during read/deserialize/dispatch [" + t.toString() + "]. Failing endpoint...", Tracer.Level.WARNING);
                            LnkNwPeerEndpoint.this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)t), Tracer.Level.WARNING);
                            failure = new ELnkException("Failure during read/deserialize/dispatch [" + t.toString() + "].");
                            ((Throwable)((Object)failure)).initCause(t);
                        }
                    } while (failure == null && LnkNwPeerEndpoint.this.isReadOperational() && LnkNwPeerEndpoint.this.eagerRead && (LnkNwPeerEndpoint.this.maxEagerReadTime <= 0 || UtlTime.now() - startTime < (long)LnkNwPeerEndpoint.this.maxEagerReadTime));
                }
                finally {
                    LnkNwPeerEndpoint.this.ibuf = ibuf;
                }
                if (failure == null && LnkNwPeerEndpoint.this.isReadOperational() && LnkNwPeerEndpoint.this.readWaitCond.list().size() > 0 && !LnkNwPeerEndpoint.this.flgReadReadyEventScheduled) {
                    if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                        LnkNwPeerEndpoint.this.tracer.log("Scheduling read ready event on network link...", Tracer.Level.DEBUG);
                    }
                    try {
                        LnkNwPeerEndpoint.this.readDispatcher.schedNwReadReadyEv((IEmxNwReadReadyEvent)((IEmxEvent)LnkNwPeerEndpoint.this.readWaitCond.list().get(0)).setHandler(this));
                        LnkNwPeerEndpoint.this.flgReadReadyEventScheduled = true;
                    }
                    catch (Exception e) {
                        LnkNwPeerEndpoint.this.tracer.log("Failure in scheduling read event on read start [" + e.toString() + "]. Failing endpoint...", Tracer.Level.WARNING);
                        LnkNwPeerEndpoint.this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                        failure = new ELnkException("Failure in scheduling read ready event [" + e.toString() + "]");
                        ((Throwable)((Object)failure)).initCause(e);
                    }
                }
                if (failure != null) {
                    try {
                        LnkNwPeerEndpoint.this.stopRead(0);
                    }
                    catch (Exception e) {
                        LnkNwPeerEndpoint.this.tracer.log("Failure in stopping read on network link failure [" + e.toString() + "].", Tracer.Level.WARNING);
                    }
                    if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                        LnkNwPeerEndpoint.this.tracer.log("Network link failure [" + ((Throwable)((Object)failure)).toString() + "].", Tracer.Level.DEBUG);
                    }
                    if (LnkNwPeerEndpoint.this.handler != null) {
                        if (LnkNwPeerEndpoint.this.state == ILnkPeerEndpoint.State.CONNECTED) {
                            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                                LnkNwPeerEndpoint.this.tracer.log("Dispatching network link failure event...", Tracer.Level.DEBUG);
                            }
                            try {
                                LnkNwPeerEndpoint.this.handler.onEvent(dispatcher, 8, (Object)failure);
                            }
                            catch (Exception e) {
                                LnkNwPeerEndpoint.this.tracer.log("Received exception from network link failure handler [" + e.toString() + "]. Ignoring...", Tracer.Level.WARNING);
                            }
                        } else if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                            LnkNwPeerEndpoint.this.tracer.log("Not dispatching network link failure event [link is not CONNECTED]...", Tracer.Level.DEBUG);
                        }
                    } else if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                        LnkNwPeerEndpoint.this.tracer.log("No handler to dispatch failure event.", Tracer.Level.DEBUG);
                    }
                }
                return false;
            }
            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                LnkNwPeerEndpoint.this.tracer.log("Read was stopped on network endpoint while start was pending. Not starting.", Tracer.Level.DEBUG);
            }
            return false;
        }
    }

    private final class AsyncFlushWriteReadyEventHandler
    implements IEmxEventHandler {
        private AsyncFlushWriteReadyEventHandler() {
        }

        final AsyncFlushWriteReadyEventHandler reset() {
            return this;
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                LnkNwPeerEndpoint.this.tracer.log("Received write ready event for async flush. Retrying flush...", Tracer.Level.DEBUG);
            }
            try {
                ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).pendingFlushContext.inProgress = !LnkNwPeerEndpoint.this.obuf.flush(LnkNwPeerEndpoint.this.pep, LnkNwPeerEndpoint.this.flushWaitCond);
            }
            catch (Exception e) {
                ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).pendingFlushContext.inProgress = false;
                ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).pendingFlushContext.status = new ELnkOpFailedException(e);
            }
            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                LnkNwPeerEndpoint.this.tracer.log("Flush complete [inProgress=" + ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).pendingFlushContext.inProgress + " status=" + ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).pendingFlushContext.status + "].", Tracer.Level.DEBUG);
            }
            if (!((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).pendingFlushContext.inProgress) {
                ((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).pendingFlushContext.syncComplete = false;
                ILnkEventHandlerCore handler = LnkNwPeerEndpoint.this.handler;
                if (handler != null) {
                    ILnkPeerEndpoint.AsynchronousFlushContext asyncFlushContext = LnkNwPeerEndpoint.this.pendingFlushContext;
                    LnkNwPeerEndpoint.this.pendingFlushContext = null;
                    handler.onEvent(dispatcher, 7, asyncFlushContext);
                }
                return false;
            }
            return true;
        }
    }

    private final class SyncBlockingFlushWriteReadyEventHandler
    implements IEmxEventHandler {
        boolean done;
        ELnkOpFailedException status;

        private SyncBlockingFlushWriteReadyEventHandler() {
        }

        final SyncBlockingFlushWriteReadyEventHandler reset() {
            this.done = false;
            this.status = null;
            return this;
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                LnkNwPeerEndpoint.this.tracer.log("Received write ready event for sync non-blocking flush. Retrying flush...", Tracer.Level.DEBUG);
            }
            try {
                this.done = LnkNwPeerEndpoint.this.obuf.flush(LnkNwPeerEndpoint.this.pep, LnkNwPeerEndpoint.this.flushWaitCond);
            }
            catch (Exception e) {
                this.done = true;
                this.status = new ELnkOpFailedException(e);
            }
            if (((LnkNwPeerEndpoint)LnkNwPeerEndpoint.this).tracer.debug) {
                LnkNwPeerEndpoint.this.tracer.log("Completed flush [done=" + this.done + " status=" + (Object)((Object)this.status) + "].", Tracer.Level.DEBUG);
            }
            return !this.done;
        }
    }
}

