/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.ci.XRuntime;
import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkClosedGracefullyException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.emx.IEmxNwWriteReadyEvent;
import com.neeve.emx.test.unit.EmxNwLnkClientEndpointTest;
import com.neeve.emx.test.unit.EmxNwLnkEndpointTest;
import com.neeve.emx.test.unit.EmxNwLnkServerEndpointTest;
import java.nio.ByteBuffer;
import org.junit.Test;

public final class EmxNwLnkPeerEndpointTest
extends EmxNwLnkEndpointTest {
    private long remaining(ByteBuffer[] buffers) {
        long remaining = 0L;
        if (buffers != null) {
            for (int i = 0; i < buffers.length; ++i) {
                remaining += (long)buffers[i].remaining();
            }
        }
        return remaining;
    }

    private IEmxNwLnkPeerEndpoint connect(IEmxNwLnkClientEndpoint cep) throws Exception {
        try {
            IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
            return pep;
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Failed to establish connection [" + e.toString() + "]"));
            return null;
        }
    }

    private IEmxNwLnkPeerEndpoint accept(IEmxNwLnkServerEndpoint sep) throws Exception {
        try {
            IEmxNwLnkPeerEndpoint pep = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
            if (pep == null) {
                EmxNwLnkPeerEndpointTest.testFailure((String)"No connection pending to be accepted!");
            }
            return pep;
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Failed to accept connection [" + e.toString() + "]"));
            return null;
        }
    }

    static IEmxNwReadReadyEvent prepareNwReadReadyEvent(IEmxNwLnkPeerEndpoint pep) throws Exception {
        int count;
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        while ((count = pep.read(ByteBuffer.allocate(8192), waitCond)) > 0) {
        }
        return (IEmxNwReadReadyEvent)waitCond.list().get(0);
    }

    static IEmxNwWriteReadyEvent prepareNwWriteReadyEvent(IEmxNwLnkPeerEndpoint pep) throws Exception {
        long count;
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(8192)};
        while ((count = pep.write(buffers, buffers.length, waitCond)) > 0L) {
        }
        return (IEmxNwWriteReadyEvent)waitCond.list().get(0);
    }

    private void testRead(IEmxNwLnkPeerEndpoint pep, String desc, Exception exp, int expBytesRead, ByteBuffer expBuffer) throws Exception {
        try {
            EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
            ByteBuffer buffer = ByteBuffer.allocate(expBuffer != null ? expBuffer.capacity() : 1);
            int bytesRead = pep.read(buffer, waitCond);
            buffer.flip();
            if (exp != null) {
                EmxNwLnkPeerEndpointTest.testFailure((String)("Peer endpoint read [desc=" + desc + "] should have thrown an exception! [exp=" + exp.getClass().getName() + "]"));
            } else {
                if (expBytesRead == bytesRead) {
                    if (bytesRead != 0) {
                        if (!expBuffer.equals(buffer)) {
                            EmxNwLnkPeerEndpointTest.testFailure((String)"Read returned successfully but the data read is different from expected!");
                        }
                    } else {
                        if (buffer.remaining() > 0) {
                            EmxNwLnkPeerEndpointTest.testFailure((String)"Read returned with zero bytes but buffer position was advanced!");
                        }
                        if (waitCond.list().size() == 0) {
                            EmxNwLnkPeerEndpointTest.testFailure((String)"Read returned 'read pending' but has not set any wait condition!");
                        }
                    }
                } else {
                    EmxNwLnkPeerEndpointTest.testFailure((String)("Peer endpoint read [desc=" + desc + "] returned incorrect number of bytes read [exp=" + expBytesRead + " actual=" + bytesRead + "]"));
                }
                EmxNwLnkPeerEndpointTest.testSuccess((String)("Peer endpoint read successfully [desc=" + desc + "]"));
            }
        }
        catch (Exception e) {
            if (exp != null && exp.getClass().isInstance(e)) {
                EmxNwLnkPeerEndpointTest.testSuccess((String)("Peer endpoint read [desc=" + desc + "] successfully threw exception [" + e.toString() + "]"));
            }
            EmxNwLnkPeerEndpointTest.testFailure((String)("Peer endpoint read [desc=" + desc + "] threw incorrect exception [exp=" + (exp != null ? exp.getClass().getName() : "null") + " actual=" + e.toString() + "]"));
        }
    }

    private void testWrite(IEmxNwLnkPeerEndpoint pep, String desc, Exception exp, int expBytesWritten, ByteBuffer[] buffers) throws Exception {
        try {
            long remaining = this.remaining(buffers);
            EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
            long bytesWritten = pep.write(buffers, buffers != null ? buffers.length : 0, waitCond);
            if (exp != null) {
                EmxNwLnkPeerEndpointTest.testFailure((String)("Peer endpoint write [desc=" + desc + "] should have thrown an exception! [exp=" + exp.getClass().getName() + "]"));
            } else {
                if ((long)expBytesWritten == bytesWritten) {
                    if (bytesWritten == 0L) {
                        if (this.remaining(buffers) != remaining) {
                            EmxNwLnkPeerEndpointTest.testFailure((String)("Write returned with zero bytes but remaining count in buffers changed [exp= " + remaining + " actual=" + this.remaining(buffers) + "]"));
                        }
                        if (buffers[buffers.length - 1].remaining() != 0 && waitCond.list().size() == 0) {
                            EmxNwLnkPeerEndpointTest.testFailure((String)"Write returned with zero bytes bytes remaining to be written but no wait condition is set!");
                        }
                    }
                } else {
                    EmxNwLnkPeerEndpointTest.testFailure((String)("Peer endpoint write [desc=" + desc + "] returned incorrect number of bytes written [exp=" + expBytesWritten + " actual=" + bytesWritten + "]"));
                }
                EmxNwLnkPeerEndpointTest.testSuccess((String)("Peer endpoint write successfully [desc=" + desc + "]"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (exp != null && exp.getClass().isInstance(e)) {
                EmxNwLnkPeerEndpointTest.testSuccess((String)("Peer endpoint write [desc=" + desc + "] successfully threw exception [" + e.toString() + "]"));
            }
            EmxNwLnkPeerEndpointTest.testFailure((String)("Peer endpoint write [desc=" + desc + "] threw incorrect exception [exp=" + (exp != null ? exp.getClass().getName() : "null") + " actual=" + e.toString() + "]"));
        }
    }

    private void testReadNoInboundData(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        this.testRead(pep1, desc + "(connect)", null, 0, null);
        this.testRead(pep2, desc + "(accept)", null, 0, null);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
    }

    private void testReadWithLessBuffer(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(100), ByteBuffer.allocate(100)};
        buffers[0].clear();
        buffers[1].clear();
        this.testWrite(pep1, desc + "(connect)", null, 200, buffers);
        buffers[0].clear();
        buffers[1].clear();
        this.testWrite(pep2, desc + "(accept)", null, 200, buffers);
        buffers[0].clear();
        this.testRead(pep1, desc + "(connect)", null, buffers[0].remaining(), buffers[0]);
        this.testRead(pep2, desc + "(accept)", null, buffers[0].remaining(), buffers[0]);
        buffers[1].clear();
        this.testRead(pep1, desc + "(connect)", null, buffers[1].remaining(), buffers[1]);
        this.testRead(pep2, desc + "(accept)", null, buffers[1].remaining(), buffers[1]);
        this.testRead(pep1, desc + "(connect)", null, 0, null);
        this.testRead(pep2, desc + "(accept)", null, 0, null);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
    }

    private void testReadWithEqualBuffer(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(100)};
        buffers[0].clear();
        this.testWrite(pep1, desc + "(connect)", null, 100, buffers);
        buffers[0].clear();
        this.testWrite(pep2, desc + "(accept)", null, 100, buffers);
        buffers[0].clear();
        this.testRead(pep1, desc + "(connect)", null, buffers[0].remaining(), buffers[0]);
        this.testRead(pep2, desc + "(accept)", null, buffers[0].remaining(), buffers[0]);
        this.testRead(pep1, desc + "(connect)", null, 0, null);
        this.testRead(pep2, desc + "(accept)", null, 0, null);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
    }

    private void testReadWithMoreBuffer(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(100)};
        buffers[0].clear();
        this.testWrite(pep1, desc + "(connect)", null, 100, buffers);
        buffers[0].clear();
        this.testWrite(pep2, desc + "(accept)", null, 100, buffers);
        ByteBuffer buffer = ByteBuffer.allocate(110);
        buffer.put((ByteBuffer)buffers[0].clear()).flip();
        this.testRead(pep1, desc + "(connect)", null, buffer.remaining(), buffer);
        this.testRead(pep2, desc + "(accept)", null, buffer.remaining(), buffer);
        this.testRead(pep1, desc + "(connect)", null, 0, null);
        this.testRead(pep2, desc + "(accept)", null, 0, null);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
    }

    private void testReadAfterPeerClose(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
        this.testRead(pep1, desc + "(connect)", (Exception)((Object)new EEmxNwLnkClosedGracefullyException()), 0, null);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        pep1 = this.connect(cep);
        pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        this.testRead(pep2, desc + "(accept)", (Exception)((Object)new EEmxNwLnkClosedGracefullyException()), 0, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
    }

    private void testReadAfterClose(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        this.testRead(pep1, desc + "(connect)", (Exception)((Object)new EEmxInvalidStateException("", "")), 0, null);
        this.testRead(pep2, desc + "(accept)", (Exception)((Object)new EEmxInvalidStateException("", "")), 0, null);
    }

    private void testWriteZeroBytes(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        ByteBuffer[] buffers = new ByteBuffer[]{(ByteBuffer)ByteBuffer.allocate(100).flip()};
        this.testWrite(pep1, desc + "(connect)", null, 0, buffers);
        this.testWrite(pep2, desc + "(accept)", null, 0, buffers);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
    }

    private void testWriteCongested(EmxFactory.EmxImpl impl, String desc) throws Exception {
        long bytesWritten;
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(100), ByteBuffer.allocate(1000), ByteBuffer.allocate(150)};
        do {
            buffers[0].clear();
            buffers[1].clear();
            buffers[2].clear();
        } while ((bytesWritten = pep1.write(buffers, buffers.length, new EmxNwLnkOpWaitCond())) != 0L);
        do {
            buffers[0].clear();
            buffers[1].clear();
            buffers[2].clear();
        } while ((bytesWritten = pep2.write(buffers, buffers.length, new EmxNwLnkOpWaitCond())) != 0L);
        buffers[0].clear();
        buffers[1].clear();
        buffers[2].clear();
        this.testWrite(pep1, desc + "(connect)", null, 0, buffers);
        buffers[0].clear();
        buffers[1].clear();
        buffers[2].clear();
        this.testWrite(pep2, desc + "(accept)", null, 0, buffers);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
    }

    private void testWriteAfterClose(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        this.testWrite(pep1, desc + "(connect)", (Exception)((Object)new EEmxInvalidStateException("", "")), 0, null);
        this.testWrite(pep2, desc + "(accept)", (Exception)((Object)new EEmxInvalidStateException("", "")), 0, null);
    }

    private void testCloseAfterClose(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep1 = this.connect(cep);
        IEmxNwLnkPeerEndpoint pep2 = this.accept(sep);
        EmxNwLnkPeerEndpointTest.testClose(sep, null);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep1, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
        EmxNwLnkPeerEndpointTest.testClose(pep2, null);
    }

    @Test
    public void testPropsSet() {
        try {
            this.testTCPAndSocketPropsOnEndpoint(2, EmxFactory.EmxImpl.NIO, "tcp://localhost:4408");
            this.testTCPAndSocketPropsOnEndpoint(3, EmxFactory.EmxImpl.NIO, "tcp://localhost:4409");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testReadNoInboundData() {
        try {
            this.testReadNoInboundData(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testReadWithLessBuffer() {
        try {
            this.testReadWithLessBuffer(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testReadWithEqualBuffer() {
        try {
            this.testReadWithEqualBuffer(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testReadWithMoreBuffer() {
        try {
            this.testReadWithMoreBuffer(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testReadAfterPeerClose() {
        try {
            this.testReadAfterPeerClose(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testReadAfterClose() {
        try {
            this.testReadAfterClose(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testWriteZeroBytes() {
        try {
            this.testWriteZeroBytes(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testWriteCongested() {
        try {
            if (!XRuntime.getValue((String)"nv.ec2.skipincompatibletests", (boolean)false)) {
                this.testWriteCongested(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
            }
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testWriteAfterClose() {
        try {
            this.testWriteAfterClose(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseAfterClose() {
        try {
            this.testCloseAfterClose(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkPeerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }
}

