/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.command.Command;
import com.neeve.command.ICommandHandler;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnkInetAddr;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.EmxNwLnkProps;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.test.unit.EmxNwLnkClientEndpointTest;
import com.neeve.emx.test.unit.EmxNwLnkServerEndpointTest;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlThrowable;
import java.net.InetAddress;
import java.util.HashMap;

class EmxNwLnkEndpointTest
extends UnitTest {
    EmxNwLnkEndpointTest() {
    }

    private IEmxNwLnkPeerEndpoint createPeerEndpointFromClient(EmxFactory.EmxImpl impl, String desc, HashMap<String, Object> inprops) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, inprops);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        EmxNwLnkEndpointTest.testClose(sep, null);
        return pep;
    }

    private IEmxNwLnkPeerEndpoint createPeerEndpointFromServer(EmxFactory.EmxImpl impl, String desc, HashMap<String, Object> inprops) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, inprops);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        EmxNwLnkEndpointTest.testClose(sep, null);
        if (pep == null) {
            EmxNwLnkEndpointTest.testFailure((String)"Failed to accept through server endpoint when it should have!");
        }
        EmxNwLnkEndpointTest.testClose(pep, null);
        return pep1;
    }

    private void checkEpProps(ICommandHandler commandHandler, EmxFactory.EmxImpl impl, String desc, HashMap<String, Object> outprops) throws Exception {
        String OS;
        HashMap<String, Object> props = new HashMap<String, Object>();
        commandHandler.procCommand(Command.getprops.toString(), props);
        if (new Integer(0).equals(outprops.get(EmxNwLnkProps.Socket.localport.toString()))) {
            props.put(EmxNwLnkProps.Socket.localport.toString(), 0);
        }
        if (outprops.get(EmxNwLnkProps.Socket.localifaddr.toString()) != null && ((String)outprops.get(EmxNwLnkProps.Socket.localifaddr.toString())).compareTo("0.0.0.0") == 0) {
            props.put(EmxNwLnkProps.Socket.localifaddr.toString(), "0.0.0.0");
        }
        if (new Integer(0).equals(outprops.get(EmxNwLnkProps.Socket.remoteport.toString()))) {
            props.put(EmxNwLnkProps.Socket.remoteport.toString(), 0);
        }
        if (outprops.get(EmxNwLnkProps.Socket.remoteifaddr.toString()) != null && ((String)outprops.get(EmxNwLnkProps.Socket.remoteifaddr.toString())).compareTo("0.0.0.0") == 0) {
            props.put(EmxNwLnkProps.Socket.remoteifaddr.toString(), "0.0.0.0");
        }
        if ((OS = System.getProperty("os.name").toLowerCase()).indexOf("win") >= 0) {
            outprops = new HashMap<String, Object>(outprops);
            System.out.println("WARN: Ignoring KeepAlive and TcpNoDelay on Windows");
            outprops.remove(EmxNwLnkProps.Tcp.keepalive.toString());
            props.remove(EmxNwLnkProps.Tcp.keepalive.toString());
            outprops.remove(EmxNwLnkProps.Tcp.nodelay.toString());
            props.remove(EmxNwLnkProps.Tcp.nodelay.toString());
        }
        if (!props.equals(outprops)) {
            EmxNwLnkEndpointTest.testFailure((String)("Properties " + props + " after endpoint creation with impl='" + impl.toString() + "' desc='" + desc + "' do not match expected properties " + outprops));
        }
        EmxNwLnkEndpointTest.testSuccess((String)("Properties of endpoint created with impl='" + impl.toString() + "' desc='" + desc + "' and props=" + props + " checked out successfully"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEndpointCheckProps(int type, EmxFactory.EmxImpl impl, String desc, HashMap<String, Object> inprops, HashMap<String, Object> outprops) throws Exception {
        IEmxNwLnkEndpoint ep = null;
        switch (type) {
            case 0: {
                ep = EmxFactory.getInstance().createNwLnkEndpoint(true, impl, desc, inprops);
                break;
            }
            case 1: {
                ep = EmxFactory.getInstance().createNwLnkEndpoint(false, impl, desc, inprops);
                break;
            }
            case 2: {
                ep = this.createPeerEndpointFromClient(impl, desc, inprops);
                break;
            }
            case 3: {
                ep = this.createPeerEndpointFromServer(impl, desc, inprops);
            }
        }
        IEmxNwLnkPeerEndpoint pep = null;
        try {
            this.checkEpProps((ICommandHandler)ep, impl, desc, outprops);
            if (type == 0) {
                try {
                    pep = ((IEmxNwLnkClientEndpoint)ep).connect(new EmxNwLnkOpWaitCond());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.checkEpProps((ICommandHandler)ep, impl, desc, outprops);
        }
        finally {
            try {
                if (ep != null) {
                    ep.close();
                }
            }
            catch (Exception e) {
                EmxNwLnkEndpointTest.testFailure((String)("Failed to close endpoint after successful create [" + e.toString() + "]: " + UtlThrowable.prepareStackTrace((Throwable)e)));
            }
            if (pep != null) {
                try {
                    pep.close();
                }
                catch (Exception e) {
                    EmxNwLnkEndpointTest.testFailure((String)("Failed to close peer endpoint after successful create [" + e.toString() + "]"));
                }
            }
        }
    }

    void testTCPAndSocketPropsOnServerEndpoint(EmxFactory.EmxImpl impl, String baseDesc) {
        try {
            HashMap<String, Object> inprops = new HashMap<String, Object>();
            HashMap<String, Object> outprops = new HashMap<String, Object>();
            HashMap props = new HashMap();
            UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse((String)baseDesc, props);
            EmxNwLnkInetAddr inetAddr = EmxNwLnkInetAddr.parse(descriptor.address);
            outprops.put(EmxNwLnkProps.Socket.localifaddr.toString(), InetAddress.getByName(inetAddr.host).getHostAddress());
            outprops.put(EmxNwLnkProps.Socket.localport.toString(), new Integer(inetAddr.port));
            outprops.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(Short.MAX_VALUE));
            outprops.put(EmxNwLnkProps.Socket.backlog.toString(), new Integer(0));
            inprops.put(EmxNwLnkProps.Socket.localifaddr.toString(), "0.0.0.0");
            this.createEndpointCheckProps(1, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.localifaddr.toString(), "191.169.7.45");
            this.createEndpointCheckProps(1, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.localport.toString(), 0);
            this.createEndpointCheckProps(1, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.localport.toString(), 6000);
            this.createEndpointCheckProps(1, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(40000));
            outprops.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(40000));
            this.createEndpointCheckProps(1, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.backlog.toString(), new Integer(10));
            outprops.put(EmxNwLnkProps.Socket.backlog.toString(), new Integer(10));
            this.createEndpointCheckProps(1, impl, baseDesc, inprops, outprops);
            this.createEndpointCheckProps(1, impl, baseDesc + "&localifaddr=0.0.0.0", inprops, outprops);
            this.createEndpointCheckProps(1, impl, baseDesc + "&localifaddr=182.45.67.89", inprops, outprops);
            this.createEndpointCheckProps(1, impl, baseDesc + "&localifaddr=0.0.0.0&localport=0", inprops, outprops);
            this.createEndpointCheckProps(1, impl, baseDesc + "&localifaddr=0.0.0.0&localport=10000", inprops, outprops);
            outprops.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(30000));
            this.createEndpointCheckProps(1, impl, baseDesc + "&localifaddr=0.0.0.0&localport=4400&recvbuffersize=30000", inprops, outprops);
            outprops.put(EmxNwLnkProps.Socket.backlog.toString(), new Integer(100));
            this.createEndpointCheckProps(1, impl, baseDesc + "&localifaddr=0.0.0.0&localport=4400&recvbuffersize=30000&backlog=100", inprops, outprops);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxNwLnkEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    void testTCPAndSocketPropsOnClientOrPeerEndpoint(int type, EmxFactory.EmxImpl impl, String baseDesc) {
        try {
            String str;
            HashMap<String, Object> inprops = new HashMap<String, Object>();
            HashMap<String, Object> outprops = new HashMap<String, Object>();
            HashMap props = new HashMap();
            UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse((String)baseDesc, props);
            EmxNwLnkInetAddr inetAddr = EmxNwLnkInetAddr.parse(descriptor.address);
            outprops.put(EmxNwLnkProps.Socket.localifaddr.toString(), "0.0.0.0");
            outprops.put(EmxNwLnkProps.Socket.localport.toString(), new Integer(0));
            if (type == 0 || type == 3) {
                outprops.put(EmxNwLnkProps.Socket.remoteifaddr.toString(), "0.0.0.0");
                outprops.put(EmxNwLnkProps.Socket.remoteport.toString(), new Integer(0));
            } else {
                outprops.put(EmxNwLnkProps.Socket.remoteifaddr.toString(), InetAddress.getByName(inetAddr.host).getHostAddress());
                outprops.put(EmxNwLnkProps.Socket.remoteport.toString(), new Integer(inetAddr.port));
            }
            outprops.put(EmxNwLnkProps.Tcp.keepalive.toString(), new Boolean(false));
            outprops.put(EmxNwLnkProps.Tcp.nodelay.toString(), new Boolean(false));
            outprops.put(EmxNwLnkProps.Socket.sendbuffersize.toString(), new Integer(Short.MAX_VALUE));
            outprops.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(Short.MAX_VALUE));
            outprops.put(EmxNwLnkProps.Socket.linger.toString(), new Boolean(true));
            outprops.put(EmxNwLnkProps.Socket.lingertime.toString(), new Integer(10));
            inprops.put(EmxNwLnkProps.Socket.localifaddr.toString(), "0.0.0.0");
            this.createEndpointCheckProps(type, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.localport.toString(), 0);
            this.createEndpointCheckProps(type, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.localport.toString(), 6001);
            if (type == 3) {
                outprops.put(EmxNwLnkProps.Socket.localport.toString(), inetAddr.port);
            } else {
                outprops.put(EmxNwLnkProps.Socket.localport.toString(), 6001);
            }
            this.createEndpointCheckProps(type, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Tcp.keepalive.toString(), new Boolean(true));
            outprops.put(EmxNwLnkProps.Tcp.keepalive.toString(), new Boolean(true));
            this.createEndpointCheckProps(type, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Tcp.nodelay.toString(), new Boolean(true));
            outprops.put(EmxNwLnkProps.Tcp.nodelay.toString(), new Boolean(true));
            this.createEndpointCheckProps(type, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.sendbuffersize.toString(), new Integer(40000));
            outprops.put(EmxNwLnkProps.Socket.sendbuffersize.toString(), new Integer(40000));
            this.createEndpointCheckProps(type, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(40000));
            outprops.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(40000));
            this.createEndpointCheckProps(type, impl, baseDesc, inprops, outprops);
            inprops.put(EmxNwLnkProps.Socket.linger.toString(), new Boolean(false));
            outprops.put(EmxNwLnkProps.Socket.linger.toString(), new Boolean(false));
            outprops.put(EmxNwLnkProps.Socket.lingertime.toString(), new Integer(-1));
            this.createEndpointCheckProps(type, impl, baseDesc, inprops, outprops);
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0", inprops, outprops);
            outprops.put(EmxNwLnkProps.Socket.localport.toString(), 0);
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0&localport=0", inprops, outprops);
            if (type == 3) {
                str = "";
            } else {
                str = "&localport=4401";
                outprops.put(EmxNwLnkProps.Socket.localport.toString(), 4401);
            }
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0" + str, inprops, outprops);
            outprops.put(EmxNwLnkProps.Tcp.keepalive.toString(), new Boolean(false));
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0" + str + "&keepalive=false", inprops, outprops);
            outprops.put(EmxNwLnkProps.Tcp.nodelay.toString(), new Boolean(false));
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0" + str + "&keepalive=false&nodelay=false", inprops, outprops);
            outprops.put(EmxNwLnkProps.Socket.sendbuffersize.toString(), new Integer(30000));
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0" + str + "&keepalive=false&nodelay=false&sendbuffersize=30000", inprops, outprops);
            outprops.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(30000));
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0" + str + "&keepalive=false&nodelay=false&sendbuffersize=30000&recvbuffersize=30000", inprops, outprops);
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0" + str + "&keepalive=false&nodelay=false&sendbuffersize=30000&recvbuffersize=30000&lingertime=5", inprops, outprops);
            outprops.put(EmxNwLnkProps.Socket.lingertime.toString(), new Integer(5));
            outprops.put(EmxNwLnkProps.Socket.linger.toString(), new Boolean(true));
            this.createEndpointCheckProps(type, impl, baseDesc + "&localifaddr=0.0.0.0" + str + "&keepalive=false&nodelay=false&sendbuffersize=30000&recvbuffersize=30000&lingertime=5&linger=true", inprops, outprops);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxNwLnkEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    protected void testCreateInvalidDescContent(int type, EmxFactory.EmxImpl impl, String desc) throws Exception {
        try {
            IEmxNwLnkEndpoint ep = null;
            switch (type) {
                case 0: {
                    ep = EmxFactory.getInstance().createNwLnkEndpoint(true, impl, desc, null);
                    break;
                }
                case 1: {
                    ep = EmxFactory.getInstance().createNwLnkEndpoint(false, impl, desc, null);
                    break;
                }
            }
            HashMap props = new HashMap();
            ((ICommandHandler)ep).procCommand(Command.getprops.toString(), props);
            EmxNwLnkEndpointTest.testFailure((String)("Endpoint creation with invalid descriptor content [desc=" + desc + "] succeeded! [props=" + props + "]"));
        }
        catch (EEmxException e) {
            EmxNwLnkEndpointTest.testSuccess((String)("Endpoint creation with invalid descriptor content [desc=" + desc + "] successfully threw exception [" + e.toString() + "]"));
        }
    }

    protected void testCreateValidDescContent(int type, EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkEndpoint ep = null;
        switch (type) {
            case 0: {
                ep = EmxFactory.getInstance().createNwLnkEndpoint(true, impl, desc, null);
                break;
            }
            case 1: {
                ep = EmxFactory.getInstance().createNwLnkEndpoint(false, impl, desc, null);
                break;
            }
        }
        HashMap props = new HashMap();
        ((ICommandHandler)ep).procCommand(Command.getprops.toString(), props);
        ep.close();
        EmxNwLnkEndpointTest.testSuccess((String)("Endpoint creation with [desc=" + desc + "] succeeded [props=" + props + "]"));
    }

    protected void testTCPAndSocketPropsOnEndpoint(int type, EmxFactory.EmxImpl impl, String baseDesc) {
        if (type == 1) {
            this.testTCPAndSocketPropsOnServerEndpoint(impl, baseDesc);
        } else {
            this.testTCPAndSocketPropsOnClientOrPeerEndpoint(type, impl, baseDesc);
        }
    }

    protected static void testClose(IEmxNwLnkEndpoint ep, Exception exp) throws Exception {
        try {
            if (ep != null) {
                ep.close();
            }
        }
        catch (Exception e) {
            if (exp != null && exp.getClass().isInstance(e)) {
                EmxNwLnkEndpointTest.testSuccess((String)("Endpoint close successfully threw exception [" + e.toString() + "]"));
            }
            EmxNwLnkEndpointTest.testFailure((String)("Endpoint " + ep.getClass().getName() + " close threw incorrect exception [exp=" + (exp != null ? exp.getClass().getName() : "null") + " actual=" + e.getClass().getName() + "]"));
        }
    }
}

