/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio;

import com.neeve.emx.EmxNwLnkProps;
import com.neeve.emx.IEmxNwLnkEndpoint;
import com.neeve.emx.nio.EmxNioObject;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;

public abstract class EmxNioNwLnkEndpoint
extends EmxNioObject
implements IEmxNwLnkEndpoint {
    protected final void getSocketNTcpProps(SocketChannel sc, HashMap<String, Object> props) throws SocketException {
        props.put(EmxNwLnkProps.Socket.localifaddr.toString(), sc.socket().getLocalAddress().getHostAddress());
        props.put(EmxNwLnkProps.Socket.localport.toString(), new Integer(sc.socket().getLocalPort()));
        props.put(EmxNwLnkProps.Socket.remoteifaddr.toString(), sc.socket().isConnected() ? sc.socket().getInetAddress().getHostAddress() : "0.0.0.0");
        props.put(EmxNwLnkProps.Socket.remoteport.toString(), new Integer(sc.socket().getPort()));
        try {
            props.put(EmxNwLnkProps.Tcp.keepalive.toString(), new Boolean(sc.socket().getKeepAlive()));
        }
        catch (SocketException se) {
            try {
                props.put(EmxNwLnkProps.Tcp.keepalive.toString(), new Boolean(sc.socket().getKeepAlive()));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        try {
            props.put(EmxNwLnkProps.Tcp.nodelay.toString(), new Boolean(sc.socket().getTcpNoDelay()));
        }
        catch (SocketException se) {
            try {
                props.put(EmxNwLnkProps.Tcp.nodelay.toString(), new Boolean(sc.socket().getTcpNoDelay()));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        props.put(EmxNwLnkProps.Socket.sendbuffersize.toString(), new Integer(sc.socket().getSendBufferSize()));
        props.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(sc.socket().getReceiveBufferSize()));
        props.put(EmxNwLnkProps.Socket.linger.toString(), new Boolean(sc.socket().getSoLinger() >= 0));
        props.put(EmxNwLnkProps.Socket.lingertime.toString(), new Integer(sc.socket().getSoLinger()));
    }

    protected final void getSocketNTcpProps(ServerSocketChannel ssc, HashMap<String, Object> props) throws SocketException {
        props.put(EmxNwLnkProps.Socket.localifaddr.toString(), ssc.socket().getInetAddress().getHostAddress());
        props.put(EmxNwLnkProps.Socket.localport.toString(), new Integer(ssc.socket().getLocalPort()));
        props.put(EmxNwLnkProps.Socket.recvbuffersize.toString(), new Integer(ssc.socket().getReceiveBufferSize()));
    }

    public class BooleanProperty
    extends Property {
        public BooleanProperty(String name, boolean defaultValue) {
            super(name, new Boolean(defaultValue), "java.lang.Boolean");
        }

        public boolean value() {
            return (Boolean)this.value;
        }

        @Override
        Object convert(String str) {
            return Boolean.valueOf(str);
        }
    }

    public final class ShortProperty
    extends Property {
        public ShortProperty(String name, short defaultValue) {
            super(name, new Short(defaultValue), "java.lang.Short");
        }

        public short value() {
            return (Short)this.value;
        }

        @Override
        Object convert(String str) {
            return Short.valueOf(str);
        }
    }

    public final class IntProperty
    extends Property {
        public IntProperty(String name, int defaultValue) {
            super(name, new Integer(defaultValue), "java.lang.Integer");
        }

        public int value() {
            return (Integer)this.value;
        }

        @Override
        Object convert(String str) {
            return Integer.valueOf(str);
        }
    }

    public final class StringProperty
    extends Property {
        public StringProperty(String name, String defaultValue) {
            super(name, defaultValue, "java.lang.String");
        }

        public String value() {
            return (String)this.value;
        }

        @Override
        Object convert(String str) {
            return str;
        }
    }

    public abstract class Property {
        public final String name;
        public final Class<?> clazz;
        public final Object defaultValue;
        public Object value;

        protected Property(String name, Object defaultValue, String classname) {
            this.name = name;
            this.defaultValue = defaultValue;
            try {
                this.clazz = Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load network link property class '" + classname + "' [" + e.toString() + "]");
            }
        }

        public Property init(HashMap<String, Object> properties) {
            Object object = this.value = properties != null ? properties.get(this.name) : null;
            if (this.value instanceof String) {
                this.value = this.convert((String)this.value);
            } else if (this.value == null || !this.clazz.isInstance(this.value)) {
                this.value = this.defaultValue;
            }
            return this;
        }

        public Property save(HashMap<String, Object> properties) {
            if (this.value != null) {
                properties.put(this.name, this.value);
            } else {
                properties.remove(this.name);
            }
            return this;
        }

        abstract Object convert(String var1);
    }
}

