/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio;

import cern.colt.bitvector.BitVector;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.nio.EmxNioObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;

final class EmxNioDispatcherReadyQueue
extends EmxNioObject {
    private final UtlList[] queues = new UtlList[32];
    private final BitVector mask;
    private int count;

    EmxNioDispatcherReadyQueue() {
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i] = UtlList.create();
        }
        this.mask = new BitVector(32);
    }

    final void add(UtlListElement event, int priority) {
        if (this.checked) {
            if (event.isLinked()) {
                throw new InternalError("Event being added to dispatcher ready queue while already in another queue!");
            }
            if (priority > 31 || priority < 0) {
                throw new InternalError("Priority of event being added to dispatcher ready queue is invalid!");
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Adding event " + event + " to priority queue [" + priority + "]", Tracer.Level.DEBUG);
        }
        this.queues[priority].append(event);
        this.mask.putQuick(priority, true);
        ++this.count;
    }

    final void add(UtlList list) {
        UtlListElement element;
        while ((element = list.next()) != null) {
            element.unlink();
            this.add(element, ((IEmxEvent)element).getPriority());
        }
    }

    final boolean remove(UtlListElement event, int priority) {
        if (this.checked && (priority > 31 || priority < 0)) {
            throw new InternalError("Priority of event being removed from dispatcher ready queue is invalid!");
        }
        if (this.tracer.debug) {
            this.tracer.log("Removing event " + event + " from priority queue [" + priority + "]", Tracer.Level.DEBUG);
        }
        if (event.head == this.queues[priority]) {
            event.unlink();
            int newListSize = this.queues[priority].count();
            if (newListSize == 0) {
                this.mask.putQuick(priority, false);
            }
            --this.count;
            return true;
        }
        if (this.tracer.debug) {
            this.tracer.log("Event " + event + " is not linked into the ready queue", Tracer.Level.DEBUG);
        }
        return false;
    }

    final UtlList get(UtlList list) {
        UtlList retval = list;
        if (list.count() != 0) {
            throw new InternalError("list provided to replace dispatch list is not empty!");
        }
        if (this.count > 0) {
            for (int i = this.queues.length - 1; i >= 0; --i) {
                if (!this.mask.getQuick(i)) continue;
                if (this.tracer.debug) {
                    this.tracer.log("Returning priority queue [" + i + "] as next dispatch list", Tracer.Level.DEBUG);
                }
                retval = this.queues[i];
                this.queues[i] = list;
                this.mask.putQuick(i, false);
                break;
            }
            this.count -= retval.count();
        }
        return retval;
    }

    final int count() {
        return this.count;
    }
}

