/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public final class UtlAddressDescriptor
extends UtlDescriptor {
    private UtlAddressDescriptor connectorDescriptor;
    public final String address;
    public final HashMap<String, Object> props;

    private UtlAddressDescriptor(String type, String config, String address, HashMap<String, Object> props, UtlAddressDescriptor connectorDescriptor) {
        super(type, config);
        this.address = address;
        this.props = props;
        this.connectorDescriptor = connectorDescriptor;
    }

    private UtlAddressDescriptor(String descriptor, HashMap<String, Object> props) throws IllegalArgumentException {
        super(descriptor);
        String str = this.config;
        StringTokenizer tokenizer = new StringTokenizer(str, "&", false);
        if (tokenizer.countTokens() <= 0) {
            throw new IllegalArgumentException("Address portion in descriptor cannot be empty");
        }
        this.address = tokenizer.nextToken();
        HashMap hashMap = this.props = props == null ? new HashMap() : (HashMap)props.clone();
        while (tokenizer.hasMoreTokens()) {
            String propVal = tokenizer.nextToken();
            StringTokenizer propValTokenizer = new StringTokenizer(propVal, "=", false);
            if (propValTokenizer.countTokens() == 2) {
                String prop = propValTokenizer.nextToken();
                String val = propValTokenizer.nextToken();
                this.props.put(prop, val);
                continue;
            }
            throw new IllegalArgumentException("Property specifiers must be of the form 'name=value'");
        }
    }

    public static UtlAddressDescriptor parse(String descriptor, HashMap<String, Object> props) throws IllegalArgumentException {
        return new UtlAddressDescriptor(descriptor, props);
    }

    public static boolean isValid(CharSequence descriptor) {
        int index = -1;
        int s = 0;
        for (int i = 0; i < descriptor.length(); ++i) {
            s = descriptor.charAt(i) == "://".charAt(s) ? ++s : 0;
            if (s != "://".length()) continue;
            index = i - "://".length() + 1;
            break;
        }
        if (index <= 0 || index + "://".length() == descriptor.length()) {
            throw new IllegalArgumentException("Descriptor must of of format [type]://[config], but was '" + descriptor + "'");
        }
        int firstPropIndex = -1;
        for (int i = index + "://".length(); i < descriptor.length(); ++i) {
            if (descriptor.charAt(i) != '&') continue;
            if (i == index + "://".length()) {
                throw new IllegalArgumentException("Address portion in descriptor cannot be empty");
            }
            if (i + 1 >= descriptor.length()) break;
            firstPropIndex = i + 1;
            break;
        }
        if (firstPropIndex >= 0 && firstPropIndex < descriptor.length()) {
            boolean inKey = true;
            int currentValueIndex = firstPropIndex;
            for (int i = firstPropIndex; i < descriptor.length(); ++i) {
                char c = descriptor.charAt(i);
                if (inKey) {
                    if (c == '=') {
                        if (i == currentValueIndex) {
                            throw new IllegalArgumentException("Unexpected '=' at index " + i + ", property specifiers must be of the form 'name=value'");
                        }
                        inKey = false;
                        currentValueIndex = i + 1;
                        continue;
                    }
                    if (c != '&') continue;
                    throw new IllegalArgumentException("Unexpected '&' at index " + i + ", property specifiers must be of the form 'name=value'");
                }
                if (c == '&') {
                    if (i == currentValueIndex) {
                        throw new IllegalArgumentException("Unexpected '&' at index " + i + ", property specifiers must be of the form 'name=value'");
                    }
                    inKey = true;
                    currentValueIndex = i + 1;
                    continue;
                }
                if (descriptor.charAt(i) != '=') continue;
                throw new IllegalArgumentException("Unexpected '=' at index " + i + ", property specifiers must be of the form 'name=value'");
            }
        }
        return true;
    }

    public final boolean equals(Object o) {
        UtlAddressDescriptor other = (UtlAddressDescriptor)o;
        return other != null && other.type.equals(this.type) && other.address.equals(this.address) && other.props.equals(this.props);
    }

    public final int hashCode(Object o) {
        return (this.type + this.address + this.props.toString()).hashCode();
    }

    public final void setConnectorDescriptor(UtlAddressDescriptor connectorDescriptor) {
        this.connectorDescriptor = connectorDescriptor;
    }

    public final UtlAddressDescriptor getConnectorDescriptor() {
        return this.connectorDescriptor;
    }

    public final String toShortString() {
        StringBuilder sb = new StringBuilder();
        this.appendShortStringTo(sb);
        return sb.toString();
    }

    public final void appendShortStringTo(Appendable appendable) {
        try {
            appendable.append(this.type).append("://").append(this.address);
        }
        catch (IOException e) {
            throw new RuntimeException("Error appending descriptor: " + e.getMessage(), e);
        }
    }

    public final String toFullString(String stringInPropsToSanitize) {
        StringBuilder sb = new StringBuilder(this.toShortString());
        this.appendFullStringTo(sb, stringInPropsToSanitize);
        return sb.toString();
    }

    public final String toFullString() {
        return this.toFullString(null);
    }

    public final String toPasswordSanitizedFullString() {
        return this.toFullString("password");
    }

    public final void appendFullStringTo(Appendable appendable, String stringInPropsToSanitize) {
        if (this.props != null) {
            for (String key : this.props.keySet()) {
                Object val = this.props.get(key);
                if (!(val instanceof String)) continue;
                try {
                    if (stringInPropsToSanitize == null || !key.toLowerCase().contains(stringInPropsToSanitize.toLowerCase())) {
                        appendable.append("&").append(key).append("=").append((String)val);
                        continue;
                    }
                    appendable.append("&").append(key).append("=").append("<sanitized>");
                }
                catch (IOException e) {
                    throw new RuntimeException("Error appending descriptor: " + e.getMessage(), e);
                }
            }
        }
    }

    public final void appendFullStringTo(Appendable appendable) {
        this.appendFullStringTo(appendable, null);
    }

    public final UtlAddressDescriptor copy() {
        UtlAddressDescriptor connectorDescriptor = this.connectorDescriptor != null ? this.connectorDescriptor.copy() : null;
        return new UtlAddressDescriptor(this.type, this.config, this.address, new HashMap<String, Object>(this.props), connectorDescriptor);
    }
}

