/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XDateIterator;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufRepeatedLongFieldBuffer;
import com.neeve.xbuf.XbufVariableDateField;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.NoSuchElementException;

public class XbufRepeatedDateFieldBuffer
implements XDateIterator {
    static final Date[] EMPTY_ARRAY = new Date[0];
    final PktBuffer val;
    final XbufField.VarintDesyncLength desyncLength = new XbufField.VarintDesyncLength();
    private final boolean allowsNullValues;
    private final XbufField.NullValueCheckPolicy nullValueCheckPolicy;
    final short id;
    int current;
    int length;
    int count;

    XbufRepeatedDateFieldBuffer(short id, boolean mayHaveNullValues, XbufField.NullValueCheckPolicy nullValueCheckPolicy, int initialLength, boolean isNative) {
        this.id = id;
        this.val = PktBuffer.create((IOElasticBuffer.Sizer)null, (int)initialLength, (boolean)isNative);
        this.val.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.allowsNullValues = mayHaveNullValues;
        this.nullValueCheckPolicy = nullValueCheckPolicy;
    }

    public final short getFieldId() {
        return this.id;
    }

    public final void clear() throws IllegalStateException {
        this.reset();
    }

    final XbufRepeatedDateFieldBuffer reset() {
        if (this.count > 0) {
            this.val.setLength(0);
            this.count = 0;
            this.current = 0;
            this.length = 0;
        }
        return this;
    }

    final int desyncAndAddValue(PktBuffer buffer, int offset, int length) {
        this.add(XbufVariableDateField.deserializeValue(buffer, offset, this.desyncLength));
        return this.desyncLength.value;
    }

    final int copyInto(IOElasticBuffer buffer, int offset) {
        if (this.length == 0) {
            return 0;
        }
        buffer.putFrom(offset, (IOElasticBuffer)this.val, 0, this.length);
        return this.length;
    }

    final int serializedLength() {
        return this.length;
    }

    final int count() {
        return this.count;
    }

    public final void add(long v) {
        this.length += XbufVariableDateField.serializeFieldAsTimestamp(this.val, this.length, this.id, v);
        ++this.count;
    }

    public final void add(Date v) {
        if (!this.assertEncodable(v)) {
            return;
        }
        this.length += XbufVariableDateField.serializeField(this.val, this.length, this.id, v);
        ++this.count;
    }

    public final void setValuesFrom(XbufRepeatedDateFieldBuffer values) {
        this.reset();
        if (this.isBufferCopyPossibleFrom(values)) {
            this.val.putFrom(0, (IOElasticBuffer)values.val, 0, values.length);
            this.length = values.length;
            this.count = values.count;
        } else {
            values.toFirst();
            while (values.hasNext()) {
                this.add(values.nextAsTimestamp());
            }
            values.toFirst();
        }
    }

    public final void setValuesFrom(XIterator<Date> values) {
        if (values instanceof XbufRepeatedDateFieldBuffer) {
            this.setValuesFrom((XbufRepeatedDateFieldBuffer)values);
        } else {
            this.reset();
            values.toFirst();
            while (values.hasNext()) {
                this.add((Date)values.next());
            }
            values.toFirst();
        }
    }

    public final boolean hasNext() {
        return this.current < this.length;
    }

    public final Date next() {
        if (this.hasNext()) {
            Date v = XbufVariableDateField.deserializeField(this.val, this.current, this.id, this.desyncLength);
            this.current += this.desyncLength.value;
            return v;
        }
        throw new NoSuchElementException("no more elements");
    }

    public final long nextAsTimestamp() {
        if (this.hasNext()) {
            long v = XbufVariableDateField.deserializeFieldAsTimestamp(this.val, this.current, this.id, this.desyncLength);
            this.current += this.desyncLength.value;
            return v;
        }
        throw new NoSuchElementException("no more elements");
    }

    public final void remove() {
        throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
    }

    public final XbufRepeatedDateFieldBuffer toFirst() {
        this.current = 0;
        return this;
    }

    private final boolean assertEncodable(Date val) {
        if (this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked) {
            return true;
        }
        if (val != null) {
            return true;
        }
        switch (this.nullValueCheckPolicy) {
            case Ignore: {
                return false;
            }
            case Throw: {
                throw new NullPointerException("Can't add a null value to an array field.");
            }
            case Unchecked: {
                return true;
            }
        }
        return true;
    }

    final boolean allowsNullValues() {
        return this.allowsNullValues;
    }

    private final boolean isBufferCopyPossibleFrom(XbufRepeatedDateFieldBuffer source) {
        if (source.getFieldId() != this.getFieldId()) {
            return false;
        }
        if (this.allowsNullValues()) {
            return true;
        }
        if (!source.allowsNullValues()) {
            switch (source.nullValueCheckPolicy) {
                case Ignore: 
                case Throw: {
                    return true;
                }
                case Unchecked: {
                    return this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Date[] toArray() {
        if (this.count == 0) {
            return EMPTY_ARRAY;
        }
        Date[] ret = new Date[this.count];
        int c = this.current;
        try {
            this.toFirst();
            int i = 0;
            while (this.hasNext()) {
                ret[i++] = this.next();
            }
        }
        finally {
            this.current = c;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long[] toTimestampArray() {
        if (this.count == 0) {
            return XbufRepeatedLongFieldBuffer.EMPTY_ARRAY;
        }
        long[] ret = new long[this.count];
        int c = this.current;
        try {
            this.toFirst();
            int i = 0;
            while (this.hasNext()) {
                ret[i++] = this.nextAsTimestamp();
            }
        }
        finally {
            this.current = c;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Appendable toString(Appendable to) {
        int c = this.current;
        try {
            this.toFirst();
            while (this.hasNext()) {
                try {
                    to.append(String.valueOf(this.next()));
                    if (!this.hasNext()) continue;
                    to.append(",");
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage(), t);
                    return to;
                }
            }
        }
        finally {
            this.current = c;
        }
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

