/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import cern.colt.list.ObjectArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufReferenceTypeField;
import com.neeve.xbuf.XbufSchema;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public abstract class XbufListField<T>
extends XbufField {
    private static final ConcurrentHashMap<Class<?>, FieldMap> fieldMapsByType = new ConcurrentHashMap();
    private final T[] EMPTY;
    private final XbufReferenceTypeField<T> templateField;
    private final Values values = new Values();
    private final XBufListFieldIterator iterator = new XBufListFieldIterator();

    protected XbufListField(XbufField.Type type, short id, String name, XbufReferenceTypeField<T> templateField) {
        super(type, id, name, false, true);
        if (templateField.type.wireType != XbufField.WireType.HASLEN) {
            throw new InternalError("this class can only be used as a base class for repeating fields of HASLEN wire type");
        }
        FieldMap fieldMaps = fieldMapsByType.get(((Object)((Object)this)).getClass());
        if (fieldMaps == null) {
            fieldMaps = new FieldMap(templateField);
            fieldMapsByType.put(((Object)((Object)this)).getClass(), fieldMaps);
        }
        XbufField[] fields = new XbufField[]{templateField};
        this.templateField = templateField;
        XbufFieldContainer.create(PktBuffer.create((IOElasticBuffer.Sizer)null, (int)1, (boolean)false)).setSchema(XbufSchema.create(fields, fieldMaps.fieldMapByName, fieldMaps.fieldMapById));
        this.EMPTY = this.createTypeArray(0);
    }

    private final int fieldSync(PktBuffer buffer, int offset, T value) {
        int headerLength = this.templateField.headerLength();
        if (value == null && this.templateField.type.wireType == XbufField.WireType.HASLEN) {
            this.templateField.syncHeader(buffer, offset, -1);
            return headerLength;
        }
        int len = this.templateField.serialize(buffer, offset + headerLength, value);
        this.templateField.syncHeader(buffer, offset, len);
        return headerLength + len;
    }

    private final boolean assertNullEncodable() {
        switch (this.getNullValueCheckPolicy()) {
            case Ignore: {
                return false;
            }
            case Throw: {
                throw new NullPointerException("Can't add a null value to an array field.");
            }
            case Unchecked: {
                return true;
            }
        }
        return true;
    }

    private final Values getValues(boolean forWrite) {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.fieldValues[this.index] == null) {
            this.values.clear();
            if (forWrite) {
                this.container.setValue(this, this.values, forWrite);
            }
        } else if (forWrite) {
            this.container.markDirty(this, this.values);
        }
        return this.values;
    }

    boolean allowsNullValues() {
        return this.templateField.canSerializeNull();
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        int totalLen = 0;
        ObjectArrayList list = this.getValuesOrNullIfNotSet();
        if (list != null) {
            Object[] values = list.elements();
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                Object value = values[i];
                this.templateField.setReferenceValue(value);
                totalLen += this.fieldSync(buffer, offset + totalLen, value);
            }
        }
        return totalLen;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        this.getValues(true).desync(buffer, offset, length);
        return Math.max(length, 0);
    }

    @Override
    protected final int contentLength() {
        int totalLen = 0;
        ObjectArrayList list = this.getValuesOrNullIfNotSet();
        if (list != null) {
            Object[] values = list.elements();
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                Object value = values[i];
                this.templateField.setReferenceValue(value);
                totalLen += this.templateField.headerLength() + this.templateField.serializedLength(value);
            }
        }
        return totalLen;
    }

    @Override
    protected final String contentAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        XBufListFieldIterator v = this.getValueIterator();
        while (v.hasNext()) {
            sb.append(this.templateField.toString(v.next()));
            if (!v.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected final boolean contentClear() {
        this.values.clear();
        return this.container.clearValue(this);
    }

    protected XbufField.NullValueCheckPolicy getNullValueCheckPolicy() {
        return XbufField.NullValueCheckPolicy.Unchecked;
    }

    protected final boolean assertEncodable(T val) {
        return val != null || this.assertNullEncodable();
    }

    protected final boolean isArrayCopyPossibleFrom(XBufListFieldIterator values) {
        if (this.allowsNullValues()) {
            return true;
        }
        if (!values.allowsNullValues()) {
            switch (values.nullValueCheckPolicy()) {
                case Ignore: 
                case Throw: {
                    return true;
                }
                case Unchecked: {
                    return this.getNullValueCheckPolicy() == XbufField.NullValueCheckPolicy.Unchecked;
                }
            }
        }
        return false;
    }

    protected abstract T[] createTypeArray(int var1);

    public final void setValues(T[] val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (val == null) {
            throw new IllegalArgumentException("cannot set a list field to null");
        }
        this.getValues(true).clear();
        switch (this.getNullValueCheckPolicy()) {
            case Ignore: {
                for (int i = 0; i < val.length; ++i) {
                    this.addValue(val[i]);
                }
                break;
            }
            case Throw: {
                int i;
                for (i = 0; i < val.length; ++i) {
                    if (val[i] != null) continue;
                    throw new NullPointerException("Can't add a null value to an array field.");
                }
                for (i = 0; i < val.length; ++i) {
                    this.values.add(val[i]);
                }
                break;
            }
            case Unchecked: {
                this.values.list.elements((Object[])val);
            }
        }
    }

    public final void setValuesFrom(XIterator<T> val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (val == null) {
            throw new IllegalArgumentException("cannot set a list field to null");
        }
        if (this.iterator == val) {
            val.toFirst();
            return;
        }
        if (!(this.getNullValueCheckPolicy() != XbufField.NullValueCheckPolicy.Throw || val instanceof XBufListFieldIterator && this.isArrayCopyPossibleFrom((XBufListFieldIterator)val))) {
            while (val.hasNext()) {
                if (val.next() != null) continue;
                throw new NullPointerException("Can't add a null value to an array field.");
            }
        }
        this.getValues(true).clear();
        val.toFirst();
        while (val.hasNext()) {
            Object value = val.next();
            if (!this.assertEncodable(value)) continue;
            this.values.add(value);
        }
    }

    public final void addValue(T val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (val == null && !this.templateField.canSerializeNull()) {
            throw new NullPointerException("Can't add a null value to an array field.");
        }
        if (!this.assertEncodable(val)) {
            return;
        }
        this.getValues(true).add(val);
    }

    public final ObjectArrayList getValuesOrNullIfNotSet() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        Values values = (Values)this.container.fieldValues[this.index];
        return values != null ? values.list() : null;
    }

    public final T[] getValuesAsArray() {
        ObjectArrayList list = this.getValuesOrNullIfNotSet();
        if (list == null || list.size() == 0) {
            return this.EMPTY;
        }
        return list.toArray((Object[])this.createTypeArray(list.size()));
    }

    public final XBufListFieldIterator getValueIterator(boolean onlyValuesInObjectForm, IteratedValueNotificationReceiver<T> notificationReceiver) {
        this.getValues(false);
        return this.iterator.toFirst().onlyValuesInObjectForm(onlyValuesInObjectForm).iteratedValueNotificationReceiver(notificationReceiver);
    }

    public final XBufListFieldIterator getValueIterator(boolean onlyValuesInObjectForm) {
        return this.getValueIterator(onlyValuesInObjectForm, null);
    }

    public final XBufListFieldIterator getValueIterator() {
        return this.getValueIterator(false, null);
    }

    public static interface IteratedValueNotificationReceiver<T> {
        public void handleIteratedValue(T var1, boolean var2);
    }

    public final class XBufListFieldIterator
    implements XIterator<T> {
        private int bufferCurrent;
        private int listCurrent;
        private boolean onlyValuesInObjectForm;
        private IteratedValueNotificationReceiver<T> notificationReceiver;
        private T lastIteratedValue;
        private boolean lastIteratedValueWasDesyncd;

        private final void checkAndNotifyLastIterated() {
            if (this.notificationReceiver != null && this.lastIteratedValue != null) {
                this.notificationReceiver.handleIteratedValue(this.lastIteratedValue, this.lastIteratedValueWasDesyncd);
            }
            this.lastIteratedValue = null;
        }

        final short getFieldId() {
            return XbufListField.this.id;
        }

        final boolean allowsNullValues() {
            return XbufListField.this.allowsNullValues();
        }

        final XbufField.NullValueCheckPolicy nullValueCheckPolicy() {
            return XbufListField.this.getNullValueCheckPolicy();
        }

        final XBufListFieldIterator onlyValuesInObjectForm(boolean val) {
            this.onlyValuesInObjectForm = val;
            return this;
        }

        final XBufListFieldIterator iteratedValueNotificationReceiver(IteratedValueNotificationReceiver<T> val) {
            this.notificationReceiver = val;
            return this;
        }

        public final boolean hasNext() {
            this.checkAndNotifyLastIterated();
            return !this.onlyValuesInObjectForm && this.bufferCurrent < XbufListField.this.values.buffer.getLength() || this.listCurrent < XbufListField.this.values.list.size();
        }

        public final T next() {
            this.checkAndNotifyLastIterated();
            if (this.hasNext()) {
                Object val;
                if (!this.onlyValuesInObjectForm && this.bufferCurrent < XbufListField.this.values.buffer.getLength()) {
                    int length = XbufListField.this.values.buffer.getInt(this.bufferCurrent);
                    this.bufferCurrent += 4;
                    if (length >= 0) {
                        val = XbufListField.this.templateField.deserialize(XbufListField.this.values.buffer, this.bufferCurrent, length);
                        this.bufferCurrent += length;
                    } else {
                        val = null;
                    }
                    this.lastIteratedValue = val;
                    this.lastIteratedValueWasDesyncd = true;
                } else {
                    val = XbufListField.this.values.list.get(this.listCurrent++);
                    this.lastIteratedValue = val;
                    this.lastIteratedValueWasDesyncd = false;
                }
                return val;
            }
            throw new NoSuchElementException("no more elements");
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final XBufListFieldIterator toFirst() {
            this.checkAndNotifyLastIterated();
            this.bufferCurrent = 0;
            this.listCurrent = 0;
            return this;
        }
    }

    private final class Values {
        private final PktBuffer buffer = PktBuffer.create((IOElasticBuffer.Sizer)null, (int)1, (boolean)true);
        private int countInBuffer;
        private final ObjectArrayList list;

        Values() {
            this.buffer.setLength(0);
            this.countInBuffer = 0;
            this.list = new ObjectArrayList();
        }

        final void desync(PktBuffer buf, int offset, int length) {
            if (length >= 0 || XbufListField.this.assertNullEncodable()) {
                ++this.countInBuffer;
                this.buffer.putInt(this.buffer.getLength(), length);
                if (length >= 0) {
                    this.buffer.putFrom(this.buffer.getLength(), (IOElasticBuffer)buf, offset, length);
                }
            }
        }

        final void add(T val) {
            this.list.add(val);
        }

        final void clear() {
            this.buffer.setLength(0);
            this.countInBuffer = 0;
            this.list.clear();
        }

        final ObjectArrayList list() {
            if (this.countInBuffer > 0) {
                ObjectArrayList list = new ObjectArrayList();
                XBufListFieldIterator iterator = XbufListField.this.getValueIterator();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
                return list;
            }
            return this.list;
        }
    }

    private static final class FieldMap {
        private final OpenIntObjectHashMap fieldMapById = new OpenIntObjectHashMap(1, 0.0, 0.5);
        private final Map<String, Integer> fieldMapByName = new HashMap<String, Integer>(2);

        private FieldMap(XbufReferenceTypeField<?> templateField) {
            this.fieldMapById.put((int)templateField.id, (Object)0);
            this.fieldMapByName.put(templateField.name, 0);
        }
    }
}

