/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XCharArrayIterator;
import com.neeve.lang.XCharIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class XbufCharArrayField
extends XbufVariableLengthField<char[]> {
    private final Iterator iterator = new Iterator();

    private XbufCharArrayField(short id, String name) {
        super(XbufField.Type.CHAR_ARRAY, id, name);
    }

    public static XbufCharArrayField create(short id, String name) {
        return new XbufCharArrayField(id, name);
    }

    @Override
    protected final int serializedLength(char[] val) {
        return val == null ? 0 : val.length * 2;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, char[] val) {
        buffer.putFrom(offset, val, 0, val.length);
        return val.length * 2;
    }

    @Override
    protected final char[] deserialize(PktBuffer buffer, int offset, int length) {
        char[] val = new char[length / 2];
        if (length > 0) {
            buffer.getTo(offset, val, 0, val.length);
        }
        return val;
    }

    public final void setValues(char[] values) {
        super.setValue(values);
    }

    public final char[] getValuesAsArray() {
        return (char[])super.getValue();
    }

    public final void setValuesFrom(XCharIterator val) {
        char[] v;
        if (val instanceof Iterator) {
            v = ((Iterator)val).array();
        } else if (val instanceof XCharArrayIterator) {
            XCharArrayIterator a = (XCharArrayIterator)val;
            v = a.array();
            if (v.length != a.length()) {
                v = new char[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                ++size;
                val.next();
            }
            v = new char[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                v[i] = val.next();
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(char val) {
        char[] vArray;
        char[] existing = (char[])this.getValue();
        if (this.getValue() == null) {
            vArray = new char[1];
        } else {
            vArray = new char[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    @Override
    protected final String toString(char[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XCharIterator {
        int current = 0;

        public char[] array() {
            return (char[])XbufCharArrayField.this.getValue();
        }

        public final boolean hasNext() {
            char[] value = (char[])XbufCharArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public char next() {
            char[] val = (char[])XbufCharArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((char[])XbufCharArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }
    }
}

