/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmBoolean;
import com.neeve.adm.AdmByte;
import com.neeve.adm.AdmChar;
import com.neeve.adm.AdmCurrency;
import com.neeve.adm.AdmDate;
import com.neeve.adm.AdmDouble;
import com.neeve.adm.AdmFloat;
import com.neeve.adm.AdmInteger;
import com.neeve.adm.AdmLong;
import com.neeve.adm.AdmShort;
import com.neeve.adm.AdmString;
import com.neeve.adm.AdmType;
import com.neeve.adm.AdmUUID;

public abstract class AdmPrimitive
extends AdmType {
    private final Type type;

    protected AdmPrimitive(String name, Type type) {
        super(null, name != null ? name : type.toString());
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.type = type;
    }

    public static final AdmPrimitive toPrimitiveType(String typeName) {
        try {
            return AdmPrimitive.toPrimitiveType(Type.valueOf(typeName));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final AdmPrimitive toPrimitiveType(Type type) {
        switch (type) {
            case Byte: {
                return new AdmByte();
            }
            case Short: {
                return new AdmShort();
            }
            case Integer: {
                return new AdmInteger();
            }
            case Long: {
                return new AdmLong();
            }
            case Float: {
                return new AdmFloat();
            }
            case Double: {
                return new AdmDouble();
            }
            case Boolean: {
                return new AdmBoolean();
            }
            case String: {
                return new AdmString();
            }
            case Date: {
                return new AdmDate();
            }
            case Currency: {
                return new AdmCurrency();
            }
            case UUID: {
                return new AdmUUID();
            }
            case Char: {
                return new AdmChar();
            }
        }
        throw new IllegalArgumentException("unknown primitive type '" + (Object)((Object)type) + "'");
    }

    public final Type getType() {
        return this.type;
    }

    public final boolean isNullable() {
        switch (this.type) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Double: 
            case Float: 
            case Integer: 
            case Long: 
            case Short: {
                return false;
            }
            case Currency: 
            case UUID: 
            case Date: 
            case String: {
                return true;
            }
        }
        throw new IllegalArgumentException("unknown primitive type '" + (Object)((Object)this.type) + "'");
    }

    public final String getDefaultValueLiteral() {
        switch (this.type) {
            case Byte: {
                return "0";
            }
            case Short: {
                return "0";
            }
            case Integer: {
                return "0";
            }
            case Long: {
                return "0";
            }
            case Float: {
                return "0";
            }
            case Double: {
                return "0";
            }
            case Boolean: {
                return "false";
            }
            case Char: {
                return "0";
            }
            case String: {
                return "null";
            }
            case Date: {
                return "null";
            }
            case Currency: {
                return "null";
            }
            case UUID: {
                return "null";
            }
        }
        throw new IllegalArgumentException("unknown primitive type '" + (Object)((Object)this.type) + "'");
    }

    @Override
    public String getJavaTypeName() {
        return this.type.getJavaTypeName();
    }

    @Override
    public String getTemplatedJavaTypeName() {
        return "%{" + this.getJavaTypeName() + "}";
    }

    @Override
    public String getPrimitiveTypeName() {
        return this.type.getPrimitiveTypeName();
    }

    @Override
    public String getTemplatedPrimitiveTypeName() {
        return this.type.getTemplatedPrimitiveTypeName();
    }

    public boolean isWrappedPrimitive() {
        switch (this.type) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Double: 
            case Float: 
            case Integer: 
            case Long: 
            case Short: {
                return true;
            }
        }
        return false;
    }

    public static enum Type {
        Byte(1),
        Short(2),
        Integer(4),
        Long(8),
        Float(4),
        Double(8),
        Boolean(1),
        String("com.neeve.lang.XString", "com.neeve.lang.XString", 0),
        Date(8),
        Char(2),
        Currency(3),
        UUID("com.neeve.raw.RawUUID", "com.neeve.raw.impl.RawUUIDImpl", 16);

        private final String rawValueTypeName;
        private final String rawValueTypeImplName;
        private final String rawValueTypeSimpleName;
        private final String rawValueTypeImplSimpleName;
        private final int serializedLength;

        private Type(int serializedLength) {
            this(null, null, serializedLength);
        }

        private Type(String rawValueTypeName, String rawValueTypeImplName, int serializedLength) {
            this.rawValueTypeName = rawValueTypeName;
            this.rawValueTypeImplName = rawValueTypeImplName;
            this.rawValueTypeSimpleName = rawValueTypeName != null ? rawValueTypeName.substring(rawValueTypeName.lastIndexOf(".") + 1) : null;
            this.rawValueTypeImplSimpleName = rawValueTypeImplName != null ? rawValueTypeImplName.substring(rawValueTypeImplName.lastIndexOf(".") + 1) : null;
            this.serializedLength = serializedLength;
        }

        public int getSerializedLength() {
            return this.serializedLength;
        }

        public String getJavaTypeName() {
            if (this == Char) {
                return "java.lang.Character";
            }
            if (this == Date) {
                return "java.util.Date";
            }
            if (this == Currency) {
                return "java.util.Currency";
            }
            if (this == UUID) {
                return "java.util.UUID";
            }
            return "java.lang." + this.name();
        }

        public String getPrimitiveTypeName() {
            switch (this) {
                case Boolean: {
                    return "boolean";
                }
                case Byte: {
                    return "byte";
                }
                case Char: {
                    return "char";
                }
                case Double: {
                    return "double";
                }
                case Float: {
                    return "float";
                }
                case Integer: {
                    return "int";
                }
                case Long: {
                    return "long";
                }
                case Short: {
                    return "short";
                }
            }
            return this.getJavaTypeName();
        }

        public String getTemplatedPrimitiveTypeName() {
            switch (this) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Double: 
                case Float: 
                case Integer: 
                case Long: 
                case Short: {
                    return this.getPrimitiveTypeName();
                }
            }
            return "%{" + this.getJavaTypeName() + "}";
        }

        public String getXIteratorType() {
            switch (this) {
                case Boolean: {
                    return "com.neeve.lang.XBooleanIterator";
                }
                case Byte: {
                    return "com.neeve.lang.XByteIterator";
                }
                case Char: {
                    return "com.neeve.lang.XCharIterator";
                }
                case Double: {
                    return "com.neeve.lang.XDoubleIterator";
                }
                case Float: {
                    return "com.neeve.lang.XFloatIterator";
                }
                case Integer: {
                    return "com.neeve.lang.XIntIterator";
                }
                case Long: {
                    return "com.neeve.lang.XLongIterator";
                }
                case Short: {
                    return "com.neeve.lang.XShortIterator";
                }
            }
            return "com.neeve.lang.XIterator<" + this.getJavaTypeName() + ">";
        }

        public String getTemplatedXIteratorType() {
            switch (this) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Double: 
                case Float: 
                case Integer: 
                case Long: 
                case Short: {
                    return "%{" + this.getXIteratorType() + "}";
                }
            }
            return "%{com.neeve.lang.XIterator}<%{" + this.getJavaTypeName() + "}>";
        }

        public String getXIteratorTypeRaw() {
            switch (this) {
                case Boolean: {
                    return "com.neeve.lang.XBooleanIterator";
                }
                case Byte: {
                    return "com.neeve.lang.XByteIterator";
                }
                case Char: {
                    return "com.neeve.lang.XCharIterator";
                }
                case Double: {
                    return "com.neeve.lang.XDoubleIterator";
                }
                case Float: {
                    return "com.neeve.lang.XFloatIterator";
                }
                case Integer: {
                    return "com.neeve.lang.XIntIterator";
                }
                case Long: {
                    return "com.neeve.lang.XLongIterator";
                }
                case Short: {
                    return "com.neeve.lang.XShortIterator";
                }
            }
            return "com.neeve.lang.XIterator";
        }

        public String getZGXIteratorType() {
            switch (this) {
                case Date: {
                    return "com.neeve.lang.XDateIterator";
                }
                case String: {
                    return "com.neeve.lang.XStringIterator";
                }
            }
            return this.getXIteratorType();
        }

        public String getTemplatedZGXIteratorType() {
            switch (this) {
                case Date: 
                case String: {
                    return "%{" + this.getZGXIteratorType() + "}";
                }
            }
            return this.getTemplatedXIteratorType();
        }

        public String getZGXIteratorTypeRaw() {
            switch (this) {
                case Date: {
                    return "com.neeve.lang.XDateIterator";
                }
                case String: {
                    return "com.neeve.lang.XStringIterator";
                }
            }
            return this.getXIteratorTypeRaw();
        }

        public String getXArrayIteratorType() {
            switch (this) {
                case Boolean: {
                    return "com.neeve.lang.XBooleanArrayIterator";
                }
                case Byte: {
                    return "com.neeve.lang.XByteArrayIterator";
                }
                case Char: {
                    return "com.neeve.lang.XCharArrayIterator";
                }
                case Double: {
                    return "com.neeve.lang.XDoubleArrayIterator";
                }
                case Float: {
                    return "com.neeve.lang.XFloatArrayIterator";
                }
                case Integer: {
                    return "com.neeve.lang.XIntArrayIterator";
                }
                case Long: {
                    return "com.neeve.lang.XLongArrayIterator";
                }
                case Short: {
                    return "com.neeve.lang.XShortArrayIterator";
                }
                case Date: {
                    return "com.neeve.lang.XDateArrayIterator";
                }
                case String: {
                    return "com.neeve.lang.XStringArrayIterator";
                }
            }
            return "com.neeve.lang.XArrayIterator<" + this.getJavaTypeName() + ">";
        }

        public String getTemplatedXArrayIteratorType() {
            switch (this) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Double: 
                case Float: 
                case Integer: 
                case Long: 
                case Short: 
                case Date: 
                case String: {
                    return "%{" + this.getXArrayIteratorType() + "}";
                }
            }
            return "%{com.neeve.lang.XArrayIterator}<%{" + this.getJavaTypeName() + "}>";
        }

        public String getXArrayIteratorTypeRaw() {
            switch (this) {
                case Boolean: {
                    return "com.neeve.lang.XBooleanArrayIterator";
                }
                case Byte: {
                    return "com.neeve.lang.XByteArrayIterator";
                }
                case Char: {
                    return "com.neeve.lang.XCharArrayIterator";
                }
                case Double: {
                    return "com.neeve.lang.XDoubleArrayIterator";
                }
                case Float: {
                    return "com.neeve.lang.XFloatArrayIterator";
                }
                case Integer: {
                    return "com.neeve.lang.XIntArrayIterator";
                }
                case Long: {
                    return "com.neeve.lang.XLongArrayIterator";
                }
                case Short: {
                    return "com.neeve.lang.XShortArrayIterator";
                }
                case Date: {
                    return "com.neeve.lang.XDateArrayIterator";
                }
                case String: {
                    return "com.neeve.lang.XStringArrayIterator";
                }
            }
            return "com.neeve.lang.XArrayIterator";
        }

        public final boolean hasRawValue() {
            return this.rawValueTypeName != null;
        }

        public final String getRawValueType() {
            return this.rawValueTypeName;
        }

        public final String getRawValueTypeImpl() {
            return this.rawValueTypeImplName;
        }

        public final String getRawValueTypeSimpleName() {
            return this.rawValueTypeSimpleName;
        }

        public final String getRawValueTypeImplSimpleName() {
            return this.rawValueTypeImplSimpleName;
        }
    }
}

