/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.eaio.uuid.UUID;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.query.QueryEngine;
import com.neeve.query.QueryException;
import com.neeve.query.QueryRepository;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.util.UtlQueryResultFormatter;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogGraphCollection;
import com.neeve.rog.impl.log.RogLogQueryEngineImpl;
import com.neeve.rog.impl.log.RogLogQueryFieldResolver;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCdcProcessor;
import com.neeve.rog.log.RogLogCompactor;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogMetadata;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogResultSet;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTableFormatter;
import com.neeve.util.UtlTime;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;

public class TransactionLogTool {
    private static final String PROP_TLT_INIT_SCRIPTS = "nv.tlt.initScripts";
    private final InteractiveTool interactiveTool;
    private Mode mode = Mode.BROWSE;
    private final File workingDir;
    private RogLogReader reader;
    private Package defaultPackage = null;
    @InteractiveTool.ConfigProperty(name="lazyDeserialization", validOptions={"lazy", "eager"}, defaultValue="lazy", description="Whether or not objects should be be lazily deserialized on demand. Lazy deserialization speeds up log traversal, but may incur more memory overhead")
    private DeserializationPolicy deserializationPolicy;
    @InteractiveTool.ConfigProperty(name="displayMetadata", defaultValue="On", validOptions={"On", "Off", "Only"}, description="Set whether metadata should be displayed by commands that dump entries in 'detailed' mode.\n -'On' indicates that both metadata and the object should be displayed.\n -'Off' indicates that only the object should be displayed.\n -'Only' indicates that only the metadata should be displayed (no object).")
    private MetadataPolicy metadataDisplay;
    @InteractiveTool.ConfigProperty(name="filterUnsetFields", defaultValue="Off", validOptions={"on", "off", "true", "false"}, parser=InteractiveTool.BooleanPropertyParser.class, description="Sets whether to display values returned for unset fields for fields that expose a hasXXX method")
    private boolean filterUnsetFields = false;
    @InteractiveTool.ConfigProperty(name="jsonStyle", defaultValue="Default", validOptions={"Default", "PrettyPrint", "Minimal", "SingleLine", "Custom"}, description="Sets the pretty print style to use for json output.\n-Default: Jackson default pretty printer\n-PrettyPrint: Jackson default pretty printer (same as default)\n-Minimal: A minimal single line printer\n-SingleLine: Single line with space after colon between field name and value\n-Custom: Examines the runtime property nv.json.customPrettyPrinter to find the classname of a pretty printer that implements:\n   com.fasterxml.jackson.core.PrettyPrinter")
    private RogLogUtil.JsonPrettyPrintStyle jsonPrettyPrintStyle = RogLogUtil.JsonPrettyPrintStyle.Default;
    @InteractiveTool.ConfigProperty(name="autoindexing", defaultValue="off", validOptions={"off", "on", "true", "false"}, parser=InteractiveTool.BooleanPropertyParser.class, description="Sets whether to automatically create indexes based on queries.\n 'on' Enables auto indexing \n'off' disables auto indexing. \n\nEnabling auto indexing will create indexes based on fields referenced in a query to improve response time of subsequent follow up queries, but it can lead to progressively slower indexing of new entries if too many indexes are auto created, and can additionally slow down query results while the indexes are being built depending on the 'indexingPolicy'")
    private boolean autoindexing = false;
    @InteractiveTool.ConfigProperty(name="autoindexLimit", defaultValue="5", description="The number of fields to be indexed via autoindexing when executing select statements. The limit considers fields from the WHERE, ORDER BY, GROUP BY and SELECT clauses of a query in that order.")
    private int autoindexLimit = 5;
    @InteractiveTool.ConfigProperty(name="indexingPolicy", defaultValue="FLUSH_NEVER", validOptions={"FLUSH_NEVER", "FLUSH_ON_CREATE", "FLUSH_ON_QUERY", "FLUSH_ON_USE"}, description="Sets the policy for background indexing, if none specified the current value will be displayed\n-FLUSH_NEVER: If applicable index is still being built don't wait, instead, start with table scan\n-FLUSH_ON_USE: If an index is still being built, and can be used by a query, query will wait for index build to finish\n-FLUSH_ON_QUERY: Flush all indexing prior to executing a SELECT statement-FLUSH_ON_CREATE: Synchronously build the index when it is created. 'create index' commands and 'select' with autoindexing=on will wait for index build prior to executing the query.")
    private QueryEngine.BackgroundIndexingPolicy backgroundIndexingPolicy = QueryEngine.BackgroundIndexingPolicy.FLUSH_NEVER;
    @InteractiveTool.ConfigProperty(name="fullscanThreshold", parser=FullscanThresholdParser.class, description="A value between 0 and 1 representing the minimum proportion of an index's keys that qualify the index to be used in a query")
    private Double fullscanThreshold = null;
    @InteractiveTool.ConfigProperty(name="selectPreviewCount", defaultValue="0", description="A positive value indicating the default number of rows to preview after a select.")
    private int selectPreviewCount = 0;
    @InteractiveTool.ConfigProperty(name="deleteExtractedArchivesDirOnExit", defaultValue="off", validOptions={"off", "on", "true", "false"}, parser=InteractiveTool.BooleanPropertyParser.class, description=" Enabling this option will recursively delete the extracted-archives folder when exiting the tool including any previously files in the directory so care should be taken when using this option.")
    private boolean deleteExtractedArchivesDirOnExit = false;
    @InteractiveTool.ConfigProperty(name="showQueryPlan", defaultValue="false", validOptions={"off", "on", "true", "false"}, parser=InteractiveTool.BooleanPropertyParser.class, description="Whether or not a query's plan is displayed after being issue.")
    private boolean showQueryPlan = false;
    @InteractiveTool.ConfigProperty(name="maxInMemorySortCardinality", defaultValue="500", description="The size beyond which temporary data structures for sorting will become disk based.")
    private int maxInMemorySortCardinality = 500;
    @InteractiveTool.ConfigProperty(name="timestampFormat", defaultValue="yyyy-MM-dd HH:mm:ss.SSS z", description="The default timestamp format to use when displaying results (use quotes when setting).")
    private String timestampFormat = "yyyy-MM-dd HH:mm:ss.SSS z";
    @InteractiveTool.ConfigProperty(name="timestampTZ", defaultValue="DEFAULT", description="The timezone in which to display timestamps. A value of 'DEFAULT' uses the current system timezone")
    private String timestampTZ = TimeZone.getDefault().getID();
    @InteractiveTool.ConfigProperty(name="logScavengePolicy", defaultValue="Disabled", validOptions={"Disabled", "Delete"}, description="Whether or not cleanup of old log files that are no longer needed by CDC. For safety this value is defaulted to false.")
    private String logScavengePolicy = "Disabled";
    private RogLogQueryEngine queryEngine = null;
    private RogLogResultSet queryResults = null;
    private HashMap<UtlTableFormatter.Format, String> resultHeaders = new HashMap();
    private HashMap<UtlTableFormatter.Format, String> resultRowFormats = new HashMap();
    private HashMap<UtlTableFormatter.Format, String> resultFooters = new HashMap();
    private File extractedArchivesDir = null;
    private final FileFilter logMetadataFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".metadata");
        }
    };
    private HashMap<File, RogLog> openLogs = new HashMap();

    public TransactionLogTool() throws Exception {
        this(null);
    }

    public TransactionLogTool(File archiveExtractionDir) throws Exception {
        this.interactiveTool = new InteractiveTool("Transaction Log Tool", null, ManifestProductInfo.loadProductInfo((String)"nvx-rumi-ods"));
        this.interactiveTool.registerAnnotatedCommands((Object)this);
        this.interactiveTool.addCloseHook(new Runnable(){

            @Override
            public void run() {
                try {
                    new Close().execute();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error closing logs: " + e.getMessage(), e);
                }
                finally {
                    if (TransactionLogTool.this.deleteExtractedArchivesDirOnExit && TransactionLogTool.this.extractedArchivesDir != null && TransactionLogTool.this.extractedArchivesDir.exists()) {
                        TransactionLogTool.this.interactiveTool.info("Deleting extracted archive directory '" + TransactionLogTool.this.extractedArchivesDir + "'...");
                        try {
                            UtlFile.deleteDirectory((File)TransactionLogTool.this.extractedArchivesDir);
                        }
                        catch (IOException e) {
                            TransactionLogTool.this.interactiveTool.error("Error deleting extracted archive directory", (Throwable)e);
                        }
                    }
                }
            }
        });
        this.interactiveTool.addPreCommandLoopTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!"disabled".equalsIgnoreCase(TransactionLogTool.this.logScavengePolicy)) {
                    TransactionLogTool.this.interactiveTool.warn("WARNING: logScavengePolicy is set to '" + TransactionLogTool.this.logScavengePolicy + "'. Ensure any old log versions needed by CDC are backed up!");
                }
                if (!"disabled".equalsIgnoreCase(TransactionLogTool.this.logScavengePolicy)) {
                    TransactionLogTool.this.interactiveTool.warn("WARNING: Before operating on any production files, ensure they are first backed up!");
                }
                try {
                    List<File> embeddedFiles = RogLogUtil.extractArchivedLogs(TransactionLogTool.this.interactiveTool.out(), TransactionLogTool.this.extractedArchivesDir);
                    if (embeddedFiles != null && !embeddedFiles.isEmpty()) {
                        for (File embedded : embeddedFiles) {
                            try {
                                TransactionLogTool.this.openLog(embedded, false, "r", null);
                            }
                            catch (Exception e) {
                                TransactionLogTool.this.interactiveTool.error("Error opening embedded log: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        TransactionLogTool.this.switchTo(embeddedFiles.get(0));
                    }
                }
                catch (Exception e) {
                    TransactionLogTool.this.interactiveTool.error("Error extracting embedded archive contents: " + e.getMessage(), (Throwable)e);
                }
                String initScripts = XRuntime.getValue((String)TransactionLogTool.PROP_TLT_INIT_SCRIPTS, null);
                if (initScripts != null) {
                    StringTokenizer tok = new StringTokenizer(initScripts, ",");
                    while (tok.hasMoreTokens()) {
                        File initScript = new File(tok.nextToken());
                        if (!initScript.exists()) {
                            TransactionLogTool.this.interactiveTool.error("Init script not found " + initScript);
                        }
                        if (initScript.isDirectory()) {
                            TransactionLogTool.this.interactiveTool.error("Init script not a file " + initScript);
                        }
                        BufferedReader reader = null;
                        try {
                            TransactionLogTool.this.interactiveTool.info("Running init script " + initScript);
                            reader = new BufferedReader(new FileReader(initScript));
                            String line = reader.readLine();
                            while (line != null) {
                                TransactionLogTool.this.interactiveTool.executeCommand(line, true);
                                line = reader.readLine();
                            }
                        }
                        catch (Exception e) {
                            TransactionLogTool.this.interactiveTool.error("Init script not a file " + initScript);
                        }
                        finally {
                            if (reader == null) continue;
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                TransactionLogTool.this.interactiveTool.error("Init script not properly closed " + initScript, (Throwable)e);
                            }
                        }
                    }
                }
            }
        });
        this.workingDir = new File(System.getProperty("user.dir"));
        this.interactiveTool.addConfigPropertyChangeHandler("autoindexing", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                if (TransactionLogTool.this.queryEngine != null) {
                    TransactionLogTool.this.queryEngine.setAutoIndexing(TransactionLogTool.this.autoindexing);
                }
            }
        });
        this.interactiveTool.addConfigPropertyChangeHandler("autoindexLimit", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                if (TransactionLogTool.this.queryEngine != null) {
                    TransactionLogTool.this.queryEngine.setAutoIndexLimit(TransactionLogTool.this.autoindexLimit);
                }
            }
        });
        this.interactiveTool.addConfigPropertyChangeHandler("indexingPolicy", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                if (TransactionLogTool.this.queryEngine != null) {
                    TransactionLogTool.this.queryEngine.setBackgroundIndexingPolicy(TransactionLogTool.this.backgroundIndexingPolicy);
                }
            }
        });
        this.interactiveTool.addConfigPropertyChangeHandler("fullscanThreshold", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                if (TransactionLogTool.this.queryEngine != null) {
                    TransactionLogTool.this.queryEngine.setFetchRatioThreshold(TransactionLogTool.this.fullscanThreshold);
                }
            }
        });
        this.interactiveTool.addConfigPropertyChangeHandler("maxInMemorySortCardinality", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                if (TransactionLogTool.this.queryEngine != null) {
                    TransactionLogTool.this.queryEngine.setSortAreaInMemoryCardinality(TransactionLogTool.this.maxInMemorySortCardinality);
                }
            }
        });
        this.interactiveTool.addConfigPropertyChangeHandler("lazyDeserialization", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                if (TransactionLogTool.this.reader != null) {
                    TransactionLogTool.this.reader.setLazyDeserialization(TransactionLogTool.this.deserializationPolicy == DeserializationPolicy.Lazy);
                }
            }
        });
        UtlTime.setTimestampFormat((String)this.timestampFormat);
        this.interactiveTool.addConfigPropertyChangeHandler("timestampFormat", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                UtlTime.setTimestampFormat((String)value.toString());
            }
        });
        if ("DEFAULT".equals(this.timestampTZ)) {
            this.timestampTZ = TimeZone.getDefault().getID();
        }
        UtlTime.setTimestampFormatTimeZone((String)this.timestampTZ);
        this.interactiveTool.addConfigPropertyChangeHandler("timestampTZ", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                if ("DEFAULT".equals(value)) {
                    value = TimeZone.getDefault().getID();
                }
                UtlTime.setTimestampFormatTimeZone((String)value.toString());
            }
        });
        this.interactiveTool.addConfigPropertyChangeHandler("logScavengePolicy", new InteractiveTool.PropertyChangeHandler(){

            public void onPropertyChange(String property, Object value) {
                if (!"disabled".equalsIgnoreCase(String.valueOf(value))) {
                    TransactionLogTool.this.interactiveTool.info("...WARNING: log scavenge policy is set to '" + value + "'. Ensure any old log versions needed by CDC are backed up!");
                }
            }
        });
        this.extractedArchivesDir = archiveExtractionDir == null ? new File(this.workingDir, "extracted-archives") : new File(archiveExtractionDir, "extracted-archives");
    }

    private final void run() throws Exception {
        Thread.currentThread().setName("X-TransactionLogTool");
        this.interactiveTool.run();
    }

    private final void run(File script) throws Exception {
        Thread.currentThread().setName("X-TransactionLogTool");
        this.interactiveTool.run(script);
    }

    private final void switchTo(File logfile) throws Exception {
        RogLog log = this.openLogs.get(this.mainLogFile(logfile));
        if (log != null) {
            if (this.reader == null || !this.reader.log().getLogFile().equals(log.getLogFile())) {
                if (this.reader != null) {
                    this.reader.close();
                    this.interactiveTool.info("Switching to '" + log.getName() + "' use 'switch <logName>' to change between browsed logs");
                }
                this.reader = log.createReader();
                this.reader.setLazyDeserialization(this.deserializationPolicy == DeserializationPolicy.Lazy);
                this.interactiveTool.info("opened with " + (Object)((Object)this.deserializationPolicy) + " deserialization.");
            }
        } else {
            this.interactiveTool.error("No log named '" + log + " is currently open");
            this.listOpen();
            return;
        }
        this.mode = Mode.BROWSE;
        this.updatePrompt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void switchTo(String target) throws Exception {
        if (target.equalsIgnoreCase("query")) {
            if (this.mode == Mode.QUERY) return;
            if (this.queryEngine == null) {
                this.interactiveTool.info("Initializing query engine.");
                this.queryEngine = RogLogFactory.createQueryEngine();
                if (this.openLogs != null) {
                    for (RogLog log : this.openLogs.values()) {
                        RogLogRepository repo = log.asRepository();
                        repo.open();
                        this.queryEngine.addRepository(repo, this.getLogNameAlias(log));
                    }
                }
                this.queryEngine.setDefaultPackage(this.defaultPackage);
                this.queryEngine.setAutoIndexing(this.autoindexing);
                this.queryEngine.setAutoIndexLimit(this.autoindexLimit);
                this.queryEngine.setBackgroundIndexingPolicy(this.backgroundIndexingPolicy);
                if (this.fullscanThreshold != null) {
                    this.queryEngine.setFetchRatioThreshold(this.fullscanThreshold);
                }
            }
            this.mode = Mode.QUERY;
            this.interactiveTool.info("Entered query mode. Use 'switch browse' to go back to log mode");
        } else if (target.equalsIgnoreCase("browse")) {
            if (this.mode == Mode.BROWSE) return;
            this.mode = Mode.BROWSE;
        } else {
            this.switchTo(this.mainLogFile(new File(target)));
        }
        this.updatePrompt();
    }

    private final void updatePrompt() throws IOException {
        if (this.mode == Mode.QUERY) {
            this.interactiveTool.setPrompt("query");
        } else if (this.reader == null) {
            this.interactiveTool.setPrompt(null);
        } else {
            this.interactiveTool.setPrompt(this.getRelativeLogAlias(this.reader.log()));
        }
    }

    private File mainLogFile(File template) throws IOException {
        if (!template.getName().endsWith(".log")) {
            template = new File(template.getParentFile(), template.getName() + ".log");
        }
        if (new File(template.getParentFile(), template.getName().substring(0, template.getName().length() - 4) + ".metadata").exists()) {
            return template.getCanonicalFile();
        }
        String[] components = template.getName().split("\\.");
        if (components.length > 2) {
            try {
                Integer.parseInt(components[components.length - 1]);
                int versionSuffixPos = template.getName().substring(0, template.getName().length() - 4).lastIndexOf(".");
                File versionStripped = new File(template.getParentFile(), template.getName().substring(0, versionSuffixPos));
                if (new File(versionStripped.getParentFile(), versionStripped.getName() + ".metadata").exists()) {
                    return new File(versionStripped.getParentFile(), versionStripped.getName() + ".log");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return template.getCanonicalFile();
    }

    private final String getLogRelativePath(File log) throws IOException {
        return UtlFile.relativePath((File)this.workingDir, (File)log).replace('\\', '/');
    }

    private final String getLogRelativeDirectory(RogLog log) throws IOException {
        String relPath = this.getLogRelativePath(log.getLogFile());
        return relPath.substring(0, relPath.length() - log.getLogFile().getName().length());
    }

    private final String getRelativeLogAlias(RogLog log) throws IOException {
        String relativePath = this.getLogRelativeDirectory(log);
        if (relativePath.length() > 0) {
            return relativePath + this.getLogNameAlias(log);
        }
        return this.getLogNameAlias(log);
    }

    private final String getLogNameAlias(RogLog log) throws IOException {
        return log.getName();
    }

    private final void openLogOrDirectory(File file, boolean repair, String openMode, Properties properties) throws Exception {
        if (file.exists() && file.isDirectory()) {
            for (File log : file.listFiles(this.logMetadataFilter)) {
                File logFile = new File(file, log.getName().substring(0, log.getName().length() - 9));
                try {
                    this.openLog(logFile, repair, openMode, properties);
                }
                catch (Exception e) {
                    this.interactiveTool.error("Failed to open '" + logFile + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            this.openLog(file, repair, openMode, properties);
        }
    }

    private final void openLog(File logfile, boolean repair, String openMode, Properties properties) throws Exception {
        File mainLogFile = this.mainLogFile(logfile).getCanonicalFile();
        String name = mainLogFile.getName();
        name = name.substring(0, name.length() - 4);
        File metadata = new File(mainLogFile.getParentFile(), name + ".metadata");
        if (!metadata.exists()) {
            this.interactiveTool.error("Log doesn't exist, no metadata for '" + metadata + "' for '" + logfile + "'");
            return;
        }
        if (this.openLogs.containsKey(mainLogFile)) {
            this.interactiveTool.info("Log already opened: " + mainLogFile.getCanonicalPath());
            return;
        }
        this.interactiveTool.info("Opening log '" + this.getLogRelativePath(mainLogFile) + "'");
        File factoriesFile = new File(mainLogFile.getParent(), name + ".factories");
        if (factoriesFile.exists()) {
            new Factories().doFactories(factoriesFile.getCanonicalPath());
        } else {
            this.interactiveTool.info("Factories file '" + factoriesFile + "' was not found.");
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (!properties.containsKey("logScavengePolicy")) {
            properties.put("logScavengePolicy", this.logScavengePolicy);
        }
        if (!"disabled".equalsIgnoreCase(properties.getProperty("logScavengePolicy"))) {
            this.interactiveTool.info("...log scavenge policy is set to '" + properties.getProperty("logScavengePolicy") + "'.");
        }
        if (metadata.exists()) {
            RogLogMetadata logMetadata = new RogLogMetadata(metadata.getParentFile(), name);
            logMetadata.open();
            if (logMetadata.isCdcEnabled() && !properties.containsKey("cdcEnabled")) {
                properties.put("cdcEnabled", "" + logMetadata.isCdcEnabled());
                this.interactiveTool.info("...enabling CDC.");
            }
            logMetadata.close();
        }
        RogLog log = this.createLog(mainLogFile, repair, openMode, properties);
        log.open();
        this.openLogs.put(mainLogFile, log);
        if (this.reader == null) {
            this.reader = log.createReader();
            this.reader.setLazyDeserialization(this.deserializationPolicy == DeserializationPolicy.Lazy);
            this.interactiveTool.info("reader opened with " + (Object)((Object)this.deserializationPolicy) + " deserialization.");
        }
        if (this.queryEngine != null) {
            RogLogRepository repo = log.asRepository();
            repo.open();
            this.queryEngine.addRepository(repo, this.getLogNameAlias(log));
        }
    }

    private final RogLog createLog(File log, boolean repair, String openMode, Properties openProps) throws IOException, OdsException {
        File mainLogFile = this.mainLogFile(log);
        String name = mainLogFile.getName().substring(0, mainLogFile.getName().length() - 4);
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        props.setProperty("storeRoot", mainLogFile.getParent());
        props.setProperty("autoRepair", String.valueOf(repair));
        props.setProperty("logMode", openMode);
        if (openProps != null) {
            props.putAll((Map<?, ?>)openProps);
        }
        return RogLog.create(name, props);
    }

    private final void listOpen() throws IOException {
        this.listOpen(null, true);
    }

    private final void listOpen(String filter, boolean verbose) throws IOException {
        if (this.openLogs.isEmpty()) {
            this.interactiveTool.info("No logs are currently open. Use 'open' to open a log.");
            return;
        }
        if (filter == null) {
            this.interactiveTool.info("There are " + this.openLogs.size() + " open logs:");
            for (RogLog log : this.openLogs.values()) {
                this.listLog(log, verbose);
            }
        } else {
            this.interactiveTool.info("There are " + this.openLogs.size() + " open logs, matching against '" + filter + "':");
            for (RogLog log : this.openLogs.values()) {
                String line = this.getLogNameAlias(log);
                if (filter != null && line.indexOf(filter) == -1) continue;
                this.listLog(log, verbose);
            }
        }
    }

    private final void listLog(RogLog log, boolean verbose) throws IOException {
        this.interactiveTool.info(this.getLogNameAlias(log) + (verbose ? " [" + log.getLogFile().getCanonicalPath() + "]" : ""));
        if (verbose) {
            this.interactiveTool.info("  Log Version    : " + log.getMetadata().getVersion());
            this.interactiveTool.info("  Used Size      : " + UtlFile.readableFileSize((long)log.getSize()));
            this.interactiveTool.info("  File Size      : " + UtlFile.readableFileSize((long)log.getLogFile().length()));
            this.interactiveTool.info("  Free Disk      : " + UtlFile.readableFileSize((long)log.getLogFile().getFreeSpace()));
            this.interactiveTool.info("  Last Modified  : " + UtlTime.format((Date)new Date(log.getLogFile().lastModified())));
            this.interactiveTool.info("  Validated FP   : " + log.getMetadata().getLastValidatedPosition());
            this.interactiveTool.info("  Log Number     : " + log.getMetadata().getLiveLogNumber());
            this.interactiveTool.info("  CDC Chkpt Ver  : " + log.getMetadata().getCdcCheckpointVersion());
            this.interactiveTool.info("  CDC Cursor     : " + log.getMetadata().getCdcCursor());
            this.interactiveTool.info("  CDC Log Number : " + log.getMetadata().getCdcLogNumber());
            if (this.queryEngine != null) {
                for (RogLogRepository repo : this.queryEngine.getRepositories()) {
                    if (repo.getLog() != log) continue;
                    this.interactiveTool.info("  Num Indexes    :" + ((QueryIndexableRepository)((Object)repo)).getIndexes().size());
                    this.interactiveTool.info("  Index Complete :" + ((QueryIndexableRepository)((Object)repo)).isLiveIndexingUpToDate());
                }
            }
        }
    }

    private final boolean closeLogOrDirectory(File file) throws Exception {
        if (file.exists() && file.isDirectory()) {
            boolean closed = false;
            for (File log : file.listFiles(this.logMetadataFilter)) {
                closed |= this.closeLog(new File(file, log.getName().substring(0, log.getName().length() - 9)));
            }
            return closed;
        }
        return this.closeLog(file);
    }

    private void closeQuery() throws Exception {
        this.closeQueryResult();
        if (this.mode == Mode.QUERY) {
            this.switchTo("browse");
        }
    }

    private void closeQueryResult() {
        if (this.queryResults != null) {
            this.queryResults.close();
            this.queryResults = null;
            this.resultHeaders.clear();
            this.resultRowFormats.clear();
            this.resultFooters.clear();
        }
    }

    private final boolean closeLog(File logfile) throws Exception {
        File mainLogFile = this.mainLogFile(logfile);
        RogLog log = this.openLogs.remove(mainLogFile);
        if (log == null) {
            this.interactiveTool.info("No log named '" + logfile.getName() + " to close");
            return false;
        }
        if (this.queryEngine != null) {
            this.interactiveTool.info("Removing log '" + this.getLogNameAlias(log) + "' from the query engine");
            if (this.queryEngine != null) {
                this.closeQuery();
                for (QueryRepository queryRepository : this.queryEngine.getRepositories()) {
                    RogLogRepository logRepo;
                    if (!(queryRepository instanceof RogLogRepository) || queryRepository.getName() != log.getName() || (logRepo = (RogLogRepository)queryRepository).getLog() != log) continue;
                    logRepo.close();
                }
                this.queryEngine.removeRepository(this.getLogNameAlias(log));
            }
        }
        log.close();
        if (this.reader != null && this.reader.log().getName() == log.getName()) {
            this.reader = null;
            if (!this.inQueryMode()) {
                this.updatePrompt();
            }
        }
        return true;
    }

    private final void assertOpen() throws Exception {
        if (this.reader == null || !this.reader.log().isOpen()) {
            throw new Exception("This command requires an open log. Please use the 'open' command");
        }
    }

    private final void assertQueryMode() throws Exception {
        if (this.mode != Mode.QUERY) {
            throw new Exception("This command is only valid in query mode. Use 'switch query' to enter query mode");
        }
    }

    private final void assertBrowseMode() throws Exception {
        if (this.mode != Mode.BROWSE) {
            throw new Exception("This command is only valid in browse mode. Use 'switch browse' to enter browse mode");
        }
    }

    private final void assertResultSet() throws Exception {
        this.assertQueryMode();
        if (this.queryResults == null) {
            throw new Exception("In query mode this command is only valid with a result set. Run 'SELECT' first.");
        }
    }

    private final boolean inQueryMode() {
        return this.queryEngine != null && this.mode == Mode.QUERY;
    }

    private void writeEntry(RogLog.Entry entry, boolean detailed, boolean csv, boolean showLog, PrintStream out) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        this.writeEntry(entry, detailed, csv, showLog, bw);
        bw.flush();
    }

    private final void writeEntry(RogLog.Entry entry, boolean detailed, boolean csv, boolean showLog, BufferedWriter bw) throws IOException {
        if (!detailed) {
            bw.write(entry.toString(csv));
            bw.newLine();
        } else {
            RogLogUtil.dumpLogEntryJson(entry, this.metadataDisplay != MetadataPolicy.Off, this.metadataDisplay != MetadataPolicy.Only, this.filterUnsetFields, this.jsonPrettyPrintStyle, bw);
            bw.newLine();
        }
    }

    private void writeResultSetRow(RogLogResultSet resultSet, boolean detailed, boolean csv, boolean showLog, PrintStream out) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        this.writeResultSetRow(resultSet, detailed, csv, showLog, bw);
        bw.flush();
    }

    private void writeResultSetRow(RogLogResultSet resultSet, boolean detailed, boolean csv, boolean showLog, BufferedWriter bw) throws IOException {
        if (csv) {
            RogLogUtil.dumpResultSetRowCsv(resultSet, bw);
        } else if (detailed) {
            RogLogUtil.dumpResultSetRowJson(resultSet, this.metadataDisplay != MetadataPolicy.Off, this.metadataDisplay != MetadataPolicy.Only, this.filterUnsetFields, this.jsonPrettyPrintStyle, bw);
            bw.newLine();
        } else {
            RogLogUtil.dumpResultSetRowTabular(resultSet, bw);
        }
    }

    private final void writeQueryResult(PrintStream out, boolean includeHeader, UtlTableFormatter.Format format) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        this.writeQueryResult(bw, includeHeader, format);
        bw.flush();
    }

    private final void writeQueryResult(BufferedWriter bw, boolean includeHeader, UtlTableFormatter.Format format) throws IOException {
        String header = this.resultHeaders.get(format);
        if (header == null) {
            header = UtlQueryResultFormatter.getHeader(this.queryResults, format);
            this.resultHeaders.put(format, header);
            this.resultRowFormats.put(format, UtlQueryResultFormatter.getRowFormatString(this.queryResults, format));
            this.resultFooters.put(format, UtlQueryResultFormatter.getFooter(this.queryResults, format));
        }
        String rowFormat = this.resultRowFormats.get(format);
        if (includeHeader) {
            bw.write(header);
        }
        bw.write(UtlQueryResultFormatter.formatRow(this.queryResults, rowFormat, format));
    }

    private static void printUsage() {
        System.err.println("                 [{-e, --extractionDir the extraction folder to use for transaction log archives]");
        System.err.println("                 [{-i, --initScripts <list-of scripts> to run at start} a comma separated list");
        System.err.println("                                     of scripts to run before entering interactive mode or running");
        System.err.println("                                     the main script.");
        System.err.println("                 [{-s, --script <script name>} run the tool from a script]");
        System.err.println("                 [{-h, --help} print this help string]");
    }

    public static void main(String[] args) {
        try {
            if (System.getProperty("nv.indent.json") == null) {
                System.setProperty("nv.indent.json", "true");
            }
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option extractionDirOption = parser.addStringOption('e', "extractionDir");
            CmdLineParser.Option initScriptNameOption = parser.addStringOption('i', "initScripts");
            CmdLineParser.Option scriptNameOption = parser.addStringOption('s', "script");
            CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
            File scriptFile = null;
            File extractionDir = null;
            parser.parse(args);
            if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                String extractionDirName;
                String initScriptPaths;
                String scriptName = (String)parser.getOptionValue(scriptNameOption, null);
                File file = scriptFile = scriptName == null ? null : new File(scriptName);
                if (scriptFile != null && !scriptFile.exists()) {
                    System.err.println("Cannot find script file '" + scriptFile + "'");
                    System.exit(-1);
                }
                if ((initScriptPaths = (String)parser.getOptionValue(initScriptNameOption, null)) != null) {
                    XRuntime.getProps().setProperty(PROP_TLT_INIT_SCRIPTS, initScriptPaths);
                }
                File file2 = extractionDir = (extractionDirName = (String)parser.getOptionValue(extractionDirOption, null)) == null ? null : new File(extractionDirName);
                if (extractionDir != null) {
                    if (!extractionDir.exists()) {
                        if (!extractionDir.mkdirs()) {
                            System.err.println("Failed to create specified archive extraction dir '" + extractionDir + "'");
                            System.exit(-1);
                        }
                    } else if (!extractionDir.isDirectory()) {
                        System.err.println("Specified extraction dir '" + extractionDir + "' is not a directory.");
                        System.exit(-1);
                    }
                }
            } else {
                TransactionLogTool.printUsage();
            }
            if (scriptFile != null) {
                new TransactionLogTool(extractionDir).run(scriptFile);
            } else {
                new TransactionLogTool(extractionDir).run();
            }
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public Collection<RogLog> open(String logPath) {
        this.interactiveTool.executeCommand("open " + logPath);
        return this.openLogs.values();
    }

    public Collection<RogLog> getOpenLogs() {
        return this.openLogs.values();
    }

    public RogLogQueryEngine getQueryEngine() throws Exception {
        this.switchTo("query");
        return this.queryEngine;
    }

    public String getLogFromUUID(String logId) {
        for (RogLog log : this.openLogs.values()) {
            if (!log.getLogUUID().toString().equals(logId)) continue;
            return log.getName();
        }
        return null;
    }

    public Collection<Class<?>> getTypes() throws Exception {
        this.switchTo("query");
        return ((RogLogQueryEngineImpl)this.queryEngine).getTypes();
    }

    @AnnotatedCommand.Command(keywords={"archive"}, description="Creates an executable jar archive of transaction logs")
    public final class Archive
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=109, longForm="includeMessageLogs", defaultValue="false", required=false, description="flag indicating that corresponding inbound and outbound message logs should also be included in the archive")
        private boolean includeMessageLogs;
        @AnnotatedCommand.Option(shortForm=115, longForm="includePerTransactionStatsLog", defaultValue="false", required=false, description="flag indicating that corresponding transactionstats logs should also be included in the archive")
        private boolean includePerTransactionStats;
        @AnnotatedCommand.Option(shortForm=110, longForm="name", required=false, description="The name to use for the archive. If ommitted and a single log is specified its name will be used, otherwise 'archive' will be used.")
        private String name;
        @AnnotatedCommand.Option(shortForm=97, longForm="additional", required=false, description="A path delimited set of <archive-target-dir>=<source-fileOrDir-path> pairs indicating additional files or directories to include in the archive. Directories are copied into the archive recursively.\n            Examples\n            -a .=conf:logs=rdat/xserver.log:logs=/root/logs/mylog.log:.=errors.txt\n            Would result in\n            - conf being recursively copied to conf in the archive\n            - rdat/xserver.log being copied to logs/xserver.log\n            - /root/logs/mylog.log being copied to logs/mylog.log\n            - errors.txt being copied to errors.txt in the archive\n           ")
        private String additionalContent;
        @AnnotatedCommand.Argument(position=1, name="log", required=true, description="The path to the log that should be archived")
        File log;
        @AnnotatedCommand.RemainingArgs(name="additionalLogs", required=false, description="Additional logs to add to the archive")
        String[] additionalLogs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute() throws Exception {
            if (this.log.isDirectory()) {
                throw new Exception("Can't archive a directory, a log file must be specified");
            }
            TreeMap<String, RogLog> included = new TreeMap<String, RogLog>();
            ArrayList<File> toReopen = new ArrayList<File>();
            this.openLogsForArchive(this.log, included, toReopen);
            for (String additional : this.additionalLogs) {
                File additionalFile = new File(UtlFile.expandPath((String)additional));
                if (additionalFile.isDirectory()) {
                    this.console().error("Can't archive a directory, a log file must be specified, " + additionalFile + " will be ignored");
                    continue;
                }
                this.openLogsForArchive(additionalFile, included, toReopen);
            }
            if (Strings.isNullOrEmpty((String)this.name)) {
                this.name = this.additionalLogs != null && this.additionalLogs.length > 0 ? "archive" : included.firstEntry().getValue().getName();
            }
            ArrayList<String> additionalContentList = null;
            if (this.additionalContent != null) {
                additionalContentList = new ArrayList<String>();
                StringTokenizer contentTok = new StringTokenizer(this.additionalContent, File.pathSeparator);
                while (contentTok.hasMoreTokens()) {
                    additionalContentList.add(contentTok.nextToken());
                }
            }
            try {
                File archive = RogLogUtil.createExecutableArchive(new File(TransactionLogTool.this.workingDir, "archives"), this.name, this.console().out(), null, additionalContentList, included.values().toArray(new RogLog[0]));
                this.console().info("Successfully created archive: " + UtlFile.relativePath((File)TransactionLogTool.this.workingDir, (File)archive) + " (" + UtlFile.readableFileSize((long)archive.length()) + ")");
            }
            finally {
                for (RogLog archived : included.values()) {
                    archived.close();
                }
            }
        }

        private void openLogsForArchive(File log, Map<String, RogLog> logs, List<File> toReopen) throws Exception {
            RogLog txnstats;
            RogLog main = this.openLogForArchive(log = TransactionLogTool.this.mainLogFile(log), toReopen);
            if (main == null) {
                throw new Exception("Log file " + log + " does not exist");
            }
            logs.put(main.getLogFile().getCanonicalPath(), main);
            if (this.includeMessageLogs) {
                RogLog outbound;
                RogLog inbound = this.openLogForArchive(new File(main.getLogFile().getParent(), main.getName() + ".in.log"), toReopen);
                if (inbound != null) {
                    logs.put(inbound.getLogFile().getCanonicalPath(), inbound);
                }
                if ((outbound = this.openLogForArchive(new File(main.getLogFile().getParent(), main.getName() + ".out.log"), toReopen)) != null) {
                    logs.put(outbound.getLogFile().getCanonicalPath(), outbound);
                }
            }
            if (this.includePerTransactionStats && (txnstats = this.openLogForArchive(new File(main.getLogFile().getParent(), main.getName() + ".txnstats.log"), toReopen)) != null) {
                logs.put(txnstats.getLogFile().getCanonicalPath(), txnstats);
            }
        }

        private final RogLog openLogForArchive(File log, List<File> toReopen) throws Exception {
            File metadata = new File((log = TransactionLogTool.this.mainLogFile(log)).getParentFile(), log.getName().substring(0, log.getName().length() - 4) + ".metadata");
            if (!metadata.exists()) {
                return null;
            }
            if (TransactionLogTool.this.openLogs.containsKey(log)) {
                TransactionLogTool.this.closeLog(log);
                toReopen.add(log);
            }
            return TransactionLogTool.this.createLog(log, false, "r", null);
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"COUNT", "count"}, description="Get the number of matching results in a query")
    public final class Count
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            TransactionLogTool.this.assertQueryMode();
            TransactionLogTool.this.assertResultSet();
            this.console().info("" + TransactionLogTool.this.queryResults.getCount());
        }
    }

    @AnnotatedCommand.Command(keywords={"SCHEMA", "schema", "NAMESPACE", "namespace", "PACKAGE", "package"}, description="Sets the default package for resolving ambiguous unqualified class references")
    public final class Schema
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=120, longForm="clear", defaultValue="false", description="Indicates that current default schema should be cleared")
        boolean clear;
        @AnnotatedCommand.Argument(position=1, name="packageName", required=false, description="A package name e.g. com.foo or com/foo, required unless -x is specified")
        String packageName;

        public final void execute() throws Exception {
            boolean changed = false;
            if (this.clear) {
                if (TransactionLogTool.this.defaultPackage != null) {
                    changed = true;
                }
                TransactionLogTool.this.defaultPackage = null;
            } else if (this.packageName != null && this.packageName.length() > 0) {
                Package newPackage = Package.getPackage(this.packageName.replace('/', '.'));
                if (newPackage == null) {
                    throw new IllegalArgumentException("Package not found: " + this.packageName);
                }
                changed = TransactionLogTool.this.defaultPackage == null || !TransactionLogTool.this.defaultPackage.equals(newPackage);
                TransactionLogTool.this.defaultPackage = newPackage;
            }
            if (TransactionLogTool.this.queryEngine != null && changed) {
                TransactionLogTool.this.queryEngine.setDefaultPackage(TransactionLogTool.this.defaultPackage);
            }
            if (changed) {
                if (TransactionLogTool.this.defaultPackage != null) {
                    this.console().info("Default package set to " + TransactionLogTool.this.defaultPackage.getName());
                } else {
                    this.console().info("Default package cleared");
                }
            } else if (TransactionLogTool.this.defaultPackage != null) {
                this.console().info("Default package is " + TransactionLogTool.this.defaultPackage.getName());
            } else {
                this.console().info("No default package set");
            }
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"DESCRIBE", "describe"}, description="Describes the fields for a given object.")
    public final class Describe
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="type", required=true, description="The name of the type to describe, must be fully qualified e.g. com.mycompany.MyClass, if ambiguous")
        String type;

        public final void execute() throws Exception {
            TransactionLogTool.this.assertOpen();
            TransactionLogTool.this.switchTo("query");
            RogLogQueryFieldResolver resolver = (RogLogQueryFieldResolver)((RogLogQueryEngineImpl)TransactionLogTool.this.queryEngine).getQueryFieldResolver(RogLog.Entry.class);
            try {
                StringBuffer desc = new StringBuffer();
                resolver.describeFields(TransactionLogTool.this.queryEngine.getField(this.type), desc);
                this.console().info(desc.toString());
            }
            catch (QueryException qe) {
                this.console().error("Error resolving type '" + this.type + "' " + qe.getMessage(), (Throwable)((Object)qe));
            }
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"LIST", "list"}, description="Lists objects.")
    public final class ListCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=118, longForm="verbose", defaultValue="false", required=false, description="Whether to list extra details if avaiable")
        boolean verbose;
        @AnnotatedCommand.Argument(position=1, name="type", required=true, validOptions={"indexes", "types", "logs", "open", "schema", "commands"}, description="What to list. A value of 'indexes' lists the indexes on open logs. A value of 'types' lists the types available for query. A value of 'logs' or 'open' lists the currently open logs.")
        String type;
        @AnnotatedCommand.Argument(position=2, name="filter", required=false, description="An optional, case sensitive filter on list")
        String filter;
        private volatile boolean interrupted = false;

        public final void execute() throws Exception {
            this.interrupted = false;
            if (this.type.equalsIgnoreCase("indexes")) {
                TransactionLogTool.this.assertOpen();
                TransactionLogTool.this.switchTo("query");
                Set indexedFields = TransactionLogTool.this.queryEngine.getIndexedFields();
                if (!indexedFields.isEmpty()) {
                    for (IdxField field : indexedFields) {
                        if (!this.interrupted) {
                            String line = (this.verbose ? field.getCanonicalName() : field.getName()) + ": path=" + field.getFieldPath();
                            if (this.verbose) {
                                line = line + ", fieldType=" + field.getFieldType().getSimpleName() + ", recordType=" + field.getRecordType().getName();
                            }
                            if (this.filter != null && line.indexOf(this.filter) == -1) continue;
                            this.console().info(line);
                            if (!this.verbose) continue;
                            for (QueryRepository queryRepository : TransactionLogTool.this.queryEngine.getRepositories()) {
                                if (queryRepository.getIndex(field) == null) {
                                    this.console().info("  " + queryRepository.getName() + ": NO INDEX");
                                    continue;
                                }
                                IdxIndex index = queryRepository.getIndex(field);
                                IdxIndex.Stats<?> stats = queryRepository.getIndex(field).getStats();
                                this.console().info("  " + queryRepository.getName() + "indexer : " + index + ":");
                                this.console().info("     live        : " + stats.isLive());
                                this.console().info("     current     : " + ((QueryIndexableRepository)queryRepository).isLiveIndexingUpToDate());
                                this.console().info("     commitSeqNo : " + stats.getCommitSequenceNumber());
                                this.console().info("     cardinality : " + stats.getCardinality());
                                this.console().info("     keys        : " + stats.getKeyCardinality());
                                this.console().info("     lowKey      : " + stats.getLowKey());
                                this.console().info("     highKey     : " + stats.getHighKey());
                            }
                            continue;
                        }
                        break;
                    }
                } else {
                    this.console().info("No indexes found for the currently opened log(s). Use 'create index' command to create one");
                }
            } else if (this.type.equalsIgnoreCase("types")) {
                TransactionLogTool.this.assertOpen();
                TransactionLogTool.this.switchTo("query");
                for (Class<?> type : ((RogLogQueryEngineImpl)TransactionLogTool.this.queryEngine).getTypes()) {
                    if (!this.interrupted) {
                        if (type.isInterface()) continue;
                        String line = type.getCanonicalName().replace(".", "/");
                        if (this.filter != null && line.indexOf(this.filter) == -1) continue;
                        this.console().info(line);
                        continue;
                    }
                    break;
                }
            } else if (this.type.equalsIgnoreCase("logs") || this.type.equalsIgnoreCase("open")) {
                TransactionLogTool.this.listOpen(this.filter, this.verbose);
            } else if (this.type.equalsIgnoreCase("schema")) {
                TransactionLogTool.this.assertOpen();
                TransactionLogTool.this.switchTo("query");
                HashSet<String> schemas = new HashSet<String>();
                for (Class<?> type : ((RogLogQueryEngineImpl)TransactionLogTool.this.queryEngine).getTypes()) {
                    if (this.interrupted) break;
                    if (type.isInterface()) continue;
                    String line = type.getPackage().getName();
                    if (this.filter != null && line.indexOf(this.filter) == -1) continue;
                    schemas.add(type.getPackage().getName());
                }
                ArrayList schemaList = new ArrayList(schemas);
                Collections.sort(schemaList);
                for (String schema : schemaList) {
                    this.console().info(schema);
                }
            } else if (this.type.equalsIgnoreCase("commands")) {
                TransactionLogTool.this.interactiveTool.listCommands(this.filter);
            }
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }
    }

    @AnnotatedCommand.Command(keywords={"SELECT", "select"}, parseOptions=false, preserveArgumentQuotes=true, description="Issues a select statement against one or more open logs.")
    public final class Select
    extends AnnotatedCommand {
        @AnnotatedCommand.RemainingArgs(name="query", required=true, description="<fields> FROM <logs> WHERE <conditions>. The keyword 'logs' in the FROM clause selects all open logs")
        String remainingArgs;

        public final void execute() throws Exception {
            boolean showQueryPlan;
            TransactionLogTool.this.assertOpen();
            TransactionLogTool.this.closeQueryResult();
            if (TransactionLogTool.this.mode != Mode.QUERY) {
                TransactionLogTool.this.switchTo("query");
            }
            Stopwatch timer = Stopwatch.createStarted();
            TransactionLogTool.this.queryResults = TransactionLogTool.this.queryEngine.execute(TransactionLogTool.this.queryEngine.createQuery("SELECT " + this.remainingArgs));
            int estimate = TransactionLogTool.this.queryResults.getEstimatedCount();
            boolean showPreview = TransactionLogTool.this.interactiveTool.isInteractive();
            boolean bl = showQueryPlan = TransactionLogTool.this.interactiveTool.isInteractive() && TransactionLogTool.this.showQueryPlan;
            if (showQueryPlan) {
                TransactionLogTool.this.queryResults.describePlan(TransactionLogTool.this.interactiveTool.out());
            }
            this.console().info("Query plan prepared in " + timer.toString() + ".");
            if (TransactionLogTool.this.queryResults.isFullScan()) {
                this.console().info("  No suitable indexes found for query, full scan will be performed to serve results.");
            } else {
                this.console().info("  Approximately " + estimate + " entries need to be inspected to show results.");
            }
            if (TransactionLogTool.this.selectPreviewCount > 0 && showPreview) {
                int i;
                this.console().info("Result Preview:");
                for (i = 0; TransactionLogTool.this.queryResults.next() && i < TransactionLogTool.this.selectPreviewCount; ++i) {
                    TransactionLogTool.this.writeQueryResult(this.console().out(), i == 0, UtlTableFormatter.Format.TABULAR);
                }
                if (i == 0) {
                    this.console().info("...no results.");
                }
                if (i > 0) {
                    TransactionLogTool.this.queryResults.beforeFirst();
                    this.console().info("Results rewound.");
                }
            }
            this.console().info("Use 'next', 'next <count>', 'dump' or 'count' commands to display results");
        }
    }

    @AnnotatedCommand.Command(keywords={"drop", "DROP"}, description="Drops a log index")
    public final class Drop
    extends AnnotatedCommand {
        @AnnotatedCommand.RemainingArgs(required=true, name="name", description="the drop statement 'DROP INDEX <indexName>', Use 'list' indexes to see existing indexes")
        String remainingArgs;

        public final void execute() throws Exception {
            TransactionLogTool.this.assertQueryMode();
            TransactionLogTool.this.queryEngine.executeStatement("DROP " + this.remainingArgs);
        }
    }

    @AnnotatedCommand.Command(keywords={"create", "CREATE"}, description="Creates log indexes.")
    public final class Create
    extends AnnotatedCommand {
        @AnnotatedCommand.RemainingArgs(name="indexArgs", required=true, description="<optional:UNIQUE> INDEX <name> ON <log_name|logs>(<indexField>) indexField is specified the same as it would in a select or where clause.")
        String remainingArgs;

        public final void execute() throws Exception {
            TransactionLogTool.this.assertOpen();
            if (TransactionLogTool.this.mode != Mode.QUERY) {
                TransactionLogTool.this.switchTo("query");
            }
            TransactionLogTool.this.queryEngine.executeStatement("CREATE " + this.remainingArgs);
        }
    }

    @AnnotatedCommand.Command(keywords={"compare"}, description="Compares two logs")
    public final class Compare
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=118, longForm="verbose", defaultValue="false", required=false, description="Whether to dump comparison information for debugging purposes")
        boolean verbose;
        @AnnotatedCommand.Option(shortForm=99, longForm="csv", defaultValue="false", description="indicates that csv mode should be used when displaying diffs in the console, otherwise a tabular format will be used")
        boolean csv;
        @AnnotatedCommand.Option(shortForm=109, longForm="metadata", defaultValue="false", required=false, description="Indicates that platform metadata should be considered as well")
        boolean metadata;
        @AnnotatedCommand.Option(shortForm=115, longForm="state", defaultValue="false", required=false, description="If the two logs are state replication recovery logs, this flag will compare their rebuilt state")
        boolean state;
        @AnnotatedCommand.Option(shortForm=108, longForm="limit", defaultValue="5", required=false, description="The number of divergent entries to display or dump once the first divergence is detected")
        int limit;
        @AnnotatedCommand.Argument(position=1, required=true, name="log1Name", description="The name of log to compare relative to the current working directory (no .log suffix)")
        File log1;
        @AnnotatedCommand.Argument(position=2, required=true, name="log2Name", description="The name of second log to compare relative to the current working directory (no .log suffix).")
        File log2;
        @AnnotatedCommand.Argument(position=3, required=false, name="outputFile", description="The name of a file to which to dump diff results. A suffix of .csv will yield csv output, .html will yield html, otherwise a textual tabular format is used.")
        File dumpFile;

        public final void execute() throws Exception {
            TransactionLogTool.this.openLog(this.log2, false, "r", null);
            TransactionLogTool.this.openLog(this.log1, false, "r", null);
            TransactionLogTool.this.switchTo(this.log1);
            try {
                BufferedWriter bw;
                RogLog first = (RogLog)TransactionLogTool.this.openLogs.get(TransactionLogTool.this.mainLogFile(this.log1));
                RogLog second = (RogLog)TransactionLogTool.this.openLogs.get(TransactionLogTool.this.mainLogFile(this.log2));
                UtlTableFormatter.Format format = UtlTableFormatter.Format.TABULAR;
                if (this.dumpFile != null) {
                    if (this.dumpFile.exists()) {
                        throw new Exception("File already exists");
                    }
                    if (this.dumpFile.getName().endsWith(".html")) {
                        format = UtlTableFormatter.Format.HTML;
                    } else if (this.dumpFile.getName().endsWith(".csv")) {
                        format = UtlTableFormatter.Format.CSV;
                    }
                    bw = new BufferedWriter(new FileWriter(this.dumpFile));
                } else {
                    bw = new BufferedWriter(new PrintWriter(this.console().out()));
                }
                if (this.csv) {
                    format = UtlTableFormatter.Format.CSV;
                }
                boolean divergent = false;
                if (this.state) {
                    divergent = !RogLogUtil.compareState(first, second, RogLogUtil.loadComparisonFilter(), bw, this.metadata, this.verbose, format);
                } else {
                    boolean bl = divergent = !RogLogUtil.compareEntries(first, second, RogLogUtil.loadComparisonFilter(), bw, this.limit, this.metadata, this.verbose, format);
                }
                if (this.dumpFile != null) {
                    if (!divergent) {
                        this.console().info("Logs are not divergent.");
                    } else {
                        this.console().info("Logs are divergent.");
                    }
                }
                if (this.dumpFile != null) {
                    bw.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Error comparing logs:" + e.getMessage(), e);
            }
        }

        public boolean interruptable() {
            return false;
        }
    }

    private final class NoOpCdcHandler
    implements IRogChangeDataCaptureHandler {
        private NoOpCdcHandler() {
        }

        @Override
        public void onLogStart(int logNumber) {
            TransactionLogTool.this.interactiveTool.info("[CDC HANDLER] Starting CDC on Log #" + logNumber + "...");
        }

        @Override
        public void onLogComplete(int logNumber, IRogChangeDataCaptureHandler.LogCompletionReason reason, Throwable errorCause) {
            if (errorCause != null) {
                TransactionLogTool.this.interactiveTool.error("[CDC HANDLER] Completed CDC on Log #" + logNumber + "(" + (Object)((Object)reason) + ") - " + errorCause.getMessage(), errorCause);
            } else {
                TransactionLogTool.this.interactiveTool.info("[CDC HANDLER] Completed CDC on Log #" + logNumber + "(" + (Object)((Object)reason) + ")");
            }
        }

        @Override
        public void onCheckpointStart(long checkpointVersion) {
            TransactionLogTool.this.interactiveTool.info("[CDC HANDLER] On Checkpoint #" + checkpointVersion + " start.");
        }

        @Override
        public boolean onCheckpointComplete(long checkpointVersion) {
            TransactionLogTool.this.interactiveTool.info("[CDC HANDLER] On Checkpoint #" + checkpointVersion + " complete.");
            return true;
        }

        @Override
        public void onWait() {
            TransactionLogTool.this.interactiveTool.info("[CDC HANDLER] On Wait.");
        }

        @Override
        public boolean handleChange(UUID objectId, IRogChangeDataCaptureHandler.ChangeType changeType, List<IRogNode> entries) {
            TransactionLogTool.this.interactiveTool.info("[CDC HANDLER] on change [" + (entries.size() > 0 ? entries.get(0).getClass().getSimpleName() : "???") + "(id=" + objectId + "), ctype " + (Object)((Object)changeType) + ", entries=" + entries.size() + "]");
            return true;
        }
    }

    @AnnotatedCommand.Command(keywords={"cdc"}, description="Performs change data capture on the log. (browse mode only)", hidden=true)
    public final class Cdc
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=105, longForm="initialSize", defaultValue="10485760", required=false, description="The initial size of the new file into which to compact")
        long initialLogSize;
        @AnnotatedCommand.Option(shortForm=119, longForm="compactionWindow", defaultValue="-1", required=false, description="The compaction window size to use. A value <=0 indicates that the default windows size should be used.")
        long compactionWindowSize = -1L;

        public final void execute() throws Exception {
            TransactionLogTool.this.assertBrowseMode();
            TransactionLogTool.this.assertOpen();
            RogLog log = TransactionLogTool.this.reader.log();
            if (log.getLogFile().getName().endsWith("in.log")) {
                throw new Exception("Compaction not supported for inbound message logs");
            }
            if (log.getLogFile().getName().endsWith("out.log")) {
                throw new Exception("Compaction not supported for outbound message logs");
            }
            if (TransactionLogTool.this.queryEngine != null) {
                TransactionLogTool.this.closeQuery();
                for (QueryRepository queryRepository : TransactionLogTool.this.queryEngine.getRepositories()) {
                    RogLogRepository logRepo;
                    if (!(queryRepository instanceof RogLogRepository) || queryRepository.getName() != log.getName() || (logRepo = (RogLogRepository)queryRepository).getLog() != log) continue;
                    logRepo.close();
                }
                TransactionLogTool.this.queryEngine.removeRepository(TransactionLogTool.this.getLogNameAlias(log));
            }
            RogLogCdcProcessor cdcProcessor = log.createCdcProcessor(new NoOpCdcHandler());
            cdcProcessor.run();
            cdcProcessor.close();
            if (TransactionLogTool.this.reader != null) {
                TransactionLogTool.this.reader.close();
            }
            TransactionLogTool.this.reader = log.createReader();
            if (TransactionLogTool.this.queryEngine != null) {
                RogLogRepository rogLogRepository = log.asRepository();
                rogLogRepository.open();
                TransactionLogTool.this.queryEngine.addRepository(rogLogRepository, TransactionLogTool.this.getLogNameAlias(log));
            }
            Thread.sleep(200L);
            TransactionLogTool.this.updatePrompt();
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"compact"}, description="Compacts a state replication log. (browse mode only)", hidden=true)
    public final class Compact
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=105, longForm="initialSize", defaultValue="0", required=false, description="The initial size of the new file into which to compact")
        long initialLogSize;

        public final void execute() throws Exception {
            TransactionLogTool.this.assertBrowseMode();
            TransactionLogTool.this.assertOpen();
            RogLog log = TransactionLogTool.this.reader.log();
            if (log.getLogFile().getName().endsWith("in.log")) {
                throw new Exception("Compaction not supported for inbound message logs");
            }
            if (log.getLogFile().getName().endsWith("out.log")) {
                throw new Exception("Compaction not supported for outbound message logs");
            }
            if (TransactionLogTool.this.queryEngine != null) {
                TransactionLogTool.this.closeQuery();
                for (QueryRepository queryRepository : TransactionLogTool.this.queryEngine.getRepositories()) {
                    RogLogRepository logRepo;
                    if (!(queryRepository instanceof RogLogRepository) || queryRepository.getName() != log.getName() || (logRepo = (RogLogRepository)queryRepository).getLog() != log) continue;
                    logRepo.close();
                }
                TransactionLogTool.this.queryEngine.removeRepository(TransactionLogTool.this.getLogNameAlias(log));
            }
            RogLogCompactor compactor = log.getCompactor();
            if (this.initialLogSize >= 0L) {
                compactor.setNewLogInitialLogSize(this.initialLogSize);
            }
            compactor.compact();
            compactor.waitForCompactionToComplete();
            if (TransactionLogTool.this.reader != null) {
                TransactionLogTool.this.reader.close();
            }
            TransactionLogTool.this.reader = log.createReader();
            if (TransactionLogTool.this.queryEngine != null) {
                RogLogRepository rogLogRepository = log.asRepository();
                rogLogRepository.open();
                TransactionLogTool.this.queryEngine.addRepository(rogLogRepository, TransactionLogTool.this.getLogNameAlias(log));
            }
            Thread.sleep(200L);
            TransactionLogTool.this.updatePrompt();
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"logmetadata"}, description="Shows log metadata for the given transaction log", hidden=true)
    public final class LogMetadata
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=117, longForm="update", required=false, defaultValue="false", description="Instructs command to update a property ")
        boolean update;
        @AnnotatedCommand.Option(shortForm=108, longForm="list", required=false, defaultValue="true", description="Lists metadata for the given log")
        boolean list;
        @AnnotatedCommand.Argument(position=1, name="logName", required=true, description="The path to the log metata file.")
        File metadataFile;
        @AnnotatedCommand.RemainingArgs(name="updates", required=false, description="key=value pairs used to update metadata properties.")
        String[] updateValues;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws Exception {
            if (!this.metadataFile.exists()) {
                throw new IllegalArgumentException(this.metadataFile.getAbsolutePath() + " does not exist");
            }
            if (this.metadataFile.isDirectory()) {
                throw new IllegalArgumentException(this.metadataFile.getAbsolutePath() + " is not a file");
            }
            if (!this.metadataFile.getName().endsWith(".metadata")) {
                throw new IllegalArgumentException(this.metadataFile.getAbsolutePath() + " does not have a .metadata extension");
            }
            metadata.open();
            try (RogLogMetadata metadata = new RogLogMetadata(this.metadataFile.getParentFile(), this.metadataFile.getName().substring(0, this.metadataFile.getName().length() - 9));){
                if (this.list) {
                    this.console().info(metadata.toString());
                }
                if (this.update) {
                    if (this.updateValues == null || this.updateValues.length == 0) {
                        throw new IllegalArgumentException("key=value pairs must be supplied when the update flag is set");
                    }
                    for (int i = 0; i < this.updateValues.length; ++i) {
                        String[] kv = this.updateValues[i].split("=");
                        UtlReflection.setNonNestedProperty((Object)metadata, (String)kv[0], (Object)kv[1]);
                    }
                }
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"close"}, description="Close open logs and queries")
    public final class Close
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="target", required=false, description="Optionally specifies the name of a log or directory to close.")
        String target;

        public final void execute() throws Exception {
            boolean closed = false;
            if (this.target == null) {
                if (TransactionLogTool.this.reader != null) {
                    TransactionLogTool.this.reader.close();
                    TransactionLogTool.this.reader = null;
                    closed = true;
                }
                if (TransactionLogTool.this.queryEngine != null) {
                    this.console().info("Closing query engine...");
                    TransactionLogTool.this.closeQueryResult();
                    try {
                        TransactionLogTool.this.queryEngine.close();
                        this.console().info("Query engine closed.");
                    }
                    catch (Exception e) {
                        this.console().error("Error closing query engine: " + e.getMessage(), (Throwable)e);
                    }
                    TransactionLogTool.this.queryEngine = null;
                    closed = true;
                }
                for (RogLog log : TransactionLogTool.this.openLogs.values()) {
                    this.console().info("Closing " + log.getName());
                    try {
                        log.close();
                    }
                    catch (Exception e) {
                        this.error("Error closing " + log.getName() + ": " + e.getMessage(), e);
                    }
                    closed = true;
                }
                TransactionLogTool.this.openLogs.clear();
                if (!closed) {
                    this.console().info("No log to close.");
                }
                TransactionLogTool.this.updatePrompt();
            } else {
                if (!TransactionLogTool.this.openLogs.isEmpty()) {
                    this.console().info("Closing logs...");
                }
                if (!TransactionLogTool.this.closeLogOrDirectory(new File(UtlFile.expandPath((String)this.target)))) {
                    TransactionLogTool.this.listOpen();
                } else if (!TransactionLogTool.this.openLogs.isEmpty()) {
                    this.console().info("Logs closed");
                }
                TransactionLogTool.this.updatePrompt();
                TransactionLogTool.this.closeQuery();
            }
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"rewrite", "writelog"}, hidden=false, description="Rewrites the results of the current query as a new transaction log. Note that recovering from a rewritten transaction log is an inherently unsafe operation ... removing an event from the recovery stream may result in an unrecoverable transaction log or recovery with inconsistent state. Extreme caution should be exercised when using a rewritten  transaction log in a production environment.")
    public final class Rewrite
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="outputFolder", required=true, position=1, description="The output folder to which to write rewritten logs")
        File outputFolder;
        private volatile boolean interrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute() throws Exception {
            TransactionLogTool.this.assertQueryMode();
            TransactionLogTool.this.assertResultSet();
            HashMap<String, RogLog> rewrittenLogs = new HashMap<String, RogLog>();
            XLinkedHashMap pendingPackets = new XLinkedHashMap();
            TransactionLogTool.this.queryResults.beforeFirst();
            try {
                RogLog targetLog;
                Object entry;
                int recordsWritten = 0;
                while (TransactionLogTool.this.queryResults.next() && !this.interrupted && (entry = (RogLog.Entry)TransactionLogTool.this.queryResults.getRawResult()) != null) {
                    String logName = ((RogLog.Entry)entry).getLogName();
                    targetLog = (RogLog)rewrittenLogs.get(logName);
                    if (targetLog == null) {
                        this.console().info("Opening rewrite log '" + this.outputFolder + "/" + logName + ".log");
                        Properties props = new Properties();
                        props.setProperty("detachedPersist", "true");
                        props.setProperty("storeRoot", this.outputFolder.getCanonicalPath());
                        props.setProperty("autoRepair", "true");
                        props.setProperty("logMode", "rw");
                        targetLog = RogLog.create(logName, props);
                        if (targetLog.getLogFile().exists()) {
                            this.console().info("Target rewrite log already exists (" + targetLog.getLogFile().getCanonicalPath() + ")... backing it up.");
                            String backup = targetLog.backupLog(true);
                            this.console().info("Target log backed up to '" + backup + "'");
                        }
                        targetLog.open();
                        rewrittenLogs.put(logName, targetLog);
                    }
                    PktPacket packet = ((RogLog.Entry)entry).getPacket();
                    PktPacket pendingPacket = (PktPacket)pendingPackets.get((Object)logName);
                    if (pendingPacket != null) {
                        long currentTransactionId = packet.getHeader().getODSSubheader().getTransactionId();
                        if (currentTransactionId != pendingPacket.getHeader().getODSSubheader().getTransactionId()) {
                            packet.getHeader().getODSSubheader().setFlagCommitStart(true);
                            pendingPacket.getHeader().getODSSubheader().setFlagCommitEnd(true);
                        }
                        pendingPacket.getHeader().getODSSubheader().copyPersisterMetadataFrom(null);
                        StoreCommitEntry commitEntry = StoreCommitEntry.create();
                        commitEntry.init(pendingPacket);
                        targetLog.writeCommitEntry(commitEntry, false, false);
                        pendingPacket.dispose();
                    }
                    packet.acquire();
                    pendingPackets.put((Object)logName, (Object)packet);
                    ((RogLog.Entry)entry).dispose();
                    if (++recordsWritten <= 0 || (recordsWritten - 1) % 10000 != 0) continue;
                    this.console().info("..." + recordsWritten + " written");
                }
                for (String pendingLogName : pendingPackets.keySet()) {
                    targetLog = (RogLog)rewrittenLogs.get(pendingLogName);
                    PktPacket pendingPacket = (PktPacket)pendingPackets.get((Object)pendingLogName);
                    if (pendingPacket == null) continue;
                    pendingPacket.getHeader().getODSSubheader().copyPersisterMetadataFrom(null);
                    StoreCommitEntry commitEntry = StoreCommitEntry.create();
                    commitEntry.init(pendingPacket);
                    targetLog.writeCommitEntry(commitEntry, false, false);
                    pendingPacket.dispose();
                    this.console().info("..." + recordsWritten + " were rewritten to '" + pendingLogName + "'");
                }
            }
            finally {
                for (RogLog log : rewrittenLogs.values()) {
                    this.console().info("Flushing and closing rewritten log '" + log.getLogFile());
                    this.console().info("  " + log.getStats().toString());
                    log.flush(true);
                    log.close();
                }
            }
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }
    }

    @AnnotatedCommand.Command(keywords={"dump"}, description="Dump contents of the current log or query results")
    public final class Dump
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=100, longForm="detailed", defaultValue="false", description="displays detailed dump of each entry (as opposed to default brief tabular format")
        boolean detailed;
        @AnnotatedCommand.Option(shortForm=114, longForm="raw", defaultValue="false", description="writes out the entry in raw format")
        boolean raw;
        @AnnotatedCommand.Option(shortForm=103, longForm="group", defaultValue="false", description="groups dumped entries by transaction")
        boolean group;
        @AnnotatedCommand.Option(shortForm=111, longForm="sorted", defaultValue="false", description="DEPRECATED -sorts transaction entries by placing replicated entries first followed by message entries")
        boolean sorted;
        @AnnotatedCommand.Option(shortForm=115, longForm="state", defaultValue="false", description="build and dumps the application state graph")
        boolean state;
        @AnnotatedCommand.Option(shortForm=120, longForm="skipEntries", defaultValue="false", description="skips displaying entries")
        boolean skipEntries;
        @AnnotatedCommand.Option(shortForm=110, longForm="noOrphan", defaultValue="false", description="skips displaying entries without a transaction id")
        boolean noOrphan;
        @AnnotatedCommand.Option(shortForm=102, longForm="force", defaultValue="false", description="when dumping to a file that already exists, forces overwrite of the file.")
        boolean force;
        @AnnotatedCommand.Option(shortForm=112, longForm="packets", defaultValue="false", description="Indicates whether or not packets should be dumped instead of entries (browse mode only).")
        boolean packets;
        @AnnotatedCommand.Argument(name="dumpFile", position=1, required=false, description="The output file to which to dump. Suffixing with .csv results in csv output and with .html result in html")
        File dumpFile;
        IStoreBinding store = null;
        RogGraphCollection collection = null;
        private volatile boolean interrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void execute() throws Exception {
            BufferedWriter bw;
            this.interrupted = false;
            if (TransactionLogTool.this.inQueryMode()) {
                BufferedWriter bw2;
                if (this.skipEntries) {
                    throw new Exception("skipEntries flag doesn't apply to query results");
                }
                if (this.noOrphan) {
                    throw new Exception("noOrphan flag doesn't apply to query results");
                }
                if (this.state) {
                    throw new Exception("state flag doesn't apply to query results");
                }
                if (this.sorted) {
                    throw new Exception("sorted flag doesn't apply to query results");
                }
                if (this.group) {
                    throw new Exception("group flag doesn't apply to query results");
                }
                if (this.packets) {
                    throw new Exception("packet dump is not a valid option in query mode");
                }
                TransactionLogTool.this.assertResultSet();
                TransactionLogTool.this.queryResults.beforeFirst();
                UtlTableFormatter.Format format = UtlTableFormatter.Format.TABULAR;
                if (this.dumpFile != null) {
                    if (this.dumpFile.exists()) {
                        if (!this.force) throw new Exception("File '" + this.dumpFile.getName() + "' already exists. Use '-f' to force overwrite");
                        this.dumpFile.delete();
                    }
                    if (this.dumpFile.getName().endsWith(".html")) {
                        format = UtlTableFormatter.Format.HTML;
                    } else if (this.dumpFile.getName().endsWith(".csv")) {
                        format = UtlTableFormatter.Format.CSV;
                    }
                    bw2 = new BufferedWriter(new FileWriter(this.dumpFile));
                } else {
                    bw2 = new BufferedWriter(new PrintWriter(this.console().out()));
                }
                try {
                    String resultFooter;
                    boolean first = true;
                    block40: while (TransactionLogTool.this.queryResults.next() && !this.interrupted) {
                        ByteBuffer buffer;
                        RogLog.Entry entry;
                        String rawStr = null;
                        if (this.raw && (entry = (RogLog.Entry)TransactionLogTool.this.queryResults.getRawResult()) != null && (buffer = entry.getRawBody()) != null) {
                            rawStr = UtlBuffer.dump((ByteBuffer)buffer.duplicate());
                        }
                        try {
                            if (!this.detailed) {
                                TransactionLogTool.this.writeQueryResult(bw2, first, format);
                            } else {
                                boolean showLog;
                                entry = (RogLog.Entry)TransactionLogTool.this.queryResults.getRawResult();
                                boolean csv = format == UtlTableFormatter.Format.CSV;
                                boolean bl = showLog = TransactionLogTool.this.openLogs.size() > 1;
                                if (entry == null) {
                                    TransactionLogTool.this.writeResultSetRow(TransactionLogTool.this.queryResults, this.detailed, csv, showLog, bw2);
                                } else {
                                    TransactionLogTool.this.writeEntry((RogLog.Entry)TransactionLogTool.this.queryResults.getRawResult(), this.detailed, csv, showLog, bw2);
                                }
                            }
                            first = false;
                            if (!this.raw) continue;
                        }
                        catch (Throwable throwable) {
                            if (!this.raw) throw throwable;
                            switch (format) {
                                case CSV: {
                                    bw2.append("\"[RAW BODY]: ");
                                    if (rawStr == null) {
                                        bw2.append("Unavailable");
                                    } else {
                                        bw2.append(rawStr);
                                    }
                                    bw2.append("\"");
                                    bw2.newLine();
                                    throw throwable;
                                }
                                case HTML: {
                                    bw2.append("<tr><td colspan=\"100\"><pre style=\"white-space: pre-wrap;\">");
                                    bw2.append("[RAW BODY]");
                                    bw2.newLine();
                                    if (rawStr == null) {
                                        bw2.append("Unavailable");
                                    } else {
                                        bw2.append(rawStr);
                                    }
                                    bw2.append("</pre></td></tr>");
                                    throw throwable;
                                }
                                case TABULAR: {
                                    bw2.append("  [RAW BODY]");
                                    bw2.newLine();
                                    if (rawStr == null) {
                                        bw2.append("Unavailable");
                                    } else {
                                        bw2.append(rawStr);
                                    }
                                    bw2.newLine();
                                    throw throwable;
                                }
                            }
                            throw throwable;
                        }
                        switch (format) {
                            case CSV: {
                                bw2.append("\"[RAW BODY]: ");
                                if (rawStr == null) {
                                    bw2.append("Unavailable");
                                } else {
                                    bw2.append(rawStr);
                                }
                                bw2.append("\"");
                                bw2.newLine();
                                continue block40;
                            }
                            case HTML: {
                                bw2.append("<tr><td colspan=\"100\"><pre style=\"white-space: pre-wrap;\">");
                                bw2.append("[RAW BODY]");
                                bw2.newLine();
                                if (rawStr == null) {
                                    bw2.append("Unavailable");
                                } else {
                                    bw2.append(rawStr);
                                }
                                bw2.append("</pre></td></tr>");
                                continue block40;
                            }
                            case TABULAR: {
                                bw2.append("  [RAW BODY]");
                                bw2.newLine();
                                if (rawStr == null) {
                                    bw2.append("Unavailable");
                                } else {
                                    bw2.append(rawStr);
                                }
                                bw2.newLine();
                                continue block40;
                            }
                        }
                    }
                    if (this.detailed || (resultFooter = (String)TransactionLogTool.this.resultFooters.get(format)) == null) return;
                    bw2.write((String)TransactionLogTool.this.resultFooters.get(format));
                    return;
                }
                finally {
                    bw2.flush();
                    if (this.dumpFile != null) {
                        bw2.close();
                    }
                }
            }
            TransactionLogTool.this.assertOpen();
            UtlTableFormatter.Format format = UtlTableFormatter.Format.TABULAR;
            if (this.dumpFile != null) {
                if (this.dumpFile.exists()) {
                    if (!this.force) throw new Exception("File '" + this.dumpFile.getName() + "' already exists. Use '-f' to force overwrite.");
                    this.dumpFile.delete();
                }
                if (this.dumpFile.getName().endsWith(".html")) {
                    throw new Exception("HTML dump is only supported for query results");
                }
                if (this.dumpFile.getName().endsWith(".csv")) {
                    format = UtlTableFormatter.Format.CSV;
                }
                bw = new BufferedWriter(new FileWriter(this.dumpFile));
            } else {
                bw = new BufferedWriter(new PrintWriter(this.console().out()));
            }
            try {
                if (this.packets) {
                    File logFile = TransactionLogTool.this.reader.log().getLogFile();
                    pktlog.open(0, 0L);
                    try (PktRecoveryLog pktlog = PktRecoveryLog.create((String)logFile.getParent(), (String)logFile.getName(), (PktRecoveryLog.FileOpenMode)PktRecoveryLog.FileOpenMode.rw, (long)0L, (int)8192, (int)8192);){
                        pktlog.dump((Appendable)bw);
                        return;
                    }
                }
                if (!this.skipEntries) {
                    TransactionLogTool.this.reader.rewind();
                    bw.write("[LOG ENTRIES]");
                    bw.newLine();
                    if (this.group) {
                        RogLogReader.Transaction transaction;
                        if (!this.detailed) {
                            bw.append(RogLog.Entry.getHeaderRow(format == UtlTableFormatter.Format.CSV));
                            bw.newLine();
                            bw.newLine();
                        }
                        while ((transaction = TransactionLogTool.this.reader.nextTransaction()) != null && !this.interrupted) {
                            if (this.noOrphan && transaction.getId() == -1L) continue;
                            block42: for (RogLog.Entry entry : transaction.getEntries()) {
                                ByteBuffer buffer;
                                String rawStr = null;
                                if (this.raw && (buffer = entry.getRawBody()) != null) {
                                    rawStr = UtlBuffer.dump((ByteBuffer)buffer.duplicate());
                                }
                                try {
                                    TransactionLogTool.this.writeEntry(entry, this.detailed, format == UtlTableFormatter.Format.CSV, false, bw);
                                    if (!this.raw) continue;
                                }
                                catch (Throwable throwable) {
                                    if (!this.raw) throw throwable;
                                    switch (format) {
                                        case CSV: {
                                            bw.append("\"[RAW BODY]: ");
                                            if (rawStr == null) {
                                                bw.append("Unavailable");
                                            } else {
                                                bw.append(rawStr);
                                            }
                                            bw.append("\"");
                                            bw.newLine();
                                            throw throwable;
                                        }
                                        case HTML: {
                                            bw.append("<tr><td colspan=\"100\"><pre style=\"white-space: pre-wrap;\">");
                                            bw.append("[RAW BODY]");
                                            bw.newLine();
                                            if (rawStr == null) {
                                                bw.append("Unavailable");
                                            } else {
                                                bw.append(rawStr);
                                            }
                                            bw.append("</pre></td></tr>");
                                            throw throwable;
                                        }
                                        case TABULAR: {
                                            bw.append("  [RAW BODY]");
                                            bw.newLine();
                                            if (rawStr == null) {
                                                bw.append("Unavailable");
                                            } else {
                                                bw.append(rawStr);
                                            }
                                            bw.newLine();
                                            throw throwable;
                                        }
                                    }
                                    throw throwable;
                                }
                                switch (format) {
                                    case CSV: {
                                        bw.append("\"[RAW BODY]: ");
                                        if (rawStr == null) {
                                            bw.append("Unavailable");
                                        } else {
                                            bw.append(rawStr);
                                        }
                                        bw.append("\"");
                                        bw.newLine();
                                        continue block42;
                                    }
                                    case HTML: {
                                        bw.append("<tr><td colspan=\"100\"><pre style=\"white-space: pre-wrap;\">");
                                        bw.append("[RAW BODY]");
                                        bw.newLine();
                                        if (rawStr == null) {
                                            bw.append("Unavailable");
                                        } else {
                                            bw.append(rawStr);
                                        }
                                        bw.append("</pre></td></tr>");
                                        continue block42;
                                    }
                                    case TABULAR: {
                                        bw.append("  [RAW BODY]");
                                        bw.newLine();
                                        if (rawStr == null) {
                                            bw.append("Unavailable");
                                        } else {
                                            bw.append(rawStr);
                                        }
                                        bw.newLine();
                                        continue block42;
                                    }
                                }
                            }
                        }
                    } else {
                        RogLog.Entry entry;
                        if (!this.detailed) {
                            bw.append(RogLog.Entry.getHeaderRow(format == UtlTableFormatter.Format.CSV));
                            bw.newLine();
                        }
                        while ((entry = TransactionLogTool.this.reader.next()) != null && !this.interrupted) {
                            ByteBuffer buffer;
                            if (this.noOrphan && entry.getTransactionId() == -1L) continue;
                            String rawStr = null;
                            if (this.raw && (buffer = entry.getRawBody()) != null) {
                                rawStr = UtlBuffer.dump((ByteBuffer)buffer.duplicate());
                            }
                            try {
                                TransactionLogTool.this.writeEntry(entry, this.detailed, format == UtlTableFormatter.Format.CSV, false, bw);
                            }
                            finally {
                                if (!this.raw) continue;
                                bw.append("[RAW BODY]");
                                bw.newLine();
                                if (rawStr == null) {
                                    bw.append("Unavailable");
                                } else {
                                    bw.append(rawStr);
                                }
                                bw.newLine();
                            }
                        }
                    }
                }
                if (!this.state || this.interrupted) return;
                String name = "LogReaderTool" + System.currentTimeMillis();
                StoreDescriptor descriptor = StoreDescriptor.create("store");
                this.collection = (RogGraphCollection)RogGraphCollection.create(name, descriptor, null, 0, 0);
                this.store = this.collection.getStore();
                TransactionLogTool.this.reader.rewind();
                this.store.open();
                try {
                    bw.newLine();
                    bw.newLine();
                    bw.write("[STATE DUMP]");
                    this.collection.dump(bw);
                    return;
                }
                finally {
                    this.store.close(0);
                }
            }
            finally {
                bw.flush();
                if (this.dumpFile != null) {
                    bw.close();
                }
            }
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }
    }

    @AnnotatedCommand.Command(keywords={"pktdiag"}, description="Test packet deserialization.", hidden=true)
    public final class PktDiag
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=118, longForm="verbose", defaultValue="false", description="Whether to trace deserialization details.")
        boolean verbose = false;
        @AnnotatedCommand.Option(shortForm=111, longForm="offset", defaultValue="0", description="The offset into the dump.")
        int offset = 0;
        @AnnotatedCommand.Option(shortForm=97, longForm="all", defaultValue="false", description="Read all packets that can be read from the given offset.")
        boolean all = false;
        @AnnotatedCommand.Option(shortForm=101, longForm="dumpEntry", defaultValue="false", description="Dumps the packet as a log entry (requires 'factories' to be registered ... see 'factories -h').")
        boolean dumpEntry = false;
        @AnnotatedCommand.RemainingArgs(name="pktDumpHex", required=true, description="The packet in hex form as dumped by UtlBuffer.dump.")
        String pktDump;

        public void execute() throws Exception {
            ByteBuffer buffer = UtlBuffer.fromDump((String)this.pktDump);
            this.console().info("Decoded " + buffer.remaining() + " hex bytes. Attempting to deserialize packet at offset: " + this.offset);
            PktSerializable.DeserializeContext deserializeContext = PktSerializable.DeserializeContext.create();
            deserializeContext.setPolicy(1);
            deserializeContext.setBuffer(buffer);
            buffer.position(this.offset);
            Tracer tracer = Tracer.create((Tracer.Level)(this.verbose ? Tracer.Level.DEBUG : Tracer.Level.INFO));
            tracer.bind("pkt.diag");
            PktPacket packet = PktFactory.getInstance().createPacket(deserializeContext, tracer);
            this.console().info("Successfully deserialized packet: " + packet);
            if (this.dumpEntry) {
                this.dumpStoreObject(packet);
            }
            try {
                packet.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.all) {
                while ((packet = PktFactory.getInstance().createPacket(deserializeContext, tracer)) != null) {
                    this.console().info("Successfully deserialized packet: " + packet);
                    if (this.dumpEntry) {
                        this.dumpStoreObject(packet);
                    }
                    try {
                        packet.dispose();
                    }
                    catch (Throwable t) {
                        this.error("Error disposing packet: " + t.getMessage(), t);
                        this.console().info("Continuing...");
                    }
                }
            }
        }

        private void dumpStoreObject(PktPacket packet) throws Exception {
            PktSubheaderODS odsHeader = packet.getHeader().getODSSubheader();
            if (odsHeader == null) {
                this.console().info("...not an ods object.");
                return;
            }
            RogLog.Entry entry = RogLog.Entry.create(packet);
            StringWriter sw = new StringWriter();
            sw.flush();
            IStoreObjectFactory factory = StoreObjectFactoryRegistry.getInstance().getObjectFactory(odsHeader.getObjectFactoryId());
            if (factory == null) {
                this.console().info("Factory for object with ofid=" + odsHeader.getObjectFactoryId() + " not found (did you register factories with 'factories' command?");
            }
            RogLogUtil.dumpLogEntryJson(entry, true, factory != null, this.all, TransactionLogTool.this.jsonPrettyPrintStyle, sw);
            this.console().info("Entry:\n" + sw.toString());
            entry.dispose();
        }
    }

    @AnnotatedCommand.Command(keywords={"diag"}, description="Sets diagnostic parameters.", hidden=true)
    public final class Diag
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="parameter", required=false, validOptions={"typeInference", "staticTypes"}, description="The parameter to set")
        String parameter;
        @AnnotatedCommand.Argument(position=2, name="parameter", required=false, description="The parameter value")
        String value;

        public void execute() throws Exception {
            if (this.parameter != null) {
                if (this.parameter.equals("typeInference")) {
                    TransactionLogTool.this.switchTo("query");
                    TransactionLogTool.this.queryEngine.enableTypeInference(new InteractiveTool.BooleanPropertyParser().parse(this.value, "false"));
                } else {
                    TransactionLogTool.this.switchTo("query");
                    TransactionLogTool.this.queryEngine.enableStaticFields(new InteractiveTool.BooleanPropertyParser().parse(this.value, "false"));
                }
                this.console().info("Set " + this.parameter + " to " + this.value);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"consume"}, description="Consume the current query. Primarily used for performance testing.", hidden=true)
    public final class Consume
    extends AnnotatedCommand {
        private volatile boolean interrupted = false;

        public void execute() throws Exception {
            this.interrupted = false;
            if (TransactionLogTool.this.inQueryMode()) {
                TransactionLogTool.this.assertResultSet();
                while (TransactionLogTool.this.queryResults.next() && !this.interrupted) {
                    TransactionLogTool.this.queryResults.getRawResult();
                }
            }
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }
    }

    @AnnotatedCommand.Command(keywords={"factories"}, description="Register a set of factories with the X runtime")
    public final class Factories
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="factoryFile", description="The name of file containing factories", required=true, position=1)
        File file;

        public final void execute() throws Exception {
            this.doFactories(this.file);
        }

        public void doFactories(String factoriesFilename) throws Exception {
            this.doFactories(new File(UtlFile.expandPath((String)factoriesFilename)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFactories(File file) throws Exception {
            Factory factory = new Factory();
            if (file.exists()) {
                try (BufferedReader br = new BufferedReader(new FileReader(file));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        factory.doFactory(line.trim());
                    }
                }
            } else {
                throw new Exception("File not found: " + file);
            }
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"factory"}, description="Register a factory with the X runtime")
    public final class Factory
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="factoryClass", position=1, description="The fully qualified factory class name")
        String factoryClass;

        public final void doFactory(String className) throws Exception {
            Class<?> clazz = Class.forName(className);
            Method createMethod = null;
            try {
                Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
                createMethod = clazz.getMethod("create", parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load java.util.Properties during instantiation of factory class");
            }
            catch (SecurityException e) {
                throw new Exception("Invalid factory class [Access to instantiation method is denied]");
            }
            catch (NoSuchMethodException e) {
                throw new Exception("Invalid factory class [Instantiation method could not be found]");
            }
            IStoreObjectFactory factory = null;
            try {
                try {
                    Object[] parameters = new Object[]{null};
                    factory = (IStoreObjectFactory)createMethod.invoke(null, parameters);
                    if (factory == null) {
                        throw new Exception("Invalid factory class [Instantiation method returned a null object]");
                    }
                    RogLogReader.registerFactory(factory);
                }
                catch (ClassCastException e) {
                    throw new Exception("Invalid factory class [Instantiation method did not return a valid factory");
                }
            }
            catch (IllegalAccessException e) {
                throw new Exception("Invalid factory class [Access to instantiation method is denied]");
            }
        }

        public final void execute() throws Exception {
            this.doFactory(this.factoryClass);
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"switch"}, description="Switches between browse and query modes. Query mode allows queries against the open logs, whilst browse mode allows you to browse through the current log.")
    public final class Switch
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=108, longForm="list", defaultValue="false", description="Indicates the list of options should be displayed")
        boolean list = false;
        @AnnotatedCommand.Argument(position=1, name="target", required=false, description="The name of the log to switch to in browse mode, 'query' to switch to query mode or 'browse' to switch to browse mode.")
        String target;

        public final void execute() throws Exception {
            if (this.list) {
                TransactionLogTool.this.listOpen();
                this.console().info("You can use 'switch <logname>' to browse or 'switch query' to issue queries and/or view results");
            }
            if (this.target != null) {
                TransactionLogTool.this.switchTo(this.target);
            }
        }

        public final boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"stats"}, description="Displays log file stats for the entries read so far. (browse mode only)")
    public final class Stats
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=97, longForm="all", defaultValue="false", description="Reads to the end of the log and display all stats")
        boolean all;

        public final void execute() throws Exception {
            TransactionLogTool.this.assertBrowseMode();
            TransactionLogTool.this.assertOpen();
            this.console().info(RogLog.Stats.getHeaderRow());
            if (this.all) {
                this.console().info(TransactionLogTool.this.reader.computeStats().toString());
            } else {
                this.console().info(TransactionLogTool.this.reader.getStats().toString());
            }
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"tail"}, description="Tails entries in a current log (browse mode only)")
    public final class Tail
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=116, longForm="transactions", defaultValue="false", required=false, description="Indicates that the log should tail completed transactions rather than entries")
        boolean transactions;
        @AnnotatedCommand.Option(shortForm=115, longForm="stats", defaultValue="false", required=false, description="Indicates that aggregate log stats should be displayed rather than entries")
        boolean stats;
        @AnnotatedCommand.Option(shortForm=111, longForm="sorted", defaultValue="false", description="DEPRECATED: sorts transaction entries by placing replicated entries first followed by message entries")
        boolean sorted;
        @AnnotatedCommand.Option(shortForm=100, longForm="detailed", defaultValue="false", description="displays detailed dump of each entry (as opposed to default brief tabular format")
        boolean detailed;
        @AnnotatedCommand.Option(shortForm=102, longForm="follow", defaultValue="false", description="Continually follows the log file")
        boolean follow;
        @AnnotatedCommand.Option(shortForm=105, longForm="interval", defaultValue="1.0", description="with --follow the interval to check for new entries in seconds")
        float intervalSeconds;
        @AnnotatedCommand.Option(shortForm=112, longForm="noorphan", defaultValue="false", description="Skips orphans")
        boolean noOrphan;
        @AnnotatedCommand.Option(shortForm=99, longForm="csv", defaultValue="false", description="indicates that csv mode should be used for brief format, otherwise a tabular format will be used")
        boolean csv;
        @AnnotatedCommand.Option(shortForm=110, longForm="count", defaultValue="10", description="output the last N lines, instead of the last 10")
        int numEntries;
        private volatile boolean interrupted = false;

        public final void execute() throws Exception {
            this.interrupted = false;
            TransactionLogTool.this.assertBrowseMode();
            TransactionLogTool.this.assertOpen();
            TransactionLogTool.this.reader.rewind();
            long interval = (long)this.intervalSeconds * 1000L;
            if (!this.stats && !this.detailed) {
                this.console().info(RogLog.Entry.getHeaderRow(this.csv));
            }
            if (this.stats) {
                this.console().info(RogLog.Stats.getHeaderRow());
            }
            boolean first = true;
            while (!this.interrupted) {
                RogLog.Entry entry;
                RogLog.Stats stats;
                if (this.transactions) {
                    RogLogReader.Transaction transaction;
                    if (first) {
                        stats = TransactionLogTool.this.reader.computeStats();
                        first = false;
                        int numTxns = stats.getNumTransactions();
                        TransactionLogTool.this.reader.rewind();
                        if (numTxns > this.numEntries) {
                            TransactionLogTool.this.reader.skipTransaction(numTxns - this.numEntries, null);
                        }
                    }
                    if ((transaction = TransactionLogTool.this.reader.nextTransaction()) != null) {
                        if (transaction.getId() != -1L) {
                            this.console().info("Transaction id=" + transaction.getId());
                        } else {
                            if (this.noOrphan) continue;
                            this.console().info("Orphaned Entry:");
                        }
                        if (!this.stats) {
                            List<RogLog.Entry> entries = transaction.getEntries();
                            for (RogLog.Entry entry2 : entries) {
                                TransactionLogTool.this.writeEntry(entry2, this.detailed, this.csv, false, this.console().out());
                            }
                            continue;
                        }
                        this.console().info(TransactionLogTool.this.reader.getStats().toString());
                        continue;
                    }
                    if (this.follow) {
                        Thread.sleep(Math.max(100L, interval));
                        continue;
                    }
                    return;
                }
                if (first) {
                    stats = TransactionLogTool.this.reader.computeStats();
                    first = false;
                    int count = stats.getNumEntries();
                    TransactionLogTool.this.reader.rewind();
                    if (count > this.numEntries) {
                        TransactionLogTool.this.reader.skipTransaction(count - this.numEntries, null);
                    }
                }
                if ((entry = TransactionLogTool.this.reader.next()) != null) {
                    if (!this.stats) {
                        TransactionLogTool.this.writeEntry(entry, this.detailed, this.csv, false, this.console().out());
                        continue;
                    }
                    this.console().info(TransactionLogTool.this.reader.getStats().toString());
                    continue;
                }
                if (this.follow) {
                    Thread.sleep(Math.max(100L, interval));
                    continue;
                }
                return;
            }
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }
    }

    @AnnotatedCommand.Command(keywords={"rewind"}, description="In browse mode rewinds the browser to the start of the log. In query mode rewinde the query results to the beginning")
    public final class Rewind
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            if (!TransactionLogTool.this.inQueryMode()) {
                TransactionLogTool.this.assertOpen();
                TransactionLogTool.this.reader.rewind();
            } else {
                TransactionLogTool.this.assertResultSet();
                TransactionLogTool.this.queryResults.beforeFirst();
            }
        }

        public boolean interruptable() {
            return false;
        }
    }

    @AnnotatedCommand.Command(keywords={"skiptxn"}, description="Skip over a set of log transactions. (browse mode only)")
    public final class SkipTransaction
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="count", defaultValue="1", required=false, position=1, description="The number of transactions to skip")
        int count;
        private volatile boolean interrupted = false;

        public final void execute() throws Exception {
            this.interrupted = false;
            TransactionLogTool.this.assertBrowseMode();
            TransactionLogTool.this.assertOpen();
            SkipStatsCollector collector = new SkipStatsCollector();
            for (int i = 0; i < this.count && !this.interrupted; ++i) {
                TransactionLogTool.this.reader.skipTransaction(1, collector);
            }
            this.console().info("Skipped " + collector.numTransactions + " Transactions");
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }

        private final class SkipStatsCollector
        implements RogLogReader.TransactionSkipCallback {
            int numTransactions;

            private SkipStatsCollector() {
            }

            @Override
            public void onTransactionSkip(RogLogReader.Transaction transaction) {
                ++this.numTransactions;
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"skip"}, description="Skip over a number of log entries or query results.")
    public final class Skip
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="count", defaultValue="1", required=false, position=1, description="The number of entries to skip")
        int count;
        private volatile boolean interrupted = false;

        public final void execute() throws Exception {
            this.interrupted = false;
            if (TransactionLogTool.this.inQueryMode()) {
                TransactionLogTool.this.assertResultSet();
                int i = 0;
                i = 0;
                while (i < this.count & !this.interrupted) {
                    if (!TransactionLogTool.this.queryResults.next()) {
                        this.console().info("No more results.");
                        break;
                    }
                    ++i;
                }
                this.console().info("Skipped " + i + " results");
            } else {
                TransactionLogTool.this.assertOpen();
                SkipStatsCollector collector = new SkipStatsCollector();
                int i = 0;
                while (i < this.count & !this.interrupted) {
                    TransactionLogTool.this.reader.skip(1, collector);
                    ++i;
                }
                this.console().info("Skipped " + collector.numMessages + " Msgs, " + collector.numSends + " Sends, " + collector.numPuts + " Puts, " + collector.numUpdates + " Updates, " + collector.numRemoves + " Removes");
            }
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }

        private final class SkipStatsCollector
        implements RogLogReader.SkipCallback {
            int numPuts;
            int numUpdates;
            int numRemoves;
            int numSends;
            int numMessages;

            private SkipStatsCollector() {
            }

            @Override
            public void onSkip(RogLog.Entry.Type type) {
                switch (type) {
                    case Put: {
                        ++this.numPuts;
                        break;
                    }
                    case Update: {
                        ++this.numUpdates;
                        break;
                    }
                    case Remove: {
                        ++this.numRemoves;
                        break;
                    }
                    case Send: {
                        ++this.numSends;
                        break;
                    }
                    case Message: {
                        ++this.numMessages;
                    }
                }
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"nexttxn"}, description="This command reads the next application transaction from the log and dumps its contents to the console. An application transaction is a set of log entries grouped by the same.application transaction id. (browse mode only)")
    public final class NextTransaction
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=100, longForm="detailed", defaultValue="false", description="displays detailed dump of each entry (as opposed to default brief tabular format")
        boolean detailed;
        @AnnotatedCommand.Option(shortForm=99, longForm="csv", defaultValue="false", description="indicates that csv mode should be used for brief format, otherwise a tabular format will be used")
        boolean csv;
        @AnnotatedCommand.Option(shortForm=111, longForm="sorted", defaultValue="false", description="DEPRECATED sorts transaction entries by placing replicated entries first followed by message entries")
        boolean sorted;
        private volatile boolean interrupted = false;

        public final void execute() throws Exception {
            this.interrupted = false;
            TransactionLogTool.this.assertBrowseMode();
            TransactionLogTool.this.assertOpen();
            RogLogReader.Transaction transaction = TransactionLogTool.this.reader.nextTransaction();
            if (transaction != null) {
                List<RogLog.Entry> entries = transaction.getEntries();
                this.console().info("Transaction #" + transaction.getId() + " {");
                if (!this.detailed) {
                    this.console().info(RogLog.Entry.getHeaderRow(this.csv));
                }
                for (RogLog.Entry entry : entries) {
                    if (this.interrupted) break;
                    TransactionLogTool.this.writeEntry(entry, this.detailed, this.csv, false, this.console().out());
                }
                this.console().info("}");
            } else {
                this.console().info("EOF");
            }
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }
    }

    @AnnotatedCommand.Command(keywords={"next"}, description="Dump the contents of a number of the next entries in the log or query result to the console.")
    public final class Next
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=114, longForm="raw", defaultValue="false", description="writes out the raw body")
        boolean raw;
        @AnnotatedCommand.Option(shortForm=100, longForm="detailed", defaultValue="false", description="displays detailed dump of each entry (as opposed to a tabular format")
        boolean detailed;
        @AnnotatedCommand.Option(shortForm=99, longForm="csv", defaultValue="false", description="indicates that csv mode should be used for brief format, otherwise a tabular format will be used")
        boolean csv;
        @AnnotatedCommand.Argument(position=1, name="count", defaultValue="1", required=false, description="Number of entries to display")
        int count;
        private volatile boolean interrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute() throws Exception {
            this.interrupted = false;
            for (int i = 0; i < this.count && !this.interrupted; ++i) {
                RogLog.Entry entry;
                if (!TransactionLogTool.this.inQueryMode()) {
                    TransactionLogTool.this.assertOpen();
                    entry = TransactionLogTool.this.reader.next();
                    if (entry != null) {
                        String rawHeader = "Unavailable";
                        String rawBody = null;
                        if (this.raw) {
                            ByteBuffer buffer;
                            if (entry.getPacket() != null) {
                                try {
                                    rawHeader = entry.getPacket().getHeader().getBody().dump("");
                                }
                                catch (Throwable thrown) {
                                    rawHeader = "Error: " + thrown.getMessage();
                                }
                            }
                            if ((buffer = entry.getRawBody()) != null) {
                                rawBody = UtlBuffer.dump((ByteBuffer)buffer.duplicate());
                            }
                        }
                        try {
                            if (!this.detailed && i == 0) {
                                this.console().info(RogLog.Entry.getHeaderRow(this.csv));
                            }
                            TransactionLogTool.this.writeEntry(entry, this.detailed, this.csv, false, this.console().out());
                            continue;
                        }
                        finally {
                            if (this.raw) {
                                this.console().info("[RAW HEADER]");
                                if (rawBody == null) {
                                    this.console().info(rawHeader);
                                } else {
                                    this.console().info(rawBody);
                                }
                                this.console().info("[RAW BODY]");
                                if (rawBody == null) {
                                    this.console().info(" Unavailable");
                                } else {
                                    this.console().info(rawBody);
                                }
                            }
                        }
                    }
                    this.console().info("EOF");
                    return;
                }
                TransactionLogTool.this.assertResultSet();
                if (TransactionLogTool.this.queryResults.next()) {
                    ByteBuffer buffer;
                    entry = (RogLog.Entry)TransactionLogTool.this.queryResults.getRawResult();
                    String rawStr = null;
                    if (this.raw && entry != null && (buffer = entry.getRawBody()) != null) {
                        rawStr = UtlBuffer.dump((ByteBuffer)buffer.duplicate());
                    }
                    try {
                        if (!this.detailed) {
                            TransactionLogTool.this.writeQueryResult(this.console().out(), i == 0, this.csv ? UtlTableFormatter.Format.CSV : UtlTableFormatter.Format.TABULAR);
                            continue;
                        }
                        boolean showLog = TransactionLogTool.this.openLogs.size() > 1;
                        PrintStream out = this.console().out();
                        if (entry == null) {
                            TransactionLogTool.this.writeResultSetRow(TransactionLogTool.this.queryResults, this.detailed, this.csv, showLog, out);
                            continue;
                        }
                        TransactionLogTool.this.writeEntry((RogLog.Entry)TransactionLogTool.this.queryResults.getRawResult(), this.detailed, this.csv, showLog, out);
                        continue;
                    }
                    finally {
                        if (this.raw) {
                            this.console().info("");
                            this.console().info("[RAW BODY]");
                            if (rawStr == null) {
                                this.console().info("Unavailable");
                            } else {
                                this.console().info(rawStr);
                            }
                        }
                    }
                }
                this.console().info("No more results");
                return;
            }
            if (!this.detailed && TransactionLogTool.this.inQueryMode()) {
                this.console().out().println((String)TransactionLogTool.this.resultFooters.get(this.csv ? UtlTableFormatter.Format.CSV : UtlTableFormatter.Format.TABULAR));
            }
        }

        public void interrupt(Thread commandThread) {
            this.interrupted = true;
        }
    }

    @AnnotatedCommand.Command(keywords={"open"}, description="This command opens a ROG log. If looking for the log created by an application driven by an AEP engine, use the name of the AEP engine (i.e. application name) as the name of the recovery log here. You may also specify a directory to open all logs in the directory")
    public final class Open
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=114, longForm="repair", required=false, defaultValue="false", description="May be specified to indicate that the log should be repaired. Repair required that the file be opened in a writeable mode.")
        boolean repair;
        @AnnotatedCommand.Option(shortForm=109, longForm="mode", required=false, defaultValue="r", validOptions={"r", "rw", "rws", "rwd"}, description="Indicate the mode in which the log should be opened")
        String openMode;
        @AnnotatedCommand.Option(shortForm=112, longForm="properties", required=false, defaultValue="", description="A comma separated list of key=value log open properties")
        String openProperties;
        @AnnotatedCommand.Argument(position=1, name="log", required=true, description="The path to a log or a directory. When a directory is specified all logs in the directory are added.")
        File log;
        @AnnotatedCommand.RemainingArgs(name="additionalLogs", required=false, description="Additional logs or directories to add")
        String[] additionalLogs;

        public final void execute() throws Exception {
            if (this.repair && this.openMode.equals("r")) {
                throw new IllegalArgumentException("The repair flag can't be used in read only mode. Use the -m flag to specify a writeable mode.");
            }
            Properties properties = new Properties();
            if (this.openProperties != null && this.openProperties.length() > 0) {
                StringTokenizer tok = new StringTokenizer(this.openProperties, ",");
                while (tok.hasMoreTokens()) {
                    String keyValue = tok.nextToken();
                    String[] split = keyValue.split("=");
                    if (split.length != 2) {
                        throw new IllegalArgumentException("Invalid open property '" + keyValue + "' expected propName=propValue");
                    }
                    properties.put(split[0], split[1]);
                }
            }
            TransactionLogTool.this.openLogOrDirectory(this.log, this.repair, this.openMode, properties);
            for (String additional : this.additionalLogs) {
                TransactionLogTool.this.openLogOrDirectory(new File(UtlFile.expandPath((String)additional)), this.repair, this.openMode, properties);
            }
            if (!TransactionLogTool.this.inQueryMode()) {
                if (!this.log.isDirectory()) {
                    TransactionLogTool.this.switchTo(TransactionLogTool.this.mainLogFile(this.log));
                } else if (!TransactionLogTool.this.openLogs.isEmpty()) {
                    TransactionLogTool.this.switchTo((File)TransactionLogTool.this.openLogs.keySet().iterator().next());
                }
            }
        }
    }

    public static final class FullscanThresholdParser
    implements InteractiveTool.PropertyParser {
        public Double parse(String threshold, String defaultValue) throws IllegalArgumentException {
            if (threshold == null) {
                threshold = defaultValue;
            }
            if (threshold == null) {
                return null;
            }
            Double value = Double.valueOf(threshold);
            if (value < 0.0 || value > 1.0) {
                throw new IllegalArgumentException("The threshold must be between 0.0 and 1.0");
            }
            return value;
        }
    }

    static enum DeserializationPolicy {
        Lazy,
        Eager;

    }

    static enum MetadataPolicy {
        On,
        Off,
        Only;

    }

    static enum Mode {
        QUERY,
        BROWSE;

    }
}

