/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBuffer;
import com.neeve.rog.log.RogLog;
import com.neeve.test.UnitTest;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class RogLogOpenTest
extends UnitTest {
    @Rule
    public TestName name = new TestName();

    @After
    public void cleanup() throws Exception {
        RogLog.create(this.name.getMethodName()).delete();
    }

    @Test
    public void testLogOpenEnableDisableCdc() throws Exception {
        System.out.println("default open");
        Properties props = new Properties();
        RogLog log = RogLog.create(this.name.getMethodName(), props);
        log.open();
        Assert.assertFalse((boolean)log.getMetadata().isCdcEnabled());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcLogNumber());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcCursor());
        Assert.assertEquals((long)0L, (long)log.getMetadata().getCdcCheckpointVersion());
        log.getMetadata().setLiveLogNumber(11);
        log.close();
        System.out.println("open with cdcEnabled=true");
        props.setProperty("cdcEnabled", "true");
        log = RogLog.create(this.name.getMethodName(), props);
        log.open();
        Assert.assertEquals((long)11L, (long)log.getMetadata().getLiveLogNumber());
        Assert.assertTrue((boolean)log.getMetadata().isCdcEnabled());
        Assert.assertEquals((long)0L, (long)log.getMetadata().getCdcLogNumber());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcCursor());
        Assert.assertEquals((long)0L, (long)log.getMetadata().getCdcCheckpointVersion());
        log.close();
        System.out.println("open with cdcEnabled=false");
        props.setProperty("cdcEnabled", "false");
        log = RogLog.create(this.name.getMethodName(), props);
        log.open();
        Assert.assertFalse((boolean)log.getMetadata().isCdcEnabled());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcLogNumber());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcCursor());
        Assert.assertEquals((long)0L, (long)log.getMetadata().getCdcCheckpointVersion());
        log.getMetadata().setCdcCheckpointVersion(100L);
        log.close();
        System.out.println("open with cdcEnabled=false again");
        log = RogLog.create(this.name.getMethodName(), props);
        log.open();
        Assert.assertFalse((boolean)log.getMetadata().isCdcEnabled());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcLogNumber());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcCursor());
        Assert.assertEquals((long)100L, (long)log.getMetadata().getCdcCheckpointVersion());
        log.getMetadata().setCdcCheckpointVersion(100L);
        log.close();
        System.out.println("open with cdcEnabled=true");
        props.setProperty("cdcEnabled", "true");
        log = RogLog.create(this.name.getMethodName(), props);
        log.open();
        Assert.assertTrue((boolean)log.getMetadata().isCdcEnabled());
        Assert.assertEquals((long)0L, (long)log.getMetadata().getCdcLogNumber());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcCursor());
        Assert.assertEquals((long)100L, (long)log.getMetadata().getCdcCheckpointVersion());
        log.getMetadata().setCdcLogNumber(10);
        log.getMetadata().setCdcCursor(1000L);
        log.close();
        System.out.println("open with cdcEnabled=true again");
        log = RogLog.create(this.name.getMethodName(), props);
        log.open();
        Assert.assertTrue((boolean)log.getMetadata().isCdcEnabled());
        Assert.assertEquals((long)10L, (long)log.getMetadata().getCdcLogNumber());
        Assert.assertEquals((long)1000L, (long)log.getMetadata().getCdcCursor());
        Assert.assertEquals((long)100L, (long)log.getMetadata().getCdcCheckpointVersion());
        log.getMetadata().setCdcEnabled(false);
        PktBuffer buffer = PktBuffer.create(null, (int)1, (boolean)false);
        log.getMetadata().serialize((IOElasticBuffer)buffer);
        log.close();
        System.out.println("open with cdcEnabled=true (on backup) but cdcEnabled=false in serialized form (from primary)");
        props.setProperty("cdcEnabled", "true");
        log = RogLog.create(this.name.getMethodName(), props);
        log.open(buffer, false);
        Assert.assertFalse((boolean)log.getMetadata().isCdcEnabled());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcLogNumber());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcCursor());
        Assert.assertEquals((long)100L, (long)log.getMetadata().getCdcCheckpointVersion());
        log.getMetadata().setCdcEnabled(true);
        log.getMetadata().serialize((IOElasticBuffer)buffer);
        log.close();
        System.out.println("open with cdcEnabled=false (on backup) but cdcEnabled=true in serialized form (from primary)");
        props.setProperty("cdcEnabled", "false");
        log = RogLog.create(this.name.getMethodName(), props);
        log.open(buffer, false);
        Assert.assertTrue((boolean)log.getMetadata().isCdcEnabled());
        Assert.assertEquals((long)0L, (long)log.getMetadata().getCdcLogNumber());
        Assert.assertEquals((long)-1L, (long)log.getMetadata().getCdcCursor());
        Assert.assertEquals((long)100L, (long)log.getMetadata().getCdcCheckpointVersion());
        log.close();
    }
}

