/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.impl.RogDirectMetadataV2Deserializer;
import com.neeve.rog.impl.RogUtil;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.util.UtlProps;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;

@JsonPropertyOrder(value={"enqueueTs", "enqueueTsMicros", "graphId", "inMsgsInTransaction", "isInboundMessage", "isInternal", "isLastTransaction", "isMessage", "isOutboundMessage", "isReplayedMessage", "messageBus", "messageChannel", "messageFlow", "messageKey", "messageSender", "messageSequenceNumber", "messageTransportHeaders", "outMsgsInTransaction", "outTs", "outTsMicros", "parentId", "preProcessingTs", "preProcessingTsMicros", "possibleDuplicate", "transactionInSequenceNumber", "transactionOutSequenceNumber"})
public final class RogDirectMetadata
implements IRogMetadata {
    private static final boolean DISABLE_NATIVE_BUFFERS = XRuntime.getValue((String)"nv.rog.metadata.disablenative", (boolean)Boolean.FALSE);
    private static final boolean DISABLE_MICROSECOND_TIMESTAMPS = XRuntime.getValue((String)"nv.rog.metadata.disablemicrotimestamps", (boolean)Boolean.FALSE);
    private static final byte V3 = 3;
    private static final byte V4 = 4;
    private static final byte V5 = 5;
    private static final byte VERSION = 5;
    private static final int FLAG_IN_MSGS_IN_TRANSACTION = 1;
    private static final int FLAG_OUT_MSGS_IN_TRANSACTION = 2;
    private static final int FLAG_POSDUP = 4;
    private static final int FLAG_IS_MESSAGE = 8;
    private static final int FLAG_IS_MESSAGE_OUTBOUND = 16;
    private static final int FLAG_IS_MESSAGE_REPLAYED = 32;
    private static final int FLAG_LAST_TRANSACTION = 64;
    private static final int FLAG_INTERNAL = 128;
    private static final int FLAG_IS_MESSAGE_INBOUND = 256;
    private static final int FLAG_TS_IN_MICROS = 512;
    private static final int HAS_FLAGS = 1;
    private static final int HAS_TRANSACTION_IN_SEQ_NO = 2;
    private static final int HAS_TRANSACTION_OUT_SEQ_NO = 4;
    private static final int HAS_GRAPH_ID = 8;
    private static final int HAS_PARENT_ID = 16;
    private static final int HAS_PREPROCESSING_TS = 32;
    private static final int HAS_OUT_TS = 64;
    private static final int HAS_MESSAGE_SENDER = 128;
    private static final int HAS_MESSAGE_FLOW = 256;
    private static final int HAS_MESSAGE_SEQ_NUMBER = 512;
    private static final int HAS_MESSAGE_BUS = 1024;
    private static final int HAS_MESSAGE_CHANNEL = 2048;
    private static final int HAS_MESSAGE_KEY = 4096;
    private static final int HAS_ENQUEUE_TS = 8192;
    private static final int HAS_TRANSPORT_HEADERS = 16384;
    private static final MemoryStats memoryStats;
    private int hasFlags;
    private int flags;
    private int transactionInSequenceNumber;
    private int transactionOutSequenceNumber;
    private int graphId;
    private UUID parentId;
    private long preprocTs;
    private long outTs;
    private long enqueueTs;
    private int messageSender;
    private int messageFlow;
    private long messageSno;
    private XString messageBus;
    private XString messageChannel;
    private XString messageKey;
    private MessageTransportHeaders messageTransportHeaders;
    private final IOElasticBuffer buffer = IOElasticBuffer.create((IOElasticBuffer.Sizer)new IOElasticBuffer.Sizer(){

        public final int getInitialBufferLength() {
            throw new InternalError("buffer sizer can never be called for a metadata buffer");
        }
    }, (int)0, (boolean)false);
    private XString messageBusBuffer;
    private XString messageChannelBuffer;
    private XString messageKeyBuffer;
    private final Offsets offsets;
    private static final String DATE_FORMAT = "yyyyMMdd-HH:mm:ss.SSS";
    private boolean readOnly;

    RogDirectMetadata(boolean copyDeserialize) {
        this.offsets = copyDeserialize ? null : new Offsets();
    }

    RogDirectMetadata() {
        this(false);
    }

    public static final RogDirectMetadata create() {
        return RogDirectMetadata.create(false);
    }

    public static final RogDirectMetadata create(boolean copyDeserialize) {
        return new RogDirectMetadata(copyDeserialize);
    }

    public static final RogDirectMetadata createFrom(IOElasticBuffer metadata, boolean copyDeserialize) {
        return new RogDirectMetadata().deserializeCore(metadata, copyDeserialize);
    }

    public static final RogDirectMetadata createFrom(IOElasticBuffer metadata) {
        return RogDirectMetadata.createFrom(metadata, false);
    }

    private static final String tsToDateString(long ts, SimpleDateFormat dateFormat) {
        return ts == 0L ? "0" : dateFormat.format(new Date(ts));
    }

    public static final boolean isNativeMetadataEnabled() {
        return !DISABLE_NATIVE_BUFFERS;
    }

    private final void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("Metadata is readonly");
        }
    }

    private final boolean hasField(int flag) {
        return (this.hasFlags & flag) == flag;
    }

    private final void setHasField(int flag) {
        this.hasFlags |= flag;
    }

    private final void clearHasField(int flag) {
        this.hasFlags &= ~flag;
    }

    private final void setFlag(int flag) {
        this.flags |= flag;
        this.setHasField(1);
    }

    private final void clearFlag(int flag) {
        this.flags &= ~flag;
        if (this.flags == 0) {
            this.clearHasField(1);
        }
    }

    private final boolean getFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    private final RogDirectMetadata deserializeCore(IOElasticBuffer metadata, boolean copyDeserialize) {
        boolean frameDeserialize;
        boolean bl = frameDeserialize = !copyDeserialize && this.offsets != null;
        if (metadata != null) {
            int len = 0;
            byte version = metadata.get(len);
            if (version >= 3) {
                len = (short)(len + 1);
                this.hasFlags = metadata.getInt(len);
                len = (short)(len + 4);
                if (this.hasField(1)) {
                    this.flags = metadata.getInt(len);
                    len = (short)(len + 4);
                }
                if (this.hasField(2)) {
                    if (frameDeserialize) {
                        this.offsets.transactionInSequenceNumberOffset = (short)len;
                    } else {
                        this.transactionInSequenceNumber = metadata.getInt(len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(4)) {
                    if (frameDeserialize) {
                        this.offsets.transactionOutSequenceNumberOffset = (short)len;
                    } else {
                        this.transactionOutSequenceNumber = metadata.getInt(len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(8)) {
                    if (frameDeserialize) {
                        this.offsets.graphIdOffset = (short)len;
                    } else {
                        this.graphId = metadata.getInt(len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(16)) {
                    if (frameDeserialize) {
                        this.offsets.parentIdOffset = (short)len;
                    } else {
                        long time = metadata.getLong(len);
                        long cas = metadata.getLong(len + 8);
                        this.parentId = new UUID(time, cas);
                    }
                    len = (short)(len + 16);
                }
                if (this.hasField(32)) {
                    if (frameDeserialize) {
                        this.offsets.preprocTsOffset = (short)len;
                    } else {
                        this.preprocTs = metadata.getLong(len);
                        if (!this.getFlag(512)) {
                            this.preprocTs *= 1000L;
                        }
                    }
                    len = (short)(len + 8);
                }
                if (this.hasField(64)) {
                    if (frameDeserialize) {
                        this.offsets.outTsOffset = (short)len;
                    } else {
                        this.outTs = metadata.getLong(len);
                        if (!this.getFlag(512)) {
                            this.outTs *= 1000L;
                        }
                    }
                    len = (short)(len + 8);
                }
                if (version > 3 && this.hasField(8192)) {
                    if (frameDeserialize) {
                        this.offsets.enqueueTsOffset = (short)len;
                    } else {
                        this.enqueueTs = metadata.getLong(len);
                        if (!this.getFlag(512)) {
                            this.enqueueTs *= 1000L;
                        }
                    }
                    len = (short)(len + 8);
                }
                if (this.hasField(128)) {
                    if (frameDeserialize) {
                        this.offsets.messageSenderOffset = (short)len;
                    } else {
                        this.messageSender = metadata.getInt(len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(256)) {
                    if (frameDeserialize) {
                        this.offsets.messageFlowOffset = (short)len;
                    } else {
                        this.messageFlow = metadata.getInt(len);
                    }
                    len = (short)(len + 4);
                }
                if (this.hasField(512)) {
                    if (frameDeserialize) {
                        this.offsets.messageSnoOffset = (short)len;
                    } else {
                        this.messageSno = metadata.getLong(len);
                    }
                    len = (short)(len + 8);
                }
                if (this.hasField(1024)) {
                    short messageBusLen = metadata.getShort(len);
                    if (frameDeserialize) {
                        this.offsets.messageBusOffset = (short)len;
                    } else {
                        this.messageBus = this.messageBusBuffer(messageBusLen);
                        this.messageBus.setValue(metadata, len + 2, (int)messageBusLen);
                    }
                    len = (short)(len + (2 + messageBusLen));
                }
                if (this.hasField(2048)) {
                    short messageChannelLen = metadata.getShort(len);
                    if (frameDeserialize) {
                        this.offsets.messageChannelOffset = (short)len;
                    } else {
                        this.messageChannel = this.messageChannelBuffer(messageChannelLen);
                        this.messageChannel.setValue(metadata, len + 2, (int)messageChannelLen);
                    }
                    len = (short)(len + (2 + messageChannelLen));
                }
                if (this.hasField(4096)) {
                    short messageKeyLen = metadata.getShort(len);
                    if (frameDeserialize) {
                        this.offsets.messageKeyOffset = (short)len;
                    } else {
                        this.messageKey = this.messageKeyBuffer(messageKeyLen);
                        this.messageKey.setValue(metadata, len + 2, (int)messageKeyLen);
                    }
                    len = (short)(len + (2 + messageKeyLen));
                }
                if (version > 4 && this.hasField(16384)) {
                    int messageTransportHeadersLen = MessageTransportHeaders.getSerializedLength((IOElasticBuffer)metadata, (int)len);
                    if (frameDeserialize) {
                        this.offsets.messageTransportHeadersOffset = (short)len;
                    } else {
                        if (this.messageTransportHeaders == null) {
                            this.messageTransportHeaders = MessageTransportHeaders.create();
                        }
                        this.messageTransportHeaders.deserialize(metadata, len);
                    }
                    len = (short)(len + messageTransportHeadersLen);
                }
                if (frameDeserialize) {
                    this.buffer.wrapIOBuffer(metadata.getIOBuffer(), metadata.getOffset(), metadata.getLength());
                }
            } else if (version == 2) {
                this.setGraphId(RogDirectMetadataV2Deserializer.getGraphId(metadata));
                this.setInMsgsInTransaction(RogDirectMetadataV2Deserializer.getInMsgsInTransaction(metadata));
                this.setIsInboundMessage(RogDirectMetadataV2Deserializer.getIsInboundMessage(metadata));
                this.setIsInternal(RogDirectMetadataV2Deserializer.getIsInternal(metadata));
                this.setIsLastTransaction(RogDirectMetadataV2Deserializer.getIsLastTransaction(metadata));
                this.setIsMessage(RogDirectMetadataV2Deserializer.getIsMessage(metadata));
                this.setIsOutboundMessage(RogDirectMetadataV2Deserializer.getIsOutboundMessage(metadata));
                this.setIsReplayedMessage(RogDirectMetadataV2Deserializer.getIsReplayedMessage(metadata));
                this.setMessageFlow(RogDirectMetadataV2Deserializer.getMessageFlow(metadata));
                this.setMessageSender(RogDirectMetadataV2Deserializer.getMessageSender(metadata));
                this.setMessageSequenceNumber(RogDirectMetadataV2Deserializer.getMessageSequenceNumber(metadata));
                this.setOutMsgsInTransaction(RogDirectMetadataV2Deserializer.getOutMsgsInTransaction(metadata));
                this.setOutTs(RogDirectMetadataV2Deserializer.getOutTs(metadata));
                this.setParentId(RogDirectMetadataV2Deserializer.getParentId(metadata));
                this.setPossibleDuplicate(RogDirectMetadataV2Deserializer.isPossibleDuplicate(metadata));
                this.setPreProcessingTs(RogDirectMetadataV2Deserializer.getPreProcessingTs(metadata));
                this.setTransactionInSequenceNumber(RogDirectMetadataV2Deserializer.getTransactionInSequenceNumber(metadata));
                this.setTransactionOutSequenceNumber(RogDirectMetadataV2Deserializer.getTransactionOutSequenceNumber(metadata));
                if (RogDirectMetadataV2Deserializer.hasMessageBus(metadata)) {
                    this.messageBus = this.messageBusBuffer(RogDirectMetadataV2Deserializer.getMessageBusLength(metadata));
                    RogDirectMetadataV2Deserializer.getMessageBus(metadata, this.messageBus);
                    this.setHasField(1024);
                }
                if (RogDirectMetadataV2Deserializer.hasMessageChannel(metadata)) {
                    this.messageChannel = this.messageChannelBuffer(RogDirectMetadataV2Deserializer.getMessageChannelLength(metadata));
                    RogDirectMetadataV2Deserializer.getMessageChannel(metadata, this.messageChannel);
                    this.setHasField(2048);
                }
                if (RogDirectMetadataV2Deserializer.hasMessageKey(metadata)) {
                    this.messageKey = this.messageKeyBuffer(RogDirectMetadataV2Deserializer.getMessageKeyLength(metadata));
                    RogDirectMetadataV2Deserializer.getMessageKey(metadata, this.messageKey);
                    this.setHasField(4096);
                }
            } else {
                if (version > 5) {
                    throw new RuntimeException("Unsupported ROG metadata version: " + version + " (possibly created with a newer version?)");
                }
                throw new RuntimeException("Unsupported ROG metadata version: " + version + " (corrupt?)");
            }
        }
        this.readOnly = frameDeserialize;
        return this;
    }

    public final RogDirectMetadata init() {
        this.hasFlags = 0;
        this.flags = 0;
        this.transactionInSequenceNumber = 0;
        this.transactionOutSequenceNumber = 0;
        this.graphId = 0;
        this.parentId = null;
        this.preprocTs = 0L;
        this.outTs = 0L;
        this.enqueueTs = 0L;
        this.messageSender = 0;
        this.messageFlow = 0;
        this.messageSno = 0L;
        this.messageBus = null;
        this.messageChannel = null;
        this.messageKey = null;
        this.buffer.reset();
        if (this.messageBusBuffer != null) {
            this.messageBusBuffer.reset();
        }
        if (this.messageChannelBuffer != null) {
            this.messageChannelBuffer.reset();
        }
        if (this.messageKeyBuffer != null) {
            this.messageKeyBuffer.reset();
        }
        if (this.messageTransportHeaders != null) {
            this.messageTransportHeaders.init();
        }
        if (this.offsets != null) {
            this.offsets.init();
        }
        this.readOnly = false;
        return this;
    }

    @Override
    @JsonProperty
    public final boolean getInMsgsInTransaction() {
        return this.getFlag(1);
    }

    public final void setInMsgsInTransaction(boolean val) {
        if (val) {
            this.setFlag(1);
        } else {
            this.clearFlag(1);
        }
    }

    @Override
    @JsonProperty
    public final boolean getOutMsgsInTransaction() {
        return this.getFlag(2);
    }

    public final void setOutMsgsInTransaction(boolean val) {
        if (val) {
            this.setFlag(2);
        } else {
            this.clearFlag(2);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsMessage() {
        return this.getFlag(8);
    }

    public final void setIsMessage(boolean val) {
        if (val) {
            this.setFlag(8);
        } else {
            this.clearFlag(8);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsInboundMessage() {
        return this.getFlag(256);
    }

    public final void setIsInboundMessage(boolean val) {
        if (val) {
            this.setFlag(256);
        } else {
            this.clearFlag(256);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsOutboundMessage() {
        return this.getFlag(16);
    }

    public final void setIsOutboundMessage(boolean val) {
        if (val) {
            this.setFlag(16);
        } else {
            this.clearFlag(16);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsReplayedMessage() {
        return this.getFlag(32);
    }

    public final void setIsReplayedMessage(boolean val) {
        if (val) {
            this.setFlag(32);
        } else {
            this.clearFlag(32);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsLastTransaction() {
        return this.getFlag(64);
    }

    public final void setIsLastTransaction(boolean val) {
        if (val) {
            this.setFlag(64);
        } else {
            this.clearFlag(64);
        }
    }

    @Override
    @JsonProperty
    public final boolean getIsInternal() {
        return this.getFlag(128);
    }

    public final void setIsInternal(boolean val) {
        if (val) {
            this.setFlag(128);
        } else {
            this.clearFlag(128);
        }
    }

    @Override
    @JsonProperty
    public final boolean isPossibleDuplicate() {
        return this.getFlag(4);
    }

    public final void setPossibleDuplicate(boolean val) {
        if (val) {
            this.setFlag(4);
        } else {
            this.clearFlag(4);
        }
    }

    @Override
    @JsonProperty
    public final int getTransactionInSequenceNumber() {
        if (this.offsets != null && this.offsets.transactionInSequenceNumberOffset > 0) {
            this.transactionInSequenceNumber = this.buffer.getInt((int)this.offsets.transactionInSequenceNumberOffset);
            this.offsets.transactionInSequenceNumberOffset = 0;
        }
        return this.transactionInSequenceNumber;
    }

    public final void setTransactionInSequenceNumber(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(2);
        } else {
            this.clearHasField(2);
        }
        this.transactionInSequenceNumber = val;
    }

    @Override
    @JsonProperty
    public final int getTransactionOutSequenceNumber() {
        if (this.offsets != null && this.offsets.transactionOutSequenceNumberOffset > 0) {
            this.transactionOutSequenceNumber = this.buffer.getInt((int)this.offsets.transactionOutSequenceNumberOffset);
            this.offsets.transactionOutSequenceNumberOffset = 0;
        }
        return this.transactionOutSequenceNumber;
    }

    public final void setTransactionOutSequenceNumber(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(4);
        } else {
            this.clearHasField(4);
        }
        this.transactionOutSequenceNumber = val;
    }

    @Override
    @JsonProperty
    public final int getGraphId() {
        if (this.offsets != null && this.offsets.graphIdOffset > 0) {
            this.graphId = this.buffer.getInt((int)this.offsets.graphIdOffset);
            this.offsets.graphIdOffset = 0;
        }
        return this.graphId;
    }

    public final void setGraphId(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(8);
        } else {
            this.clearHasField(8);
        }
        this.graphId = val;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.UUIDToStringConverter.class)
    public final UUID getParentId() {
        if (this.offsets != null && this.offsets.parentIdOffset > 0) {
            long time = this.buffer.getLong((int)this.offsets.parentIdOffset);
            long cas = this.buffer.getLong(this.offsets.parentIdOffset + 8);
            this.parentId = new UUID(time, cas);
            this.offsets.parentIdOffset = 0;
        }
        return this.parentId;
    }

    @JsonSerialize(converter=RogUtil.StringToUUIDConverter.class)
    public final void setParentId(UUID val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(16);
        } else {
            this.clearHasField(16);
        }
        this.parentId = val;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.TimestampToDateConverter.class)
    public final long getPreProcessingTs() {
        if (this.offsets != null && this.offsets.preprocTsOffset > 0) {
            this.preprocTs = this.buffer.getLong((int)this.offsets.preprocTsOffset);
            if (!this.getFlag(512)) {
                this.preprocTs *= 1000L;
            }
            this.offsets.preprocTsOffset = 0;
        }
        return this.preprocTs / 1000L;
    }

    @JsonDeserialize(converter=RogUtil.DateToTimestampConverter.class)
    public final void setPreProcessingTs(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(32);
        } else {
            this.clearHasField(32);
        }
        this.preprocTs = val * 1000L;
    }

    @Override
    @JsonProperty
    public final long getPreProcessingTsMicros() {
        if (this.offsets != null && this.offsets.preprocTsOffset > 0) {
            this.preprocTs = this.buffer.getLong((int)this.offsets.preprocTsOffset);
            if (!this.getFlag(512)) {
                this.preprocTs *= 1000L;
            }
            this.offsets.preprocTsOffset = 0;
        }
        return this.preprocTs;
    }

    public final void setPreProcessingTsMicros(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(32);
        } else {
            this.clearHasField(32);
        }
        this.preprocTs = val;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.TimestampToDateConverter.class)
    public final long getOutTs() {
        if (this.offsets != null && this.offsets.outTsOffset > 0) {
            this.outTs = this.buffer.getLong((int)this.offsets.outTsOffset);
            if (!this.getFlag(512)) {
                this.outTs *= 1000L;
            }
            this.offsets.outTsOffset = 0;
        }
        return this.outTs / 1000L;
    }

    @JsonDeserialize(converter=RogUtil.DateToTimestampConverter.class)
    public final void setOutTs(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(64);
        } else {
            this.clearHasField(64);
        }
        this.outTs = val * 1000L;
    }

    @Override
    @JsonProperty
    public final long getOutTsMicros() {
        if (this.offsets != null && this.offsets.outTsOffset > 0) {
            this.outTs = this.buffer.getLong((int)this.offsets.outTsOffset);
            if (!this.getFlag(512)) {
                this.outTs *= 1000L;
            }
            this.offsets.outTsOffset = 0;
        }
        return this.outTs;
    }

    public final void setOutTsMicros(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(64);
        } else {
            this.clearHasField(64);
        }
        this.outTs = val;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.TimestampToDateConverter.class)
    public final long getEnqueueTs() {
        if (this.offsets != null && this.offsets.enqueueTsOffset > 0) {
            this.enqueueTs = this.buffer.getLong((int)this.offsets.enqueueTsOffset);
            if (!this.getFlag(512)) {
                this.enqueueTs *= 1000L;
            }
            this.offsets.enqueueTsOffset = 0;
        }
        return this.enqueueTs / 1000L;
    }

    @JsonDeserialize(converter=RogUtil.DateToTimestampConverter.class)
    public final void setEnqueueTs(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(8192);
        } else {
            this.clearHasField(8192);
        }
        this.enqueueTs = val * 1000L;
    }

    @Override
    @JsonProperty
    public final long getEnqueueTsMicros() {
        if (this.offsets != null && this.offsets.enqueueTsOffset > 0) {
            this.enqueueTs = this.buffer.getLong((int)this.offsets.enqueueTsOffset);
            if (!this.getFlag(512)) {
                this.enqueueTs *= 1000L;
            }
            this.offsets.enqueueTsOffset = 0;
        }
        return this.enqueueTs;
    }

    public final void setEnqueueTsMicros(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(8192);
        } else {
            this.clearHasField(8192);
        }
        this.enqueueTs = val;
    }

    @Override
    @JsonProperty
    public final int getMessageSender() {
        if (this.offsets != null && this.offsets.messageSenderOffset > 0) {
            this.messageSender = this.buffer.getInt((int)this.offsets.messageSenderOffset);
            this.offsets.messageSenderOffset = 0;
        }
        return this.messageSender;
    }

    public final void setMessageSender(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(128);
        } else {
            this.clearHasField(128);
        }
        this.messageSender = val;
    }

    @Override
    @JsonProperty
    public final int getMessageFlow() {
        if (this.offsets != null && this.offsets.messageFlowOffset > 0) {
            this.messageFlow = this.buffer.getInt((int)this.offsets.messageFlowOffset);
            this.offsets.messageFlowOffset = 0;
        }
        return this.messageFlow;
    }

    public final void setMessageFlow(int val) {
        this.checkReadOnly();
        if (val != 0) {
            this.setHasField(256);
        } else {
            this.clearHasField(256);
        }
        this.messageFlow = val;
    }

    @Override
    @JsonProperty
    public final long getMessageSequenceNumber() {
        if (this.offsets != null && this.offsets.messageSnoOffset > 0) {
            this.messageSno = this.buffer.getLong((int)this.offsets.messageSnoOffset);
            this.offsets.messageSnoOffset = 0;
        }
        return this.messageSno;
    }

    public final void setMessageSequenceNumber(long val) {
        this.checkReadOnly();
        if (val != 0L) {
            this.setHasField(512);
        } else {
            this.clearHasField(512);
        }
        this.messageSno = val;
    }

    @Override
    @JsonProperty
    public final String getMessageBus() {
        XString rc = this.getMessageBusAsRaw();
        if (rc == null) {
            return null;
        }
        return rc.getValue();
    }

    @JsonIgnore
    public final XString getMessageBusAsRaw() {
        if (this.offsets != null && this.offsets.messageBusOffset > 0) {
            short messageBusLength = this.buffer.getShort((int)this.offsets.messageBusOffset);
            this.messageBus = this.messageBusBuffer(messageBusLength);
            this.messageBus.setValue(this.buffer.getIOBuffer(), this.buffer.getOffset() + this.offsets.messageBusOffset + 2, (int)messageBusLength, true);
            this.offsets.messageBusOffset = 0;
        }
        if (this.messageBus == null || this.messageBus.isNull()) {
            return null;
        }
        return this.messageBus;
    }

    public final void setMessageBus(String val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(1024);
            this.messageBus = this.messageBusBuffer(val.length());
            this.messageBus.setValue(val);
        } else {
            this.clearHasField(1024);
            if (this.messageBusBuffer != null) {
                this.messageBus = this.messageBusBuffer;
                this.messageBus.setValue((String)null);
            } else {
                this.messageBus = null;
            }
        }
    }

    public final void setMessageBusAsRaw(XString val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(1024);
        } else {
            this.clearHasField(1024);
        }
        if (val != null && val.isMutable()) {
            this.messageBus = this.messageBusBuffer(val.length());
            val.copyInto(this.messageBus);
        } else {
            this.messageBus = val;
        }
    }

    private final XString messageBusBuffer(int initialLength) {
        if (this.messageBusBuffer == null) {
            this.messageBusBuffer = XString.create((int)initialLength, (boolean)true, (!DISABLE_NATIVE_BUFFERS ? 1 : 0) != 0);
        }
        return this.messageBusBuffer;
    }

    @Override
    @JsonProperty
    public final String getMessageChannel() {
        XString rc = this.getMessageChannelAsRaw();
        if (rc == null) {
            return null;
        }
        return rc.getValue();
    }

    @JsonIgnore
    public final XString getMessageChannelAsRaw() {
        if (this.offsets != null && this.offsets.messageChannelOffset > 0) {
            short messageChannelLength = this.buffer.getShort((int)this.offsets.messageChannelOffset);
            this.messageChannel = this.messageChannelBuffer(messageChannelLength);
            this.messageChannel.setValue(this.buffer.getIOBuffer(), this.buffer.getOffset() + this.offsets.messageChannelOffset + 2, (int)messageChannelLength, true);
            this.offsets.messageChannelOffset = 0;
        }
        if (this.messageChannel == null || this.messageChannel.isNull()) {
            return null;
        }
        return this.messageChannel;
    }

    public final void setMessageChannel(String val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(2048);
            this.messageChannel = this.messageChannelBuffer(val.length());
            this.messageChannel.setValue(val);
        } else {
            this.clearHasField(2048);
            if (this.messageChannelBuffer != null) {
                this.messageChannel = this.messageChannelBuffer;
                this.messageChannel.setValue((String)null);
            } else {
                this.messageChannel = null;
            }
        }
    }

    public final void setMessageChannelAsRaw(XString val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(2048);
        } else {
            this.clearHasField(2048);
        }
        if (val != null && val.isMutable()) {
            this.messageChannel = this.messageChannelBuffer(val.length());
            val.copyInto(this.messageChannel);
        } else {
            this.messageChannel = val;
        }
    }

    private final XString messageChannelBuffer(int initialLength) {
        if (this.messageChannelBuffer == null) {
            this.messageChannelBuffer = XString.create((int)initialLength, (boolean)true, (!DISABLE_NATIVE_BUFFERS ? 1 : 0) != 0);
        }
        return this.messageChannelBuffer;
    }

    @Override
    @JsonProperty
    public final String getMessageKey() {
        XString rc = this.getMessageKeyAsRaw();
        if (rc == null) {
            return null;
        }
        return rc.getValue();
    }

    @JsonIgnore
    public final XString getMessageKeyAsRaw() {
        if (this.offsets != null && this.offsets.messageKeyOffset > 0) {
            short messageKeyLength = this.buffer.getShort((int)this.offsets.messageKeyOffset);
            this.messageKey = this.messageKeyBuffer(messageKeyLength);
            this.messageKey.setValue(this.buffer.getIOBuffer(), this.buffer.getOffset() + this.offsets.messageKeyOffset + 2, (int)messageKeyLength, true);
            this.offsets.messageKeyOffset = 0;
        }
        if (this.messageKey == null || this.messageKey.isNull()) {
            return null;
        }
        return this.messageKey;
    }

    public final void setMessageKey(String val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(4096);
            this.messageKey = this.messageKeyBuffer(val.length() + 1);
            this.messageKey.setValue(val);
        } else {
            this.clearHasField(4096);
            if (this.messageKeyBuffer != null) {
                this.messageKey = this.messageKeyBuffer;
                this.messageKey.setValue(val);
            } else {
                this.messageKey = null;
            }
        }
    }

    public final void setMessageKeyAsRaw(XString val) {
        this.checkReadOnly();
        if (val != null && !val.isNull()) {
            this.setHasField(4096);
        } else {
            this.clearHasField(4096);
        }
        if (val != null && val.isMutable()) {
            if (val == this.messageKeyBuffer) {
                this.messageKey = val;
                val.padForNullTerminator();
            } else {
                this.messageKey = this.messageKeyBuffer(val.length() + 1);
                val.copyInto(this.messageKey);
            }
        } else {
            this.messageKey = val;
        }
    }

    final XString messageKeyBuffer(int initialLength) {
        if (this.messageKeyBuffer == null) {
            this.messageKeyBuffer = XString.create((int)initialLength, (boolean)true, (!DISABLE_NATIVE_BUFFERS ? 1 : 0) != 0);
        } else if (this.messageKeyBuffer.getBackingBuffer().getLength() < initialLength) {
            this.messageKeyBuffer.getBackingBuffer().setLength(initialLength);
        }
        return this.messageKeyBuffer;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RogUtil.MessageTransportHeadersToMapConverter.class)
    public final MessageTransportHeaders getMessageTransportHeaders() {
        if (this.hasField(16384)) {
            if (this.offsets != null && this.offsets.messageTransportHeadersOffset > 0) {
                if (this.messageTransportHeaders == null) {
                    this.messageTransportHeaders = MessageTransportHeaders.create();
                }
                this.messageTransportHeaders.deserialize(this.buffer, (int)this.offsets.messageTransportHeadersOffset);
                this.offsets.messageTransportHeadersOffset = 0;
            } else if (this.messageTransportHeaders == null) {
                this.messageTransportHeaders = MessageTransportHeaders.create();
            }
            return this.messageTransportHeaders;
        }
        return null;
    }

    @JsonDeserialize(converter=RogUtil.MapToMessageTransportHeadersConverter.class)
    public final void setMessageTransportHeaders(MessageTransportHeaders val) {
        this.checkReadOnly();
        if (val != null) {
            this.setHasField(16384);
            if (val == this.messageTransportHeaders) {
                return;
            }
            if (this.messageTransportHeaders != null) {
                this.messageTransportHeaders.dispose();
            }
            this.messageTransportHeaders = val.copy();
        } else {
            this.clearHasField(16384);
            if (this.messageTransportHeaders != null) {
                this.messageTransportHeaders.dispose();
                this.messageTransportHeaders = null;
            }
        }
    }

    public final int serializedLength() {
        int len = 0;
        ++len;
        len += 4;
        if (this.hasField(1)) {
            len += 4;
        }
        if (this.hasField(2)) {
            len += 4;
        }
        if (this.hasField(4)) {
            len += 4;
        }
        if (this.hasField(8)) {
            len += 4;
        }
        if (this.hasField(16)) {
            len += 16;
        }
        if (this.hasField(32)) {
            len += 8;
        }
        if (this.hasField(64)) {
            len += 8;
        }
        if (this.hasField(8192)) {
            len += 8;
        }
        if (this.hasField(128)) {
            len += 4;
        }
        if (this.hasField(256)) {
            len += 4;
        }
        if (this.hasField(512)) {
            len += 8;
        }
        if (this.hasField(1024)) {
            len += 2 + this.getMessageBusAsRaw().getSerializedLength();
        }
        if (this.hasField(2048)) {
            len += 2 + this.getMessageChannelAsRaw().getSerializedLength();
        }
        if (this.hasField(4096)) {
            len += 2 + this.getMessageKeyAsRaw().getSerializedLength();
        }
        if (this.hasField(16384)) {
            len += this.getMessageTransportHeaders().serializedLength();
        }
        return len;
    }

    public final int serialize(IOElasticBuffer buffer, int offset) {
        int len = 0;
        if (DISABLE_MICROSECOND_TIMESTAMPS) {
            this.clearFlag(512);
        } else if (this.hasField(1)) {
            this.setFlag(512);
        }
        buffer.put(offset + len, this.hasField(16384) ? (byte)5 : 4);
        buffer.putInt(offset + ++len, this.hasFlags);
        len += 4;
        if (this.hasField(1)) {
            buffer.putInt(offset + len, this.flags);
            len += 4;
        }
        if (this.hasField(2)) {
            buffer.putInt(offset + len, this.getTransactionInSequenceNumber());
            len += 4;
        }
        if (this.hasField(4)) {
            buffer.putInt(offset + len, this.getTransactionOutSequenceNumber());
            len += 4;
        }
        if (this.hasField(8)) {
            buffer.putInt(offset + len, this.getGraphId());
            len += 4;
        }
        if (this.hasField(16)) {
            UUID parentId = this.getParentId();
            buffer.putLong(offset + len, parentId.getTime());
            buffer.putLong(offset + (len += 8), parentId.getClockSeqAndNode());
            len += 8;
        }
        if (this.hasField(32)) {
            buffer.putLong(offset + len, DISABLE_MICROSECOND_TIMESTAMPS ? this.getPreProcessingTs() : this.getPreProcessingTsMicros());
            len += 8;
        }
        if (this.hasField(64)) {
            buffer.putLong(offset + len, DISABLE_MICROSECOND_TIMESTAMPS ? this.getOutTs() : this.getOutTsMicros());
            len += 8;
        }
        if (this.hasField(8192)) {
            buffer.putLong(offset + len, DISABLE_MICROSECOND_TIMESTAMPS ? this.getEnqueueTs() : this.getEnqueueTsMicros());
            len += 8;
        }
        if (this.hasField(128)) {
            buffer.putInt(offset + len, this.getMessageSender());
            len += 4;
        }
        if (this.hasField(256)) {
            buffer.putInt(offset + len, this.getMessageFlow());
            len += 4;
        }
        if (this.hasField(512)) {
            buffer.putLong(offset + len, this.getMessageSequenceNumber());
            len += 8;
        }
        if (this.hasField(1024)) {
            XString messageBus = this.getMessageBusAsRaw();
            short messageBusLen = (short)messageBus.getSerializedLength();
            buffer.putShort(offset + len, messageBusLen);
            messageBus.copyInto(buffer, offset + (len += 2));
            len += messageBusLen;
        }
        if (this.hasField(2048)) {
            XString messageChannel = this.getMessageChannelAsRaw();
            short messageChannelLen = (short)messageChannel.getSerializedLength();
            buffer.putShort(offset + len, messageChannelLen);
            messageChannel.copyInto(buffer, offset + (len += 2));
            len += messageChannelLen;
        }
        if (this.hasField(4096)) {
            XString messageKey = this.getMessageKeyAsRaw();
            short messageKeyLen = (short)messageKey.getSerializedLength();
            buffer.putShort(offset + len, messageKeyLen);
            messageKey.copyInto(buffer, offset + (len += 2));
            len += messageKeyLen;
        }
        if (this.hasField(16384)) {
            MessageTransportHeaders headers = this.getMessageTransportHeaders();
            len += headers.serialize(buffer, offset + len);
        }
        buffer.setLength(len);
        return len;
    }

    public final RogDirectMetadata deserialize(IOElasticBuffer metadata, boolean copyDeserialize) {
        return this.init().deserializeCore(metadata, copyDeserialize);
    }

    public final RogDirectMetadata deserialize(IOElasticBuffer metadata) {
        return this.init().deserializeCore(metadata, false);
    }

    @Override
    public final String metadataToJsonString() {
        return this.metadataToJsonString(UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.indent.json", (boolean)false));
    }

    @Override
    public final String metadataToJsonString(boolean indentOutput) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder sb = new StringBuilder("{");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"class\":\"" + this.getClass().getSimpleName() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"int\":" + this.getIsInternal());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"msg\":" + this.getIsMessage());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"dir\":\"" + (this.getIsMessage() ? (this.getIsOutboundMessage() ? "out" : (this.getIsInboundMessage() ? "in" : "?")) : "---") + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"bus\":" + (this.getMessageBus() == null ? "null" : "\"" + this.getMessageBus() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"channel\":" + (this.getMessageChannel() == null ? "null" : "\"" + this.getMessageChannel() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"key\":" + (this.getMessageKey() == null ? "null" : "\"" + this.getMessageKey() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"sender\":" + this.getMessageSender());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"flow\":" + this.getMessageFlow());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"sno\":" + this.getMessageSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"graphid\":" + this.getGraphId());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"parentid\":" + (this.getParentId() == null ? "null" : "\"" + this.getParentId().toString() + "\""));
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"inmsgs\":" + this.getInMsgsInTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outmsgs\":" + this.getOutMsgsInTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"insno\":" + this.getTransactionInSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outsno\":" + this.getTransactionOutSequenceNumber());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"posdup\":" + this.isPossibleDuplicate());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"lasttxn\":" + this.getIsLastTransaction());
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outTs\":\"" + RogDirectMetadata.tsToDateString(this.getOutTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"outTsMicros\":\"" + this.getOutTsMicros() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"enqueueTs\":\"" + RogDirectMetadata.tsToDateString(this.getEnqueueTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"enqueueTsMicros\":\"" + this.getEnqueueTsMicros() + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"preprocTs\":\"" + RogDirectMetadata.tsToDateString(this.getPreProcessingTs(), dateFormat) + "\"");
        sb.append(",");
        if (indentOutput) {
            sb.append("\n  ");
        }
        sb.append("\"preprocTsMicros\":\"" + this.getPreProcessingTsMicros() + "\"");
        if (this.hasField(16384)) {
            sb.append(",");
            if (indentOutput) {
                sb.append("\n  ");
            }
            sb.append("\"messageTransportHeaders\":");
            MessageTransportHeaders headers = this.getMessageTransportHeaders();
            headers.toJsonString(indentOutput, 1, true, sb);
        }
        if (indentOutput) {
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final String metadataToString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("\n");
        sb.append("   int..............").append(this.getIsInternal()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   msg..............").append(this.getIsMessage()).append("\n");
        sb.append("   dir..............").append(this.getIsMessage() ? (this.getIsOutboundMessage() ? "out" : (this.getIsInboundMessage() ? "in" : "?")) : "---").append("\n");
        sb.append("   .................").append("\n");
        sb.append("   bus..............").append(this.getMessageBus()).append("\n");
        sb.append("   channel..........").append(this.getMessageChannel()).append("\n");
        sb.append("   key..............").append(this.getMessageKey()).append("\n");
        sb.append("   sender...........").append(this.getMessageSender()).append("\n");
        sb.append("   flow.............").append(this.getMessageFlow()).append("\n");
        sb.append("   sno..............").append(this.getMessageSequenceNumber()).append("\n");
        if (this.hasField(16384)) {
            sb.append("   transportHeaders {").append("\n");
            for (MessageTransportHeaders.Header header : this.getMessageTransportHeaders()) {
                sb.append("      ").append(header.getName()).append("=").append(header.getValue()).append("\n");
            }
            sb.append("   }\n");
        }
        sb.append("   .................").append("\n");
        sb.append("   graphid..........").append(this.getGraphId()).append("\n");
        sb.append("   parentid.........").append(this.getParentId()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   inmsgs...........").append(this.getInMsgsInTransaction()).append("\n");
        sb.append("   outmsgs..........").append(this.getOutMsgsInTransaction()).append("\n");
        sb.append("   insno............").append(this.getTransactionInSequenceNumber()).append("\n");
        sb.append("   outsno...........").append(this.getTransactionOutSequenceNumber()).append("\n");
        sb.append("   posdup...........").append(this.isPossibleDuplicate()).append("\n");
        sb.append("   lasttxn..........").append(this.getIsLastTransaction()).append("\n");
        sb.append("   .................").append("\n");
        sb.append("   outTs............").append(RogDirectMetadata.tsToDateString(this.getOutTs(), dateFormat)).append("\n");
        sb.append("   outTsMicros......").append(this.getOutTsMicros()).append("\n");
        sb.append("   enqueueTs........").append(RogDirectMetadata.tsToDateString(this.getEnqueueTs(), dateFormat)).append("\n");
        sb.append("   enqueueTsMicros..").append(this.getEnqueueTsMicros()).append("\n");
        sb.append("   preprocTs........").append(RogDirectMetadata.tsToDateString(this.getPreProcessingTs(), dateFormat)).append("\n");
        sb.append("   preprocTsMicros..").append(this.getPreProcessingTsMicros()).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public final String toString() {
        return this.metadataToString();
    }

    static {
        if (XRuntime.getValue((String)"nv.native.configtrace", (boolean)false)) {
            System.out.println("NATIVE ROG METADATA BUFFERS ARE " + (!DISABLE_NATIVE_BUFFERS ? "ENABLED" : "DISABLED"));
        }
        memoryStats = MemoryStats.getInstance();
    }

    private static final class Offsets {
        short transactionInSequenceNumberOffset;
        short transactionOutSequenceNumberOffset;
        short graphIdOffset;
        short parentIdOffset;
        short preprocTsOffset;
        short outTsOffset;
        short enqueueTsOffset;
        short messageSenderOffset;
        short messageFlowOffset;
        short messageSnoOffset;
        short messageBusOffset;
        short messageChannelOffset;
        short messageKeyOffset;
        short messageTransportHeadersOffset;

        private Offsets() {
        }

        final void init() {
            this.transactionInSequenceNumberOffset = 0;
            this.transactionOutSequenceNumberOffset = 0;
            this.graphIdOffset = 0;
            this.parentIdOffset = 0;
            this.preprocTsOffset = 0;
            this.outTsOffset = 0;
            this.enqueueTsOffset = 0;
            this.messageSenderOffset = 0;
            this.messageFlowOffset = 0;
            this.messageSnoOffset = 0;
            this.messageBusOffset = 0;
            this.messageChannelOffset = 0;
            this.messageKeyOffset = 0;
            this.messageTransportHeadersOffset = 0;
        }
    }
}

