/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;

public abstract class IdxKeyComparator<K extends Serializable>
implements Comparator<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Class<K> keyType;

    public static <K extends Serializable, C extends Comparable<C>> IdxKeyComparator<K> onResult(Class<K> keyType, KeyTransformation<K, C> keyTransformation) {
        return new TransformationComparator<K, C>(keyType, keyTransformation);
    }

    public IdxKeyComparator(Class<K> keyType) {
        this.keyType = keyType;
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }

    private static class TransformationComparator<K extends Serializable, C extends Comparable<C>>
    extends IdxKeyComparator<K> {
        private static final long serialVersionUID = 1L;
        private KeyTransformation<K, C> keyTransformation;

        public TransformationComparator(Class<K> keyType, KeyTransformation<K, C> keyTransformation) {
            super(keyType);
            this.keyTransformation = keyTransformation;
        }

        @Override
        public int compare(K key1, K key2) {
            Comparable comparable1 = (Comparable)this.keyTransformation.apply(key1);
            Comparable comparable2 = (Comparable)this.keyTransformation.apply(key2);
            return comparable1.compareTo(comparable2);
        }
    }

    public static final class KeyToString<K extends Serializable>
    extends FluentKeyTransformation<K, String> {
        private static final long serialVersionUID = 1L;

        public String apply(K key) {
            return key.toString();
        }
    }

    private static final class CachingTransformation<K extends Serializable, C extends Comparable<C>>
    extends FluentKeyTransformation<K, C> {
        private static final long serialVersionUID = 1L;
        private HashMap<K, C> cache = Maps.newHashMap();
        private KeyTransformation<K, C> keyTransformation;

        public CachingTransformation(KeyTransformation<K, C> keyTransformation) {
            this.keyTransformation = keyTransformation;
        }

        public C apply(K key) {
            Comparable result;
            if (this.cache.containsKey(key)) {
                result = (Comparable)this.cache.get(key);
            } else {
                result = (Comparable)this.keyTransformation.apply(key);
                this.cache.put(key, result);
            }
            return (C)result;
        }
    }

    public static abstract class FluentKeyTransformation<K extends Serializable, C extends Comparable<C>>
    implements KeyTransformation<K, C> {
        private static final long serialVersionUID = 1L;

        @Override
        public KeyTransformation<K, C> withResultCaching() {
            return new CachingTransformation(this);
        }
    }

    public static interface KeyTransformation<K, C extends Comparable<C>>
    extends Function<K, C>,
    Serializable {
        public KeyTransformation<K, C> withResultCaching();
    }
}

