/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.neeve.ci.XRuntime;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxNwLnkClosedGracefullyException;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.link.ILnkContainerRunCompletionChecker;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkRegistry;
import com.neeve.link.LnkSTRRunnableContainer;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.OdsConfig;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsFatalException;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.impl.EStoreReplicatorMemberLinkException;
import com.neeve.ods.impl.StoreCommitCompletionStatus;
import com.neeve.ods.impl.StoreReplicator;
import com.neeve.ods.impl.StoreReplicatorMember;
import com.neeve.ods.impl.StoreReplicatorStats;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.stats.Stats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.concurrent.atomic.AtomicBoolean;

final class StoreReplicatorEventMultiplexer
extends LnkSTRRunnableContainer
implements ILnkEventHandler {
    private final StoreReplicator replicator;
    private final StoreReplicatorStats stats;
    private final LinkReader linkReader;
    private final long linkReaderAffinityMask;
    private final EmxActionExecutor<Object, Object> actionExecutor;
    private final LinkAddAction linkAddAction;
    private final EntityUpAction entityUpAction;
    private final ScheduleMemberTableOpenWaitCompletionAlarmAction scheduleMemberTableOpenWaitCompletionAlarmAction;
    private final MemberTableOpenWaitCompletionAlarmEventHandler memberTableOpenWaitCompletionAlarmEventHandler;
    private final UnscheduleMemberTableOpenWaitCompletionAlarmAction unscheduleMemberTableOpenWaitCompletionAlarmAction;
    private final MemberHandshakeStartReadyAction memberHandshakeStartReadyAction;
    private final MemberInitReadyAction memberInitReadyAction;
    private final EntityDownAction entityDownAction;
    private final MemberFailAction memberFailAction;
    private final FailAction failAction;
    private final CloseAction closeAction;
    private final AtomicBoolean closeInitiated = new AtomicBoolean();
    private final MemberList attachedSendMemberList;
    private final boolean captureStoreLatencyStats;
    private IEmxAlarmEvent memberTableOpenWaitCompletionAlarmEvent;
    private String detachedSendClaimStrategyStr;
    private String detachedSendWaitStrategyStr;
    private RingBuffer<DetachedSendCarrierEvent> detachedSendRingBuffer;
    private SequenceBarrier detachedSendSequenceBarrier;
    private DetachedSendCarrierEventProcessor detachedSendProcessor;
    private BatchEventProcessor<DetachedSendCarrierEvent> detachedSendBatchProcessor;
    private Thread detachedSender;
    private String detachedDispatchClaimStrategyStr;
    private String detachedDispatchWaitStrategyStr;
    private RingBuffer<DetachedDispatchCarrierEvent> detachedDispatchRingBuffer;
    private SequenceBarrier detachedDispatchSequenceBarrier;
    private DetachedDispatchCarrierEventProcessor detachedDispatchProcessor;
    private BatchEventProcessor<DetachedDispatchCarrierEvent> detachedDispatchBatchProcessor;
    private Thread detachedDispatcher;
    private volatile State state;
    private volatile boolean failScheduled;

    StoreReplicatorEventMultiplexer(StoreReplicator replicator) throws Exception {
        super(OdsConfig.getConfig(), "X-ODS-StoreReplicatorLinkReader-" + replicator.getStoreName() + "-" + replicator.getMemberName(), null, 0);
        boolean detachedDispatch;
        boolean detachedSend;
        this.replicator = replicator;
        this.stats = replicator.getStats();
        this.captureStoreLatencyStats = replicator.getBinding().captureStoreLatencyStats;
        try {
            this.setReader(EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, this.getName(), IEmxDispatcher.Params.create((boolean)false, (boolean)true)));
        }
        catch (EEmxException e) {
            throw new OdsException("Failed to create link link container reader dispatcher [" + e.toString() + "]");
        }
        this.linkReader = new LinkReader();
        this.linkReaderAffinityMask = UtlThread.parseAffinityMask((String)replicator.getDescriptor().getProperty("linkReaderCpuAffinityMask", "0"));
        this.actionExecutor = new EmxActionExecutor();
        this.linkAddAction = new LinkAddAction();
        this.entityUpAction = new EntityUpAction();
        this.memberInitReadyAction = new MemberInitReadyAction();
        this.scheduleMemberTableOpenWaitCompletionAlarmAction = new ScheduleMemberTableOpenWaitCompletionAlarmAction();
        this.memberTableOpenWaitCompletionAlarmEventHandler = new MemberTableOpenWaitCompletionAlarmEventHandler();
        this.unscheduleMemberTableOpenWaitCompletionAlarmAction = new UnscheduleMemberTableOpenWaitCompletionAlarmAction();
        this.memberHandshakeStartReadyAction = new MemberHandshakeStartReadyAction();
        this.entityDownAction = new EntityDownAction();
        this.memberFailAction = new MemberFailAction();
        this.failAction = new FailAction();
        this.closeAction = new CloseAction();
        this.attachedSendMemberList = new MemberList(null);
        try {
            detachedSend = Boolean.parseBoolean(replicator.getDescriptor().getProperty("detachedSend", "false"));
        }
        catch (Exception e) {
            this.tracer.log(replicator.getTracePrefix() + "failed to parse 'detachedSend' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.SEVERE);
            throw new OdsException(e);
        }
        if (detachedSend) {
            int queueDepth;
            final long detachedSenderCpuAffinityMask = UtlThread.parseAffinityMask((String)replicator.getDescriptor().getProperty("senderCpuAffinityMask", "0"));
            try {
                queueDepth = Integer.parseInt(replicator.getDescriptor().getProperty("senderQueueDepth", "1024"));
            }
            catch (Exception e) {
                this.tracer.log(replicator.getTracePrefix() + "failed to parse 'senderQueueDepth' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.SEVERE);
                throw new OdsException(e);
            }
            SingleThreadedClaimStrategy claimStrategy = new SingleThreadedClaimStrategy(queueDepth);
            this.detachedSendClaimStrategyStr = claimStrategy.getClass().getSimpleName();
            WaitStrategy waitStrategy = XRuntime.createWaitStrategy((String)replicator.getDescriptor().getProperty("senderQueueWaitStrategy", null), (boolean)true);
            this.detachedSendWaitStrategyStr = waitStrategy.getClass().getSimpleName();
            this.detachedSendProcessor = new DetachedSendCarrierEventProcessor();
            this.detachedSendRingBuffer = new RingBuffer((EventFactory)new EventFactory<DetachedSendCarrierEvent>(){

                public DetachedSendCarrierEvent newInstance() {
                    return new DetachedSendCarrierEvent();
                }
            }, (ClaimStrategy)claimStrategy, waitStrategy);
            this.detachedSendSequenceBarrier = UtlThread.asIntrumentedSequenceBarrier((SequenceBarrier)this.detachedSendRingBuffer.newBarrier(new Sequence[0]));
            this.detachedSendBatchProcessor = new BatchEventProcessor(this.detachedSendRingBuffer, this.detachedSendSequenceBarrier, (EventHandler)this.detachedSendProcessor);
            this.detachedSendRingBuffer.setGatingSequences(new Sequence[]{this.detachedSendBatchProcessor.getSequence()});
            this.detachedSender = new Thread((Runnable)this.detachedSendBatchProcessor){

                @Override
                public final void run() {
                    if (detachedSenderCpuAffinityMask != 0L) {
                        UtlThread.setCPUAffinityMask((long)detachedSenderCpuAffinityMask);
                    } else {
                        UtlThread.setDefaultCPUAffinityMask();
                    }
                    super.run();
                }
            };
            this.detachedSender.setName("X-ODS-StoreReplicatorSender-" + replicator.getStoreName() + "-" + replicator.getMemberName());
            this.detachedSender.setDaemon(true);
        } else {
            this.detachedSendClaimStrategyStr = "N/A";
            this.detachedSendWaitStrategyStr = "N/A";
        }
        try {
            detachedDispatch = Boolean.parseBoolean(replicator.getDescriptor().getProperty("detachedDispatch", "false"));
        }
        catch (Exception e) {
            this.tracer.log(replicator.getTracePrefix() + "failed to parse 'detachedDispatch' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.SEVERE);
            throw new OdsException(e);
        }
        if (detachedDispatch) {
            int queueDepth;
            final long detachedDispatcherCpuAffinityMask = UtlThread.parseAffinityMask((String)replicator.getDescriptor().getProperty("dispatcherCpuAffinityMask", "0"));
            try {
                queueDepth = Integer.parseInt(replicator.getDescriptor().getProperty("dispatcherQueueDepth", "1024"));
            }
            catch (Exception e) {
                this.tracer.log(replicator.getTracePrefix() + "failed to parse 'dispatcherQueueDepth' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.SEVERE);
                throw new OdsException(e);
            }
            SingleThreadedClaimStrategy claimStrategy = new SingleThreadedClaimStrategy(queueDepth);
            this.detachedDispatchClaimStrategyStr = claimStrategy.getClass().getSimpleName();
            WaitStrategy waitStrategy = XRuntime.createWaitStrategy((String)replicator.getDescriptor().getProperty("dispatcherQueueWaitStrategy", null), (boolean)true);
            this.detachedDispatchWaitStrategyStr = waitStrategy.getClass().getSimpleName();
            this.detachedDispatchProcessor = new DetachedDispatchCarrierEventProcessor();
            this.detachedDispatchRingBuffer = new RingBuffer((EventFactory)new EventFactory<DetachedDispatchCarrierEvent>(){

                public DetachedDispatchCarrierEvent newInstance() {
                    return new DetachedDispatchCarrierEvent();
                }
            }, (ClaimStrategy)claimStrategy, waitStrategy);
            this.detachedDispatchSequenceBarrier = UtlThread.asIntrumentedSequenceBarrier((SequenceBarrier)this.detachedDispatchRingBuffer.newBarrier(new Sequence[0]));
            this.detachedDispatchBatchProcessor = new BatchEventProcessor(this.detachedDispatchRingBuffer, this.detachedDispatchSequenceBarrier, (EventHandler)this.detachedDispatchProcessor);
            this.detachedDispatchRingBuffer.setGatingSequences(new Sequence[]{this.detachedDispatchBatchProcessor.getSequence()});
            this.detachedDispatcher = new Thread((Runnable)this.detachedDispatchBatchProcessor){

                @Override
                public final void run() {
                    if (detachedDispatcherCpuAffinityMask != 0L) {
                        UtlThread.setCPUAffinityMask((long)detachedDispatcherCpuAffinityMask);
                    } else {
                        UtlThread.setDefaultCPUAffinityMask();
                    }
                    super.run();
                }
            };
            this.detachedDispatcher.setName("X-ODS-StoreReplicatorDispatcher-" + replicator.getStoreName() + "-" + replicator.getMemberName());
            this.detachedDispatcher.setDaemon(true);
        } else {
            this.detachedDispatchClaimStrategyStr = "N/A";
            this.detachedDispatchWaitStrategyStr = "N/A";
        }
        this.state = State.Init;
        if (this.tracer.debug) {
            this.tracer.log(replicator.getTracePrefix() + "created event multpliexer '" + this.getName() + "'...", Tracer.Level.DEBUG);
        }
    }

    private final IllegalStateException prepareStateValidationErrorException() {
        switch (this.state) {
            case Init: {
                return new IllegalStateException("multiplexer has not been opened");
            }
            case Open: {
                return new IllegalStateException("multiplexer is open");
            }
            case Closed: {
                return new IllegalStateException("multiplexer is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    private final void onFatalError(Throwable cause) {
        OdsFatalException e;
        StringBuilder sb = new StringBuilder();
        sb.append(this.replicator.getTracePrefix() + "store replicator event multiplexer encountered fatal exception ' [" + cause.toString() + "]").append("\n");
        sb.append("Stack Trace:").append("\n");
        sb.append(UtlThrowable.prepareStackTrace((Throwable)cause));
        sb.append("Shutting down store...").append("\n");
        this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        OdsFatalException odsFatalException = e = cause instanceof OdsFatalException ? (OdsFatalException)cause : new OdsFatalException(cause);
        if (Thread.currentThread() == this.getDispatcherThread()) {
            this.replicator.handleFailure(e);
        } else {
            this.scheduleFail(e);
        }
    }

    private final void publishToDetachedDispatcher(DetachedDispatchCarrierEventType eventType, Object eventData, StoreReplicatorMember packetMember) {
        long sequence = this.detachedDispatchRingBuffer.next();
        DetachedDispatchCarrierEvent carrierEvent = (DetachedDispatchCarrierEvent)this.detachedDispatchRingBuffer.get(sequence);
        carrierEvent.type = eventType;
        carrierEvent.data = eventData;
        carrierEvent.packetMember = packetMember;
        if (this.captureStoreLatencyStats) {
            carrierEvent.publishTs = UtlTime.now();
        }
        this.detachedDispatchRingBuffer.publish(sequence);
    }

    private final void dispatchHandleEntityUp(IDiscoveryEntity entity) {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleEntityUp(entity);
        }
    }

    private final void dispatchHandleMemberTableOpenWaitCompletion() {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleMemberTableOpenWaitCompletion();
        }
    }

    private final void dispatchHandleMemberHandshakeStartReady(IStoreMember member) {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleMemberHandshakeStartReady(member);
        }
    }

    private final void dispatchHandleMemberInitReady(IStoreMember member) {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleMemberInitReady(member);
        }
    }

    private final void dispatchHandleEntityDown(IDiscoveryEntity entity) {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleEntityDown(entity, "discovery");
        }
    }

    private final void dispatchHandleMemberPacket(StoreReplicatorMember member, PktPacket packet) {
        if (!this.failScheduled && this.state != State.Closed) {
            member.onPacket(packet);
        }
    }

    private final void dispatchHandleMemberFail(StoreReplicatorMember member) {
        if (this.state != State.Closed) {
            member.fail(null);
        }
    }

    private final void dispatchHandleFail(Exception e) {
        if (this.state != State.Closed) {
            this.replicator.handleFailure(e);
        }
    }

    private final void sendCommitEntryCore(PktPacket packet, MemberList memberList, StoreCommitCompletionStatus completionStatus, boolean commitEnd, long postSerializeTs, Stats.LatencyManager s2w, int flushFlags) {
        for (int i = 0; i < memberList.memberCount; ++i) {
            try {
                memberList.members[i].sendCommitEntry(packet, flushFlags);
                continue;
            }
            catch (EStoreReplicatorMemberLinkException e) {
                this.tracer.log(this.replicator.getTracePrefix() + "failure in sending commit entry [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] to member '" + memberList.members[i].getName() + "'. failing member...", Tracer.Level.SEVERE);
                this.scheduleMemberFail(memberList.members[i]);
            }
        }
        if (completionStatus != null) {
            long preWireTs = packet.getOutTs();
            completionStatus.getCompletionEvent().setPreWireTs(preWireTs);
            if (s2w != null && postSerializeTs > 0L && preWireTs > 0L) {
                s2w.add((double)(preWireTs - postSerializeTs));
            }
        }
    }

    private final void flushMemberList(MemberList memberList) {
        for (int i = 0; i < memberList.memberCount; ++i) {
            try {
                memberList.members[i].flush();
                continue;
            }
            catch (EStoreReplicatorMemberLinkException e) {
                this.tracer.log(this.replicator.getTracePrefix() + "failure in flushing member [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] (member '" + memberList.members[i].getName() + "'). failing member...", Tracer.Level.SEVERE);
                this.scheduleMemberFail(memberList.members[i]);
            }
        }
    }

    private final void onPacket(ILnkPeerEndpoint pep, PktPacket packet) {
        block11: {
            try {
                if (pep.getAttachment() != null) {
                    try {
                        if (this.detachedDispatcher != null) {
                            this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberPacket, packet, (StoreReplicatorMember)pep.getAttachment());
                        } else {
                            this.dispatchHandleMemberPacket((StoreReplicatorMember)pep.getAttachment(), packet);
                        }
                        break block11;
                    }
                    catch (ClassCastException e) {
                        throw new InternalError("Link attachment is not a store member object!");
                    }
                    catch (Exception e) {
                        this.tracer.log(this.replicator.getTracePrefix() + "failure in processing inbound packet [" + e.toString() + "].", Tracer.Level.WARNING);
                        throw e;
                    }
                }
                if (packet.getBody().getType() == 756) {
                    try {
                        this.replicator.handleMemberConnect(pep, packet);
                        break block11;
                    }
                    catch (Exception e) {
                        this.tracer.log(this.replicator.getTracePrefix() + "failure in scheduling member connect [" + e.toString() + "]. Closing link...", Tracer.Level.WARNING);
                        this.closeLink(pep);
                        throw e;
                    }
                }
                this.tracer.log(this.replicator.getTracePrefix() + "invalid packet <exp='" + PktFactory.getInstance().getPacketTypeNameFromId(756) + "', actual='" + PktFactory.getInstance().getPacketTypeNameFromId(packet.getBody().getType()) + "'>. Closing link...", Tracer.Level.WARNING);
                this.closeLink(pep);
            }
            catch (Throwable e) {
                this.onFatalError(e);
            }
        }
    }

    private final void onPacketList(ILnkPeerEndpoint pep, UtlList packets) {
        for (PktPacket packet = (PktPacket)packets.first(); packet != null; packet = (PktPacket)packet.next()) {
            this.onPacket(pep, packet);
        }
    }

    private final void onLinkFailure(ILnkPeerEndpoint pep, Exception cause) {
        StoreReplicatorMember member = (StoreReplicatorMember)pep.getAttachment();
        if (member != null) {
            try {
                if (cause.getCause() instanceof EEmxNwLnkClosedGracefullyException) {
                    this.tracer.log(this.replicator.getTracePrefix() + "member '" + member.getName() + "' closed its link.", Tracer.Level.VERBOSE);
                } else {
                    this.tracer.log(this.replicator.getTracePrefix() + "member '" + member.getName() + "' link has failed [" + (cause.getMessage() != null ? cause.getMessage() : cause.toString()) + "]. failing member...", Tracer.Level.WARNING);
                }
                this.scheduleMemberFail(member);
            }
            catch (ClassCastException e) {
                throw new InternalError("Link attachment is not a store member object!");
            }
            catch (Exception e) {
                this.tracer.log(this.replicator.getTracePrefix() + "failure in processing entity down event [" + e.toString() + "]. Closing link...", Tracer.Level.WARNING);
                this.closeLink(pep);
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "an unattached link has failed [" + cause.toString() + ". Closing link...", Tracer.Level.DEBUG);
            }
            this.closeLink(pep);
        }
    }

    final boolean isDetachedSend() {
        return this.detachedSender != null;
    }

    final int getDetachedSendDisruptorCapacity() {
        return this.detachedSender != null ? this.detachedSendRingBuffer.getBufferSize() : -1;
    }

    final int getDetachedSendDisruptorRemaining() {
        return this.detachedSender != null ? (int)this.detachedSendRingBuffer.remainingCapacity() : -1;
    }

    final String getDetachedSendDisruptorClaimStrategy() {
        return this.detachedSendClaimStrategyStr;
    }

    final String getDetachedSendDisruptorWaitStrategy() {
        return this.detachedSendWaitStrategyStr;
    }

    final boolean isDetachedDispatch() {
        return this.detachedDispatcher != null;
    }

    final int getDetachedDispatchDisruptorCapacity() {
        return this.detachedDispatcher != null ? this.detachedDispatchRingBuffer.getBufferSize() : -1;
    }

    final int getDetachedDispatchDisruptorRemaining() {
        return this.detachedDispatcher != null ? (int)this.detachedDispatchRingBuffer.remainingCapacity() : -1;
    }

    final String getDetachedDispatchDisruptorClaimStrategy() {
        return this.detachedDispatchClaimStrategyStr;
    }

    final String getDetachedDispatchDisruptorWaitStrategy() {
        return this.detachedDispatchWaitStrategyStr;
    }

    final State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void open() {
        if (this.tracer.debug) {
            this.tracer.log(this.replicator.getTracePrefix() + "opening event multpliexer...", Tracer.Level.DEBUG);
        }
        if (this.state == State.Init) {
            if (this.detachedSender != null) {
                this.detachedSender.start();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.detachedDispatcher != null) {
                this.detachedDispatcher.start();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.linkReader.start();
            LinkReader.StartCoordinator startCoordinator = this.linkReader.startCoordinator;
            synchronized (startCoordinator) {
                while (!this.linkReader.startCoordinator.isStarted) {
                    try {
                        this.linkReader.startCoordinator.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        throw this.prepareStateValidationErrorException();
        this.state = State.Open;
    }

    final Thread getDispatcherThread() {
        return this.detachedDispatcher != null ? this.detachedDispatcher : this.linkReader;
    }

    final void addReplicatorLink(ILnkPeerEndpoint pep) throws Exception {
        if (this.state == State.Open) {
            if (pep.getContainer() == null) {
                pep.setContainer((LnkContainer)this);
            }
            if (pep.getContainer() != this) {
                throw new InternalError("wrong container attached to link!");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
        this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.linkAddAction, (Object)pep, 1);
    }

    final void scheduleEntityUp(IDiscoveryEntity entity) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.entityUpAction, (Object)entity, 0);
    }

    final void scheduleMemberTableOpenWaitCompletion(int memberTableOpenWaitTime) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.scheduleMemberTableOpenWaitCompletionAlarmAction, (Object)memberTableOpenWaitTime, 0);
    }

    final void unscheduleMemberTableOpenWaitCompletion() throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.unscheduleMemberTableOpenWaitCompletionAlarmAction, null, 0);
    }

    final void scheduleMemberHandshakeStartReady(IStoreMember member) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.memberHandshakeStartReadyAction, (Object)member, 0);
    }

    final void scheduleMemberInitReady(IStoreMember member) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.memberInitReadyAction, (Object)member, 0);
    }

    final void scheduleEntityDown(IDiscoveryEntity entity) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.entityDownAction, (Object)entity, 0);
    }

    final void scheduleMemberFail(StoreReplicatorMember member) {
        if (this.state == State.Open) {
            try {
                member.setFailing();
                this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.memberFailAction, (Object)member, 0);
            }
            catch (Exception e) {
                throw new InternalError("failed to schedule member fail in link container reader thread");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    final void scheduleFail(Exception cause) {
        if (this.state == State.Open) {
            try {
                this.failScheduled = true;
                this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.failAction, (Object)cause, 0);
            }
            catch (Exception e) {
                throw new InternalError("failed to schedule fail in link container reader thread");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    final MemberList getFreshReplicationMemberList() {
        if (this.detachedSender != null) {
            long sequence = this.detachedSendRingBuffer.next();
            DetachedSendCarrierEvent carrierEvent = (DetachedSendCarrierEvent)this.detachedSendRingBuffer.get(sequence);
            carrierEvent.sequence = sequence;
            return carrierEvent.memberList;
        }
        return this.attachedSendMemberList;
    }

    final void sendCommitEntry(StoreCommitEntry commitEntry, MemberList memberList, StoreCommitCompletionStatus completionStatus, long postSerializeTs, Stats.LatencyManager s2w) {
        int flushFlags = 0;
        if (commitEntry.commitEnd) {
            flushFlags = memberList.carrierEvent != null ? 8 : 16;
        }
        this.sendCommitEntryCore(commitEntry.serializedObject, memberList, completionStatus, commitEntry.commitEnd, postSerializeTs, s2w, flushFlags);
        if (memberList.carrierEvent != null) {
            if (this.captureStoreLatencyStats) {
                memberList.carrierEvent.publishTs = UtlTime.now();
            }
            this.detachedSendRingBuffer.publish(memberList.carrierEvent.sequence);
        }
    }

    final void closeLink(ILnkPeerEndpoint pep) {
        try {
            pep.close((short)-1);
        }
        catch (Exception e) {
            this.tracer.log(this.replicator.getTracePrefix() + "failed to close link after packet processing failure [" + e.toString() + "].", Tracer.Level.WARNING);
        }
    }

    final void close(Boolean dispatchMemberDownEvents) {
        block23: {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "closing event multiplexer...", Tracer.Level.DEBUG);
            }
            if (this.state != State.Closed) {
                if (this.state == State.Open) {
                    try {
                        if (this.closeInitiated.compareAndSet(false, true)) {
                            if (this.detachedDispatchBatchProcessor != null) {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.replicator.getTracePrefix() + "shutting down the detached dispatcher thread...", Tracer.Level.DEBUG);
                                }
                                if (this.detachedDispatcher != null) {
                                    while (this.detachedDispatcher.isAlive()) {
                                        try {
                                            this.detachedDispatchBatchProcessor.halt();
                                            this.detachedDispatcher.join(500L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    UtlThread.deregister((Thread)this.detachedDispatcher);
                                    this.detachedDispatcher = null;
                                }
                                this.detachedDispatchBatchProcessor = null;
                            }
                            if (this.detachedSendBatchProcessor != null) {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.replicator.getTracePrefix() + "shutting down the detached sender thread...", Tracer.Level.DEBUG);
                                }
                                if (this.detachedSender != null) {
                                    while (this.detachedSender.isAlive()) {
                                        try {
                                            this.detachedSendBatchProcessor.halt();
                                            this.detachedSender.join(500L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    UtlThread.deregister((Thread)this.detachedSender);
                                    this.detachedSender = null;
                                }
                                this.detachedSendBatchProcessor = null;
                            }
                            this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.closeAction, (Object)dispatchMemberDownEvents, 1);
                        }
                        if (Thread.currentThread() == this.getReader().getOwner()) break block23;
                        while (true) {
                            try {
                                this.linkReader.join();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        InternalError error = new InternalError("Failure encountered while shutting down ODS event link container reader thread [" + e.toString() + "]...");
                        error.initCause(e);
                        throw error;
                    }
                }
            } else if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "already closed.", Tracer.Level.DEBUG);
            }
        }
    }

    public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
        switch (type) {
            case 5: {
                this.onPacket((ILnkPeerEndpoint)ep, (PktPacket)data);
                break;
            }
            case 6: {
                this.onPacketList((ILnkPeerEndpoint)ep, (UtlList)data);
                break;
            }
            case 8: {
                this.onLinkFailure((ILnkPeerEndpoint)ep, (Exception)data);
                break;
            }
        }
    }

    final class MemberList {
        private final DetachedSendCarrierEvent carrierEvent;
        final StoreReplicatorMember[] members = new StoreReplicatorMember[255];
        int memberCount;

        MemberList(DetachedSendCarrierEvent carrierEvent) {
            this.carrierEvent = carrierEvent;
        }

        final void reset() {
            this.memberCount = 0;
        }
    }

    static enum State {
        Init,
        Open,
        Closed;

    }

    private final class DetachedDispatchCarrierEventProcessor
    implements EventHandler<DetachedDispatchCarrierEvent> {
        private DetachedDispatchCarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void onEvent(DetachedDispatchCarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (event.publishTs > 0L) {
                    ((StoreReplicatorEventMultiplexer)StoreReplicatorEventMultiplexer.this).stats.ddo2p.add((double)(UtlTime.now() - event.publishTs));
                }
                switch (event.type) {
                    case EntityUp: {
                        StoreReplicatorEventMultiplexer.this.dispatchHandleEntityUp((IDiscoveryEntity)event.data);
                        return;
                    }
                    case MemberTableOpenWaitCompletion: {
                        StoreReplicatorEventMultiplexer.this.dispatchHandleMemberTableOpenWaitCompletion();
                        return;
                    }
                    case MemberHandshakeStartReady: {
                        StoreReplicatorEventMultiplexer.this.dispatchHandleMemberHandshakeStartReady((IStoreMember)event.data);
                        return;
                    }
                    case MemberInitReady: {
                        StoreReplicatorEventMultiplexer.this.dispatchHandleMemberInitReady((IStoreMember)event.data);
                        return;
                    }
                    case MemberPacket: {
                        StoreReplicatorEventMultiplexer.this.dispatchHandleMemberPacket(event.packetMember, (PktPacket)event.data);
                        return;
                    }
                    case MemberFail: {
                        StoreReplicatorEventMultiplexer.this.dispatchHandleMemberFail((StoreReplicatorMember)event.data);
                        return;
                    }
                    case EntityDown: {
                        StoreReplicatorEventMultiplexer.this.dispatchHandleEntityDown((IDiscoveryEntity)event.data);
                        return;
                    }
                    case Fail: {
                        StoreReplicatorEventMultiplexer.this.dispatchHandleFail((Exception)event.data);
                        return;
                    }
                    default: {
                        throw new InternalError("unknown detached dispatch event type '" + (Object)((Object)event.type) + "'");
                    }
                }
            }
            catch (Throwable e) {
                StoreReplicatorEventMultiplexer.this.onFatalError(e);
                return;
            }
            finally {
                event.reset();
            }
        }
    }

    private final class DetachedDispatchCarrierEvent {
        private DetachedDispatchCarrierEventType type;
        private Object data;
        private StoreReplicatorMember packetMember;
        private long publishTs;

        private DetachedDispatchCarrierEvent() {
        }

        final void reset() {
            this.publishTs = 0L;
            this.data = null;
        }
    }

    private static enum DetachedDispatchCarrierEventType {
        EntityUp,
        MemberTableOpenWaitCompletion,
        MemberHandshakeStartReady,
        MemberInitReady,
        MemberPacket,
        MemberFail,
        EntityDown,
        Fail;

    }

    private final class DetachedSendCarrierEventProcessor
    implements EventHandler<DetachedSendCarrierEvent> {
        private DetachedSendCarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onEvent(DetachedSendCarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (event.publishTs > 0L) {
                    ((StoreReplicatorEventMultiplexer)StoreReplicatorEventMultiplexer.this).stats.dso2p.add((double)(UtlTime.now() - event.publishTs));
                }
                StoreReplicatorEventMultiplexer.this.flushMemberList(event.memberList);
            }
            catch (Throwable e) {
                StoreReplicatorEventMultiplexer.this.onFatalError(e);
            }
            finally {
                event.reset();
            }
        }
    }

    private final class DetachedSendCarrierEvent {
        private final MemberList memberList;
        private long sequence;
        private long publishTs;

        private DetachedSendCarrierEvent() {
            this.memberList = new MemberList(this);
        }

        final void reset() {
            this.publishTs = 0L;
            this.memberList.reset();
        }
    }

    private final class CloseAction
    implements IEmxAction<Object, Object> {
        private CloseAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            try {
                StoreReplicatorEventMultiplexer.this.replicator.handleClose((Boolean)object);
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder();
                sb.append(StoreReplicatorEventMultiplexer.this.replicator.getTracePrefix() + "store replicator close handler faulter with error ' [" + t.toString() + "]").append("\n");
                sb.append("Stack Trace:").append("\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)t));
                sb.append("Ignoring...").append("\n");
                StoreReplicatorEventMultiplexer.this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
            try {
                if (((StoreReplicatorEventMultiplexer)StoreReplicatorEventMultiplexer.this).tracer.debug) {
                    StoreReplicatorEventMultiplexer.this.tracer.log(StoreReplicatorEventMultiplexer.this.replicator.getTracePrefix() + "shutting down the link container reader thread...", Tracer.Level.DEBUG);
                }
                ((LinkReader)StoreReplicatorEventMultiplexer.this.getReader().getOwner()).shutdown();
            }
            finally {
                StoreReplicatorEventMultiplexer.this.state = State.Closed;
            }
            return null;
        }
    }

    private final class FailAction
    implements IEmxAction<Object, Object> {
        private FailAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventMultiplexer.this.detachedDispatcher != null) {
                StoreReplicatorEventMultiplexer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.Fail, object, null);
            } else {
                StoreReplicatorEventMultiplexer.this.dispatchHandleFail((Exception)object);
            }
            return null;
        }
    }

    private final class MemberFailAction
    implements IEmxAction<Object, Object> {
        private MemberFailAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventMultiplexer.this.detachedDispatcher != null) {
                StoreReplicatorEventMultiplexer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberFail, object, null);
            } else {
                StoreReplicatorEventMultiplexer.this.dispatchHandleMemberFail((StoreReplicatorMember)object);
            }
            return null;
        }
    }

    private final class EntityDownAction
    implements IEmxAction<Object, Object> {
        private EntityDownAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventMultiplexer.this.detachedDispatcher != null) {
                StoreReplicatorEventMultiplexer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.EntityDown, object, null);
            } else {
                StoreReplicatorEventMultiplexer.this.dispatchHandleEntityDown((IDiscoveryEntity)object);
            }
            return null;
        }
    }

    private final class MemberInitReadyAction
    implements IEmxAction<Object, Object> {
        private MemberInitReadyAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventMultiplexer.this.detachedDispatcher != null) {
                StoreReplicatorEventMultiplexer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberInitReady, object, null);
            } else {
                StoreReplicatorEventMultiplexer.this.dispatchHandleMemberInitReady((IStoreMember)object);
            }
            return null;
        }
    }

    private final class MemberHandshakeStartReadyAction
    implements IEmxAction<Object, Object> {
        private MemberHandshakeStartReadyAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventMultiplexer.this.detachedDispatcher != null) {
                StoreReplicatorEventMultiplexer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberHandshakeStartReady, object, null);
            } else {
                StoreReplicatorEventMultiplexer.this.dispatchHandleMemberHandshakeStartReady((IStoreMember)object);
            }
            return null;
        }
    }

    private final class UnscheduleMemberTableOpenWaitCompletionAlarmAction
    implements IEmxAction<Object, Object> {
        private UnscheduleMemberTableOpenWaitCompletionAlarmAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEvent != null) {
                dispatcher.unschedAlarmEv(StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEvent);
                StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEvent = null;
            }
            return null;
        }
    }

    private final class MemberTableOpenWaitCompletionAlarmEventHandler
    implements IEmxEventHandler {
        private MemberTableOpenWaitCompletionAlarmEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEvent = null;
            if (StoreReplicatorEventMultiplexer.this.detachedDispatcher != null) {
                StoreReplicatorEventMultiplexer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberTableOpenWaitCompletion, null, null);
            } else {
                StoreReplicatorEventMultiplexer.this.dispatchHandleMemberTableOpenWaitCompletion();
            }
            return false;
        }
    }

    private final class ScheduleMemberTableOpenWaitCompletionAlarmAction
    implements IEmxAction<Object, Object> {
        private ScheduleMemberTableOpenWaitCompletionAlarmAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEvent == null) {
                dispatcher.schedAlarmEv(StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEvent = EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEventHandler, ((Integer)object).intValue()));
            }
            return null;
        }
    }

    private final class EntityUpAction
    implements IEmxAction<Object, Object> {
        private EntityUpAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventMultiplexer.this.detachedDispatcher != null) {
                StoreReplicatorEventMultiplexer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.EntityUp, object, null);
            } else {
                StoreReplicatorEventMultiplexer.this.dispatchHandleEntityUp((IDiscoveryEntity)object);
            }
            return null;
        }
    }

    private final class LinkAddAction
    implements IEmxAction<Object, Object> {
        private LinkAddAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            StoreReplicator.State replicatorState = StoreReplicatorEventMultiplexer.this.replicator.getState();
            if (replicatorState == StoreReplicator.State.INIT || replicatorState == StoreReplicator.State.NORMAL) {
                ILnkPeerEndpoint pep = (ILnkPeerEndpoint)object;
                StoreReplicatorMember member = (StoreReplicatorMember)pep.getAttachment();
                pep.join((short)-1, (ILnkEventHandler)StoreReplicatorEventMultiplexer.this);
                if (member != null) {
                    member.open(true);
                }
                StoreReplicatorEventMultiplexer.this.startRead(pep);
                return null;
            }
            switch (replicatorState) {
                case FAILED: {
                    throw new IllegalStateException("store replicator has failed");
                }
            }
            throw new Exception("store replicator state=" + (Object)((Object)StoreReplicatorEventMultiplexer.this.state));
        }
    }

    private final class LinkReader
    extends Thread
    implements ILnkContainerRunCompletionChecker {
        final StartCoordinator startCoordinator = new StartCoordinator();
        private boolean stopped;

        LinkReader() {
            this.setName(StoreReplicatorEventMultiplexer.this.getReader().getName());
            this.setDaemon(true);
        }

        final void shutdown() {
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                UtlThread.setCPUAffinityMask((long)StoreReplicatorEventMultiplexer.this.linkReaderAffinityMask);
                StoreReplicatorEventMultiplexer.this.getReader().setOwner(1);
                StartCoordinator startCoordinator = this.startCoordinator;
                synchronized (startCoordinator) {
                    this.startCoordinator.isStarted = true;
                    this.startCoordinator.notify();
                }
                while (true) {
                    try {
                        StoreReplicatorEventMultiplexer.this.run(-1, this);
                    }
                    catch (Throwable e) {
                        StoreReplicatorEventMultiplexer.this.onFatalError(e);
                        continue;
                    }
                    break;
                }
                if (((StoreReplicatorEventMultiplexer)StoreReplicatorEventMultiplexer.this).tracer.debug) {
                    StoreReplicatorEventMultiplexer.this.tracer.log(StoreReplicatorEventMultiplexer.this.replicator.getTracePrefix() + "link container reader thread done.", Tracer.Level.DEBUG);
                }
                if (StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEvent != null) {
                    StoreReplicatorEventMultiplexer.this.getReader().unschedAlarmEv(StoreReplicatorEventMultiplexer.this.memberTableOpenWaitCompletionAlarmEvent);
                }
                if (((StoreReplicatorEventMultiplexer)StoreReplicatorEventMultiplexer.this).tracer.debug) {
                    StoreReplicatorEventMultiplexer.this.tracer.log(StoreReplicatorEventMultiplexer.this.replicator.getTracePrefix() + "closing link container reader dispatcher...", Tracer.Level.DEBUG);
                }
                try {
                    StoreReplicatorEventMultiplexer.this.getReader().close(true);
                }
                catch (Exception e) {
                    StoreReplicatorEventMultiplexer.this.tracer.log(StoreReplicatorEventMultiplexer.this.replicator.getTracePrefix() + "failed to close link container reader dispatcher [" + e.toString() + "].", Tracer.Level.WARNING);
                }
            }
            finally {
                LnkRegistry.getInstance().removeContainer(this.getName());
            }
        }

        public final boolean isDone() {
            return this.stopped;
        }

        public final Object getCompletion() throws Exception {
            return null;
        }

        private final class StartCoordinator {
            boolean isStarted = false;

            private StartCoordinator() {
            }
        }
    }
}

