/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.util.UtlAddressDescriptor;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class StoreInterClusterReplicatorDescriptor
extends OdsObject {
    private final String name;
    private final Properties props;
    private IStoreBinding.InterClusterReplicationRole role;
    private String url;

    private StoreInterClusterReplicatorDescriptor(String name, IStoreBinding.InterClusterReplicationRole role, String url) {
        super(null);
        this.name = name;
        this.props = new Properties();
        this.role = role;
        this.url = url;
    }

    public final String getName() {
        return this.name;
    }

    public final IStoreBinding.InterClusterReplicationRole getRole() {
        return this.role;
    }

    public final String getUrl() {
        return this.url;
    }

    public final StoreInterClusterReplicatorDescriptor setProperty(String name, String val) {
        if (val != null) {
            this.props.setProperty(name, val);
        } else {
            this.props.remove(name);
        }
        return this;
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final StoreInterClusterReplicatorDescriptor setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
        return this;
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final Properties save(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        return props;
    }

    public final void save(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            String icrContainerAddr = "/ods/icrs";
            IConfigSimpleEntityContainer icrContainer = repo.getSimpleEntityContainer("/ods/icrs");
            if (icrContainer == null) {
                icrContainer = repo.createSimpleEntityContainer("/ods/icrs");
            }
            if ((entity = (IConfigSimpleEntity)icrContainer.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)icrContainer.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperties(this.props);
            entity.setProperty("Role", this.role.toString());
            entity.setProperty("Url", this.url);
        }
        catch (EConfigException e) {
            throw new OdsException(e);
        }
    }

    public final void save() throws OdsException {
        this.save(ConfigRepositoryFactory.getInstance().getDefaultRepository());
    }

    public final void delete(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer icrContainer = repo.getSimpleEntityContainer("/ods/icrs");
        if (icrContainer != null) {
            icrContainer.removeEntity(this.name);
        }
    }

    public final void delete() throws OdsException {
        this.delete(ConfigRepositoryFactory.getInstance().getDefaultRepository());
    }

    public static StoreInterClusterReplicatorDescriptor create(String name, IStoreBinding.InterClusterReplicationRole role, String url) {
        if (name == null) {
            throw new IllegalArgumentException("ICR name cannot be null");
        }
        if (role == null) {
            throw new IllegalArgumentException("ICR role cannot be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("ICR url cannot be null");
        }
        return new StoreInterClusterReplicatorDescriptor(name, role, url);
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("ICR name cannot be null");
        }
        return repo.getSimpleEntity("/ods/icrs/" + name) != null;
    }

    public static boolean exists(String name) {
        return StoreInterClusterReplicatorDescriptor.exists(ConfigRepositoryFactory.getInstance().getDefaultRepository(), name);
    }

    public static StoreInterClusterReplicatorDescriptor load(IConfigRepository repo, String name) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/ods/icrs/" + name);
        if (entity != null) {
            StoreInterClusterReplicatorDescriptor icrDescriptor = StoreInterClusterReplicatorDescriptor.create(name, IStoreBinding.InterClusterReplicationRole.valueOf(entity.getProperty("Role", null)), entity.getProperty("Url", null));
            icrDescriptor.setProperties(entity.getProperties());
            icrDescriptor.getProperties().remove("Role");
            icrDescriptor.getProperties().remove("Url");
            return icrDescriptor;
        }
        throw new OdsException("Store ICR '" + name + "' not found in repository");
    }

    public static StoreInterClusterReplicatorDescriptor load(String name) throws OdsException {
        return StoreInterClusterReplicatorDescriptor.load(ConfigRepositoryFactory.getInstance().getDefaultRepository(), name);
    }

    public static Set<StoreInterClusterReplicatorDescriptor> loadAll(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<StoreInterClusterReplicatorDescriptor> icrs = new LinkedHashSet<StoreInterClusterReplicatorDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/ods/icrs");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    icrs.add(StoreInterClusterReplicatorDescriptor.load(repo, entity.getName()));
                }
                catch (OdsException e) {
                    throw new OdsException("Failure in loading descriptor for ICR '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return icrs;
    }

    public static Set<StoreInterClusterReplicatorDescriptor> loadAll() throws OdsException {
        return StoreInterClusterReplicatorDescriptor.loadAll(ConfigRepositoryFactory.getInstance().getDefaultRepository());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nStore ICR '" + this.getName() + "' Configuration {").append("\n");
        sb.append("...role='" + (Object)((Object)this.getRole())).append("'\n");
        sb.append("...url='" + UtlAddressDescriptor.parse((String)this.getUrl(), null).toPasswordSanitizedFullString()).append("'\n");
        sb.append("...properties {").append("\n");
        Properties properties = this.getProperties();
        if (properties != null) {
            for (String name : properties.stringPropertyNames()) {
                sb.append("......").append(name).append("=").append(properties.getProperty(name)).append("\n");
            }
        }
        sb.append("...}").append("\n");
        return sb.toString();
    }
}

