/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.adm.test.unit.xbuf.Child2;
import com.neeve.adm.test.unit.xbuf.Child3;
import com.neeve.adm.test.unit.xbuf.Message;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.stats.IStats;
import com.neeve.stats.StatsFactory;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlPool;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class XbufPoolingTest
extends UnitTest {
    @Test
    public void testXbufEmbeddedEntityPooling() throws Exception {
        IOBuffer iobuf = IOBuffer.create((int)32, (boolean)true);
        UtlPool ioBufferPool = iobuf.getPool();
        System.out.println(iobuf.getPool().stats());
        iobuf.dispose();
        Message message = Message.create();
        int numChild2PerMessage = 10;
        int numChild3PerChild2 = 10;
        UtlPool messagePool = message.getPacket().getPool();
        UtlPool<Child2> child2Pool = null;
        UtlPool<Child3> child3Pool = null;
        for (int i = 0; i < numChild2PerMessage; ++i) {
            Child2 c2 = Child2.create();
            child2Pool = c2.getPool();
            for (int j = 0; j < numChild3PerChild2; ++j) {
                Child3 c3 = Child3.create();
                child3Pool = c3.getPool();
                c2.addChildArrayField(c3);
            }
            message.addChildArrayField(c2);
        }
        XbufPoolingTest.assertPoolParamsEqual("Message Packet Pool", UtlPool.Params.create().setMaxCapacity(2048).setInitialCapacity(1024).setThreaded(true).setDetachedWash(true), messagePool.params());
        XbufPoolingTest.assertPoolParamsEqual("Child2 Pool", UtlPool.Params.create().setMaxCapacity(0).setInitialCapacity(0).setThreaded(true), child2Pool.params());
        XbufPoolingTest.assertPoolParamsEqual("Child3 Pool", UtlPool.Params.create().setMaxCapacity(0).setInitialCapacity(0).setThreaded(true), child3Pool.params());
        System.out.println("Stats after create:");
        System.out.println(ioBufferPool.stats());
        System.out.println(messagePool.stats());
        System.out.println(child2Pool.stats());
        System.out.println(child3Pool.stats());
        int expectedChild2Creates = numChild2PerMessage;
        int expectedChild2Evicts = 0;
        Assert.assertEquals((String)("Wrong number of misses after taking " + expectedChild2Creates + " Child2 without preallocation"), (long)expectedChild2Creates, (long)child2Pool.stats().misses());
        Assert.assertEquals((String)("Wrong number of hits after taking " + expectedChild2Creates + " Child2 without preallocation"), (long)0L, (long)child2Pool.stats().hits());
        Assert.assertEquals((String)("Wrong number of puts after taking " + expectedChild2Creates + " Child2 without preallocation"), (long)0L, (long)child2Pool.stats().puts());
        Assert.assertEquals((String)("Wrong number of gets after taking " + expectedChild2Creates + " Child2 without preallocation"), (long)expectedChild2Creates, (long)child2Pool.stats().gets());
        Assert.assertEquals((String)("Wrong number of evicts after taking " + expectedChild2Creates + " Child2 without preallocation"), (long)expectedChild2Evicts, (long)child2Pool.stats().evicts());
        Assert.assertEquals((String)("Wrong size after taking " + expectedChild2Creates + " Child2 without preallocation"), (long)0L, (long)child2Pool.size());
        Assert.assertEquals((String)("Wrong capacity after taking " + expectedChild2Creates + " Child2 without preallocation"), (long)child2Pool.params().getInitialCapacity(), (long)child2Pool.capacity());
        int expectedChild3Creates = numChild2PerMessage * numChild3PerChild2;
        int expectedChild3Evicts = 0;
        Assert.assertEquals((String)("Wrong number of misses after taking " + expectedChild3Creates + " Child3 without preallocation"), (long)expectedChild3Creates, (long)child3Pool.stats().misses());
        Assert.assertEquals((String)("Wrong number of hits after taking " + expectedChild3Creates + " Child3 without preallocation"), (long)0L, (long)child3Pool.stats().hits());
        Assert.assertEquals((String)("Wrong number of puts after taking " + expectedChild3Creates + " Child3 without preallocation"), (long)0L, (long)child3Pool.stats().puts());
        Assert.assertEquals((String)("Wrong number of gets after taking " + expectedChild3Creates + " Child3 without preallocation"), (long)expectedChild3Creates, (long)child3Pool.stats().gets());
        Assert.assertEquals((String)("Wrong number of evicts after taking " + expectedChild3Creates + " Child3 without preallocation"), (long)expectedChild3Evicts, (long)child3Pool.stats().evicts());
        Assert.assertEquals((String)("Wrong size after taking " + expectedChild3Creates + " Child3 without preallocation"), (long)0L, (long)child3Pool.size());
        Assert.assertEquals((String)("Wrong capacity after taking " + expectedChild3Creates + " Child3 without preallocation"), (long)child3Pool.params().getInitialCapacity(), (long)child3Pool.capacity());
        message.sync();
        PktPacket packet = message.serialize();
        ByteBuffer buf1 = ByteBuffer.allocate(packet.getSerializedLength());
        packet.serialize(buf1);
        packet.acquire();
        message.dispose();
        System.out.println("Stats after message dispose:");
        System.out.println(ioBufferPool.stats());
        System.out.println(messagePool.stats());
        System.out.println(child2Pool.stats());
        System.out.println(child3Pool.stats());
        ByteBuffer buf2 = ByteBuffer.allocate(packet.getSerializedLength());
        packet.serialize(buf2);
        packet.dispose();
        System.out.println("Stats after packet dispose:");
        System.out.println(ioBufferPool.stats());
        System.out.println(messagePool.stats());
        System.out.println(child2Pool.stats());
        System.out.println(child3Pool.stats());
        Message deserialized1 = Message.createFromSerializedXbufContainerPacket(buf1);
        Message deserialized2 = Message.createFromSerializedXbufContainerPacket(buf2);
        StringBuffer comp = new StringBuffer();
        if (!RogLogUtil.compareRogNodes(deserialized1, deserialized2, null, comp)) {
            System.out.println("Serialized and deserialized differ: " + comp);
        }
        deserialized1.dispose();
        deserialized2.dispose();
    }

    @Test
    @Ignore
    public void testEntityArrayDisposePerf() throws Exception {
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.Message.pool.threaded", "true");
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.Child2.pool.threaded", "true");
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.Child3.pool.threaded", "true");
        int numChild2PerMessage = 1000;
        int cycles = 40;
        int numPerCycle = 10240;
        IStats.Latencies disposeLatencies = StatsFactory.createLatencyStat((String)"Dispose Latencies", (int)numPerCycle);
        for (int c = 1; c <= cycles; ++c) {
            for (int m = 0; m < numPerCycle; ++m) {
                Message message = Message.create();
                for (int i = 0; i < numChild2PerMessage; ++i) {
                    Child2 c2 = Child2.create();
                    message.addChildArrayField(c2);
                }
                long start = System.nanoTime();
                message.dispose();
                long dur = System.nanoTime() - start;
                disposeLatencies.add((double)dur);
            }
            StringBuilder sb = new StringBuilder();
            disposeLatencies.compute();
            disposeLatencies.get(sb, NumberFormat.getIntegerInstance());
            System.out.println("Cycle:" + c + " " + sb);
            disposeLatencies.reset();
        }
    }

    private static void assertPoolParamsEqual(String actualParamsDescription, UtlPool.Params expectedParams, UtlPool.Params actualParams) {
        Assert.assertEquals((String)(actualParamsDescription + " initialCapacity is incorrect"), (long)expectedParams.getInitialCapacity(), (long)actualParams.getInitialCapacity());
        Assert.assertEquals((String)(actualParamsDescription + " maxCapacity is incorrect"), (long)expectedParams.getMaxCapacity(), (long)actualParams.getMaxCapacity());
        Assert.assertEquals((String)(actualParamsDescription + " detachedWash is incorrect"), (Object)expectedParams.isDetachedWash(), (Object)actualParams.isDetachedWash());
        Assert.assertEquals((String)(actualParamsDescription + " preallocate is incorrect"), (Object)expectedParams.isPreallocate(), (Object)actualParams.isPreallocate());
        Assert.assertEquals((String)(actualParamsDescription + " threaded is incorrect"), (Object)expectedParams.isThreaded(), (Object)actualParams.isThreaded());
    }

    static {
        XRuntime.getProps().setProperty("nv.pkt.shouldpool", "true");
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.Message.desyncpolicy", "FrameFields");
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.Message.pool.shouldpool", "true");
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.Message.pool.maxCapacity", "2048");
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.Child2.pool.maxCapacity", "0");
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.Child3.pool.maxCapacity", "0");
    }
}

