/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.adm.test.unit.AdmGeneratedCodeTest;
import com.neeve.adm.test.unit.proto.CharEnumeration;
import com.neeve.adm.test.unit.proto.Child1;
import com.neeve.adm.test.unit.proto.Child2;
import com.neeve.adm.test.unit.proto.Child3;
import com.neeve.adm.test.unit.proto.ChildLongMap;
import com.neeve.adm.test.unit.proto.ChildQueue;
import com.neeve.adm.test.unit.proto.ChildStringMap;
import com.neeve.adm.test.unit.proto.Enumeration;
import com.neeve.adm.test.unit.proto.Factory;
import com.neeve.adm.test.unit.proto.IntEnumeration;
import com.neeve.adm.test.unit.proto.Parent;
import com.neeve.adm.test.unit.proto.StringEnumeration;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XIterator;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreMemberInitCompleteEvent;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.rog.IRogGraphCollection;
import com.neeve.rog.IRogRootNode;
import com.neeve.rog.impl.RogGraphCollection;
import com.neeve.sto.test.unit.StoBooleanArrayFieldTest;
import com.neeve.sto.test.unit.StoByteArrayFieldTest;
import com.neeve.sto.test.unit.StoDoubleArrayFieldTest;
import com.neeve.sto.test.unit.StoFloatArrayFieldTest;
import com.neeve.sto.test.unit.StoIntArrayFieldTest;
import com.neeve.sto.test.unit.StoLongArrayFieldTest;
import com.neeve.sto.test.unit.StoShortArrayFieldTest;
import com.neeve.sto.test.unit.StoStringArrayFieldTest;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlObjectGraph;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AdmReplicationTest
extends UnitTest {
    private static final Random random;

    private final Child3 populateChild3(Child3 child, ChildValidator validator) {
        Assert.assertNotNull((Object)child);
        Assert.assertNotNull((Object)validator);
        child.setBooleanField(validator.getBooleanField());
        child.setFloatField(validator.getFloatField());
        child.setDoubleField(validator.getDoubleField());
        child.setIntField(validator.getIntField());
        child.setShortField(validator.getShortField());
        child.setLongField(validator.getLongField());
        child.setByteField(validator.getByteField());
        child.setCharField(validator.getCharField());
        child.setEnumField(Enumeration.fromValue(validator.getEnumField()));
        child.setStringField(validator.getStringField());
        child.setDateField(validator.getDateField());
        child.setCurrencyField(validator.getCurrencyField());
        child.setEnumArrayField(this.byteToEnumArray(validator.getEnumArrayField()));
        child.setBooleanArrayField(validator.getBooleanArrayField());
        child.setByteArrayField(validator.getByteArrayField());
        child.setCharArrayField(validator.getCharArrayField());
        child.setShortArrayField(validator.getShortArrayField());
        child.setIntArrayField(validator.getIntArrayField());
        child.setLongArrayField(validator.getLongArrayField());
        child.setFloatArrayField(validator.getFloatArrayField());
        child.setDoubleArrayField(validator.getDoubleArrayField());
        child.setStringArrayField(validator.getStringArrayField());
        child.setDateArrayField(validator.getDateArrayField());
        child.setCurrencyArrayField(validator.getCurrencyArrayField());
        return child;
    }

    private final Child2 populateChild2(Child2 child, ChildValidator validator) {
        Assert.assertNotNull((Object)child);
        Assert.assertNotNull((Object)validator);
        child.setBooleanField(validator.getBooleanField());
        child.setFloatField(validator.getFloatField());
        child.setDoubleField(validator.getDoubleField());
        child.setIntField(validator.getIntField());
        child.setShortField(validator.getShortField());
        child.setLongField(validator.getLongField());
        child.setByteField(validator.getByteField());
        child.setCharField(validator.getCharField());
        child.setEnumField(Enumeration.fromValue(validator.getEnumField()));
        child.setStringField(validator.getStringField());
        child.setDateField(validator.getDateField());
        child.setCurrencyField(validator.getCurrencyField());
        child.setEnumArrayField(this.byteToEnumArray(validator.getEnumArrayField()));
        child.setBooleanArrayField(validator.getBooleanArrayField());
        child.setByteArrayField(validator.getByteArrayField());
        child.setCharArrayField(validator.getCharArrayField());
        child.setShortArrayField(validator.getShortArrayField());
        child.setIntArrayField(validator.getIntArrayField());
        child.setLongArrayField(validator.getLongArrayField());
        child.setFloatArrayField(validator.getFloatArrayField());
        child.setDoubleArrayField(validator.getDoubleArrayField());
        child.setStringArrayField(validator.getStringArrayField());
        child.setDateArrayField(validator.getDateArrayField());
        child.setCurrencyArrayField(validator.getCurrencyArrayField());
        if (child.getChildField() == null) {
            Child3 child3 = Child3.create();
            child.setChildField(this.populateChild3(child3, validator.getChildValidator()));
        } else {
            this.populateChild3(child.getChildField(), validator.getChildValidator());
        }
        if (child.getChildArrayField() == null || child.getChildArrayField().length == 0) {
            Child3[] child3Array = new Child3[validator.getChildValidatorArray().length];
            for (int i = 0; i < child3Array.length; ++i) {
                child3Array[i] = Child3.create();
                this.populateChild3(child3Array[i], validator.getChildValidatorArray()[i]);
            }
            child.setChildArrayField(child3Array);
        }
        return child;
    }

    private static final Validators createValidators() {
        Validators validators = new Validators();
        validators.parentValidator = AdmReplicationTest.createParentValidator();
        validators.parentsChildEntityValidator = AdmReplicationTest.createChildValidator(WhichChild.Child1);
        validators.parentsChildQueueValidator = new ChildValidator[2];
        for (int i = 0; i < validators.parentsChildQueueValidator.length; ++i) {
            validators.parentsChildQueueValidator[i] = AdmReplicationTest.createChildValidator(WhichChild.Child1);
        }
        validators.parentsChildLongMapValidator = new HashMap<Long, ChildValidator>();
        validators.parentsChildLongMapValidator.put(random.nextLong(), AdmReplicationTest.createChildValidator(WhichChild.Child1));
        validators.parentsChildLongMapValidator.put(random.nextLong(), AdmReplicationTest.createChildValidator(WhichChild.Child1));
        validators.parentsChildStringMapValidator = new HashMap<String, ChildValidator>();
        validators.parentsChildStringMapValidator.put(AdmReplicationTest.randomString(random.nextInt(100)), AdmReplicationTest.createChildValidator(WhichChild.Child1));
        validators.parentsChildStringMapValidator.put(AdmReplicationTest.randomString(random.nextInt(100)), AdmReplicationTest.createChildValidator(WhichChild.Child1));
        return validators;
    }

    private static final Validators updateValidators(Validators validators) {
        AdmReplicationTest.updateParentValidator(validators.parentValidator);
        AdmReplicationTest.updateChildValidator(validators.parentsChildEntityValidator);
        return validators;
    }

    private static final String randomString(int len) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < len; ++i) {
            sb.append(random.nextInt(10));
        }
        return sb.toString();
    }

    final Enumeration[] byteToEnumArray(byte[] byteArray) {
        Enumeration[] enumArray;
        Enumeration[] enumerationArray = enumArray = byteArray == null ? null : new Enumeration[byteArray.length];
        if (enumArray != null) {
            for (int i = 0; i < enumArray.length; ++i) {
                enumArray[i] = Enumeration.fromValue(byteArray[i]);
            }
        }
        return enumArray;
    }

    final byte[] enumToByteArray(Enumeration[] enumArray) {
        byte[] byteArray;
        byte[] byArray = byteArray = enumArray == null ? null : new byte[enumArray.length];
        if (byteArray != null) {
            for (int i = 0; i < byteArray.length; ++i) {
                byteArray[i] = (byte)enumArray[i].val;
            }
        }
        return byteArray;
    }

    private static final ChildValidator[] createChildValidatorArray(WhichChild whichChild) {
        ChildValidator[] validatorArray = new ChildValidator[random.nextInt(10)];
        for (int i = 0; i < validatorArray.length; ++i) {
            validatorArray[i] = AdmReplicationTest.createChildValidator(whichChild);
        }
        return validatorArray;
    }

    private static final byte[] createRandomEnumerationArray(int len) {
        byte[] val = new byte[len];
        for (int i = 0; i < val.length; ++i) {
            val[i] = (byte)(AdmReplicationTest.random.nextInt((int)1) == 0 ? Enumeration.Value1 : Enumeration.Value2).val;
        }
        return val;
    }

    private static final ChildValidator createChildValidator(WhichChild whichChild) {
        return new ChildValidator(AdmReplicationTest.randomString(5), random.nextBoolean(), random.nextFloat(), random.nextDouble(), random.nextInt(), (short)random.nextInt(Short.MAX_VALUE), random.nextLong(), (byte)random.nextInt(127), (char)random.nextInt(127), ((byte)AdmReplicationTest.random.nextInt((int)1) == 0 ? Enumeration.Value1 : Enumeration.Value2).val, ((byte)AdmReplicationTest.random.nextInt((int)1) == 0 ? IntEnumeration.Value1 : IntEnumeration.Value2).val, ((byte)random.nextInt(1) == 0 ? CharEnumeration.Value1 : CharEnumeration.Value2).getCodeString().charAt(0), ((byte)random.nextInt(1) == 0 ? StringEnumeration.Value1 : StringEnumeration.Value2).getCodeString(), AdmReplicationTest.randomString(random.nextInt(100)), new Date(), (Currency)UtlObjectGraph.BuiltInHandler.getRandomValue(Currency.class, (Random)random), AdmReplicationTest.createRandomEnumerationArray(random.nextInt(10)), StoBooleanArrayFieldTest.createArray((int)random.nextInt(10)), StoByteArrayFieldTest.createArray((int)random.nextInt(10)), (char[])UtlObjectGraph.BuiltInHandler.getRandomValue(char[].class, (Random)random), StoShortArrayFieldTest.createArray((int)random.nextInt(10)), StoIntArrayFieldTest.createArray((int)random.nextInt(10)), StoLongArrayFieldTest.createArray((int)random.nextInt(10)), StoFloatArrayFieldTest.createArray((int)random.nextInt(10)), StoDoubleArrayFieldTest.createArray((int)random.nextInt(10)), StoStringArrayFieldTest.createArray((int)random.nextInt(10)), (Date[])UtlObjectGraph.BuiltInHandler.getRandomValue(Date[].class, (Random)random), (Currency[])UtlObjectGraph.BuiltInHandler.getRandomValue(Currency[].class, (Random)random), whichChild == WhichChild.Child1 ? AdmReplicationTest.createChildValidator(WhichChild.Child2) : (whichChild == WhichChild.Child2 ? AdmReplicationTest.createChildValidator(WhichChild.Child3) : null), (ChildValidator[])(whichChild == WhichChild.Child1 ? AdmReplicationTest.createChildValidatorArray(WhichChild.Child2) : (whichChild == WhichChild.Child2 ? AdmReplicationTest.createChildValidatorArray(WhichChild.Child3) : null)));
    }

    private static final void updateChildValidator(ChildValidator validator) {
        validator.setBooleanField(random.nextBoolean());
        validator.setFloatField(random.nextFloat());
        validator.setDoubleField(random.nextDouble());
        validator.setIntField(random.nextInt());
        validator.setShortField((short)random.nextInt(Short.MAX_VALUE));
        validator.setLongField(random.nextLong());
        validator.setByteField((byte)random.nextInt(127));
        validator.setCharField(((Character)UtlObjectGraph.BuiltInHandler.getRandomValue(Character.TYPE, (Random)random)).charValue());
        validator.setCurrencyField((Currency)UtlObjectGraph.BuiltInHandler.getRandomValue(Currency.class, (Random)random));
        validator.setEnumField(((byte)AdmReplicationTest.random.nextInt((int)1) == 0 ? Enumeration.Value1 : Enumeration.Value2).val);
        validator.setIntEnum(((byte)AdmReplicationTest.random.nextInt((int)1) == 0 ? IntEnumeration.Value1 : IntEnumeration.Value2).val);
        validator.setCharEnum(((byte)random.nextInt(1) == 0 ? CharEnumeration.Value1 : CharEnumeration.Value2).getCodeString().charAt(0));
        validator.setStringEnum(((byte)random.nextInt(1) == 0 ? StringEnumeration.Value1 : StringEnumeration.Value2).getCodeString());
        validator.setStringField(AdmReplicationTest.randomString(random.nextInt(100)));
        validator.setDateField(new Date(validator.getDateField().getTime() + 1000L));
        validator.setCurrencyField((Currency)UtlObjectGraph.BuiltInHandler.getRandomValue(Currency.class, (Random)random));
        validator.setEnumArrayField(AdmReplicationTest.createRandomEnumerationArray(random.nextInt(10)));
        validator.setBooleanArrayField(StoBooleanArrayFieldTest.createArray((int)random.nextInt(10)));
        validator.setByteArrayField(StoByteArrayFieldTest.createArray((int)random.nextInt(10)));
        validator.setCharArrayField((char[])UtlObjectGraph.BuiltInHandler.getRandomValue(char[].class, (Random)random));
        validator.setShortArrayField(StoShortArrayFieldTest.createArray((int)random.nextInt(10)));
        validator.setIntArrayField(StoIntArrayFieldTest.createArray((int)random.nextInt(10)));
        validator.setLongArrayField(StoLongArrayFieldTest.createArray((int)random.nextInt(10)));
        validator.setFloatArrayField(StoFloatArrayFieldTest.createArray((int)random.nextInt(10)));
        validator.setDoubleArrayField(StoDoubleArrayFieldTest.createArray((int)random.nextInt(10)));
        validator.setStringArrayField(StoStringArrayFieldTest.createArray((int)random.nextInt(10)));
        validator.setDateArrayField((Date[])UtlObjectGraph.BuiltInHandler.getRandomValue(Date[].class, (Random)random));
        validator.setCurrencyArrayField((Currency[])UtlObjectGraph.BuiltInHandler.getRandomValue(Currency[].class, (Random)random));
        if (validator.getChildValidator() != null) {
            AdmReplicationTest.updateChildValidator(validator.getChildValidator());
        }
    }

    private final void populateChild1(Child1 child, ChildValidator validator) {
        Assert.assertNotNull((Object)child);
        Assert.assertNotNull((Object)validator);
        child.setBooleanField(validator.getBooleanField());
        child.setFloatField(validator.getFloatField());
        child.setDoubleField(validator.getDoubleField());
        child.setIntField(validator.getIntField());
        child.setShortField(validator.getShortField());
        child.setLongField(validator.getLongField());
        child.setByteField(validator.getByteField());
        child.setCharField(validator.getCharField());
        child.setEnumField(Enumeration.fromValue(validator.getEnumField()));
        child.setIntEnumField(IntEnumeration.fromCode(validator.getIntEnum()));
        child.setCharEnumField(CharEnumeration.fromCode(Character.valueOf(validator.getCharEnum())));
        child.setStringEnumField(StringEnumeration.fromCode(validator.getStringEnum()));
        child.setStringField(validator.getStringField());
        child.setDateField(validator.getDateField());
        child.setCurrencyField(validator.getCurrencyField());
        child.setEnumArrayField(this.byteToEnumArray(validator.getEnumArrayField()));
        child.setBooleanArrayField(validator.getBooleanArrayField());
        child.setByteArrayField(validator.getByteArrayField());
        child.setCharArrayField(validator.getCharArrayField());
        child.setShortArrayField(validator.getShortArrayField());
        child.setIntArrayField(validator.getIntArrayField());
        child.setLongArrayField(validator.getLongArrayField());
        child.setFloatArrayField(validator.getFloatArrayField());
        child.setDoubleArrayField(validator.getDoubleArrayField());
        child.setStringArrayField(validator.getStringArrayField());
        child.setDateArrayField(validator.getDateArrayField());
        child.setCurrencyArrayField(validator.getCurrencyArrayField());
        if (child.getChildField() == null) {
            Child2 child2 = Child2.create();
            child.setChildField(this.populateChild2(child2, validator.getChildValidator()));
        } else {
            this.populateChild2(child.getChildField(), validator.getChildValidator());
        }
        if (child.getChildArrayField() == null || child.getChildArrayField().length == 0) {
            Child2[] child2Array = new Child2[validator.getChildValidatorArray().length];
            for (int i = 0; i < child2Array.length; ++i) {
                child2Array[i] = Child2.create();
                this.populateChild2(child2Array[i], validator.getChildValidatorArray()[i]);
            }
            child.setChildArrayField(child2Array);
        }
    }

    private final void validateParent(Parent parent, Validators validators) {
        Assert.assertEquals((long)parent.getFixlenField(), (long)validators.parentValidator.getFixlenField());
        Assert.assertEquals((Object)parent.getVarlenField(), (Object)validators.parentValidator.getVarlenField());
        this.validateChild1(parent.getEntityField(), validators.parentsChildEntityValidator);
        Assert.assertEquals((long)parent.getQueueField().size(), (long)validators.parentsChildQueueValidator.length);
        XIterator iterator0 = parent.getQueueField().iterator();
        int i = 0;
        while (iterator0.hasNext()) {
            this.validateChild1((Child1)iterator0.next(), validators.parentsChildQueueValidator[i++]);
        }
        Assert.assertEquals((long)parent.getLongMapField().size(), (long)validators.parentsChildLongMapValidator.size());
        for (Map.Entry<Long, ChildValidator> entry : validators.parentsChildLongMapValidator.entrySet()) {
            this.validateChild1((Child1)parent.getLongMapField().get(entry.getKey()), entry.getValue());
        }
        Assert.assertEquals((long)parent.getStringMapField().size(), (long)validators.parentsChildStringMapValidator.size());
        for (Map.Entry<String, ChildValidator> entry : validators.parentsChildStringMapValidator.entrySet()) {
            this.validateChild1((Child1)parent.getStringMapField().get(entry.getKey()), entry.getValue());
        }
    }

    private final void validateChild3(Child3 child, ChildValidator validator) {
        Assert.assertNotNull((Object)child);
        Assert.assertNotNull((Object)validator);
        Assert.assertEquals((Object)child.getBooleanField(), (Object)validator.getBooleanField());
        Assert.assertEquals((double)child.getFloatField(), (double)validator.getFloatField(), (double)0.0);
        Assert.assertEquals((double)child.getDoubleField(), (double)validator.getDoubleField(), (double)0.0);
        Assert.assertEquals((long)child.getIntField(), (long)validator.getIntField());
        Assert.assertEquals((long)child.getShortField(), (long)validator.getShortField());
        Assert.assertEquals((long)child.getLongField(), (long)validator.getLongField());
        Assert.assertEquals((long)child.getByteField(), (long)validator.getByteField());
        Assert.assertEquals((long)child.getCharField(), (long)validator.getCharField());
        Assert.assertEquals((long)child.getEnumField().val, (long)validator.getEnumField());
        Assert.assertEquals((Object)child.getStringField(), (Object)validator.getStringField());
        Assert.assertEquals((Object)child.getDateField(), (Object)validator.getDateField());
        Assert.assertEquals((Object)child.getCurrencyField(), (Object)validator.getCurrencyField());
        StoByteArrayFieldTest.compare((byte[])this.enumToByteArray(child.getEnumArrayFieldEmptyIfNull()), (byte[])validator.getEnumArrayField(), (boolean)false);
        StoBooleanArrayFieldTest.compare((boolean[])child.getBooleanArrayFieldEmptyIfNull(), (boolean[])validator.getBooleanArrayField(), (boolean)false);
        StoByteArrayFieldTest.compare((byte[])child.getByteArrayFieldEmptyIfNull(), (byte[])validator.getByteArrayField(), (boolean)false);
        AdmGeneratedCodeTest.compare(child.getCharArrayFieldEmptyIfNull(), validator.getCharArrayField(), false);
        StoShortArrayFieldTest.compare((short[])child.getShortArrayFieldEmptyIfNull(), (short[])validator.getShortArrayField(), (boolean)false);
        StoIntArrayFieldTest.compare((int[])child.getIntArrayFieldEmptyIfNull(), (int[])validator.getIntArrayField(), (boolean)false);
        StoLongArrayFieldTest.compare((long[])child.getLongArrayFieldEmptyIfNull(), (long[])validator.getLongArrayField(), (boolean)false);
        StoFloatArrayFieldTest.compare((float[])child.getFloatArrayFieldEmptyIfNull(), (float[])validator.getFloatArrayField(), (boolean)false);
        StoDoubleArrayFieldTest.compare((double[])child.getDoubleArrayFieldEmptyIfNull(), (double[])validator.getDoubleArrayField(), (boolean)false);
        StoStringArrayFieldTest.compare((String[])child.getStringArrayFieldEmptyIfNull(), (String[])validator.getStringArrayField(), (boolean)false);
        AdmGeneratedCodeTest.compare(child.getDateArrayFieldEmptyIfNull(), validator.getDateArrayField(), false);
        AdmGeneratedCodeTest.compare(child.getCurrencyArrayFieldEmptyIfNull(), validator.getCurrencyArrayField(), false);
    }

    private final void validateChild1(Child1 child, ChildValidator validator) {
        if (child == null || validator == null) {
            Assert.assertSame((Object)child, (Object)validator);
        } else {
            Assert.assertEquals((long)child.getType(), (long)2L);
            Assert.assertEquals((Object)child.getBooleanField(), (Object)validator.getBooleanField());
            Assert.assertEquals((double)child.getFloatField(), (double)validator.getFloatField(), (double)0.0);
            Assert.assertEquals((double)child.getDoubleField(), (double)validator.getDoubleField(), (double)0.0);
            Assert.assertEquals((long)child.getIntField(), (long)validator.getIntField());
            Assert.assertEquals((long)child.getShortField(), (long)validator.getShortField());
            Assert.assertEquals((long)child.getLongField(), (long)validator.getLongField());
            Assert.assertEquals((long)child.getByteField(), (long)validator.getByteField());
            Assert.assertEquals((long)child.getCharField(), (long)validator.getCharField());
            Assert.assertEquals((long)child.getEnumField().val, (long)validator.getEnumField());
            Assert.assertEquals((long)child.getIntEnumField().val, (long)validator.getIntEnum());
            Assert.assertEquals((long)child.getCharEnumField().getCodeString().charAt(0), (long)validator.getCharEnum());
            Assert.assertEquals((Object)child.getStringEnumField().getCodeString(), (Object)validator.getStringEnum());
            Assert.assertEquals((Object)child.getStringField(), (Object)validator.getStringField());
            Assert.assertEquals((Object)child.getDateField(), (Object)validator.getDateField());
            Assert.assertEquals((Object)child.getCurrencyField(), (Object)validator.getCurrencyField());
            StoByteArrayFieldTest.compare((byte[])this.enumToByteArray(child.getEnumArrayFieldEmptyIfNull()), (byte[])validator.getEnumArrayField(), (boolean)false);
            StoBooleanArrayFieldTest.compare((boolean[])child.getBooleanArrayFieldEmptyIfNull(), (boolean[])validator.getBooleanArrayField(), (boolean)false);
            StoByteArrayFieldTest.compare((byte[])child.getByteArrayFieldEmptyIfNull(), (byte[])validator.getByteArrayField(), (boolean)false);
            AdmGeneratedCodeTest.compare(child.getCharArrayFieldEmptyIfNull(), validator.getCharArrayField(), false);
            StoShortArrayFieldTest.compare((short[])child.getShortArrayFieldEmptyIfNull(), (short[])validator.getShortArrayField(), (boolean)false);
            StoIntArrayFieldTest.compare((int[])child.getIntArrayFieldEmptyIfNull(), (int[])validator.getIntArrayField(), (boolean)false);
            StoLongArrayFieldTest.compare((long[])child.getLongArrayFieldEmptyIfNull(), (long[])validator.getLongArrayField(), (boolean)false);
            StoFloatArrayFieldTest.compare((float[])child.getFloatArrayFieldEmptyIfNull(), (float[])validator.getFloatArrayField(), (boolean)false);
            StoDoubleArrayFieldTest.compare((double[])child.getDoubleArrayFieldEmptyIfNull(), (double[])validator.getDoubleArrayField(), (boolean)false);
            StoStringArrayFieldTest.compare((String[])child.getStringArrayFieldEmptyIfNull(), (String[])validator.getStringArrayField(), (boolean)false);
            AdmGeneratedCodeTest.compare(child.getDateArrayFieldEmptyIfNull(), validator.getDateArrayField(), false);
            AdmGeneratedCodeTest.compare(child.getCurrencyArrayFieldEmptyIfNull(), validator.getCurrencyArrayField(), false);
            this.validateChild2(child.getChildField(), validator.getChildValidator());
            Assert.assertEquals((long)child.getChildArrayFieldEmptyIfNull().length, (long)validator.getChildValidatorArray().length);
            for (int i = 0; i < child.getChildArrayFieldEmptyIfNull().length; ++i) {
                this.validateChild2(child.getChildArrayFieldEmptyIfNull()[i], validator.getChildValidatorArray()[i]);
            }
        }
    }

    private final void validateChild2(Child2 child, ChildValidator validator) {
        Assert.assertNotNull((Object)child);
        Assert.assertNotNull((Object)validator);
        Assert.assertEquals((Object)child.getBooleanField(), (Object)validator.getBooleanField());
        Assert.assertEquals((double)child.getFloatField(), (double)validator.getFloatField(), (double)0.0);
        Assert.assertEquals((double)child.getDoubleField(), (double)validator.getDoubleField(), (double)0.0);
        Assert.assertEquals((long)child.getIntField(), (long)validator.getIntField());
        Assert.assertEquals((long)child.getShortField(), (long)validator.getShortField());
        Assert.assertEquals((long)child.getLongField(), (long)validator.getLongField());
        Assert.assertEquals((long)child.getByteField(), (long)validator.getByteField());
        Assert.assertEquals((long)child.getCharField(), (long)validator.getCharField());
        Assert.assertEquals((long)child.getEnumField().val, (long)validator.getEnumField());
        Assert.assertEquals((Object)child.getStringField(), (Object)validator.getStringField());
        Assert.assertEquals((Object)child.getDateField(), (Object)validator.getDateField());
        Assert.assertEquals((Object)child.getCurrencyField(), (Object)validator.getCurrencyField());
        StoByteArrayFieldTest.compare((byte[])this.enumToByteArray(child.getEnumArrayFieldEmptyIfNull()), (byte[])validator.getEnumArrayField(), (boolean)false);
        StoBooleanArrayFieldTest.compare((boolean[])child.getBooleanArrayFieldEmptyIfNull(), (boolean[])validator.getBooleanArrayField(), (boolean)false);
        StoByteArrayFieldTest.compare((byte[])child.getByteArrayFieldEmptyIfNull(), (byte[])validator.getByteArrayField(), (boolean)false);
        AdmGeneratedCodeTest.compare(child.getCharArrayFieldEmptyIfNull(), validator.getCharArrayField(), false);
        StoShortArrayFieldTest.compare((short[])child.getShortArrayFieldEmptyIfNull(), (short[])validator.getShortArrayField(), (boolean)false);
        StoIntArrayFieldTest.compare((int[])child.getIntArrayFieldEmptyIfNull(), (int[])validator.getIntArrayField(), (boolean)false);
        StoLongArrayFieldTest.compare((long[])child.getLongArrayFieldEmptyIfNull(), (long[])validator.getLongArrayField(), (boolean)false);
        StoFloatArrayFieldTest.compare((float[])child.getFloatArrayFieldEmptyIfNull(), (float[])validator.getFloatArrayField(), (boolean)false);
        StoDoubleArrayFieldTest.compare((double[])child.getDoubleArrayFieldEmptyIfNull(), (double[])validator.getDoubleArrayField(), (boolean)false);
        StoStringArrayFieldTest.compare((String[])child.getStringArrayFieldEmptyIfNull(), (String[])validator.getStringArrayField(), (boolean)false);
        AdmGeneratedCodeTest.compare(child.getDateArrayFieldEmptyIfNull(), validator.getDateArrayField(), false);
        AdmGeneratedCodeTest.compare(child.getCurrencyArrayFieldEmptyIfNull(), validator.getCurrencyArrayField(), false);
        this.validateChild3(child.getChildField(), validator.getChildValidator());
        Assert.assertEquals((long)validator.getChildValidatorArray().length, (long)child.getChildArrayFieldEmptyIfNull().length);
        for (int i = 0; i < child.getChildArrayFieldEmptyIfNull().length; ++i) {
            this.validateChild3(child.getChildArrayFieldEmptyIfNull()[i], validator.getChildValidatorArray()[i]);
        }
    }

    private static final ParentValidator createParentValidator() {
        return new ParentValidator(random.nextInt(), AdmReplicationTest.randomString(random.nextInt(100)));
    }

    private static final void updateParentValidator(ParentValidator validator) {
        validator.setFixlenField(random.nextInt());
        validator.setVarlenField(AdmReplicationTest.randomString(random.nextInt(100)));
    }

    private final Parent populateParent(Parent parent, Validators validators) {
        parent.setFixlenField(validators.parentValidator.getFixlenField());
        parent.setVarlenField(validators.parentValidator.getVarlenField());
        Child1 child = Child1.create();
        this.populateChild1(child, validators.parentsChildEntityValidator);
        parent.setEntityField(child);
        ChildQueue childQueue = parent.getQueueField();
        for (int i = 0; i < validators.parentsChildQueueValidator.length; ++i) {
            child = Child1.create();
            this.populateChild1(child, validators.parentsChildQueueValidator[i]);
            childQueue.offer(child);
        }
        ChildLongMap childLongMap = parent.getLongMapField();
        for (Map.Entry<Long, ChildValidator> entry : validators.parentsChildLongMapValidator.entrySet()) {
            child = Child1.create();
            this.populateChild1(child, entry.getValue());
            childLongMap.put(entry.getKey(), child);
        }
        ChildStringMap childStringMap = parent.getStringMapField();
        for (Map.Entry<String, ChildValidator> entry : validators.parentsChildStringMapValidator.entrySet()) {
            child = Child1.create();
            this.populateChild1(child, entry.getValue());
            childStringMap.put(entry.getKey(), child);
        }
        return parent;
    }

    private final Parent updateParent(Parent parent, Validators validators) {
        parent.setFixlenField(validators.parentValidator.getFixlenField());
        parent.setVarlenField(validators.parentValidator.getVarlenField());
        this.populateChild1(parent.getEntityField(), validators.parentsChildEntityValidator);
        return parent;
    }

    private final void syncCommit(IStoreBinding binding) throws Exception {
        IStoreCommitCompletionEvent completionEvent = binding.createCommitCompletionEvent().setNotify(true);
        binding.commit(completionEvent);
        completionEvent.waitForCompletion();
    }

    private final void testNoStore(boolean update) throws Exception {
        Validators validators = AdmReplicationTest.createValidators();
        Parent parent = Parent.create(1);
        this.populateParent(parent, validators);
        if (update) {
            this.updateParent(parent, AdmReplicationTest.updateValidators(validators));
        }
        this.validateParent(parent, validators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testSoleMember(boolean update) throws Exception {
        String appName = "soleMemberTest" + System.currentTimeMillis();
        StoreDescriptor descriptor = StoreDescriptor.create(appName);
        StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.create(appName);
        replicatorDescriptor.setProperty("initWaitTime", "1000");
        replicatorDescriptor.save();
        descriptor.setReplicator(replicatorDescriptor.getName());
        StoreEventHandler eh1 = new StoreEventHandler();
        IRogGraphCollection collection1 = RogGraphCollection.create("m1", descriptor, eh1);
        IStoreBinding binding1 = collection1.getStore();
        binding1.open();
        try {
            Parent parent = Parent.create(1);
            collection1.add(parent);
            Validators validators = AdmReplicationTest.createValidators();
            this.populateParent(parent, validators);
            this.syncCommit(binding1);
            if (update) {
                AdmReplicationTest.updateValidators(validators);
                this.updateParent(parent, validators);
                this.syncCommit(binding1);
            }
            this.validateParent(parent, validators);
        }
        finally {
            binding1.close(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testReplication(boolean update) throws Exception {
        String appName = "replicationTest" + System.currentTimeMillis();
        StoreDescriptor descriptor = StoreDescriptor.create(appName);
        StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.create(appName + "-primary");
        replicatorDescriptor.setProperty("storeName", appName);
        replicatorDescriptor.setProperty("initWaitTime", "1000");
        replicatorDescriptor.save();
        descriptor.setReplicator(replicatorDescriptor.getName());
        StoreEventHandler eh1 = new StoreEventHandler();
        IRogGraphCollection collection1 = RogGraphCollection.create("m1", descriptor, eh1);
        IStoreBinding binding1 = collection1.getStore();
        binding1.open();
        try {
            StoreReplicatorDescriptor backupReplicatorDescriptor = StoreReplicatorDescriptor.create(appName + "-backup");
            backupReplicatorDescriptor.setProperty("storeName", appName);
            backupReplicatorDescriptor.setProperty("initWaitTime", "1000");
            backupReplicatorDescriptor.save();
            descriptor.setReplicator(backupReplicatorDescriptor.getName());
            StoreEventHandler eh2 = new StoreEventHandler();
            IRogGraphCollection collection2 = RogGraphCollection.create("m2", descriptor, eh2);
            IStoreBinding binding2 = collection2.getStore();
            binding2.open();
            try {
                Parent parent = Parent.create(1);
                collection1.add(parent);
                Validators validators = AdmReplicationTest.createValidators();
                this.populateParent(parent, validators);
                this.syncCommit(binding1);
                if (update) {
                    AdmReplicationTest.updateValidators(validators);
                    this.updateParent(parent, validators);
                    this.syncCommit(binding1);
                }
                IRogRootNode root = collection2.get(1);
                Assert.assertNotNull((Object)root);
                Assert.assertTrue((boolean)(root instanceof Parent));
                this.validateParent((Parent)root, validators);
            }
            finally {
                binding2.close(0);
            }
        }
        finally {
            binding1.close(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testMemberInitialization(boolean update) throws Exception {
        String appName = "initTest" + System.currentTimeMillis();
        StoreDescriptor descriptor = StoreDescriptor.create(appName);
        StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.create(appName + "-primary");
        replicatorDescriptor.setProperty("storeName", appName);
        replicatorDescriptor.setProperty("initWaitTime", "1000");
        replicatorDescriptor.save();
        descriptor.setReplicator(replicatorDescriptor.getName());
        StorePersisterDescriptor persisterDescriptor = StorePersisterDescriptor.create(appName + "-primary", "com.neeve.rog.log.RogLog");
        persisterDescriptor.setProperty("flushOnCommit", "true");
        persisterDescriptor.save();
        descriptor.setPersister(persisterDescriptor.getName());
        StoreEventHandler eh1 = new StoreEventHandler();
        IRogGraphCollection collection1 = RogGraphCollection.create("m1", descriptor, eh1);
        IStoreBinding binding1 = collection1.getStore();
        binding1.open();
        try {
            Parent parent = Parent.create(1);
            collection1.add(parent);
            Validators validators = AdmReplicationTest.createValidators();
            this.populateParent(parent, validators);
            this.syncCommit(binding1);
            if (update) {
                AdmReplicationTest.updateValidators(validators);
                this.updateParent(parent, validators);
                this.syncCommit(binding1);
            }
            StoreEventHandler eh2 = new StoreEventHandler();
            StoreReplicatorDescriptor backupReplicatorDescriptor = StoreReplicatorDescriptor.create(appName + "-backup");
            backupReplicatorDescriptor.setProperty("storeName", appName);
            backupReplicatorDescriptor.setProperty("initWaitTime", "1000");
            backupReplicatorDescriptor.save();
            descriptor.setReplicator(backupReplicatorDescriptor.getName());
            StorePersisterDescriptor backupPersisterDescriptor = StorePersisterDescriptor.create(appName + "-backup", "com.neeve.rog.log.RogLog");
            backupPersisterDescriptor.setProperty("flushOnCommit", "true");
            backupPersisterDescriptor.save();
            descriptor.setPersister(backupPersisterDescriptor.getName());
            IRogGraphCollection collection2 = RogGraphCollection.create("m2", descriptor, eh2);
            IStoreBinding binding2 = collection2.getStore();
            binding2.open();
            StoreEventHandler storeEventHandler = eh2;
            synchronized (storeEventHandler) {
                while (!eh2.memberInitialized) {
                    try {
                        eh2.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                IRogRootNode root = collection2.get(1);
                Assert.assertNotNull((Object)root);
                Assert.assertTrue((boolean)(root instanceof Parent));
                this.validateParent((Parent)root, validators);
            }
            finally {
                binding2.close(0);
            }
        }
        finally {
            binding1.close(0);
        }
    }

    @Test
    public void testNoStoreWithGraphCreate() throws Exception {
        this.testNoStore(false);
    }

    @Test
    public void testNoStoreWithGraphUpdate() throws Exception {
        this.testNoStore(true);
    }

    @Test
    public void testSoleMemberWithGraphCreate() throws Exception {
        this.testSoleMember(false);
    }

    @Test
    public void testSoleMemberWithGraphUpdate() throws Exception {
        this.testSoleMember(true);
    }

    @Test
    public void testReplicationWithGraphCreate() throws Exception {
        this.testReplication(false);
    }

    @Test
    public void testReplicationWithGraphUpdate() throws Exception {
        this.testReplication(true);
    }

    @Test
    public void testMemberInitializationWithGraphCreate() throws Exception {
        this.testMemberInitialization(false);
    }

    @Test
    public void testMemberInitializationWithGraphUpdate() throws Exception {
        this.testMemberInitialization(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testStressReplication() throws Exception {
        StoreDescriptor descriptor = StoreDescriptor.create("test");
        StoreEventHandler eh1 = new StoreEventHandler();
        IRogGraphCollection collection1 = RogGraphCollection.create("m1", descriptor, eh1);
        IStoreBinding binding1 = collection1.getStore();
        try {
            StoreEventHandler eh2 = new StoreEventHandler();
            IRogGraphCollection collection2 = RogGraphCollection.create("m2", descriptor, eh2);
            IStoreBinding binding2 = collection2.getStore();
            Parent parent = Parent.create(1);
            collection1.add(parent);
            Validators validators = AdmReplicationTest.createValidators();
            this.populateParent(parent, validators);
            IStoreCommitCompletionEvent completionEvent = binding1.createCommitCompletionEvent().setNotify(true);
            binding1.commit(completionEvent);
            completionEvent.waitForCompletion();
            RandomUpdater updater = new RandomUpdater(binding1, validators, parent);
            updater.start();
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(1000L);
                System.out.println("Updates=" + updater.numUpdates);
            }
            updater.shutdown();
            try {
                IRogRootNode root = collection2.get(1);
                Assert.assertNotNull((Object)root);
                Assert.assertTrue((boolean)(root instanceof Parent));
                this.validateParent((Parent)root, validators);
            }
            finally {
                binding2.close(0);
            }
        }
        finally {
            binding1.close(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testStressMemberInitialization() throws Exception {
        StoreDescriptor descriptor = StoreDescriptor.create("test");
        StoreEventHandler eh1 = new StoreEventHandler();
        IRogGraphCollection collection1 = RogGraphCollection.create("m1", descriptor, eh1);
        IStoreBinding binding1 = collection1.getStore();
        try {
            Parent parent = Parent.create(1);
            collection1.add(parent);
            Validators validators = AdmReplicationTest.createValidators();
            this.populateParent(parent, validators);
            IStoreCommitCompletionEvent completionEvent = binding1.createCommitCompletionEvent().setNotify(true);
            binding1.commit(completionEvent);
            completionEvent.waitForCompletion();
            RandomUpdater updater = new RandomUpdater(binding1, validators, parent);
            updater.start();
            StoreEventHandler eh2 = new StoreEventHandler();
            IRogGraphCollection collection2 = RogGraphCollection.create("m2", descriptor, eh2);
            IStoreBinding binding2 = collection1.getStore();
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(1000L);
                System.out.println("Updates=" + updater.numUpdates);
            }
            updater.shutdown();
            try {
                IRogRootNode root = collection2.get(1);
                Assert.assertNotNull((Object)root);
                Assert.assertTrue((boolean)(root instanceof Parent));
                this.validateParent((Parent)root, validators);
            }
            finally {
                binding2.close(0);
            }
        }
        finally {
            binding1.close(0);
        }
    }

    static {
        System.setProperty("nv.msg.latency.stats", "true");
        System.getProperties().setProperty("nv.packet.sto.defaultbuffersize", "102400");
        System.getProperties().setProperty("nv.optimizefor", "latency");
        System.getProperties().setProperty("nv.conservecpu", "true");
        AdmReplicationTest.configureForInMemoryConfigRepo(AdmReplicationTest.class);
        Factory factory = new Factory();
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(factory);
        XRuntime.updateProps((Properties)System.getProperties());
        random = new Random(System.currentTimeMillis());
    }

    static final class Validators {
        ParentValidator parentValidator;
        ChildValidator parentsChildEntityValidator;
        ChildValidator[] parentsChildQueueValidator;
        Map<Long, ChildValidator> parentsChildLongMapValidator;
        Map<String, ChildValidator> parentsChildStringMapValidator;

        Validators() {
        }
    }

    static final class ChildValidator {
        private boolean fldBoolean;
        private byte fldByte;
        private char fldChar;
        private short fldShort;
        private int fldInt;
        private long fldLong;
        private float fldFloat;
        private double fldDouble;
        private int fldEnum;
        private int intEnum;
        private char charEnum;
        private String stringEnum;
        private String fldString;
        private Date fldDate;
        private Currency fldCurrency;
        private byte[] fldEnumArray;
        private char[] charArrayField;
        private boolean[] fldBooleanArray;
        private byte[] fldByteArray;
        private short[] fldShortArray;
        private int[] fldIntArray;
        private long[] fldLongArray;
        private float[] fldFloatArray;
        private double[] fldDoubleArray;
        private String[] fldStringArray;
        private Date[] dateArrayField;
        private Currency[] currencyArrayField;
        private ChildValidator fldChildValidator;
        private ChildValidator[] fldChildValidatorArray;

        ChildValidator(String fldFixlenString, boolean fldBoolean, float fldFloat, double fldDouble, int fldInt, short fldShort, long fldLong, byte fldByte, char fldChar, int fldEnum, int intfldEnum, char charfldEnum, String StringfldEnum, String fldString, Date fldDate, Currency fldCurrency, byte[] fldEnumArray, boolean[] fldBooleanArray, byte[] fldByteArray, char[] charArrayField, short[] fldShortArray, int[] fldIntArray, long[] fldLongArray, float[] fldFloatArray, double[] fldDoubleArray, String[] fldStringArray, Date[] dateArrayField, Currency[] currencyArrayField, ChildValidator fldChildValidator, ChildValidator[] fldChildValidatorArray) {
            this.fldBoolean = fldBoolean;
            this.fldFloat = fldFloat;
            this.fldDouble = fldDouble;
            this.fldInt = fldInt;
            this.fldShort = fldShort;
            this.fldLong = fldLong;
            this.fldByte = fldByte;
            this.fldChar = fldChar;
            this.fldEnum = fldEnum;
            this.intEnum = intfldEnum;
            this.charEnum = charfldEnum;
            this.stringEnum = StringfldEnum;
            this.fldString = fldString;
            this.fldDate = fldDate;
            this.fldCurrency = fldCurrency;
            this.fldEnumArray = fldEnumArray;
            this.fldBooleanArray = fldBooleanArray;
            this.fldByteArray = fldByteArray;
            this.setCharArrayField(charArrayField);
            this.fldShortArray = fldShortArray;
            this.fldIntArray = fldIntArray;
            this.fldLongArray = fldLongArray;
            this.fldFloatArray = fldFloatArray;
            this.fldDoubleArray = fldDoubleArray;
            this.fldStringArray = fldStringArray;
            this.dateArrayField = dateArrayField;
            this.currencyArrayField = currencyArrayField;
            this.fldChildValidator = fldChildValidator;
            this.fldChildValidatorArray = fldChildValidatorArray;
        }

        public void setBooleanField(boolean val) {
            this.fldBoolean = val;
        }

        public boolean getBooleanField() {
            return this.fldBoolean;
        }

        public void setFloatField(float val) {
            this.fldFloat = val;
        }

        public float getFloatField() {
            return this.fldFloat;
        }

        public void setDoubleField(double val) {
            this.fldDouble = val;
        }

        public double getDoubleField() {
            return this.fldDouble;
        }

        public void setIntField(int val) {
            this.fldInt = val;
        }

        public int getIntField() {
            return this.fldInt;
        }

        public void setShortField(short val) {
            this.fldShort = val;
        }

        public short getShortField() {
            return this.fldShort;
        }

        public void setLongField(long val) {
            this.fldLong = val;
        }

        public long getLongField() {
            return this.fldLong;
        }

        public void setByteField(byte val) {
            this.fldByte = val;
        }

        public byte getByteField() {
            return this.fldByte;
        }

        public void setCharField(char val) {
            this.fldChar = val;
        }

        public char getCharField() {
            return this.fldChar;
        }

        public void setEnumField(int val) {
            this.fldEnum = val;
        }

        public int getEnumField() {
            return this.fldEnum;
        }

        public int getIntEnum() {
            return this.intEnum;
        }

        public void setIntEnum(int intEnum) {
            this.intEnum = intEnum;
        }

        public char getCharEnum() {
            return this.charEnum;
        }

        public void setCharEnum(char charEnum) {
            this.charEnum = charEnum;
        }

        public String getStringEnum() {
            return this.stringEnum;
        }

        public void setStringEnum(String stringEnum) {
            this.stringEnum = stringEnum;
        }

        public void setStringField(String val) {
            this.fldString = val;
        }

        public String getStringField() {
            return this.fldString;
        }

        public void setDateField(Date val) {
            this.fldDate = val;
        }

        public Date getDateField() {
            return this.fldDate;
        }

        public Currency getCurrencyField() {
            return this.fldCurrency;
        }

        public void setCurrencyField(Currency fldCurrency) {
            this.fldCurrency = fldCurrency;
        }

        public void setEnumArrayField(byte[] val) {
            this.fldEnumArray = val;
        }

        public byte[] getEnumArrayField() {
            return this.fldEnumArray;
        }

        public void setBooleanArrayField(boolean[] val) {
            this.fldBooleanArray = val;
        }

        public boolean[] getBooleanArrayField() {
            return this.fldBooleanArray;
        }

        public void setByteArrayField(byte[] val) {
            this.fldByteArray = val;
        }

        public byte[] getByteArrayField() {
            return this.fldByteArray;
        }

        public char[] getCharArrayField() {
            return this.charArrayField;
        }

        public void setCharArrayField(char[] charArrayField) {
            this.charArrayField = charArrayField;
        }

        public void setShortArrayField(short[] val) {
            this.fldShortArray = val;
        }

        public short[] getShortArrayField() {
            return this.fldShortArray;
        }

        public void setIntArrayField(int[] val) {
            this.fldIntArray = val;
        }

        public int[] getIntArrayField() {
            return this.fldIntArray;
        }

        public void setLongArrayField(long[] val) {
            this.fldLongArray = val;
        }

        public long[] getLongArrayField() {
            return this.fldLongArray;
        }

        public void setFloatArrayField(float[] val) {
            this.fldFloatArray = val;
        }

        public float[] getFloatArrayField() {
            return this.fldFloatArray;
        }

        public void setDoubleArrayField(double[] val) {
            this.fldDoubleArray = val;
        }

        public double[] getDoubleArrayField() {
            return this.fldDoubleArray;
        }

        public void setStringArrayField(String[] val) {
            this.fldStringArray = val;
        }

        public String[] getStringArrayField() {
            return this.fldStringArray;
        }

        public Date[] getDateArrayField() {
            return this.dateArrayField;
        }

        public void setDateArrayField(Date[] dateArrayField) {
            this.dateArrayField = dateArrayField;
        }

        public Currency[] getCurrencyArrayField() {
            return this.currencyArrayField;
        }

        public void setCurrencyArrayField(Currency[] currencyArrayField) {
            this.currencyArrayField = currencyArrayField;
        }

        public ChildValidator getChildValidator() {
            return this.fldChildValidator;
        }

        public ChildValidator[] getChildValidatorArray() {
            return this.fldChildValidatorArray;
        }
    }

    static final class ParentValidator {
        private int fldFixlen;
        private String fldVarlen;

        ParentValidator(int fldFixlen, String fldVarlen) {
            this.fldFixlen = fldFixlen;
            this.fldVarlen = fldVarlen;
        }

        public int getFixlenField() {
            return this.fldFixlen;
        }

        public void setFixlenField(int val) {
            this.fldFixlen = val;
        }

        public String getVarlenField() {
            return this.fldVarlen;
        }

        public void setVarlenField(String val) {
            this.fldVarlen = val;
        }
    }

    static enum WhichChild {
        Child1,
        Child2,
        Child3;

    }

    private final class StoreEventHandler
    implements IStoreEventHandler {
        private boolean memberInitialized = false;

        private StoreEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onEvent(IStoreEvent event) {
            if (event instanceof IStoreMemberInitCompleteEvent) {
                StoreEventHandler storeEventHandler = this;
                synchronized (storeEventHandler) {
                    this.memberInitialized = true;
                    this.notifyAll();
                }
            }
        }
    }

    private final class RandomUpdater
    extends Thread {
        private final IStoreBinding binding;
        private final Validators validators;
        private final Parent parent;
        private volatile int numUpdates;
        private volatile boolean done;
        private volatile Exception status;

        RandomUpdater(IStoreBinding binding, Validators validators, Parent parent) {
            this.binding = binding;
            this.validators = validators;
            this.parent = parent;
        }

        @Override
        public final void run() {
            while (!this.done) {
                try {
                    AdmReplicationTest.this.updateParent(this.parent, AdmReplicationTest.updateValidators(this.validators));
                    IStoreCommitCompletionEvent completionEvent = this.binding.createCommitCompletionEvent().setNotify(true);
                    this.binding.commit(completionEvent);
                    completionEvent.waitForCompletion();
                    ++this.numUpdates;
                }
                catch (Exception e) {
                    this.status = e;
                    break;
                }
            }
        }

        final void shutdown() {
            this.done = true;
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            Assert.assertNull((Object)this.status);
        }
    }
}

