/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jni;

import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.solxf.ISolMessageProducer;
import com.neeve.solxf.ISolPublishEventHandler;
import com.neeve.solxf.ISolTopic;
import com.neeve.solxf.impl.jni.SolJniListener;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;

public final class SolJniMessageProducer
extends SmaObject
implements ISolMessageProducer {
    private final boolean alwaysCopyTopic = XRuntime.getValue((String)"nv.sma.soljniproducer.alwayscopytopic", (boolean)false);
    private final long _nsession;
    private final ISolPublishEventHandler _handler;
    private final boolean useNativePrewireTs;

    public SolJniMessageProducer(long nsession, ISolPublishEventHandler handler) {
        super(null);
        this._nsession = nsession;
        this._handler = handler;
        this.useNativePrewireTs = UtlTime.isNativeTimeEnabled();
        SolJniListener.registerPublishEventHandler(this._nsession, this._handler);
    }

    private static final native long nativeSend(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, long var11, long var13, long var15) throws SmaException;

    private static final native IOBuffer nativeRequest(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, long var8) throws SmaException;

    @Override
    public final long send(ByteBuffer serializedMessage, int serializedMessageOffset, int serializedMessageLength, ByteBuffer serializedMetadata, int serializedMetadataOffset, int serializedMetadataLength, ISolTopic topic, long originTs, long ackCorrelator) throws SmaException {
        XString topicName = topic.getName();
        if (this.tracer.debug) {
            this.tracer.log("[SolJniMessageProducer] Sending message...", Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessage=" + serializedMessage, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessageOffset=" + serializedMessageOffset, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessageLength=" + serializedMessageLength, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadata=" + serializedMetadata, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadataOffset=" + serializedMetadataOffset, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadataLength=" + serializedMetadataLength, Tracer.Level.DEBUG);
            this.tracer.log("[SolJniMessageProducer] ...destination=" + topicName.toDiagnosticString(), Tracer.Level.DEBUG);
        }
        IOElasticBuffer topicBuffer = topicName.getBackingBuffer();
        int serializedTopicLength = topicName.getSerializedLength();
        int serializedTopicOffset = topicBuffer.getOffset() + topicName.getBackingBufferOffset();
        ByteBuffer serializedTopic = topicName.getBackingBuffer().getIOBuffer().getBufferUnsafe();
        IOBuffer bodyHeapBufferConverter = null;
        IOBuffer metadataHeapBufferConverter = null;
        IOBuffer topicBufferConverter = null;
        try {
            if (!serializedMessage.isDirect()) {
                bodyHeapBufferConverter = IOBuffer.createNative((int)serializedMessageLength);
                UtlBuffer.copy((ByteBuffer)serializedMessage, (int)serializedMessageOffset, (ByteBuffer)bodyHeapBufferConverter.getBufferUnsafe(), (int)0, (int)serializedMessageLength);
                serializedMessage = bodyHeapBufferConverter.getBufferUnsafe();
                serializedMessageOffset = 0;
            }
            if (!serializedMetadata.isDirect()) {
                metadataHeapBufferConverter = IOBuffer.createNative((int)serializedMetadataLength);
                UtlBuffer.copy((ByteBuffer)serializedMetadata, (int)serializedMetadataOffset, (ByteBuffer)metadataHeapBufferConverter.getBufferUnsafe(), (int)0, (int)serializedMetadataLength);
                serializedMetadata = metadataHeapBufferConverter.getBufferUnsafe();
                serializedMessageOffset = 0;
            }
            if (this.alwaysCopyTopic || !serializedTopic.isDirect() || topicBuffer.isResizeNeededFor(serializedTopicLength, 1)) {
                if (this.tracer.debug) {
                    this.tracer.log("[SolJniMessageProducer] copying topic buffer from source string: " + topicName.toDiagnosticString(), Tracer.Level.DEBUG);
                }
                topicBufferConverter = IOBuffer.createNative((int)(serializedTopicLength + 1));
                UtlBuffer.copy((ByteBuffer)serializedTopic, (int)serializedTopicOffset, (ByteBuffer)topicBufferConverter.getBufferUnsafe(), (int)0, (int)serializedTopicLength);
                serializedTopic = topicBufferConverter.getBufferUnsafe();
                serializedTopicOffset = 0;
            }
            long preSendTs = this.useNativePrewireTs ? 0L : UtlTime.now();
            long nativePrewireTs = SolJniMessageProducer.nativeSend(this._nsession, serializedMessage, serializedMessageOffset, serializedMessageLength, serializedMetadata, serializedMetadataOffset, serializedMetadataLength, serializedTopic, serializedTopicOffset, serializedTopicLength, originTs, preSendTs, ackCorrelator);
            long l = this.useNativePrewireTs ? nativePrewireTs : preSendTs;
            return l;
        }
        catch (SmaException smae) {
            this.tracer.log("[SolJniMessageProducer] Sending message failed [" + smae.getMessage() + "]...", Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessage=" + serializedMessage, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessageOffset=" + serializedMessageOffset, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMessageLength=" + serializedMessageLength, Tracer.Level.SEVERE);
            try {
                this.tracer.log("[SolJniMessageProducer] ...serializedMessageBuffer=" + UtlBuffer.dump((ByteBuffer)serializedMessage), Tracer.Level.SEVERE);
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJniMessageProducer] ...serializedMessageBuffer=[" + thrown.getMessage() + "]", Tracer.Level.SEVERE);
            }
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadata=" + serializedMetadata, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadataOffset=" + serializedMetadataOffset, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...serializedMetadataLength=" + serializedMetadataLength, Tracer.Level.SEVERE);
            try {
                this.tracer.log("[SolJniMessageProducer] ...serializedMetadataBuffer=" + UtlBuffer.dump((ByteBuffer)serializedMetadata), Tracer.Level.SEVERE);
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJniMessageProducer] ...serializedMetadataBuffer=[" + thrown.getMessage() + "]", Tracer.Level.SEVERE);
            }
            this.tracer.log("[SolJniMessageProducer] ...destination=" + topic, Tracer.Level.SEVERE);
            this.tracer.log("[SolJniMessageProducer] ...topicString=" + (topicName != null ? topicName.toDiagnosticString() : topicName), Tracer.Level.SEVERE);
            try {
                this.tracer.log("[SolJniMessageProducer] ...serializedTopicBuffer=" + UtlBuffer.dump((ByteBuffer)serializedTopic), Tracer.Level.SEVERE);
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJniMessageProducer] ...serializedTopicBuffer=[" + thrown.getMessage() + "]", Tracer.Level.SEVERE);
            }
            throw smae;
        }
        finally {
            if (bodyHeapBufferConverter != null) {
                bodyHeapBufferConverter.dispose();
            }
            if (metadataHeapBufferConverter != null) {
                metadataHeapBufferConverter.dispose();
            }
            if (topicBufferConverter != null) {
                topicBufferConverter.dispose();
            }
        }
    }

    @Override
    public final void close() {
        SolJniListener.deregisterPublishEventHandler(this._nsession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] request(ISolTopic topic, byte[] content, long timeoutMillis) throws SmaException {
        XString topicName = topic.getName();
        IOElasticBuffer topicBuffer = topicName.getBackingBuffer();
        int serializedTopicLength = topicName.getSerializedLength();
        int serializedTopicOffset = topicBuffer.getOffset() + topicName.getBackingBufferOffset();
        ByteBuffer serializedTopic = topicName.getBackingBuffer().getIOBuffer().getBufferUnsafe();
        IOBuffer topicBufferConverter = null;
        IOBuffer requestContentBuffer = null;
        IOBuffer replyContentBuffer = null;
        try {
            if (this.alwaysCopyTopic || !serializedTopic.isDirect() || topicBuffer.isResizeNeededFor(serializedTopicLength, 1)) {
                topicBufferConverter = IOBuffer.createNative((int)(serializedTopicLength + 1));
                UtlBuffer.copy((ByteBuffer)serializedTopic, (int)serializedTopicOffset, (ByteBuffer)topicBufferConverter.getBufferUnsafe(), (int)0, (int)serializedTopicLength);
                serializedTopic = topicBufferConverter.getBufferUnsafe();
                serializedTopicOffset = 0;
            }
            requestContentBuffer = IOBuffer.createNative((int)content.length);
            UtlBuffer.copy((byte[])content, (int)0, (ByteBuffer)requestContentBuffer.getBufferUnsafe(), (int)0, (int)content.length);
            replyContentBuffer = SolJniMessageProducer.nativeRequest(this._nsession, serializedTopic, serializedTopicOffset, serializedTopicLength, requestContentBuffer.getBufferUnsafe(), 0, content.length, timeoutMillis);
            byte[] ret = new byte[replyContentBuffer.getLength()];
            UtlBuffer.copy((ByteBuffer)replyContentBuffer.getBufferUnsafe(), (int)0, (byte[])ret, (int)0, (int)replyContentBuffer.getLength());
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (topicBufferConverter != null) {
                topicBufferConverter.dispose();
            }
            if (requestContentBuffer != null) {
                requestContentBuffer.dispose();
            }
        }
    }

    @Override
    public final boolean supportsRequests() {
        return true;
    }
}

