/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.jms.tibems;

import com.neeve.event.IEventHandler;
import com.neeve.jms.JmsMessageBusBinding;
import com.neeve.jms.tibems.TibcoEmsMessageChannel;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.trace.Tracer;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import java.util.Properties;
import javax.jms.TopicConnectionFactory;

final class TibcoEmsMessageBusBinding
extends JmsMessageBusBinding {
    TibcoEmsMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(userName, descriptor, eventHandler);
    }

    @Override
    protected MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Creating new channel '" + descriptor.getName() + "'.", Tracer.Level.DEBUG);
        }
        return new TibcoEmsMessageChannel(descriptor, this);
    }

    @Override
    protected TopicConnectionFactory createTopicConnectionFactory(String address, Properties providerConfig) throws Exception {
        if (!address.startsWith("tcp://")) {
            address = "tcp://" + address;
        }
        if (this.jndi) {
            TopicConnectionFactory factory = super.createTopicConnectionFactory(address, providerConfig);
            if (!(factory instanceof TibjmsTopicConnectionFactory)) {
                throw new SmaPermanentException("Factory loaded via JNDI is not an instanceof TibjmsTopicConnectionFactory. Found: " + factory.getClass().getName());
            }
            return factory;
        }
        TibjmsTopicConnectionFactory factory = new TibjmsTopicConnectionFactory(address);
        return factory;
    }

    @Override
    protected final boolean supportsGuaranteedQos() {
        return true;
    }

    @Override
    protected final int getDeliveryMode(MessageChannel.Qos qos) {
        switch (qos) {
            case BestEffort: {
                return 1;
            }
            case Guaranteed: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    protected final int getAcknowledgementMode(MessageChannel.Qos qos) {
        switch (qos) {
            case BestEffort: {
                return 1;
            }
            case Guaranteed: {
                return 23;
            }
        }
        return 1;
    }
}

