/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.trace.Tracer;
import java.util.Properties;

@Deprecated
public final class Admin
extends Command {
    private final String clientName;
    private final String clientGroup;

    public Admin(String clientName, String clientGroup) {
        this.clientName = clientName;
        this.clientGroup = clientGroup;
    }

    private void processAdmin(String dest, String command) {
        String[] strs = dest.split("@");
        String appName = strs.length == 1 ? null : strs[0];
        String serverName = strs.length == 1 ? strs[0] : strs[1];
        Properties sessionProps = new Properties();
        sessionProps.setProperty("clientGroup", this.clientGroup);
        sessionProps.setProperty("connectHandshakeTimeout", "30000");
        AdminSession adminSession = null;
        try {
            adminSession = AdminSessionFactory.getDefaultInstance().createAdminClientSession(this.clientName, serverName, null, DiscoveryCacheFactory.getInstance().getDefaultCache(), Tracer.get((String)"admin"), sessionProps);
        }
        catch (Exception e) {
            this.console().error("Failed to create admin session: [" + e.getMessage() + "]", (Throwable)e);
            return;
        }
        try {
            adminSession.open();
        }
        catch (Exception e) {
            System.out.println("ERROR ['" + e.toString() + "'].");
            return;
        }
        if (appName != null) {
            this.console().info("Command '" + command + "' --> app='" + appName + "' in server '" + serverName + "'...");
        } else {
            this.console().info("Command '" + command + "' --> server '" + serverName + "'...");
        }
        try {
            String target = appName == null ? "server" : appName;
            Object result = adminSession.invokeCommandLine(target, command);
            if (result == null) {
                this.console().info("OK");
            } else {
                String resultString = String.valueOf(result);
                this.console().info("OK" + (resultString.length() > 0 ? "[" + result + "]" : ""));
            }
        }
        catch (Exception e) {
            this.console().error("ERROR [" + e.toString() + "].", (Throwable)e);
        }
        try {
            adminSession.close();
        }
        catch (Exception e) {
            this.console().error("WARN [Failed to close admin session['" + e.toString() + "']].", (Throwable)e);
        }
    }

    public final void run(String[] args) {
        if (args.length < 2) {
            System.out.println("Syntax error: admin <app@server> <command>");
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                sb.append(args[i]);
                if (i >= args.length - 1) continue;
                sb.append(" ");
            }
            this.processAdmin(args[0], sb.toString());
        }
    }

    public final void help() {
        System.out.println("admin <app@server> <command>");
        System.out.println("  Sends a command to a server or an app hosted by a server.");
    }

    public final String[] keywords() {
        return new String[]{"admin"};
    }
}

