/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.deploy;

import com.neeve.deploy.AppBus;
import com.neeve.deploy.AppClient;
import com.neeve.deploy.AppFlow;
import com.neeve.deploy.Server;
import com.neeve.server.mon.SrvMonAppState;
import com.neeve.server.mon.cnc.ISrvMonCommandDescription;
import com.neeve.server.mon.cnc.SrvMonCommandDescription;
import com.neeve.trace.Tracer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class App {
    private final Server server;
    private final String name;
    private final Tracer tracer;
    private final String tracePrefix;
    private final HashMap<String, AppBus> buses;
    private final HashMap<String, AppClient> clients;
    private final HashMap<Integer, AppFlow> flows;
    private volatile EventHandler eventHandler;
    private volatile State state;
    private SrvMonCommandDescription[] commands;

    App(Server server, String name, Tracer tracer) {
        this.server = server;
        this.name = name;
        this.tracer = tracer;
        this.tracePrefix = "[App (" + this.getName() + ")] ";
        this.buses = new HashMap();
        this.clients = new HashMap();
        this.flows = new HashMap();
        this.state = State.from(server.getSession().getWatchedAppState(name));
        if (tracer.debug) {
            tracer.log(this.tracePrefix + "Created (" + (Object)((Object)this.getState()) + ")...", Tracer.Level.DEBUG);
        }
    }

    private final void setState(State state) {
        EventHandler eventHandler;
        this.state = state;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Changed state (" + (Object)((Object)this.getState()) + ")...", Tracer.Level.DEBUG);
        }
        if ((eventHandler = this.eventHandler) != null) {
            eventHandler.onStateChange(state);
        }
        this.commands = null;
    }

    final void init() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Initializing...", Tracer.Level.DEBUG);
        }
        this.server.getSession().withAppTableLock(new Runnable(){

            @Override
            public void run() {
                int[] flowids;
                String[] clientNames;
                String[] busNames;
                if (((App)App.this).tracer.debug) {
                    App.this.tracer.log(App.this.tracePrefix + "...Buses...", Tracer.Level.DEBUG);
                }
                for (String busName : busNames = App.this.server.getSession().getWatchedAppBuses(App.this.name)) {
                    if (busName == null) continue;
                    if (((App)App.this).tracer.debug) {
                        App.this.tracer.log(App.this.tracePrefix + "......" + busName + "...", Tracer.Level.DEBUG);
                    }
                    App.this.onBusBindingCreated(busName);
                }
                if (((App)App.this).tracer.debug) {
                    App.this.tracer.log(App.this.tracePrefix + "...Clients...", Tracer.Level.DEBUG);
                }
                for (String clientName : clientNames = App.this.server.getSession().getWatchedAppClients(App.this.name)) {
                    if (clientName == null) continue;
                    if (((App)App.this).tracer.debug) {
                        App.this.tracer.log(App.this.tracePrefix + "......" + clientName + "...", Tracer.Level.DEBUG);
                    }
                    App.this.onClientConnected(clientName);
                }
                if (((App)App.this).tracer.debug) {
                    App.this.tracer.log(App.this.tracePrefix + "...Flows...", Tracer.Level.DEBUG);
                }
                for (int flowid : flowids = App.this.server.getSession().getWatchedAppFlows(App.this.name)) {
                    if (flowid < 0) continue;
                    if (((App)App.this).tracer.debug) {
                        App.this.tracer.log(App.this.tracePrefix + "......" + flowid + "...", Tracer.Level.DEBUG);
                    }
                    App.this.onFlowCreated(flowid);
                }
            }
        });
    }

    final void onStateChange() {
        this.setState(State.from(this.server.getSession().getWatchedAppState(this.name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onBusBindingCreated(String busName) {
        if (this.getBus(busName) == null) {
            AppBus bus = new AppBus(this, busName, this.tracer);
            HashMap<String, AppBus> hashMap = this.buses;
            synchronized (hashMap) {
                this.buses.put(busName, bus);
            }
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.onBusUp(bus);
            }
            bus.init();
        }
    }

    final void onBusBindingStateChange(String busName) {
        this.getBus(busName).onStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onBusBindingDestroyed(String busName) {
        EventHandler eventHandler;
        AppBus bus;
        HashMap<String, AppBus> hashMap = this.buses;
        synchronized (hashMap) {
            bus = this.buses.remove(busName);
        }
        if (bus != null && (eventHandler = this.eventHandler) != null) {
            eventHandler.onBusDown(bus);
        }
    }

    final void onBusChannelOpened(String busName, String channelName) {
        this.getBus(busName).onChannelOpen(channelName);
    }

    final void onBusChannelClosed(String busName, String channelName) {
        this.getBus(busName).onChannelClose(channelName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onClientConnected(String clientName) {
        if (this.getClient(clientName) == null) {
            AppClient client = new AppClient(this, clientName, this.tracer);
            HashMap<String, AppClient> hashMap = this.clients;
            synchronized (hashMap) {
                this.clients.put(clientName, client);
            }
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.onClientConnected(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onClientDisconnected(String clientName) {
        EventHandler eventHandler;
        AppClient client;
        HashMap<String, AppClient> hashMap = this.clients;
        synchronized (hashMap) {
            client = this.clients.remove(clientName);
        }
        if (client != null && (eventHandler = this.eventHandler) != null) {
            eventHandler.onClientDisconnected(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onFlowCreated(int flowid) {
        if (this.getFlow(flowid) == null) {
            AppFlow flow = new AppFlow(this, flowid, this.tracer);
            HashMap<Integer, AppFlow> hashMap = this.flows;
            synchronized (hashMap) {
                this.flows.put(flowid, flow);
            }
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.onFlowCreated(flow);
            }
        }
    }

    public final String getName() {
        return this.name;
    }

    public final State getState() {
        return this.state;
    }

    public final Server getServer() {
        return this.server;
    }

    public final void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public final EventHandler getEventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppBus getBus(String name) {
        HashMap<String, AppBus> hashMap = this.buses;
        synchronized (hashMap) {
            return this.buses.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<AppBus> getBuses() {
        HashSet<AppBus> ret = new HashSet<AppBus>();
        HashMap<String, AppBus> hashMap = this.buses;
        synchronized (hashMap) {
            for (AppBus bus : this.buses.values()) {
                ret.add(bus);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppClient getClient(String name) {
        HashMap<String, AppClient> hashMap = this.clients;
        synchronized (hashMap) {
            return this.clients.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<AppClient> getClients() {
        HashSet<AppClient> ret = new HashSet<AppClient>();
        HashMap<String, AppClient> hashMap = this.clients;
        synchronized (hashMap) {
            for (AppClient client : this.clients.values()) {
                ret.add(client);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppFlow getFlow(int id) {
        HashMap<Integer, AppFlow> hashMap = this.flows;
        synchronized (hashMap) {
            return this.flows.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<AppFlow> getFlows() {
        HashSet<AppFlow> ret = new HashSet<AppFlow>();
        HashMap<Integer, AppFlow> hashMap = this.flows;
        synchronized (hashMap) {
            for (AppFlow flow : this.flows.values()) {
                ret.add(flow);
            }
        }
        return ret;
    }

    public final void load() throws Exception {
        this.server.getSession().loadApp(this.getName());
    }

    public final void unload() throws Exception {
        this.server.getSession().unloadApp(this.getName());
    }

    public final ISrvMonCommandDescription[] getCommands() throws Exception {
        ISrvMonCommandDescription[] commands = this.commands;
        if (commands == null) {
            commands = this.server.getSession().getCommands(this.getName());
        }
        this.commands = commands;
        return commands;
    }

    public final Object invokeCommand(String commandLine) throws Exception {
        return this.server.getSession().invokeCommandLine(this.getName(), commandLine);
    }

    public final Object invokeCommand(String command, Object ... params) throws Exception {
        return this.server.getSession().invokeCommand(this.getName(), command, params);
    }

    public static interface EventHandler {
        public void onStateChange(State var1);

        public void onBusUp(AppBus var1);

        public void onBusDown(AppBus var1);

        public void onClientConnected(AppClient var1);

        public void onClientDisconnected(AppClient var1);

        public void onFlowCreated(AppFlow var1);
    }

    public static enum State {
        Unloaded,
        Loaded,
        Initialized,
        Started,
        Active,
        Stopped;


        public static final State from(SrvMonAppState val) {
            switch (val) {
                case Unloaded: {
                    return Unloaded;
                }
                case Loaded: {
                    return Loaded;
                }
                case Initialized: {
                    return Initialized;
                }
                case Started: {
                    return Started;
                }
                case Active: {
                    return Active;
                }
                case Stopped: {
                    return Stopped;
                }
            }
            throw new IllegalArgumentException("invalid value");
        }
    }
}

