/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.EStoFieldCorruptException;
import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class StoFixedLengthStringField
extends StoField {
    private final int len;
    private String val;
    private String emptyval;

    private StoFixedLengthStringField(String name, int len) {
        super(StoField.Type.FIXLEN_STRING, name);
        this.len = len;
    }

    private StoFixedLengthStringField(ByteBuffer buffer, int offset) {
        super(buffer, offset);
        this.len = StoFixedLengthStringField.getSerializedLength(buffer, this.bodyOffset) - 2;
    }

    private final String emptyval() {
        if (this.emptyval == null) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.len; ++i) {
                b.append(" ");
            }
            this.emptyval = b.toString();
        }
        return this.emptyval;
    }

    private final void doSyncFromBackingBuffer() {
        if (this.val == null) {
            short len = StoShortField.get(this.buffer, this.bodyOffset);
            if (len > 0) {
                byte[] valbytes = new byte[len];
                int pos = this.buffer.position();
                ((ByteBuffer)this.buffer.position(this.bodyOffset + 2)).get(valbytes).position(pos);
                try {
                    this.val = new String(valbytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.val = null;
            }
            if (this.val != null && this.val.length() != len) {
                throw new InternalError("serialized fixed length string field is corrupt [mismatch between serialized length field (" + len + " and length of serialized string (" + this.val.length() + ")");
            }
        }
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int offset) {
        try {
            String str = this.val != null ? this.val : this.emptyval();
            byte[] strbytes = str.getBytes("UTF-8");
            if (this.val != null) {
                StoShortField.put(buffer, offset, (short)strbytes.length);
                int pos = buffer.position();
                ((ByteBuffer)buffer.position(offset + 2)).put(strbytes).position(pos);
            } else {
                StoShortField.put(buffer, offset, (short)(strbytes.length * -1));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final void onBackingBufferAttach() {
        this.doSyncToBuffer(this.buffer, this.bodyOffset);
    }

    @Override
    protected final void onBackingBufferDetach() {
        this.doSyncFromBackingBuffer();
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = null;
    }

    @Override
    protected final int getSerializedLength() {
        return this.len + 2;
    }

    @Override
    protected final String getValueString() {
        this.doSyncFromBackingBuffer();
        return this.val != null ? this.val : "null";
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        String thisVal = this.getValue();
        String otherVal = ((StoFixedLengthStringField)other).getValue();
        return thisVal == null || otherVal == null ? thisVal == otherVal : thisVal.equals(otherVal);
    }

    @Override
    protected final void cloneBody(StoField object) {
        StoFixedLengthStringField clonee = (StoFixedLengthStringField)object;
        if (clonee.len != this.len) {
            throw new IllegalArgumentException("object to clone has a different string value length (this=" + this.len + ", clonee=" + clonee.len + ")");
        }
        clonee.setValue(this.getValue());
    }

    public static StoFixedLengthStringField create(String name, int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("fixed length string field length must be > 0");
        }
        return new StoFixedLengthStringField(name, len);
    }

    public static StoFixedLengthStringField create(ByteBuffer buffer, int offset) {
        return new StoFixedLengthStringField(buffer, offset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len == 0) {
            throw new EStoFieldCorruptException("serialized length of a fixed length field is 0");
        }
        return 2 + Math.abs(len) * 8 / 8;
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        this.setValue(null);
    }

    public final void setValue(String val) {
        if (val != null && val.length() != this.len) {
            throw new IllegalArgumentException("length of string value must be " + this.len);
        }
        this.val = val;
        if (this.buffer != null) {
            this.doSyncToBuffer(this.buffer, this.bodyOffset);
        }
    }

    public final String getValue() {
        if (this.val == null && this.buffer != null) {
            this.doSyncFromBackingBuffer();
        }
        return this.val;
    }
}

