/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.EPktDeserializeException;
import com.neeve.pkt.EPktSerializeException;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktSerializable;
import com.neeve.quark.QuarkBuffer;
import com.neeve.trace.Tracer;
import java.nio.ByteBuffer;

public abstract class PktBody
extends PktSerializable
implements IOElasticBuffer.Initializer {
    protected final int type;
    protected final PktBuffer buffer;
    protected final boolean isNative;
    protected boolean inDeserialize;
    protected PktSerializable.DeserializeContext deserializeContext;
    protected boolean fromFork;

    protected PktBody(int type, boolean isNative) {
        this.type = type;
        PktFactory.PktType pktType = PktFactory.getInstance().getPacketType(type);
        this.isNative = isNative && (pktType == null || PktFactory.getInstance().getPacketType(type).pooled());
        this.buffer = PktBuffer.create(this, 0, this.isNative);
        this.buffer.setInitializer(this);
        this.initialize();
    }

    private final int sync() {
        if (!this.fromFork) {
            this.doSync();
            this.buffer.ensureBackingBufferExists();
            this.buffer.setLength(this.doGetSerializedLength());
        }
        return this.buffer.getLength();
    }

    final void fork(PktBody body, boolean storageOnly) {
        if (this.buffer.getIOBuffer() != null) {
            int len = this.sync();
            body.buffer.wrapIOBuffer(this.buffer.getIOBuffer(), this.buffer.getOffset(), len);
            this.buffer.setCopyOnWrite();
            body.buffer.setCopyOnWrite();
            body.fromFork = true;
            if (!storageOnly) {
                body.postDeserialize(len);
            }
        }
    }

    protected int doGetInitialBufferLength() {
        return this.doGetSerializedLength();
    }

    protected abstract int doGetSerializedLength();

    protected boolean isResettable() {
        return false;
    }

    protected void doReset() {
        this.buffer.reset();
        this.fromFork = false;
        this.inDeserialize = false;
    }

    protected void initialize() {
    }

    protected void doSync() {
    }

    protected boolean copyOnSerialize(int policy) {
        return policy == 1;
    }

    protected boolean copyOnDeserialize(int policy) {
        return policy == 1;
    }

    protected void postDeserialize(int len) {
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isNative() {
        return this.isNative;
    }

    public final PktBuffer getBuffer() {
        return this.buffer;
    }

    public final void reset() {
        if (!this.isResettable()) {
            throw new UnsupportedOperationException("not a resettable packet type");
        }
        this.doReset();
    }

    @Override
    public final int getSerializedLength() {
        return this.fromFork ? this.buffer.getLength() : this.doGetSerializedLength();
    }

    @Override
    public final void serialize(PktSerializable.SerializeContext context, Tracer tracer) throws EPktSerializeException {
        if (tracer != null && tracer.debug) {
            tracer.log("...serializing packet body (class='" + ((Object)((Object)this)).getClass().getSimpleName() + "', type=" + this.type + ")...", Tracer.Level.DEBUG);
        }
        int resolvedPolicy = this.resolveSerializationPolicy(context.getPolicy());
        int bodySerializedLength = this.sync();
        if (tracer != null && tracer.debug) {
            tracer.log("......pre-serialize state {", Tracer.Level.DEBUG);
            tracer.log(".........serialization context", Tracer.Level.DEBUG);
            context.trace(tracer, "............");
            tracer.log(".........bodySerializedLength=" + bodySerializedLength, Tracer.Level.DEBUG);
            tracer.log(".........resolvedPolicy=" + resolvedPolicy, Tracer.Level.DEBUG);
            tracer.log(".........bodyBuffer=" + (Object)((Object)this.buffer), Tracer.Level.DEBUG);
            tracer.log("......}", Tracer.Level.DEBUG);
        }
        if (!this.copyOnSerialize(resolvedPolicy)) {
            throw new IllegalStateException("serialize by attach is currently not supported");
        }
        ByteBuffer contextBuffer = context.getByteBufferForCopy(bodySerializedLength);
        this.buffer.getTo(0, contextBuffer, bodySerializedLength);
        contextBuffer.position(contextBuffer.position() + bodySerializedLength);
        if (tracer != null && tracer.debug) {
            tracer.log("......post-serialize state {", Tracer.Level.DEBUG);
            tracer.log(".........serialization context", Tracer.Level.DEBUG);
            context.trace(tracer, "............");
            tracer.log(".........bodyBuffer=" + (Object)((Object)this.buffer), Tracer.Level.DEBUG);
            tracer.log("......}", Tracer.Level.DEBUG);
        }
    }

    public final int serialize(ByteBuffer buf) {
        return this.serialize(buf, buf.position());
    }

    public final int serialize(ByteBuffer buf, int bufOffset) {
        int bodySerializedLength = this.sync();
        this.buffer.getTo(0, buf, bufOffset, bodySerializedLength);
        return bodySerializedLength;
    }

    public final int serialize(byte[] array, int arrayOffset) {
        int bodySerializedLength = this.sync();
        this.buffer.getTo(0, array, arrayOffset, bodySerializedLength);
        return bodySerializedLength;
    }

    public final int serialize(IOBuffer iobuf, int iobufOffset) {
        int bodySerializedLength = this.sync();
        this.buffer.getTo(0, iobuf.getBufferUnsafe(), iobufOffset, bodySerializedLength);
        return bodySerializedLength;
    }

    public final int serialize(IOElasticBuffer iobuf, int iobufOffset) {
        int bodySerializedLength = this.sync();
        iobuf.putFrom(iobufOffset, (IOElasticBuffer)this.buffer, 0, bodySerializedLength);
        return bodySerializedLength;
    }

    public final int serialize(long address, int addressOffset) {
        int bodySerializedLength = this.sync();
        this.buffer.getToNative(0, address, addressOffset, bodySerializedLength);
        return bodySerializedLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deserialize(PktSerializable.DeserializeContext context, int length, Tracer tracer) throws EPktDeserializeException {
        block10: {
            if (context == null) {
                throw new IllegalArgumentException("context cannot be null");
            }
            this.inDeserialize = true;
            this.deserializeContext = context;
            try {
                int policy = context.getPolicy();
                ByteBuffer contextBuffer = context.getBuffer();
                int contextBufferPos = contextBuffer.position();
                if (contextBuffer.remaining() >= length) {
                    int resolvedPolicy = this.resolveDeserializationPolicy(policy);
                    if (tracer != null && tracer.debug) {
                        tracer.log("...deserializing packet body (class=" + ((Object)((Object)this)).getClass().getSimpleName() + ")...", Tracer.Level.DEBUG);
                        tracer.log("......pre-deserialize state {", Tracer.Level.DEBUG);
                        tracer.log(".........deserialization context", Tracer.Level.DEBUG);
                        context.trace(tracer, "............");
                        tracer.log(".........resolvedPolicy=" + resolvedPolicy, Tracer.Level.DEBUG);
                        tracer.log("......}", Tracer.Level.DEBUG);
                    }
                    if (resolvedPolicy == 1) {
                        if (tracer != null && tracer.debug) {
                            tracer.log("......copying " + length + " bytes into buffer " + (Object)((Object)this.buffer) + "...", Tracer.Level.DEBUG);
                        }
                    } else {
                        this.buffer.setCopyOnWrite();
                        context.setBufferRetained(true);
                        throw new IllegalStateException("deserialize by slice is currently not supported");
                    }
                    this.buffer.putFrom(0, contextBuffer, length);
                    context.setBufferRetained(false);
                    this.buffer.setLength(length);
                    context.setNumBytes(length);
                    contextBuffer.position(contextBufferPos + length);
                    if (tracer != null && tracer.debug) {
                        tracer.log("......post-deserialize state {", Tracer.Level.DEBUG);
                        tracer.log(".........deserialization context", Tracer.Level.DEBUG);
                        context.trace(tracer, "............");
                        tracer.log(".........bodyBuffer=" + (Object)((Object)this.buffer), Tracer.Level.DEBUG);
                        tracer.log("......}", Tracer.Level.DEBUG);
                    }
                    this.postDeserialize(length);
                    break block10;
                }
                throw new InternalError("buffer does not contain a complete serialized body.");
            }
            finally {
                this.deserializeContext = null;
                this.inDeserialize = false;
            }
        }
    }

    public final void deserialize(ByteBuffer buf, int length) {
        this.deserialize(buf, buf.position(), length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deserialize(ByteBuffer buf, int bufOffset, int length) {
        this.inDeserialize = true;
        try {
            this.buffer.putFrom(0, buf, bufOffset, length);
            this.buffer.setLength(length);
            this.postDeserialize(length);
        }
        finally {
            this.inDeserialize = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deserialize(byte[] array, int arrayOffset, int length) throws EPktDeserializeException {
        this.inDeserialize = true;
        try {
            this.buffer.putFrom(0, array, arrayOffset, length);
            this.buffer.setLength(length);
            this.postDeserialize(length);
        }
        finally {
            this.inDeserialize = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deserialize(IOBuffer iobuf, int iobufOffset, int length, boolean wrap) throws EPktDeserializeException {
        this.inDeserialize = true;
        try {
            if (wrap) {
                this.buffer.wrapIOBuffer(iobuf, iobufOffset, length);
            } else {
                this.buffer.putFrom(0, iobuf.getBufferUnsafe(), iobufOffset, length);
            }
            this.buffer.setLength(length);
            this.postDeserialize(length);
        }
        finally {
            this.inDeserialize = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deserialize(QuarkBuffer qbuf, int qbufOffset, int length) throws EPktDeserializeException {
        this.inDeserialize = true;
        try {
            this.buffer.putFrom(0, qbuf.getBufferUnsafe(), qbufOffset, length);
            this.buffer.setLength(length);
            this.postDeserialize(length);
        }
        finally {
            this.inDeserialize = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deserialize(IOElasticBuffer iobuf, int iobufOffset, int length) throws EPktDeserializeException {
        this.inDeserialize = true;
        try {
            this.buffer.putFrom(0, iobuf, iobufOffset, length);
            this.buffer.setLength(length);
            this.postDeserialize(length);
        }
        finally {
            this.inDeserialize = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deserialize(long address, int addressOffset, int length) throws EPktDeserializeException {
        this.inDeserialize = true;
        try {
            this.buffer.putFromNative(0, address, addressOffset, length);
            this.buffer.setLength(length);
            this.postDeserialize(length);
        }
        finally {
            this.inDeserialize = false;
        }
    }

    public final String dump(String prefix) {
        return this.buffer.dump(prefix, 0, this.getSerializedLength());
    }

    public final int getInitialBufferLength() {
        return this.fromFork ? this.buffer.getLength() : this.doGetInitialBufferLength();
    }

    public void initializeBuffer() {
    }
}

