/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.network;

import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.io.IOBuffer;
import com.neeve.link.network.LnkNwPeerEndpointStats;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;

final class LnkNwPeerEndpointOutputBuffer {
    private final Tracer tracer;
    private final String tracePrefix;
    private final PktSerializable.SerializeContext serializeContext;
    private final LnkNwPeerEndpointStats stats;
    private final int autoFlushSize;
    private final int maxBufferSize;
    private final boolean useDirect;
    private boolean stampOutTs;
    private int meanFlushSize;
    private double meanFlushSizeChangeLambda;
    private int size;
    private int flushedToDrain;

    LnkNwPeerEndpointOutputBuffer(String name, Tracer tracer, int autoFlushSize, int maxBufferSize, boolean useDirect, boolean stampOutTs, LnkNwPeerEndpointStats stats) {
        this.tracer = tracer;
        this.tracePrefix = "[obuf] ";
        this.serializeContext = PktSerializable.SerializeContext.create();
        this.stats = stats;
        this.autoFlushSize = autoFlushSize;
        this.maxBufferSize = maxBufferSize;
        this.useDirect = useDirect;
        this.stampOutTs = stampOutTs;
        this.meanFlushSize = this.autoFlushSize;
        this.meanFlushSizeChangeLambda = 0.1;
        this.size = 0;
        this.flushedToDrain = 0;
        this.serializeContext.addBuffer(IOBuffer.create((int)this.meanFlushSize, (boolean)this.useDirect));
        tracer.log("Network Link Endpoint Configuration (Output Buffer)...", Tracer.Level.CONFIG);
        tracer.log("....link=" + name, Tracer.Level.CONFIG);
        tracer.log("........maxBufferSize=" + this.maxBufferSize, Tracer.Level.CONFIG);
        tracer.log("........autoFlushSize=" + this.autoFlushSize, Tracer.Level.CONFIG);
        tracer.log("........useDirect=" + this.useDirect, Tracer.Level.CONFIG);
        tracer.log("........stampOutTs=" + stampOutTs, Tracer.Level.CONFIG);
    }

    final void enableIOTimestamps(boolean enabled) {
        this.stampOutTs = enabled;
    }

    final boolean serialize(PktPacket packet) {
        int preSerializeBufferCount = this.serializeContext.getBufferCount();
        ByteBuffer preSerializeLastBuffer = this.serializeContext.getByteBuffer(preSerializeBufferCount - 1);
        int preSerializeLastBufferPos = preSerializeLastBuffer.position();
        int preSerializeSize = this.size;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Before serializing packet [buffer count=" + preSerializeBufferCount + " buffer size=" + preSerializeSize + " first buffer=" + this.serializeContext.getByteBuffer(0) + "]", Tracer.Level.DEBUG);
        }
        packet.serialize(this.serializeContext, this.tracer);
        ++this.stats.numPacketsEnqueued;
        ByteBuffer[] bufferArray = this.serializeContext.getByteBuffers();
        int postSerializeBufferCount = this.serializeContext.getBufferCount();
        if (postSerializeBufferCount > preSerializeBufferCount) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Buffers grafted during serialize [new buffer count=" + postSerializeBufferCount + "]", Tracer.Level.DEBUG);
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + (preSerializeLastBuffer.position() - preSerializeLastBufferPos) + " bytes copied to last non-grafted buffer", Tracer.Level.DEBUG);
            }
            this.size += preSerializeLastBuffer.position() - preSerializeLastBufferPos;
            if (this.stampOutTs) {
                if (this.size > preSerializeSize) {
                    packet.setOutTs(preSerializeLastBuffer, preSerializeLastBufferPos, UtlTime.now());
                } else {
                    packet.setOutTs(bufferArray[preSerializeBufferCount], 0, UtlTime.now());
                }
            }
            for (int i = preSerializeBufferCount; i < postSerializeBufferCount; ++i) {
                int pos = bufferArray[i].position();
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + pos + " bytes copied to grafted buffer #" + (i - preSerializeBufferCount + 1), Tracer.Level.DEBUG);
                }
                this.size += pos;
                this.stats.numOutputBufBytesGrafted += (long)pos;
            }
        } else {
            if (postSerializeBufferCount < preSerializeBufferCount) {
                throw new InternalError("Count of buffers in serialize context descreased during serialization!");
            }
            if (bufferArray[preSerializeBufferCount - 1] != preSerializeLastBuffer) {
                throw new InternalError("Last buffer in serialization context was replaced during serialization!");
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Buffers not added during serialize.", Tracer.Level.DEBUG);
            }
            if (this.stampOutTs) {
                packet.setOutTs(preSerializeLastBuffer, preSerializeLastBufferPos, UtlTime.now());
            }
            this.size += preSerializeLastBuffer.position() - preSerializeLastBufferPos;
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "After serializing packet [buffer count=" + postSerializeBufferCount + " buffer size=" + this.size + " packet size=" + (this.size - preSerializeSize) + " first buffer=" + bufferArray[0] + "]", Tracer.Level.DEBUG);
        }
        this.stats.numBytesEnqueued += (long)(this.size - preSerializeSize);
        return this.autoFlushSize > 0 && this.size >= this.autoFlushSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean flush(IEmxNwLnkPeerEndpoint pep, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        long preWriteTs = this.stampOutTs ? UtlTime.now() : 0L;
        this.serializeContext.flipBuffers();
        ByteBuffer[] bufferArray = this.serializeContext.getByteBuffers();
        int bufferCount = this.serializeContext.getBufferCount();
        try {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Flush start [buffer count=" + bufferCount + " buffer size=" + this.size + " flushed to drain=" + this.flushedToDrain + "]", Tracer.Level.DEBUG);
            }
            while (this.size > 0) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Writing buffers [buffer count=" + bufferCount + " size=" + this.size + "]", Tracer.Level.DEBUG);
                }
                long numWritten = pep.write(bufferArray, bufferCount, waitCond);
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Written buffers [bytes written=" + numWritten + "]", Tracer.Level.DEBUG);
                }
                if (numWritten == 0L) break;
                this.size = (int)((long)this.size - numWritten);
                this.flushedToDrain = (int)((long)this.flushedToDrain + numWritten);
                this.stats.numBytesFlushed += numWritten;
                if (this.size >= 0) continue;
                throw new InternalError("Buffer size is negative after a flush!");
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Flush complete [size=" + this.size + " flushed to drain=" + this.flushedToDrain + "]", Tracer.Level.DEBUG);
            }
            if (this.size == 0) {
                int oldFirstBufferCapacity;
                int meanFirstBufferSize;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Buffers fully drained", Tracer.Level.DEBUG);
                }
                this.serializeContext.setBufferCount(1);
                this.stats.meanFlushSize = this.meanFlushSize = (int)Math.ceil(this.meanFlushSizeChangeLambda * (double)this.flushedToDrain + (1.0 - this.meanFlushSizeChangeLambda) * (double)this.meanFlushSize);
                this.stats.meanFirstBufferSize = meanFirstBufferSize = Math.min(Math.max(this.meanFlushSize, this.autoFlushSize), this.maxBufferSize > 0 ? this.maxBufferSize : Integer.MAX_VALUE);
                int newFirstBufferCapacity = oldFirstBufferCapacity = this.serializeContext.getByteBuffers()[0].limit();
                if (meanFirstBufferSize > oldFirstBufferCapacity) {
                    newFirstBufferCapacity = oldFirstBufferCapacity * 2;
                } else if (meanFirstBufferSize < newFirstBufferCapacity / 2) {
                    newFirstBufferCapacity = oldFirstBufferCapacity / 2;
                }
                if (oldFirstBufferCapacity != newFirstBufferCapacity) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Replacing first buffer [oldCapacity=" + oldFirstBufferCapacity + " newCapacity=" + newFirstBufferCapacity + "]", Tracer.Level.DEBUG);
                    }
                    this.serializeContext.resizeBuffer(0, newFirstBufferCapacity);
                    this.stats.numOutputBufBytesAllocated += (long)newFirstBufferCapacity;
                } else if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Old and new capacities the same. Retaining first buffer", Tracer.Level.DEBUG);
                }
                this.flushedToDrain = 0;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Post drain processing complete [buffer count=" + bufferCount + " first buffer capacity=" + bufferArray[0].capacity() + " buffer size=" + this.size + " flushed to drain=" + this.flushedToDrain + " mean flush size=" + this.meanFlushSize + "]", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Buffers not fully drained [size=" + this.size + "]", Tracer.Level.DEBUG);
            }
        }
        finally {
            this.serializeContext.compactBuffers();
        }
        if (this.stampOutTs) {
            this.stats.w.add((double)(UtlTime.now() - preWriteTs));
        }
        return this.size == 0;
    }

    final int getSize() {
        return this.size;
    }
}

