/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkAcceptor;
import com.neeve.emx.EmxNwLnkConnector;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.emx.test.unit.EmxNwLnkAcceptorTest;
import com.neeve.io.IOBuffer;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class EmxNwLnkReaderTest
extends UnitTest {
    protected EmxNwLnk clink;
    protected EmxNwLnk slink;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void before() throws Exception {
        EmxNwLnkAcceptorTest.Callback cb = new EmxNwLnkAcceptorTest.Callback();
        EmxNwLnkAcceptor acceptor = EmxNwLnkAcceptor.create("tcp://localhost:6000", cb);
        Thread thread = new Thread(acceptor);
        try {
            thread.start();
            this.clink = EmxNwLnkConnector.create("tcp://localhost:6000").connect();
            cb.waitUntilAccept(1000L);
            this.slink = cb.link;
            Assert.assertNotNull((Object)((Object)this.slink));
        }
        finally {
            acceptor.close();
        }
    }

    @After
    public void after() throws Exception {
        if (this.clink != null) {
            this.clink.close();
            this.clink = null;
        }
        if (this.slink != null) {
            this.slink.close();
            this.slink = null;
        }
    }

    protected static final class Writer
    extends Thread {
        private final Random random = new Random(System.currentTimeMillis());
        private final EmxNwLnk link;
        int bytesSent;

        Writer(EmxNwLnk link) {
            this.link = link;
        }

        @Override
        public final void run() {
            ByteBuffer[] bytebufs = new ByteBuffer[]{ByteBuffer.allocate(8192)};
            for (int i = 0; i < 100; ++i) {
                bytebufs[0].clear();
                bytebufs[0].limit(this.random.nextInt(8192));
                this.bytesSent += bytebufs[0].limit();
                try {
                    this.link.write(bytebufs, 1);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    protected static final class Callback
    implements EmxNwLnkReader.Callback {
        boolean receivedClose;
        Throwable failureCause;
        int bytesReceived;

        protected Callback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitUntilClose(long timeout) throws InterruptedException {
            Callback callback = this;
            synchronized (callback) {
                long start = System.currentTimeMillis();
                long remaining = timeout;
                while (remaining > 0L && !this.receivedClose) {
                    this.wait(remaining);
                    remaining = timeout - (System.currentTimeMillis() - start);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitUntilFail(long timeout) throws InterruptedException {
            Callback callback = this;
            synchronized (callback) {
                long start = System.currentTimeMillis();
                long remaining = timeout;
                while (remaining > 0L && this.failureCause == null) {
                    this.wait(remaining);
                    remaining = timeout - (System.currentTimeMillis() - start);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitUntilBytesReceived(int count, long timeout) throws InterruptedException {
            Callback callback = this;
            synchronized (callback) {
                long start = System.currentTimeMillis();
                long remaining = timeout;
                while (remaining > 0L && this.bytesReceived < count) {
                    this.wait(remaining);
                    remaining = timeout - (System.currentTimeMillis() - start);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int handleReadData(EmxNwLnk lnk, IOBuffer iobuf, int length) {
            Callback callback = this;
            synchronized (callback) {
                this.bytesReceived += length;
                this.notifyAll();
            }
            return length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handleLinkClosure(EmxNwLnk lnk) {
            Callback callback = this;
            synchronized (callback) {
                this.receivedClose = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handleLinkFailure(EmxNwLnk lnk, Throwable cause) {
            Callback callback = this;
            synchronized (callback) {
                this.failureCause = cause;
                this.notifyAll();
            }
        }
    }
}

