/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkAcceptor;
import com.neeve.emx.EmxNwLnkConnector;
import com.neeve.emx.test.unit.EmxNwLnkAcceptorTest;
import com.neeve.test.UnitTest;
import org.junit.Assert;
import org.junit.Test;

public final class EmxNwLnkConnectorTest
extends UnitTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNullDescriptor() throws Exception {
        EmxNwLnkConnector.create(null);
    }

    @Test(expected=EEmxNwLnkOpFailedException.class)
    public void testCreateConnectServerAbsent() throws Exception {
        EmxNwLnkConnector.create("tcp://localhost:6000").connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCreateConnectServerPresent(String acceptDescriptor, String connectDescriptor) throws Exception {
        EmxNwLnkAcceptorTest.Callback cb = new EmxNwLnkAcceptorTest.Callback();
        EmxNwLnkAcceptor acceptor = EmxNwLnkAcceptor.create(acceptDescriptor, cb);
        Thread thread = new Thread(acceptor);
        try {
            thread.start();
            EmxNwLnkConnector connector = EmxNwLnkConnector.create(connectDescriptor);
            EmxNwLnk clink = connector.connect();
            Assert.assertNotNull((Object)((Object)clink));
            clink.close();
            cb.waitUntilAccept(1000L);
            Assert.assertNotNull((Object)((Object)cb.link));
            cb.link.close();
        }
        finally {
            acceptor.close();
        }
    }

    @Test
    public void testCreateConnectServerPresentNoLocalIfAddrOrPort() throws Exception {
        this.testCreateConnectServerPresent("tcp://localhost:6000", "tcp://localhost:6000");
    }

    @Test
    public void testCreateConnectServerPresentLocalIfAddrSpecifiedButNotLocalPort() throws Exception {
        this.testCreateConnectServerPresent("tcp://localhost:6000", "tcp://localhost:6000&localIfAddr=127.0.0.1");
    }

    @Test
    public void testCreateConnectServerPresentLocalIfAddrAndPortSpecified() throws Exception {
        this.testCreateConnectServerPresent("tcp://localhost:6000", "tcp://localhost:6000&localifaddr=127.0.0.1&localport=6001");
    }
}

