/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.EmxNwLnkBlockingReader;
import com.neeve.emx.test.unit.EmxNwLnkReaderTest;
import org.junit.Assert;
import org.junit.Test;

public final class EmxNwLnkBlockingReaderTest
extends EmxNwLnkReaderTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNullLink() throws Exception {
        EmxNwLnkBlockingReader.create(null, new EmxNwLnkReaderTest.Callback());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNullCallback() throws Exception {
        EmxNwLnkBlockingReader.create(this.clink, null);
    }

    @Test
    public void testCreateStop() throws Exception {
        EmxNwLnkBlockingReader.create(this.clink, new EmxNwLnkReaderTest.Callback()).stop();
    }

    @Test
    public void testCreateStopStart() throws Exception {
        EmxNwLnkBlockingReader creader = EmxNwLnkBlockingReader.create(this.clink, new EmxNwLnkReaderTest.Callback());
        creader.stop();
        Thread thread = new Thread(creader);
        thread.start();
        thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartStop() throws Exception {
        EmxNwLnkReaderTest.Callback cb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkBlockingReader creader = EmxNwLnkBlockingReader.create(this.clink, cb);
        try {
            Thread thread = new Thread(creader);
            thread.start();
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)thread.isAlive());
            creader.stop();
            Assert.assertFalse((boolean)thread.isAlive());
            Assert.assertNull((Object)cb.failureCause);
        }
        finally {
            creader.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartServerSideClose() throws Exception {
        EmxNwLnkReaderTest.Callback cb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkBlockingReader creader = EmxNwLnkBlockingReader.create(this.clink, cb);
        try {
            Thread thread = new Thread(creader);
            thread.start();
            this.slink.close();
            cb.waitUntilClose(1000L);
            Assert.assertTrue((boolean)cb.receivedClose);
            thread.join(1000L);
            Assert.assertFalse((boolean)thread.isAlive());
            Assert.assertNull((Object)cb.failureCause);
        }
        finally {
            creader.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartClientSideClose() throws Exception {
        EmxNwLnkReaderTest.Callback cb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkBlockingReader creader = EmxNwLnkBlockingReader.create(this.clink, cb);
        try {
            Thread thread = new Thread(creader);
            thread.start();
            Thread.sleep(1000L);
            this.clink.close();
            cb.waitUntilFail(1000L);
            Assert.assertNotNull((Object)cb.failureCause);
            thread.join(1000L);
            Assert.assertFalse((boolean)thread.isAlive());
        }
        finally {
            creader.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartBidirectionalDataExchange() throws Exception {
        EmxNwLnkReaderTest.Callback ccb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkBlockingReader creader = EmxNwLnkBlockingReader.create(this.clink, ccb);
        try {
            Thread cthread = new Thread(creader);
            cthread.start();
            EmxNwLnkReaderTest.Callback scb = new EmxNwLnkReaderTest.Callback();
            EmxNwLnkBlockingReader sreader = EmxNwLnkBlockingReader.create(this.slink, scb);
            try {
                Thread sthread = new Thread(sreader);
                sthread.start();
                this.clink.configureBlockingWrite(true);
                this.slink.configureBlockingWrite(true);
                EmxNwLnkReaderTest.Writer cwriter = new EmxNwLnkReaderTest.Writer(this.clink);
                EmxNwLnkReaderTest.Writer swriter = new EmxNwLnkReaderTest.Writer(this.slink);
                cwriter.start();
                swriter.start();
                cwriter.join();
                swriter.join();
                scb.waitUntilBytesReceived(cwriter.bytesSent, 10000L);
                Assert.assertEquals((long)cwriter.bytesSent, (long)scb.bytesReceived);
                ccb.waitUntilBytesReceived(swriter.bytesSent, 10000L);
                Assert.assertEquals((long)swriter.bytesSent, (long)ccb.bytesReceived);
            }
            finally {
                sreader.stop();
            }
        }
        finally {
            creader.stop();
        }
    }
}

