/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlFile;
import com.neeve.util.UtlResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class UtlJar {
    private static final EntryFilter UNFILTERED = new EntryFilter(){

        @Override
        public boolean accept(ZipEntry entry) {
            return !entry.getName().startsWith("META-INF") || !entry.getName().toUpperCase().endsWith(".SF") && !entry.getName().toUpperCase().endsWith(".DSA") && !entry.getName().toUpperCase().endsWith(".RSA");
        }

        @Override
        public File remap(ZipEntry entry, File target) {
            return target;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void extract(File rootDir, ZipArchiveInputStream in, EntryFilter filter, URL jarUrl) throws IOException {
        ZipArchiveEntry entry = null;
        while ((entry = in.getNextZipEntry()) != null) {
            if (!filter.accept((ZipEntry)entry)) continue;
            if (entry.isDirectory()) {
                File folder = new File(rootDir, entry.getName());
                folder = filter.remap((ZipEntry)entry, folder);
                continue;
            }
            File target = new File(rootDir, entry.getName());
            if ((target = filter.remap((ZipEntry)entry, target)).exists()) {
                target.delete();
            }
            if (target.getParentFile() != null && !target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            target.createNewFile();
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target), 65536);){
                IOUtils.copy((InputStream)in, (OutputStream)bos);
            }
            target.setLastModified(entry.getLastModifiedDate().getTime());
            if (!entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
            UtlJar.extractManifestEntries(target, rootDir, jarUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void extractManifestEntries(File manifestFile, File outputDir, URL sourceUrl) throws IOException {
        String manifestClasspath = null;
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(manifestFile), 65536);){
            Manifest manifest = new Manifest(fis);
            manifestClasspath = (String)manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH);
        }
        if (manifestClasspath != null) {
            String[] entries = manifestClasspath.split(" ");
            for (int i = entries.length - 1; i >= 0; --i) {
                String classpathEntry = entries[i];
                URI entryUri = null;
                try {
                    URI jarUri = sourceUrl.toURI();
                    URI parent = jarUri.resolve(".");
                    entryUri = parent.resolve(classpathEntry);
                    UtlJar.extractClasspathElementToDirectory(entryUri.toURL(), outputDir);
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("WARNINNG Failed to extract classpath manifest entry '" + classpathEntry + "' from '" + sourceUrl + "' using '" + entryUri + ": " + fnfe.getMessage());
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("Failed to extract classpath manifest entry '" + classpathEntry + "' from '" + sourceUrl + "' using '" + entryUri + ": " + e.getMessage(), e);
                }
            }
        }
    }

    public static void extractFolder(URL jarUrl, final String folderName, final File targetFolder) throws IOException {
        ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new BufferedInputStream(jarUrl.openStream(), 8192));
        UtlJar.extract(targetFolder, zis, new EntryFilter(){

            @Override
            public boolean accept(ZipEntry entry) {
                if (!UNFILTERED.accept(entry)) {
                    return false;
                }
                if (!entry.getName().startsWith(folderName)) {
                    return false;
                }
                File target = this.remap(entry, new File(targetFolder, entry.getName()));
                return !target.exists() || entry.getTime() > target.lastModified();
            }

            @Override
            public File remap(ZipEntry entry, File target) {
                return new File(targetFolder, entry.getName().substring(folderName.length()));
            }
        }, jarUrl);
    }

    public static final void extractClasspathToDirectory(ClassLoader loader, File outputDir) throws IOException {
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = urls.length - 1; i >= 0; --i) {
                UtlJar.extractClasspathElementToDirectory(urls[i], outputDir);
            }
        } else {
            throw new IOException("Unsupported classloader type for Persister archive creation: " + loader.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void extractClasspathElementToDirectory(URL url, File outputDir) throws IOException {
        if ("file".equals(url.getProtocol())) {
            File file = null;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            if (file.isDirectory()) {
                UtlFile.copyDirectory(file, outputDir);
            } else if (file.getName().endsWith(".jar")) {
                if (file.getName().equals("tools.jar")) {
                    return;
                }
                try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new BufferedInputStream(url.openStream(), 65536));){
                    UtlJar.extract(outputDir, zis, UNFILTERED, url);
                }
            }
        } else if (url.getPath().endsWith(".jar")) {
            try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new BufferedInputStream(url.openStream(), 65536));){
                UtlJar.extract(outputDir, zis, UNFILTERED, url);
            }
        }
    }

    public static final void jar(File source, File target) throws IOException {
        try (ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(target), 65536));){
            os.setMethod(8);
            os.setLevel(5);
            UtlJar.recusiveJar(os, source, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recusiveJar(ZipOutputStream os, File source, String jarpath) throws IOException {
        String prefix = "";
        if (jarpath != null) {
            prefix = jarpath + "/";
        }
        if (source.isDirectory()) {
            for (File file : source.listFiles()) {
                UtlJar.recusiveJar(os, file, prefix + file.getName());
            }
        } else {
            ZipEntry entry = new ZipEntry(jarpath);
            if (!UNFILTERED.accept(entry)) {
                return;
            }
            entry.setTime(source.lastModified() + 1999L);
            os.putNextEntry(entry);
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(source), 65536);){
                IOUtils.copy((InputStream)is, (OutputStream)os, (int)65536);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listFiles(URL jarFolderUrl, Set<URL> results, UtlResource.URLFilter filter) throws IOException {
        int jarSuffixPos = jarFolderUrl.toString().lastIndexOf("!/");
        if (jarSuffixPos == -1) {
            System.err.println("WARNING: Ingoring unsupported jar url: " + jarFolderUrl);
            return;
        }
        String folderPath = jarFolderUrl.toString().substring(jarSuffixPos + 2);
        String jarUrlPath = jarFolderUrl.toString().substring(0, jarSuffixPos);
        if (jarUrlPath.startsWith("jar:")) {
            jarUrlPath = jarUrlPath.substring(4);
        }
        URL jarUrl = new URL(jarUrlPath);
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new BufferedInputStream(jarUrl.openStream(), 8192));){
            ZipArchiveEntry entry = null;
            while ((entry = zis.getNextZipEntry()) != null) {
                String entryName;
                if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(folderPath) || entryName.indexOf(47, folderPath.length() + 1) > 0) continue;
                URL url = new URL("jar:" + jarUrlPath + "!/" + entryName);
                if (filter != null && filter.filter(url)) continue;
                results.add(new URL("jar:" + jarUrlPath + "!/" + entryName));
            }
        }
    }

    private static interface EntryFilter {
        public boolean accept(ZipEntry var1);

        public File remap(ZipEntry var1, File var2);
    }
}

