/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.stats;

import com.neeve.lang.XFactory;
import com.neeve.lang.XString;
import com.neeve.stats.AbstractGauge;
import com.neeve.stats.IStats;
import java.lang.reflect.Field;
import java.text.NumberFormat;

public class FieldReflectingGauge
extends AbstractGauge {
    private final Object target;
    private final Field field;
    private final boolean primitive;
    private final XString stringHolder;

    public FieldReflectingGauge(String name, Object target, Field field) {
        super(name, FieldReflectingGauge.getType(field));
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.primitive = field.getClass().isPrimitive();
        this.stringHolder = this.type == IStats.Gauge.Type.String && !XString.class.isAssignableFrom(field.getType()) ? XFactory.createXString(16, true, true) : null;
        this.target = target;
        this.field = field;
    }

    private static final IStats.Gauge.Type getType(Field field) {
        Class<?> javaType = field.getType();
        if (javaType.equals(Boolean.class) || javaType.equals(Boolean.TYPE)) {
            return IStats.Gauge.Type.Boolean;
        }
        if (javaType.equals(Byte.class) || javaType.equals(Byte.TYPE)) {
            return IStats.Gauge.Type.Byte;
        }
        if (javaType.equals(Short.class) || javaType.equals(Short.TYPE)) {
            return IStats.Gauge.Type.Short;
        }
        if (javaType.equals(Integer.class) || javaType.equals(Integer.TYPE)) {
            return IStats.Gauge.Type.Int;
        }
        if (javaType.equals(Long.class) || javaType.equals(Long.TYPE)) {
            return IStats.Gauge.Type.Long;
        }
        if (javaType.equals(Float.class) || javaType.equals(Float.TYPE)) {
            return IStats.Gauge.Type.Float;
        }
        if (javaType.equals(Double.class) || javaType.equals(Double.TYPE)) {
            return IStats.Gauge.Type.Double;
        }
        if (javaType.equals(Character.class) || javaType.equals(Character.TYPE)) {
            return IStats.Gauge.Type.Char;
        }
        if (javaType.equals(String.class) || XString.class.isAssignableFrom(javaType)) {
            return IStats.Gauge.Type.String;
        }
        throw new IllegalArgumentException("Gauge field type is not a supported Gauge type: " + field);
    }

    @Override
    public final boolean getBooleanValue() {
        if (this.type == IStats.Gauge.Type.Boolean) {
            try {
                if (this.primitive) {
                    return this.field.getBoolean(this.target);
                }
                Boolean value = (Boolean)this.field.get(this.target);
                if (value == null) {
                    return false;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getBooleanValue();
    }

    @Override
    public final byte getByteValue() {
        if (this.type == IStats.Gauge.Type.Byte) {
            try {
                if (this.primitive) {
                    return this.field.getByte(this.target);
                }
                Byte value = (Byte)this.field.get(this.target);
                if (value == null) {
                    return 0;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getByteValue();
    }

    @Override
    public final char getCharValue() {
        if (this.type == IStats.Gauge.Type.Char) {
            try {
                if (this.primitive) {
                    return this.field.getChar(this.target);
                }
                Character value = (Character)this.field.get(this.target);
                if (value == null) {
                    return '\u0000';
                }
                return value.charValue();
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getCharValue();
    }

    @Override
    public final short getShortValue() {
        if (this.type == IStats.Gauge.Type.Short) {
            try {
                if (this.primitive) {
                    return this.field.getShort(this.target);
                }
                Short value = (Short)this.field.get(this.target);
                if (value == null) {
                    return 0;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getShortValue();
    }

    @Override
    public final int getIntValue() {
        if (this.type == IStats.Gauge.Type.Int) {
            try {
                if (this.primitive) {
                    return this.field.getInt(this.target);
                }
                Integer value = (Integer)this.field.get(this.target);
                if (value == null) {
                    return 0;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getIntValue();
    }

    @Override
    public final long getLongValue() {
        if (this.type == IStats.Gauge.Type.Long) {
            try {
                if (this.primitive) {
                    return this.field.getLong(this.target);
                }
                Long value = (Long)this.field.get(this.target);
                if (value == null) {
                    return 0L;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getLongValue();
    }

    @Override
    public final float getFloatValue() {
        if (this.type == IStats.Gauge.Type.Float) {
            try {
                if (this.primitive) {
                    return this.field.getFloat(this.target);
                }
                Float value = (Float)this.field.get(this.target);
                if (value == null) {
                    return 0.0f;
                }
                return value.floatValue();
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getFloatValue();
    }

    @Override
    public final double getDoubleValue() {
        if (this.type == IStats.Gauge.Type.Double) {
            try {
                if (this.primitive) {
                    return this.field.getDouble(this.target);
                }
                Double value = (Double)this.field.get(this.target);
                if (value == null) {
                    return 0.0;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getDoubleValue();
    }

    @Override
    public final XString getStringValue() {
        if (this.type == IStats.Gauge.Type.String) {
            try {
                if (this.stringHolder != null) {
                    this.stringHolder.setValue((String)this.field.get(this.target));
                    return this.stringHolder;
                }
                return (XString)this.field.get(this.target);
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getStringValue();
    }

    @Override
    public final void get(StringBuilder builder, NumberFormat format) {
        switch (this.type) {
            case Boolean: {
                builder.append(this.getBooleanValue());
                break;
            }
            case Byte: {
                builder.append(format.format(this.getByteValue()));
                break;
            }
            case Double: {
                builder.append(format.format(this.getDoubleValue()));
                break;
            }
            case Float: {
                builder.append(format.format(this.getFloatValue()));
                break;
            }
            case Int: {
                builder.append(format.format(this.getIntValue()));
                break;
            }
            case Long: {
                builder.append(format.format(this.getLongValue()));
                break;
            }
            case Short: {
                builder.append(format.format(this.getShortValue()));
                break;
            }
            case Char: {
                builder.append(this.getCharValue());
                break;
            }
            case String: {
                builder.append(this.getStringValue());
                break;
            }
        }
    }
}

